#ifndef GE_STATE_H
#define GE_STATE_H

#include <gdk/gdk.h>

typedef struct EncryptionState {
   gboolean incoming_encrypted;
   gboolean outgoing_encrypted;
   gboolean has_been_notified;
   gboolean is_capable;
} EncryptionState;

void GE_state_init();
void GE_state_delete();


EncryptionState* GE_get_state(GaimConversation* conv);
void GE_reset_state(GaimConversation *conv);
void GE_free_state(GaimConversation *conv);

void     GE_set_tx_encryption(GaimConversation* conv, gboolean new_state);
gboolean GE_get_tx_encryption(GaimConversation *conv);

void     GE_set_capable(GaimConversation *conv, gboolean cap);

gboolean GE_has_been_notified(GaimConversation *conv);
void     GE_set_notified(GaimConversation *conv, gboolean newstate);

void     GE_set_rx_encryption(GaimConversation *conv, gboolean encrypted);

gboolean  GE_get_default_notified(const GaimAccount *account, const gchar* name);

/* Ensure that the conversation's state is reflected in the conversation's menu */
void GE_sync_state(GaimConversation *conv);

#endif
