namespace Galago
{
	using System;
	using System.Runtime.InteropServices;

	public class Avatar
		: Object
	{
		~Avatar()
		{
			Dispose();
		}

		public Avatar(IntPtr raw) : base(raw) {}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_avatar_new(IntPtr account, byte[] data,
											   int len);

		public Avatar(Account account, byte[] data)
		{
			Raw = galago_avatar_new(account.Handle, data, data.Length);
		}

		[DllImport("libgalago.so")]
		static extern void galago_avatar_set_image_data(IntPtr avatar,
														byte[] data, int len);

		[DllImport("libgalago.so")]
		unsafe static extern void galago_avatar_get_image_data(IntPtr avatar,
															   out byte *data,
															   out int len);

		public byte[] ImageData
		{
			get
			{
				unsafe
				{
					byte *data = null;
					int len = 0;

					galago_avatar_get_image_data(Handle, out data, out len);

					byte[] ret_data = new byte[len];

					for (int i = 0; i < len; i++) {
						ret_data[i] = *data++;
					}

					return ret_data;
				}
			}
			set { galago_avatar_set_image_data(Handle, value, value.Length); }
		}
	}
}

