namespace Galago.SignalMarshals
{
	using System;
	using System.Runtime.InteropServices;

	internal delegate void VoidVoidDelegate(IntPtr obj, string signal,
											int key);
	internal delegate void VoidPointerDelegate(IntPtr obj, string signal,
											   IntPtr arg1, int key);
	internal delegate void VoidBoxedDelegate(IntPtr obj, string signal,
											 IntPtr arg1, int key);
	internal delegate void VoidBoolULongDelegate(IntPtr obj, string signal,
												 bool arg1, uint arg2, int key);
	internal delegate void VoidPointerStringDelegate(IntPtr obj, string signal,
													 IntPtr arg1, string arg2,
													 int key);

	internal class VoidVoidSignal
		: SignalCallback
	{
		private static VoidVoidDelegate _Delegate;

		private static void voidVoidSignalCb(IntPtr arg0, string signal,
											 int key)
		{
			if (!_Instances.Contains(key))
				throw new Exception("Unexpected signal key " + key);

			VoidVoidSignal inst = (VoidVoidSignal)_Instances[key];
			EventHandler h = (EventHandler)inst._handler;
			h(inst._obj, new EventArgs());
		}

		public VoidVoidSignal(Object obj, string name, Type argsType,
							  Delegate d)
			: base((Galago.Object)obj, d, argsType)
		{
			if (_Delegate == null)
				_Delegate = new VoidVoidDelegate(voidVoidSignalCb);

			Connect(name, _Delegate);
		}

		protected override void Dispose(bool disposing)
		{
			_Instances.Remove(_key);

			if (_Instances.Count == 0)
				_Delegate = null;

			Disconnect();
			base.Dispose(disposing);
		}
	}

	internal class VoidPointerSignal
		: SignalCallback
	{
		private static VoidPointerDelegate _Delegate;

		private static void voidPointerSignalCb(IntPtr arg0, string signal,
												IntPtr arg1, int key)
		{
			if (!_Instances.Contains(key))
				throw new Exception("Unexpected signal key " + key);

			VoidPointerSignal inst = (VoidPointerSignal)_Instances[key];
			SignalArgs args = (SignalArgs)Activator.CreateInstance(inst._argsType);
			args.Args = new object[1];
			args.Args[0] = arg1;

			object[] argv = new object[2];
			argv[0] = inst._obj;
			argv[1] = args;
			inst._handler.DynamicInvoke(argv);
		}

		public VoidPointerSignal(Object obj, string name, Type argsType,
								 Delegate d)
			: base((Galago.Object)obj, d, argsType)
		{
			if (_Delegate == null)
				_Delegate = new VoidPointerDelegate(voidPointerSignalCb);

			Connect(name, _Delegate);
		}

		protected override void Dispose(bool disposing)
		{
			_Instances.Remove(_key);

			if (_Instances.Count == 0)
				_Delegate = null;

			Disconnect();
			base.Dispose(disposing);
		}
	}

	internal class VoidBoxedSignal
		: SignalCallback
	{
		private static VoidBoxedDelegate _Delegate;

		private static void voidBoxedSignalCb(IntPtr arg0, string signal,
											  IntPtr arg1, int key)
		{
			if (!_Instances.Contains(key))
				throw new Exception("Unexpected signal key " + key);

			VoidBoxedSignal inst = (VoidBoxedSignal)_Instances[key];
			SignalArgs args = (SignalArgs)Activator.CreateInstance(inst._argsType);
			args.Args = new object[1];
			args.Args[0] = arg1;
			object[] argv = new object[2];
			argv[0] = inst._obj;
			argv[1] = args;
			inst._handler.DynamicInvoke(argv);
		}

		public VoidBoxedSignal(Object obj, string name, Type argsType,
							   Delegate d)
			: base((Galago.Object)obj, d, argsType)
		{
			if (_Delegate == null)
				_Delegate = new VoidBoxedDelegate(voidBoxedSignalCb);

			Connect(name, _Delegate);
		}

		protected override void Dispose(bool disposing)
		{
			_Instances.Remove(_key);

			if (_Instances.Count == 0)
				_Delegate = null;

			Disconnect();
			base.Dispose(disposing);
		}
	}

	internal class VoidBoolULongSignal
		: SignalCallback
	{
		private static VoidBoolULongDelegate _Delegate;

		private static void voidBoolULongSignalCb(IntPtr arg0, string signal,
												  bool arg1, uint arg2,
												  int key)
		{
			if (!_Instances.Contains(key))
				throw new Exception("Unexpected signal key " + key);

			VoidBoolULongSignal inst = (VoidBoolULongSignal)_Instances[key];
			SignalArgs args = (SignalArgs)Activator.CreateInstance(inst._argsType);
			args.Args = new object[2];
			args.Args[0] = arg1;
			args.Args[1] = arg2;
			object[] argv = new object[2];
			argv[0] = inst._obj;
			argv[1] = args;
			inst._handler.DynamicInvoke(argv);
		}

		public VoidBoolULongSignal(Object obj, string name, Type argsType,
								   Delegate d)
			: base((Galago.Object)obj, d, argsType)
		{
			if (_Delegate == null)
				_Delegate = new VoidBoolULongDelegate(voidBoolULongSignalCb);

			Connect(name, _Delegate);
		}

		protected override void Dispose(bool disposing)
		{
			_Instances.Remove(_key);

			if (_Instances.Count == 0)
				_Delegate = null;

			Disconnect();
			base.Dispose(disposing);
		}
	}

	internal class VoidPointerStringSignal
		: SignalCallback
	{
		private static VoidPointerStringDelegate _Delegate;

		private static void voidPointerStringSignalCb(IntPtr arg0,
													  string signal,
													  IntPtr arg1,
													  string arg2, int key)
		{
			if (!_Instances.Contains(key))
				throw new Exception("Unexpected signal key " + key);

			VoidPointerStringSignal inst =
				(VoidPointerStringSignal)_Instances[key];
			SignalArgs args = (SignalArgs)Activator.CreateInstance(inst._argsType);
			args.Args[0] = arg1;
			args.Args[1] = arg2;

			object[] argv = new object[2];
			argv[0] = inst._obj;
			argv[1] = args;
			inst._handler.DynamicInvoke(argv);
		}

		public VoidPointerStringSignal(Object obj, string name, Type argsType,
									   Delegate d)
			: base((Galago.Object)obj, d, argsType)
		{
			if (_Delegate == null)
				_Delegate = new VoidPointerStringDelegate(voidPointerStringSignalCb);

			Connect(name, _Delegate);
		}

		protected override void Dispose(bool disposing)
		{
			_Instances.Remove(_key);

			if (_Instances.Count == 0)
				_Delegate = null;

			Disconnect();
			base.Dispose(disposing);
		}
	}
}
