namespace Galago
{
	using System;
	using System.Runtime.InteropServices;

	public class Status
		: Object, ICloneable
	{
		~Status()
		{
			Dispose();
		}

		public Status(IntPtr raw) : base(raw) {}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_status_new(int type, string id,
											   string name, bool exclusive);

		public Status(StatusType type, string id, string name, bool exclusive)
		{
			Raw = galago_status_new((int)type, id, name, exclusive);
		}

		public Status(StatusType type, string id, string name)
			: this(type, id, name, true)
		{
		}

		public Status(StatusType type, string id, bool exclusive)
			: this(type, id, null, exclusive)
		{
		}

		public Status(StatusType type, string id)
			: this(type, id, true)
		{
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_status_duplicate(IntPtr status);

		public object Clone()
		{
			return new Status(galago_status_duplicate(Handle));
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_status_get_presence(IntPtr status);

		[DllImport("libgalago.so")]
		static extern void galago_status_set_presence(IntPtr status,
													  IntPtr presence);

		public Presence Presence
		{
			get
			{
				IntPtr raw_ret = galago_status_get_presence(Handle);
				return Object.Wrap(raw_ret) as Presence;
			}

			set
			{
				galago_status_set_presence(Handle, value.Handle);
			}
		}

		[DllImport("libgalago.so")]
		static extern int galago_status_get_type(IntPtr status);

		public StatusType Type
		{
			get { return (StatusType)galago_status_get_type(Handle); }
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_status_get_id(IntPtr status);

		public string Id
		{
			get
			{
				IntPtr raw_ret = galago_status_get_id(Handle);
				return Marshal.PtrToStringAnsi(raw_ret);
			}
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_status_get_name(IntPtr status);

		public string Name
		{
			get
			{
				IntPtr raw_ret = galago_status_get_name(Handle);
				return Marshal.PtrToStringAnsi(raw_ret);
			}
		}

		[DllImport("libgalago.so")]
		static extern bool galago_status_is_exclusive(IntPtr status);

		public bool Exclusive
		{
			get { return galago_status_is_exclusive(Handle); }
		}

		[DllImport("libgalago.so")]
		static extern bool galago_status_is_available(IntPtr status);

		public bool Available
		{
			get { return galago_status_is_available(Handle); }
		}

		[DllImport("libgalago.so")]
		static extern void galago_status_set_attr_bool(IntPtr status,
													   string id, bool value);

		public void SetAttribute(string id, bool value)
		{
			galago_status_set_attr_bool(Handle, id, value);
		}

		[DllImport("libgalago.so")]
		static extern void galago_status_set_attr_string(IntPtr status,
														 string id,
														 string value);

		public void SetAttribute(string id, string value)
		{
			galago_status_set_attr_string(Handle, id, value);
		}

		[DllImport("libgalago.so")]
		static extern void galago_status_set_attr_int(IntPtr status,
													  string id, int value);

		public void SetAtribute(string id, int value)
		{
			galago_status_set_attr_int(Handle, id, value);
		}

		[DllImport("libgalago.so")]
		static extern void galago_status_set_attr_double(IntPtr status,
														 string id,
														 double value);

		public void SetAttribute(string id, double value)
		{
			galago_status_set_attr_double(Handle, id, value);
		}

		[DllImport("libgalago.so")]
		static extern void galago_status_remove_attr(IntPtr status, string id);

		public void RemoveAttribute(string id)
		{
			galago_status_remove_attr(Handle, id);
		}

		[DllImport("libgalago.so")]
		static extern bool galago_status_get_attr_bool(IntPtr status,
													   string id);

		public void GetAttribute(string id, out bool value)
		{
			value = galago_status_get_attr_bool(Handle, id);
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_status_get_attr_string(IntPtr status,
														   string id);

		public void GetAtribute(string id, out string value)
		{
			IntPtr raw_ret = galago_status_get_attr_string(Handle, id);
			value = Marshal.PtrToStringAnsi(raw_ret);
		}

		[DllImport("libgalago.so")]
		static extern int galago_status_get_attr_int(IntPtr status, string id);

		public void GetAtribute(string id, out int value)
		{
			value = galago_status_get_attr_int(Handle, id);
		}

		[DllImport("libgalago.so")]
		static extern double galago_status_get_attr_double(IntPtr status,
														   string id);

		public void GetAttribute(string id, out double value)
		{
			value = galago_status_get_attr_double(Handle, id);
		}

		[DllImport("libgalago.so")]
		static extern bool galago_status_attr_exists(IntPtr status, string id);

		public bool AttributeExists(string id)
		{
			return galago_status_attr_exists(Handle, id);
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_status_get_attributes(IntPtr status);

		public List Attributes
		{
			get
			{
				IntPtr raw_ret = galago_status_get_attributes(Handle);

				return new List(raw_ret);
			}
		}
	}
}
