/*
 * Galaxium Messenger
 * Copyright (C) 2005-2007  Ben Motmans  <ben.motmans@gmail.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

using System;
using System.Collections.Generic;

using Gtk;

using Galaxium.Core;

namespace Galaxium.Gui.GtkGui
{
	public sealed class DefaultTreeNodeRenderer : ITreeNodeRenderer
	{
		private TreeStore _treeStore;

		internal DefaultTreeNodeRenderer (TreeStore treeStore)
		{
			this._treeStore = treeStore;
		}

		public void RenderIcon (CellRendererPixbuf cell, string icon, IIconSize iconSize)
		{
			cell.Pixbuf = IconUtility.GetIcon (icon, iconSize);
			cell.Width = iconSize.Size;
			cell.Height = iconSize.Size;
		}

		public void RenderText (CellRendererText cell, string text)
		{
			cell.Markup = text;
			cell.Xalign = 0.0f;
		}
	}
}