/*
 * Galaxium Messenger
 * 
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * Copyright (C) 2003 Philippe Durand <draekz@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Reflection;
using System.Collections.Generic;

using Anculus.Core;
using Galaxium.Core;

namespace Galaxium.Startup
{
	public class Program
	{
		public static void Main (string[] args)
		{
			Console.WriteLine ("Galaxium Messenger");
			Console.WriteLine ("Copyright (C) 2003-2008 Philippe Durand <draekz@gmail.com>");
			Console.WriteLine ("Copyright (C) 2006-2008 Ben Motmans <ben.motmans@gmail.com>");
			Console.WriteLine ("Copyright (C) 2007-2008 Paul Burton <paulburton89@gmail.com>");
			Console.WriteLine ("");
			
			bool debug = true;
			string appName = "Galaxium";
			
			foreach (string arg in args)
			{
				if (arg.StartsWith ("--debug"))
				{
					debug = !arg.EndsWith ("false");
					continue;
				}
				if (arg.StartsWith ("--appName="))
				{
					appName = arg.Substring (10);
					continue;
				}
			}
			
			if (debug)
				Console.WriteLine ("Running in DEBUG mode, appName {0}", appName);
			
			try
			{
				new Program (debug, appName);
			}
			catch (Exception e)
			{
				Log.Fatal (e, "Fatal exception while running Galaxium.");
			}
		}
		
		public Program (bool debug, string appName)
		{
			GLibLogging.Enabled = true;
			
			Assembly exe = typeof (Program).Assembly;
			
			CoreUtility.Initialize (exe, appName, debug);
			
			AddinUtility.Initialize ();
		}
	}
}