/*
 *  Copyright (C) 2002 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __sidebar_h
#define __sidebar_h

#include "galeon-embed.h"
#include "src/galeon-window.h"

#include <nsISidebar.h>
#include <nsIDOMWindowInternal.h>
#include <nsString.h>
#include <nsReadableUtils.h>
#include <map>

using namespace std;

void mozilla_init_sidebar(void);

class GSidebar : public nsISidebar
{
  public:
	typedef std::map<nsCString, nsCString> URLMap;

	NS_DECL_ISUPPORTS
	NS_DECL_NSISIDEBAR

	GSidebar();
	virtual ~GSidebar();

	void IncRefCount(void) { mRefCount++; }
	void DecRefCount(void) { if(--mRefCount == 0) delete this;}

	void InitSidebar(GaleonWindow *aWindow);

	void ShowPage(GaleonSidebar *aSidebar, const nsACString &aUrl);
	void RemovePage(const nsACString &aUrl);
  private:
	void AddPage(GaleonWindow *aParent,
		     const nsACString &aTitle,
		     const nsACString &aURL) const;

	void LoadSidebarPages(void);
	void SaveSidebarPages(void);

	URLMap mUrls;
	PRUint32 mRefCount;
};

#endif //__sidebar_h

