#include "config.h"

#define GALEON_DIR ".galeon"
#define GALEON_HOMEPAGE_URL "http://galeon.sourceforge.net"

/**
 * Create a version int from components
 */
#define VERSION4(a,b,c,d) ((a << 24) + (b << 16) + (c << 8) + d)
#define VERSION3(a,b,c) VERSION4(a,b,c,0)
#define VERSION2(a,b) VERSION3(a,b,0)

/**
 * Split version int into components
 */
#define VERSIONA(v) (v >> 24)
#define VERSIONB(v) ((v >> 16) & 0xFF)
#define VERSIONC(v) ((v >> 8) & 0xFF)
#define VERSIOND(v) (v  & 0xFF)
#define VERSIONPLUS(v) (VERSIOND(v) ? "+" : "")

/**
 * Convenience macros for printing versions
 */
#define VERSIONFMT "%i.%i.%i%s"
#define VERSIONFMTARGS(ver) VERSIONA(ver), VERSIONB(ver), VERSIONC(ver), VERSIONPLUS(ver)
