/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.CancellableTransferListener;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.PreviewFrame;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.HTMLEscaper;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class SlideshowFrame
extends PreviewFrame
implements Runnable,
PreferenceNames,
CancellableTransferListener,
MouseMotionListener {
    public static final String MODULE = "SlideFrame";
    List pictures = null;
    List wantDownloaded = Collections.synchronizedList(new ArrayList());
    Picture userPicture = null;
    int wantIndex = -1;
    int sleepTime = 3000;
    int skipTime = 500;
    boolean running = false;
    boolean shutdown = false;
    long pictureShownTime = 0L;
    String caption = null;
    String progress = null;
    String extra = null;
    String url = null;
    public static final int STATE_NONE = 0;
    public static final int STATE_DOWNLOADING = 1;
    public static final int STATE_PROCESSING = 2;
    public static final int STATE_NEXTREADY = 3;
    public static final int STATE_SKIPPING = 4;
    public static final int FEEDBACK_NONE = 0;
    public static final int FEEDBACK_HELP = 1;
    public static final int FEEDBACK_PREV = 2;
    public static final int FEEDBACK_NEXT = 4;
    public static final int FEEDBACK_PAUSE_PLAY = 8;
    public int feedback = 0;
    long controllerUntil = 0L;
    long dontShowUntil = 0L;
    Thread controllerThread = null;
    public static Cursor transparentCursor = null;
    public static Pattern stripper = Pattern.compile("<[^<>]*>");
    public static Pattern spacer = Pattern.compile("[\r\n]");

    public SlideshowFrame() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.initComponents();
        this.listener = this;
        this.ignoreIMFailure = true;
        FeedbackGlassPane glass = new FeedbackGlassPane();
        this.setGlassPane(glass);
        glass.setVisible(true);
    }

    public void showSlideshow() {
        DialogUtil.maxSize(this);
        this.setVisible(true);
        Log.log(3, MODULE, "Showing slideshow frame");
        Frame mainFrame = GalleryRemote._().getMainFrame();
        if (mainFrame != null) {
            mainFrame.setVisible(false);
        }
    }

    public void hide() {
        Frame mainFrame;
        Log.log(3, MODULE, "Stopping slideshow");
        this.running = false;
        this.shutdown = true;
        if (!this.isShowing()) {
            return;
        }
        this.showCursor();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        gd.setFullScreenWindow(null);
        super.hide();
        if (GalleryRemote._() != null && (mainFrame = GalleryRemote._().getMainFrame()) != null) {
            mainFrame.setVisible(true);
        }
    }

    public void initComponents() {
        this.previewCacheSize = 3;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Log.log(3, SlideshowFrame.MODULE, "Got click");
                SlideshowFrame.this.nextAsync();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                Log.log(3, SlideshowFrame.MODULE, "Got wheel: " + e);
                if (e.getWheelRotation() > 0) {
                    SlideshowFrame.this.nextAsync();
                } else {
                    SlideshowFrame.this.previousAsync();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int vKey = e.getKeyCode();
                Log.log(3, SlideshowFrame.MODULE, "Got key: " + e);
                switch (vKey) {
                    case 27: {
                        SlideshowFrame.this.hide();
                        break;
                    }
                    case 37: 
                    case 38: {
                        SlideshowFrame.this.previousAsync();
                        break;
                    }
                    case 39: 
                    case 40: {
                        SlideshowFrame.this.nextAsync();
                        break;
                    }
                    case 72: {
                        SlideshowFrame.this.updateFeedback(1);
                        break;
                    }
                    case 32: {
                        if (SlideshowFrame.this.running) {
                            SlideshowFrame.this.running = false;
                        } else {
                            new Thread(SlideshowFrame.this).start();
                        }
                        SlideshowFrame.this.updateFeedback(8);
                        SlideshowFrame.this.updateProgress(SlideshowFrame.this.currentPicture, 0);
                    }
                }
            }
        });
        this.addMouseMotionListener(this);
        PreviewFrame.ImageContentPane cp = new PreviewFrame.ImageContentPane();
        this.setContentPane(cp);
        PropertiesFile pf = GalleryRemote._().properties;
        this.sleepTime = pf.getIntProperty("slideshowDelay") * 1000;
    }

    public void start(ArrayList pictures) {
        if (GalleryRemote._().properties.getBooleanProperty("slideshowRandom")) {
            this.pictures = new ArrayList(pictures);
            Collections.shuffle(this.pictures);
        } else {
            this.pictures = pictures;
        }
        new Thread(this).start();
        if (GalleryRemote._().properties.getBooleanProperty("slideshowPreloadAll")) {
            Thread t = new Thread(){

                public void run() {
                    Log.log(3, SlideshowFrame.MODULE, "Preload thread starting");
                    Iterator it = SlideshowFrame.this.pictures.iterator();
                    while (it.hasNext() && !SlideshowFrame.this.shutdown) {
                        Picture picture = (Picture)it.next();
                        ImageUtils.download(picture, SlideshowFrame.this.getRootPane().getSize(), GalleryRemote._().getCore().getMainStatusUpdate(), null);
                    }
                    Log.log(3, SlideshowFrame.MODULE, "Preload thread done");
                }
            };
            t.setPriority(1);
            t.start();
        }
    }

    public void run() {
        this.running = true;
        while (this.running && !this.shutdown) {
            if (!this.next(false)) {
                this.hide();
                break;
            }
            try {
                long sleep;
                if (this.sleepTime <= 0) continue;
                while ((sleep = (long)this.sleepTime - (System.currentTimeMillis() - this.pictureShownTime)) > 0L) {
                    Thread.sleep(sleep);
                }
            }
            catch (InterruptedException e) {
                Log.logException(1, MODULE, e);
            }
        }
    }

    private void previousAsync() {
        new Thread(){

            public void run() {
                SlideshowFrame.this.updateFeedback(2);
                SlideshowFrame.this.previous(true);
            }
        }.start();
    }

    private void nextAsync() {
        new Thread(){

            public void run() {
                SlideshowFrame.this.updateFeedback(4);
                SlideshowFrame.this.next(true);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next(boolean user) {
        Picture picture;
        if (this.loadPicture != null && this.wantDownloaded.contains(this.loadPicture) && (this.loadPicture != this.userPicture || user)) {
            this.wantDownloaded.remove(this.loadPicture);
        }
        SlideshowFrame slideshowFrame = this;
        synchronized (slideshowFrame) {
            ++this.wantIndex;
            if (this.wantIndex >= this.pictures.size()) {
                if (GalleryRemote._().properties.getBooleanProperty("slideshowLoop")) {
                    this.wantIndex = 0;
                } else {
                    this.wantIndex = this.pictures.size() - 1;
                    return false;
                }
            }
            picture = (Picture)this.pictures.get(this.wantIndex);
            Log.log(3, MODULE, "Next picture: " + picture);
        }
        if (user) {
            this.userPicture = picture;
            this.updateProgress(picture, 4);
            Log.log(3, MODULE, "Skipping sleep");
            try {
                Thread.sleep(this.skipTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Log.log(3, MODULE, "Skipping wake");
            if (this.userPicture != picture) {
                Log.log(3, MODULE, "User skipped again, not even loading " + picture);
                return true;
            }
        } else if (this.userPicture != null && this.userPicture != picture) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        this.wantDownloaded.add(picture);
        this.updateProgress(picture, 0);
        this.displayPicture(picture, false);
        if (this.wantIndex + 1 < this.pictures.size() && this.imageIcons.get(picture = (Picture)this.pictures.get(this.wantIndex + 1)) == null) {
            this.wantDownloaded.add(picture);
            this.previewLoader.loadPreview(picture, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous(boolean user) {
        Picture picture;
        if (this.loadPicture != null && this.wantDownloaded.contains(this.loadPicture) && (this.loadPicture != this.userPicture || user)) {
            this.wantDownloaded.remove(this.loadPicture);
        }
        SlideshowFrame slideshowFrame = this;
        synchronized (slideshowFrame) {
            --this.wantIndex;
            if (this.wantIndex < 0) {
                if (GalleryRemote._().properties.getBooleanProperty("slideshowLoop")) {
                    this.wantIndex = this.pictures.size() - 1;
                } else {
                    this.wantIndex = 0;
                    return false;
                }
            }
            picture = (Picture)this.pictures.get(this.wantIndex);
        }
        Log.log(3, MODULE, "Previous picture: " + picture);
        if (user) {
            this.userPicture = picture;
            this.updateProgress(picture, 4);
            try {
                Thread.sleep(this.skipTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.userPicture != picture) {
                Log.log(3, MODULE, "User skipped again, not even loading " + picture);
                return true;
            }
        } else if (this.userPicture != null && this.userPicture != picture) {
            return true;
        }
        this.wantDownloaded.add(picture);
        this.updateProgress(picture, 0);
        this.displayPicture(picture, false);
        if (this.wantIndex - 1 > 0 && this.imageIcons.get(picture = (Picture)this.pictures.get(this.wantIndex - 1)) == null) {
            this.wantDownloaded.add(picture);
            this.previewLoader.loadPreview(picture, true);
        }
        return true;
    }

    public void pictureReady(ImageIcon image, Picture picture) {
        Log.log(3, MODULE, "Picture " + picture + " ready");
        if (picture == this.userPicture) {
            this.userPicture = null;
        }
        if (picture != this.loadPicture) {
            Log.log(3, MODULE, "We wanted " + this.loadPicture + ": ignoring");
            this.updateProgress(this.loadPicture, 3);
            return;
        }
        if (picture != null) {
            this.caption = HTMLEscaper.unescape(SlideshowFrame.stripTags(picture.getCaption()));
            Log.log(3, MODULE, this.caption);
            this.updateProgress(picture, 0);
            this.extra = picture.getExtraFieldsString();
            this.url = picture.isOnline() ? picture.safeGetUrlFull().toString() : picture.getSource().toString();
        }
        this.pictureShownTime = System.currentTimeMillis();
        super.pictureReady(image, picture);
    }

    public void pictureStartDownload(Picture picture) {
        if (picture == this.loadPicture || picture == this.userPicture) {
            this.updateProgress(picture, 1);
        }
    }

    public void pictureStartProcessing(Picture picture) {
        if (picture == this.loadPicture || picture == this.userPicture) {
            this.updateProgress(picture, 2);
        }
    }

    private void updateProgress(Picture picture, int state) {
        if (picture == null) {
            return;
        }
        Object[] params = new Object[]{picture.getName(), new Integer(this.pictures.indexOf(picture) + 1), new Integer(this.pictures.size())};
        switch (state) {
            case 0: {
                if (!this.running) {
                    this.progress = GRI18n.getString(MODULE, "paused", params);
                    break;
                }
                this.progress = GRI18n.getString(MODULE, "showing", params);
                break;
            }
            case 1: {
                this.progress = GRI18n.getString(MODULE, "downloading", params);
                break;
            }
            case 2: {
                this.progress = GRI18n.getString(MODULE, "processing", params);
                break;
            }
            case 3: {
                this.progress = GRI18n.getString(MODULE, "nextReady", params);
                break;
            }
            case 4: {
                this.progress = GRI18n.getString(MODULE, "skipping", params);
            }
        }
        Log.log(3, MODULE, "updateProgress:" + this.progress);
        this.repaint();
        this.hideCursor();
    }

    public boolean dataTransferred(int transferred, int overall, double kbPerSecond, Picture p) {
        if (!this.wantDownloaded.contains(p) || this.shutdown) {
            return false;
        }
        Graphics g = this.getGraphics();
        if (transferred == overall) {
            g.setColor(this.getContentPane().getBackground());
        } else {
            g.setColor(Color.yellow);
        }
        g.drawLine(0, 0, this.getWidth() * transferred / overall, 0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFeedback(int feedback) {
        if (feedback != 0) {
            this.controllerUntil = System.currentTimeMillis() + (long)(feedback == 1 ? 6000 : 1500);
            SlideshowFrame slideshowFrame = this;
            synchronized (slideshowFrame) {
                if (this.controllerThread == null) {
                    this.controllerThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            boolean running = true;
                            while (running) {
                                try {
                                    Thread.sleep(SlideshowFrame.this.controllerUntil - System.currentTimeMillis());
                                    7 var2_2 = this;
                                    synchronized (var2_2) {
                                        if (System.currentTimeMillis() >= SlideshowFrame.this.controllerUntil) {
                                            running = false;
                                            SlideshowFrame.this.controllerThread = null;
                                            SlideshowFrame.this.feedback = 0;
                                            SlideshowFrame.this.repaint();
                                        }
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                }
                            }
                        }
                    };
                    this.controllerThread.start();
                }
            }
        }
        this.feedback = (this.feedback & 1) == 1 ? feedback | 1 : (feedback == 1 ? (this.feedback |= 1) : feedback);
        this.repaint();
    }

    public void hideCursor() {
        if (transparentCursor == null) {
            int[] pixels = new int[256];
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
            transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisiblecursor");
        }
        this.setCursor(transparentCursor);
    }

    public static String stripTags(String text) {
        Matcher m = stripper.matcher(text);
        m = spacer.matcher(m.replaceAll(""));
        return m.replaceAll(" ");
    }

    public void showCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.showCursor();
    }

    public class FeedbackGlassPane
    extends JComponent {
        Color background = new Color(100, 100, 100, 150);
        Color normal = new Color(180, 180, 180, 180);
        Color hilight = new Color(255, 255, 255, 180);

        public void paint(Graphics g) {
            if (SlideshowFrame.this.feedback != 0 || SlideshowFrame.this.controllerUntil > System.currentTimeMillis()) {
                this.paintController(g);
            }
            this.paintInfo(g);
        }

        private void paintController(Graphics g) {
            Dimension d = this.getSize();
            int width = 475;
            int height = 150;
            int x = d.width / 2 - width / 2;
            int y = d.height / 3 * 2 - height / 2;
            g.setFont(g.getFont().deriveFont(18.0f));
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.background);
            g.fillRoundRect(x - 30, y - 20, width + 60, height + ((SlideshowFrame.this.feedback & 1) == 1 ? 70 : 40), 30, 30);
            g.setColor(this.normal);
            g.drawRoundRect(x - 30, y - 20, width + 60, height + ((SlideshowFrame.this.feedback & 1) == 1 ? 70 : 40), 30, 30);
            g.setColor((SlideshowFrame.this.feedback & 2) == 2 ? this.hilight : this.normal);
            g.fillPolygon(new int[]{x + 100, x + 100, x + 50, x + 50, x, x + 50, x + 50}, new int[]{y + 60, y + 90, y + 90, y + 125, y + 75, y + 25, y + 60}, 7);
            this.drawText(g, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.left"));
            this.drawText(g, this.hilight, fm, x + 107, y + 180, GRI18n.getString(SlideshowFrame.MODULE, "controller.mousewheel"));
            g.setColor((SlideshowFrame.this.feedback & 4) == 4 ? this.hilight : this.normal);
            g.fillPolygon(new int[]{x += 115, x, x + 50, x + 50, x + 100, x + 50, x + 50}, new int[]{y + 60, y + 90, y + 90, y + 125, y + 75, y + 25, y + 60}, 7);
            this.drawText(g, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.right"));
            x += 130;
            g.setColor((SlideshowFrame.this.feedback & 8) == 8 ? this.hilight : this.normal);
            if (SlideshowFrame.this.running) {
                g.fillPolygon(new int[]{x, x, x + 100}, new int[]{y + 10, y + 140, y + 75}, 3);
            } else {
                g.fillPolygon(new int[]{x, x, x + 30, x + 30}, new int[]{y + 10, y + 140, y + 140, y + 10}, 4);
                g.fillPolygon(new int[]{x + 70, x + 70, x + 100, x + 100}, new int[]{y + 10, y + 140, y + 140, y + 10}, 4);
            }
            this.drawText(g, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.space"));
            g.setColor(this.normal);
            g.fillPolygon(new int[]{x += 130, x, x + 30, x + 70, x + 100, x + 100, x + 70, x + 30}, new int[]{y + 55, y + 95, y + 125, y + 125, y + 95, y + 55, y + 25, y + 25}, 8);
            this.drawText(g, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.escape"));
        }

        public void paintInfo(Graphics g) {
            PropertiesFile pf = GalleryRemote._().properties;
            this.paintInfo(g, SlideshowFrame.this.caption, pf.getIntProperty("slideshowCaptionLocation"));
            this.paintInfo(g, SlideshowFrame.this.progress, pf.getIntProperty("slideshowProgressLocation"));
            this.paintInfo(g, SlideshowFrame.this.extra, pf.getIntProperty("slideshowExtraLocation"));
            this.paintInfo(g, SlideshowFrame.this.url, pf.getIntProperty("slideshowUrlLocation"));
        }

        public void paintInfo(Graphics g, String text, int position) {
            int x;
            if (position == 0 || text == null || text.length() == 0) {
                return;
            }
            text = text.trim();
            Dimension d = this.getSize();
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics(this.getFont());
            Rectangle2D bounds = fm.getStringBounds(text, g);
            int inset = 5;
            switch (position % 10) {
                default: {
                    x = inset;
                    break;
                }
                case 0: {
                    x = (int)(((double)d.width - bounds.getWidth()) / 2.0);
                    break;
                }
                case 4: {
                    x = (int)((double)d.width - bounds.getWidth() - (double)inset);
                }
            }
            switch (position / 10) {
                default: {
                    int y = inset;
                    break;
                }
                case 2: {
                    int y = (int)(((double)d.height - bounds.getHeight()) / 2.0);
                    break;
                }
                case 3: {
                    int y = (int)((double)d.height - bounds.getHeight() - (double)inset);
                }
            }
            PreviewFrame.paintOutline(g, text, x, y += fm.getAscent());
        }

        private void drawText(Graphics g, Color hilight, FontMetrics fm, int x, int y, String text) {
            if ((SlideshowFrame.this.feedback & 1) != 1) {
                return;
            }
            g.setColor(hilight);
            Rectangle2D bounds = fm.getStringBounds(text, g);
            g.drawString(text, (int)((double)x - bounds.getWidth() / 2.0), y);
        }
    }
}

