<?php
/*
 * $RCSfile: init.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @version $Revision: 1.13 $ $Date: 2005/08/23 03:48:55 $
 * @package Gallery
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Perform all necessary initialization of the Gallery framework
 */
function GalleryInitFirstPass($params=array()) {
    global $gallery;

    ini_set('magic_quotes_runtime', 0);
    ini_set('magic_quotes_sybase', 0);

    /* Specify that when an assertion fails, we terminate right away. */
    assert_options(ASSERT_WARNING, 1);
    assert_options(ASSERT_BAIL, 1);

    /* Figure out the Gallery base directory here, from our filename. */
    $galleryBase = dirname(__FILE__) . '/';

    /* Load all the core Gallery classes */
    $classDir = dirname(__FILE__) . '/modules/core/classes/';
    require_once($classDir . 'GalleryCoreApi.class');
    GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryConstants.class');
    GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryStatus.class');
    GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryUtilities.class');
    GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryCapabilities.class');
    GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryView.class');
    GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryModule.class');

    if (!strncasecmp(PHP_OS, 'win', 3)) {
	GalleryCoreApi::relativeRequireOnce(
	    'modules/core/classes/GalleryPlatform/WinNtPlatform.class');
	$platform = new WinNtPlatform();
    } else {
	GalleryCoreApi::relativeRequireOnce(
	    'modules/core/classes/GalleryPlatform/UnixPlatform.class');
	$platform = new UnixPlatform();
    }

    $gallery->setPlatform($platform);
    $slash = $platform->getDirectorySeparator();

    if (isset($params['debug'])) {
	$gallery->setDebug($params['debug']);
    }

    /* Sanitize the data path */
    $dataBase = $gallery->getConfig('data.gallery.base');
    if ($dataBase{strlen($dataBase)-1} != $slash) {
	$dataBase .= $slash;
	$gallery->setConfig('data.gallery.base', $dataBase);
    }

    /* Set our various data paths */
    $gallery->setConfig('data.gallery.cache', $dataBase . 'cache' . $slash);
    $gallery->setConfig('data.gallery.albums', $dataBase . 'albums' . $slash);
    $gallery->setConfig('data.gallery.locks', $dataBase . 'locks'. $slash);
    $gallery->setConfig('data.gallery.sessions', $dataBase . 'sessions' . $slash);
    $gallery->setConfig('data.gallery.tmp', $dataBase . 'tmp' . $slash);
    $gallery->setConfig('data.smarty.base', $dataBase . 'smarty' . $slash);
    $gallery->setConfig('data.smarty.templates_c',
	$dataBase . 'smarty' . $slash . 'templates_c' . $slash);
    $gallery->setConfig('data.gallery.plugins', $dataBase . 'plugins' . $slash);
    $gallery->setConfig('data.gallery.plugins_data', $dataBase . 'plugins_data' . $slash);
    $platform->_calculateUmaskAndFilePerms(); /* Init platform umask */

    /* Configure our url Generator */
    if (!isset($params['noDatabase'])) {
	list ($ret, $urlGenerator) = GalleryCoreApi::newFactoryInstance('GalleryUrlGenerator');
	/* Swallow ERROR_STORAGE_FAILURE, or automatic upgrading fails */
	if ($ret->isError() && !($ret->getErrorCode() & ERROR_STORAGE_FAILURE)) {
	    return $ret->wrap(__FILE__, __LINE__);
	}
    }
    if (!isset($urlGenerator)) {
	GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryUrlGenerator.class');
	$urlGenerator = new GalleryUrlGenerator();
    }
    $urlGenerator->init(
	isset($params['embedUri']) ? $params['embedUri'] : null,
	isset($params['embedPath']) ? $params['embedPath'] : null,
	isset($params['relativeG2Path']) ? $params['relativeG2Path'] : null,
	isset($params['embedSessionString']) ? $params['embedSessionString'] : null);
    $gallery->setUrlGenerator($urlGenerator);

    /* Initialize our session */
    if (!isset($params['noDatabase'])) {
	if (isset($params['gallerySessionId'])) {
	    GalleryCoreApi::relativeRequireOnce('modules/core/classes/GallerySession.class');
	    GalleryUtilities::putRequestVariable(SESSION_ID_PARAMETER, $params['gallerySessionId']);
	}
	$ret = $gallery->initSession();
	if ($ret->isError()) {
	    return $ret->wrap(__FILE__, __LINE__);
	}
    }

    /* Initialize our translator */
    if (isset($params['activeLanguage'])) {
	GalleryCoreApi::relativeRequireOnce('modules/core/classes/GalleryTranslator.class');
	list ($language) = GalleryTranslator::getSupportedLanguageCode($params['activeLanguage']);
	$gallery->setActiveLanguageCode($language);
    }
    $ret = $gallery->initTranslator(isset($params['noDatabase']));
    if ($ret->isError()) {
	return $ret->wrap(__FILE__, __LINE__);
    }

    return GalleryStatus::success();
}

function GalleryInitSecondPass() {
    global $gallery;

    $session =& $gallery->getSession();
    /*
     * Set our active user id.  Check to see if we have one in our session.  If
     * not, make us the anonymous user.  If we don't have a session, this will
     * initiate one for us.
     */
    $activeUserId = $session->get('core.id.activeUser');
    if (empty($activeUserId)) {
	/* No active user -- be anonymous */
	list ($ret, $activeUserId) =
	    GalleryCoreApi::getPluginParameter('module', 'core', 'id.anonymousUser');
	if ($ret->isError()) {
	    return $ret->wrap(__FILE__, __LINE__);
	}
    }

    list ($ret, $activeUser) = GalleryCoreApi::loadEntitiesById($activeUserId);
    if ($ret->isError()) {
	if ($ret->getErrorCode() & ERROR_MISSING_OBJECT) {
	    /* Missing user -- be anonymous */
	    list ($ret, $activeUserId) =
		GalleryCoreApi::getPluginParameter('module', 'core', 'id.anonymousUser');
	    if ($ret->isError()) {
		return $ret->wrap(__FILE__, __LINE__);
	    }

	    list ($ret, $activeUser) = GalleryCoreApi::loadEntitiesById($activeUserId);
	    if ($ret->isError()) {
		return $ret->wrap(__FILE__, __LINE__);
	    }
	} else {
	    return $ret->wrap(__FILE__, __LINE__);
	}
    }

    $gallery->setActiveUser($activeUser);

    return GalleryStatus::success();
}
?>
