<?php
/*
 * $RCSfile: GalleryItem.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @package GalleryCore
 * @subpackage ClassInterfaces
 * @version $Revision: 1.51 $ $Date: 2005/08/23 03:49:04 $
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Interface class for the GalleryItem class.
 * (Class schema version: 1.1)
 *
 * This file is automatically generated from XML embedded in the
 * class, combined with the ClassCode.xsl file.  You should not modify
 * it by hand, as your changes will be lost next time this file is
 * rebuilt.  If you want to add more getters/setters, you should add
 * them in the core class.  If you want to change the format of this
 * file, then you should edit the XSL template.
 *
 * @package GalleryCore
 * @subpackage Classes
 */
class GalleryItem extends GalleryItem_core {
  
    /**
     * Return meta information about the members of this class
     *
     * @return array member => array(type, class)
     */
    function getPersistentMemberInfo() {
	$meta = parent::getPersistentMemberInfo();
	$meta['members']['canContainChildren'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_BOOLEAN);
    
	$meta['members']['description'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_TEXT);
    
	$meta['members']['keywords'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['ownerId'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['summary'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['title'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['viewedSinceTimestamp'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['originationTimestamp'] = array('class' => 'GalleryItem', 'type' => STORAGE_TYPE_INTEGER);
    
	return $meta;
    }

    /**
     * Get the data from this persistent object as an associative array
     *
     * @return array memberName => memberValue
     */
    function getMemberData() {
	$data = parent::getMemberData();
        $data['canContainChildren'] = isset($this->_canContainChildren) ? $this->_canContainChildren : null;
        $data['description'] = isset($this->_description) ? $this->_description : null;
        $data['keywords'] = isset($this->_keywords) ? $this->_keywords : null;
        $data['ownerId'] = isset($this->_ownerId) ? $this->_ownerId : null;
        $data['summary'] = isset($this->_summary) ? $this->_summary : null;
        $data['title'] = isset($this->_title) ? $this->_title : null;
        $data['viewedSinceTimestamp'] = isset($this->_viewedSinceTimestamp) ? $this->_viewedSinceTimestamp : null;
        $data['originationTimestamp'] = isset($this->_originationTimestamp) ? $this->_originationTimestamp : null;
	return $data;
    }
  
    /**
     * Return the name of this class with the proper mix of uppercase and
     * lowercase (get_class() always returns lowercase)
     *
     * @return string class name
     */
    function getClassName() {
	return 'GalleryItem';
    }

    /** 
     * Return the path to the PHP file for this class, relative to the gallery2 dir
     * 
     * @return string path
     */ 
    function getClassFile() { 
        return 'modules/' .  
            basename(dirname(dirname(dirname(__FILE__)))) .  
            '/classes/GalleryItem.class'; 
    }
    
    /**
     * Get the value of canContainChildren
     *
     * @return BOOLEAN the value
     */
    function getcanContainChildren() {
	if (!isset($this->_canContainChildren)) {
	    return null;
	}
	return $this->_canContainChildren;
    }

    /**
     * Set the value of canContainChildren
     *
     * @param BOOLEAN the value
     */
    function setcanContainChildren($value) {
	/* Set the incoming value to be a 1 or 0 */
	$value = empty($value) ? 0 : 1;
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_canContainChildren) ? $this->_canContainChildren : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('canContainChildren', $value);
	    $this->_canContainChildren = $value;
	}
    }
  
    /**
     * Get the value of description
     *
     * @return TEXT the value
     */
    function getdescription() {
	if (!isset($this->_description)) {
	    return null;
	}
	return $this->_description;
    }

    /**
     * Set the value of description
     *
     * @param TEXT the value
     */
    function setdescription($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_description) ? $this->_description : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('description', $value);
	    $this->_description = $value;
	}
    }
  
    /**
     * Get the value of keywords
     *
     * @return STRING the value
     */
    function getkeywords() {
	if (!isset($this->_keywords)) {
	    return null;
	}
	return $this->_keywords;
    }

    /**
     * Set the value of keywords
     *
     * @param STRING the value
     */
    function setkeywords($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 255);
	$orig = isset($this->_keywords) ? $this->_keywords : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('keywords', $value);
	    $this->_keywords = $value;
	}
    }
  
    /**
     * Get the value of ownerId
     *
     * @return INTEGER the value
     */
    function getownerId() {
	if (!isset($this->_ownerId)) {
	    return null;
	}
	return $this->_ownerId;
    }

    /**
     * Set the value of ownerId
     *
     * @param INTEGER the value
     */
    function setownerId($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_ownerId) ? $this->_ownerId : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('ownerId', $value);
	    $this->_ownerId = $value;
	}
    }
  
    /**
     * Get the value of summary
     *
     * @return STRING the value
     */
    function getsummary() {
	if (!isset($this->_summary)) {
	    return null;
	}
	return $this->_summary;
    }

    /**
     * Set the value of summary
     *
     * @param STRING the value
     */
    function setsummary($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 255);
	$orig = isset($this->_summary) ? $this->_summary : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('summary', $value);
	    $this->_summary = $value;
	}
    }
  
    /**
     * Get the value of title
     *
     * @return STRING the value
     */
    function gettitle() {
	if (!isset($this->_title)) {
	    return null;
	}
	return $this->_title;
    }

    /**
     * Set the value of title
     *
     * @param STRING the value
     */
    function settitle($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_title) ? $this->_title : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('title', $value);
	    $this->_title = $value;
	}
    }
  
    /**
     * Get the value of viewedSinceTimestamp
     *
     * @return INTEGER the value
     */
    function getviewedSinceTimestamp() {
	if (!isset($this->_viewedSinceTimestamp)) {
	    return null;
	}
	return $this->_viewedSinceTimestamp;
    }

    /**
     * Set the value of viewedSinceTimestamp
     *
     * @param INTEGER the value
     */
    function setviewedSinceTimestamp($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_viewedSinceTimestamp) ? $this->_viewedSinceTimestamp : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('viewedSinceTimestamp', $value);
	    $this->_viewedSinceTimestamp = $value;
	}
    }
  
    /**
     * Get the value of originationTimestamp
     *
     * @return INTEGER the value
     */
    function getoriginationTimestamp() {
	if (!isset($this->_originationTimestamp)) {
	    return null;
	}
	return $this->_originationTimestamp;
    }

    /**
     * Set the value of originationTimestamp
     *
     * @param INTEGER the value
     */
    function setoriginationTimestamp($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_originationTimestamp) ? $this->_originationTimestamp : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('originationTimestamp', $value);
	    $this->_originationTimestamp = $value;
	}
    }
  
}
?>
