#!/usr/bin/php4 -Cq
<?php

/****************************************************************************
 * Copyright (C) 2005 BRITE NSW Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation (version 2 of the License)
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ****************************************************************************/

if (!defined('GALLIMIMUS_DB'))
{
	if ($_ENV['GALLIMIMUS_DB'])
	{
		define('GALLIMIMUS_DB', $_ENV['GALLIMIMUS_DB']);
	}
}

require_once 'gallimimus/gallimimus.php';

$commands = array(
		'init' => array('help' => "Initialise a Gallimimus database",
				'usage' => "gallimimus init",
				'minargs' => 0,
				'maxargs' => 0),

		'newfeed' => array('help' => "Add a new feed to Gallimimus",
				'usage' => "gallimimus newfeed <id> <title> <link> <description> [logo]\n"
					."\nWhere:\n"
					."\t<id>		A textual ID for the feed;\n"
					."\t<title>		The short title for the feed;\n"
					."\t<link>		A URL to the site associated with this feed;\n"
					."\t<description>	A long description for the feed;\n"
					."\t[logo]		(optional) URL to an image for a logo for the feed.\n",
				'minargs' => 4,
				'maxargs' => 5),

		'additem' => array('help' => "Add a new item to an RSS feed",
				'usage' => "gallimimus additem <feed> <title> <link> <description>\n"
					."\nWhere:\n"
					."\t<feed>		The ID of the feed to add the item to;\n"
					."\t<title>		The short title for the item;\n"
					."\t<link>		A URL to the page associated with the item;\n"
					."\t<description>	A long description for the item;\n",
				'minargs' => 4,
				'maxargs' => 4),

		'help' => array('help' => "Display help on Gallimimus commands",
				'usage' => 'gallimimus help',
				'minargs' => 0,
				'maxargs' => 0)
		);
					
$command = $commands[@$argv[1]];
if (!$command)
{
	echo "Unknown command '$command' -- try gallimimus help\n";
	exit;
}

$args = $argc - 2;
if ($command['minargs'] > $args || $command['maxargs'] < $args)
{
	echo "Usage error.\n";
	echo $command['usage'];
	exit;
}

$DB = OpenDB();

switch ($argv[1])
{
	case 'init':
		InitDB($DB);
		break;
	
	case 'newfeed':
		AddFeed($DB, $argv[2], $argv[3], $argv[4], $argv[5], $argv[6]);
		break;

	case 'additem':
		AddItem($argv[2], $argv[3], $argv[4], $argv[5]);
		break;

	case 'help':
		echo "Commands available in gallimimus:\n\n";
		foreach ($commands as $c => $data)
		{
			echo "$c\t\t".$data['help']."\n";
		}
		break;

	default:
		echo "Can't happen: defined command without a handler.  Aiee!\n";
}
