/***************************************************************************

  mathext.c

  Mathematical extension routines

  (c) 2000-2004 Beno� Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __GBX_MATH_C

#include <math.h>
#include <time.h>
#include <sys/time.h>

#include "gb_common.h"
#include "gbx_math.h"


PRIVATE long seed = 1;

PUBLIC double frac(double x)
{
  x = fabs(x);
  return x - floor(x);
}

PUBLIC long lsgn(long x)
{
  return ((x > 0) ? 1 : ((x < 0) ? (-1) : 0));
}

PUBLIC double fsgn(double x)
{
  return ((x > 0) ? 1 : ((x < 0) ? (-1) : 0));
}

PUBLIC double deg(double x)
{
  return x * 180 / M_PI;
}

PUBLIC double rad(double x)
{
  return x * M_PI / 180;
}

PUBLIC double fix(double x)
{
  if (x >= 0)
    return floor(x);
  else
    return -floor(fabs(x));
}


PUBLIC double frexp10(double x, int *exp)
{
  long double l, f;

  if (x == 0.0)
  {
    *exp = 0;
    return x;
  }

  l = modfl(log10l(fabsl(x)), &f);

  if (f == 0.0)
    l = x;
  else
    l = powl(10, l);

  if (x < 0.0) l = -l;

  while (l >= 1.0)
  {
    l /= 10.0;
    f++;
  }

  *exp = (int)f;
  return l;
}


PUBLIC double rnd(void)
{
  seed = 16807L * (seed % 127773L) - 2836L * (seed / 127773L);
  if (seed <= 0) seed += 2147483647;

  /*printf(" <%ld> ", seed);
  fflush(stdout);*/

  return (double)seed / 2147483648.0;
}


PUBLIC void randomize(void)
{
  struct timeval tv;

  if (gettimeofday(&tv, NULL) == 0)
    seed = tv.tv_sec + tv.tv_usec;
  else
    seed = 0;

  rnd();
  rnd();
}


