/***************************************************************************

  eval.c

  Expression evaluator

  (c) 2000-2003 Beno� Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __EVAL_C

#include "gb_common.h"

#include "gb_array.h"

#include "eval_trans.h"
#include "gb_code.h"
#include "eval.h"

/*#define DEBUG*/

PUBLIC EXPRESSION *EVAL;

PUBLIC void EVAL_init(void)
{
  RESERVED_init();
}


PUBLIC void EVAL_exit(void)
{
  RESERVED_exit();
}

#if 0
PRIVATE void EVAL_enter(VALUE_FUNCTION *value, int nparam)
{
  /* sauvegarde du contexte */

  STACK_push_frame(&EXEC_current);

  /* V�ification de la pile */

  STACK_check(_func.stack_usage);

  /* entr� de fonction */

  BP = SP;
  FP = &_func;
  PC = _func.code;
  OP = NULL;
  CP = &_class;
  EP = NULL;
  EC = NULL;

  RP->type = T_VOID;
}


PRIVATE void EVAL_exec(VALUE_FUNCTION *func, int nparam)
{
  STACK_push_frame(&EXEC_current);

  PC = NULL;

  EVAL_enter(func, nparam);

  TRY
  {
    EXEC_loop();
    STACK_pop_frame(&EXEC_current);
  }
  CATCH
  {
    STACK_pop_frame(&EXEC_current);
    PROPAGATE();
  }
  END_TRY

}
#endif

PUBLIC bool EVAL_expression(EXPRESSION *expr, EVAL_FUNCTION get_value)
{
  EVAL = expr;

  /* Cr�tion d'une pseudo classe avec une pseudo fonction */

  CLEAR(&EVAL->func);
  EVAL->func.type = T_VARIANT;
  EVAL->func.n_param = EVAL->nvar;
  EVAL->func.npmin = EVAL->nvar;
  EVAL->func.stack_usage = EVAL->stack_usage;
  EVAL->func.code = EVAL->code;

  CLEAR(&EVAL->class_load);
  EVAL->class_load.cst = EVAL->cst;
  EVAL->class_load.func = &EVAL->func;
  EVAL->class_load.class_ref = EVAL->class;
  EVAL->class_load.unknown = EVAL->unknown;

  CLEAR(&EVAL->exec_class);
  /*_class.class = CLASS_class;*/
  EVAL->exec_class.name = ".Eval";
  EVAL->exec_class.ref = 1;
  EVAL->exec_class.state = CS_READY;
  EVAL->exec_class.load = &EVAL->class_load;

  return GB.Eval(EVAL, get_value);
}


PUBLIC bool EVAL_compile(EXPRESSION *expr)
{
  bool error = FALSE;

  #ifdef DEBUG
  printf("EVAL: %*.s\n", expr->len, expr->source);
  #endif

  EVAL = expr;

  EVAL_clear(EVAL);

  if (expr->len == 0)
    return TRUE;

  ARRAY_create(&EVAL->pattern);

  TABLE_create(&EVAL->table, sizeof(EVAL_SYMBOL), TF_IGNORE_CASE);
  TABLE_create(&EVAL->string, sizeof(SYMBOL), TF_NORMAL);

  ARRAY_create(&EVAL->cst);
  ARRAY_create(&EVAL->class);
  ARRAY_create(&EVAL->unknown);
  ARRAY_create(&EVAL->code);
  ARRAY_create(&EVAL->var);

  EVAL->nvar = 0;

  TRY
  {
    EVAL_read();
    EVAL_translate();

    EVAL->stack_usage = CODE_stack_usage;
  }
  CATCH
  {
    EVAL_clear(EVAL);
    error = TRUE;
  }
  END_TRY

  #ifdef DEBUG
  CODE_dump(EVAL->code);
  printf("Stack usage = %d\n", CODE_stack_usage);
  #endif

  return error;
}


PUBLIC void EVAL_clear(EXPRESSION *expr)
{
  ARRAY_delete(&expr->tree);

  ARRAY_delete(&expr->var);
  ARRAY_delete(&expr->code);
  ARRAY_delete(&expr->unknown);
  ARRAY_delete(&expr->class);
  ARRAY_delete(&expr->cst);

  TABLE_delete(&expr->string);
  TABLE_delete(&expr->table);

  ARRAY_delete(&expr->pattern);
}


PUBLIC void EVAL_new(EXPRESSION **expr, char *src, long len)
{
  GB.Alloc((void **)expr, sizeof(EXPRESSION));
  CLEAR(*expr);
  GB.NewString(&((*expr)->source), src, len);
  (*expr)->len = len;
  /*(*expr)->option = option;*/
}


PUBLIC void EVAL_free(EXPRESSION **pexpr)
{
  EVAL_clear(*pexpr);
  GB.FreeString(&(*pexpr)->source);
  GB.Free((void **)pexpr);
}


PUBLIC long EVAL_add_constant(CLASS_CONST *cst)
{
  long num;
  CLASS_CONST *desc;

  num =  ARRAY_count(EVAL->cst);

  desc = ARRAY_add(&EVAL->cst);
  *desc = *cst;

  return num;
}


PUBLIC long EVAL_add_class(char *name)
{
  long num;
  CLASS **desc;

  num =  ARRAY_count(EVAL->class);

  desc = ARRAY_add(&EVAL->class);
  *desc = GB.FindClass(name);

  /*sym->class = num + 1;*/

  return num;
}


PUBLIC long EVAL_add_unknown(char *name)
{
  long num;
  char **desc;

  num =  ARRAY_count(EVAL->unknown);

  desc = ARRAY_add(&EVAL->unknown);
  *desc = name;

  return num;
}


PUBLIC long EVAL_add_variable(long index)
{
  EVAL_SYMBOL *sym;

  sym = (EVAL_SYMBOL *)TABLE_get_symbol(EVAL->table, index);

  if (sym->local == 0)
  {
    EVAL->nvar++;
    sym->local = EVAL->nvar;

    *((long *)ARRAY_add(&EVAL->var)) = index;
  }

  return (-sym->local);
}


