/***************************************************************************

  CApp.c

  The native class App

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __GBX_C_APPLICATION_C

#include <signal.h>
#include <sys/wait.h>
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>

#include "gb_common.h"
#include "gbx_api.h"
#include "gambas.h"
#include "gbx_class.h"
#include "gbx_project.h"
#include "gbx_local.h"
#include "gbx_event.h"
#include "gbx_string.h"

#include "gbx_object.h"

#include "gbx_c_application.h"

PRIVATE GB_FUNCTION signal_func;
PRIVATE bool has_signal_func;


PRIVATE void got_signal_after(long param)
{
  GB_Call(&signal_func, 0, FALSE);
}


PUBLIC void CAPP_got_signal(void)
{
  if (!has_signal_func)
    return;

  GB_Post(got_signal_after, 0);
}


PUBLIC void CAPP_init()
{
  CLASS *class = CLASS_find(PROJECT_startup);

  has_signal_func = GB_GetFunction(&signal_func, class, "Application_Signal", "") == 0;

  /*printf("has_signal_func = %d\n", has_signal_func);*/
}


BEGIN_PROPERTY(app_path)

  GB_ReturnString(PROJECT_path);

END_PROPERTY


BEGIN_PROPERTY(app_home)

  struct passwd *info = getpwuid(getuid());

  if (info)
    GB_ReturnNewString(info->pw_dir, 0);
  else
    GB_Error((char *)E_MEMORY);

END_PROPERTY


BEGIN_PROPERTY(app_user)

  struct passwd *info = getpwuid(getuid());

  if (info)
    GB_ReturnNewString(info->pw_name, 0);
  else
    GB_Error((char *)E_MEMORY);

END_PROPERTY


BEGIN_PROPERTY(app_name)

  GB_ReturnConstZeroString(PROJECT_name);

END_PROPERTY


BEGIN_PROPERTY(app_title)

  GB_ReturnConstZeroString(LOCAL_gettext(PROJECT_title));

END_PROPERTY


BEGIN_PROPERTY(app_language)

  if (READ_PROPERTY)
    GB_ReturnNewZeroString(LOCAL_get_lang());
  else
    LOCAL_set_lang(GB_ToZeroString(PROP(GB_STRING)));

END_PROPERTY


BEGIN_PROPERTY(app_charset)

  GB_ReturnString(LOCAL_encoding);

END_PROPERTY


BEGIN_PROPERTY(app_id)

  GB_ReturnInt(getpid());

END_PROPERTY


BEGIN_PROPERTY(CAPPLICATION_version)

  GB_ReturnConstZeroString(PROJECT_version);

END_PROPERTY


BEGIN_PROPERTY(app_args)

  static OBJECT args;

  args.class = CLASS_AppArgs;
  GB_ReturnObject(&args);

END_PROPERTY


BEGIN_PROPERTY(app_args_count)

  GB_ReturnInt(PROJECT_argc);

END_PROPERTY


BEGIN_METHOD(app_args_get, GB_INTEGER index)

  long index = VARG(index);

  if (index < 0)
  {
    GB_Error((char *)E_ARG);
    return;
  }

  if (index >= PROJECT_argc)
    GB_ReturnNull();
  else
    GB_ReturnConstZeroString(PROJECT_argv[index]);

END_METHOD


BEGIN_PROPERTY(app_env)

  static OBJECT env;

  env.class = CLASS_AppEnv;
  GB_ReturnObject(&env);

END_PROPERTY


BEGIN_METHOD(app_env_get, GB_STRING key)

  GB_ReturnConstZeroString(getenv(GB_ToZeroString(ARG(key))));

END_METHOD


BEGIN_METHOD(app_env_put, GB_STRING value; GB_STRING key)

  setenv(GB_ToZeroString(ARG(key)), GB_ToZeroString(ARG(value)), 1);

END_METHOD


BEGIN_PROPERTY(system_path)

  GB_ReturnString(PROJECT_exec_path);

END_PROPERTY


BEGIN_PROPERTY(system_host)

  char buffer[256];

  gethostname(buffer, 255);
  GB_ReturnNewZeroString(buffer);

END_PROPERTY


BEGIN_PROPERTY(system_domain)

  char buffer[256];

  getdomainname(buffer, 255);
  GB_ReturnNewZeroString(buffer);

END_PROPERTY



PUBLIC GB_DESC NATIVE_AppArgs[] =
{
  GB_DECLARE(".ApplicationArgs", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_PROPERTY_READ("Count", "i", app_args_count),
  GB_STATIC_METHOD("_get", "s", app_args_get, "(Index)i"),

  GB_END_DECLARE
};


PUBLIC GB_DESC NATIVE_AppEnv[] =
{
  GB_DECLARE(".ApplicationEnv", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_METHOD("_get", "s", app_env_get, "(Key)s"),
  GB_STATIC_METHOD("_put", NULL, app_env_put, "(Value)s(Key)s"),

  GB_END_DECLARE
};


PUBLIC GB_DESC NATIVE_App[] =
{
  GB_DECLARE("Application", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_PROPERTY_SELF("Args", ".ApplicationArgs"),
  GB_STATIC_PROPERTY_SELF("Env", ".ApplicationEnv"),
  GB_STATIC_PROPERTY_READ("Path", "s", app_path),
  //GB_STATIC_PROPERTY_READ("Home", "s", app_home),
  GB_STATIC_PROPERTY_READ("Name", "s", app_name),
  GB_STATIC_PROPERTY_READ("Title", "s", app_title),
  //GB_STATIC_PROPERTY_READ("User", "s", app_user),
  GB_STATIC_PROPERTY_READ("Id", "i", app_id),
  GB_STATIC_PROPERTY_READ("Handle", "i", app_id),
  GB_STATIC_PROPERTY_READ("Version", "s", CAPPLICATION_version),

  GB_END_DECLARE
};

PUBLIC GB_DESC NATIVE_System[] =
{
  GB_DECLARE("System", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_PROPERTY("Language", "s", app_language),
  GB_STATIC_PROPERTY_READ("Charset", "s", app_charset),
  GB_STATIC_PROPERTY_READ("Path", "s", system_path),
  GB_STATIC_PROPERTY_READ("Home", "s", app_home),
  GB_STATIC_PROPERTY_READ("User", "s", app_user),
  GB_STATIC_PROPERTY_READ("Host", "s", system_host),
  GB_STATIC_PROPERTY_READ("Domain", "s", system_domain),

  GB_END_DECLARE
};

