/***************************************************************************

  CDatePicker.cpp

  The KDE Date Selector

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/
#define __CDATEPICKER_CPP


#include <kdatepicker.h>

#include "gambas.h"
#include "main.h"
#include <qapplication.h>
#include "CDatePicker.h"

DECLARE_EVENT(EVENT_Change);

/***************************************************************************

  MyDatePicker

***************************************************************************/

/*
MyDatePicker::MyDatePicker(QWidget *parent)
: QDatePicker(parent)
{
}


MyDatePicker::paintEvent(QWidget *parent)
{

}
*/

/***************************************************************************

  class CDatePicker

***************************************************************************/

CDatePicker CDatePicker::manager;

void CDatePicker::changed()
{
  void *object = QT.GetObject((QWidget *)sender());
  GB.Raise(object, EVENT_Change, 0);
}


/***************************************************************************

  DatePicker

***************************************************************************/

BEGIN_METHOD(CDATEPICKER_new, GB_OBJECT parent)

  KDatePicker *wid = new KDatePicker(QT.GetContainer(VARG(parent)));

  wid->setMinimumSize(128, 128);

  QT.InitWidget(wid, _object);

  QObject::connect(wid, SIGNAL(dateChanged(QDate)), &CDatePicker::manager, SLOT(changed()));
  //QObject::connect(wid, SIGNAL(dateSelected(QDate)), &CDatePicker::manager, SLOT(changed()));
  //QObject::connect(wid, SIGNAL(dateEntered(QDate)), &CDatePicker::manager, SLOT(changed()));

  wid->show();

END_METHOD


BEGIN_PROPERTY(CDATEPICKER_value)

  GB_DATE date;

  if (READ_PROPERTY)
  {
    GB_DATE_SERIAL serial = { 0 };
    QDate d = WIDGET->getDate();
    serial.year = d.year();
    serial.month = d.month();
    serial.day = d.day();
    GB.MakeDate(&serial, &date);
    GB.ReturnDate(&date);
  }
  else
  {
    GB_DATE_SERIAL *serial;

    serial = GB.SplitDate(PROP(GB_DATE));
    QDate d(serial->year, serial->month, serial->day);
    WIDGET->setDate(d);
  }

END_PROPERTY


GB_DESC CDatePickerDesc[] =
{
  GB_DECLARE("DatePicker", sizeof(CDATEPICKER)), GB_INHERITS("Control"),

  GB_METHOD("_new", NULL, CDATEPICKER_new, "(Parent)Container;"),

  GB_PROPERTY("Value", "d", CDATEPICKER_value),

  GB_CONSTANT("_Properties", "s", CDATEPICKER_PROPERTIES),
  GB_CONSTANT("_DefaultEvent", "s", "Change"),

  GB_EVENT("Change", NULL, NULL, &EVENT_Change),

  GB_END_DECLARE
};

