/***************************************************************************

  CTimer.h

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __CTIMER_H
#define __CTIMER_H

#include "gambas.h"

#include <qtimer.h>
#include <qevent.h>

#ifndef __CTIMER_CPP
extern GB_DESC CTimerDesc[];
#else

#define THIS ((CTIMER *)_object)
#define TIMER (((CTIMER *)_object)->timer)

#define CTIMER_PROPERTIES "Enabled,Delay"


#endif

class MyTimer;

typedef
  struct {
    GB_BASE ob;
    MyTimer *timer;
    }
  CTIMER;


class MyTimer : public QObject
{
public:

  MyTimer(CTIMER *, QObject * = 0);
  ~MyTimer();

  bool isEnabled(void) { return _enabled; };
  void setEnabled(bool);
  long delay(void) { return _delay; };
  void setDelay(long);

protected:

  void timerEvent(QTimerEvent *);

private:

  long _delay;
  long id;
  CTIMER *_ob;
  bool _enabled;
};

#endif
