/*******************************************
 *
 * $GAMGI/src/gtk/gamgi_gtk_select.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"

#include "gamgi_engine_list.h"
#include "gamgi_engine_dlist.h"
#include "gamgi_gtk_dialog.h"

static void static_orbital_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;

printf ("handle orbital select ok\n");
gamgi_gtk_dialog_task0_remove (widget, window);
}

static void static_arrow_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;

printf ("handle arrow select ok\n");
gamgi_gtk_dialog_task0_remove (widget, window);
}

static void static_shape_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;

printf ("handle shape select ok\n");
gamgi_gtk_dialog_task0_remove (widget, window);
}

static void static_graph_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;

printf ("handle graph select ok\n");
gamgi_gtk_dialog_task0_remove (widget, window);
}

GtkTreeIter gamgi_gtk_select_row (GtkTreeStore *store, 
GtkTreeIter *parent, gamgi_object *object)
{
GtkTreeIter iter;
char string[GAMGI_ENGINE_STRING];

sprintf (string, "%s %d", object->name, object->number);

gtk_tree_store_append (store, &iter, parent);
gtk_tree_store_set (store, &iter, 0, string, -1);

return iter;
}

GtkWidget *gamgi_gtk_select_dialog (gamgi_window *window, 
gamgi_callback2 function_ok)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *scrolled_window;
GtkWidget *vbox;
GtkWidget *hbox;
GtkWidget *button;
GtkWidget *treeview;
GtkCellRenderer *renderer;
GtkTreeViewColumn *column;
GtkTreeSelection *selection;

gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);

vbox = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (dialog), vbox);
gtk_widget_show (vbox);

scrolled_window = gtk_scrolled_window_new (NULL, NULL);
gtk_box_pack_start (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);
gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC); 
gtk_widget_show (scrolled_window);
  
treeview = gtk_tree_view_new ();
gtk_container_add (GTK_CONTAINER (scrolled_window), treeview);
gtk_widget_set_size_request (treeview,
GAMGI_GTK_SELECT_WIDTH, GAMGI_GTK_SELECT_HEIGHT);
selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview));
gtk_tree_selection_set_mode (selection, GTK_SELECTION_BROWSE);
g_object_set_data (G_OBJECT (dialog), "treeview", treeview);
gtk_widget_show (treeview);

renderer = gtk_cell_renderer_text_new ();
column = gtk_tree_view_column_new_with_attributes ("Object", renderer, "text", 0, NULL);
gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), FALSE);

/*********************
 * Ok/Cancel buttons *
 *********************/

hbox = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
gtk_widget_show (hbox);

button = gamgi_gtk_dialog_button_create ("Ok", NULL);
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "clicked",
(GtkSignalFunc) function_ok, window);
gtk_widget_show (button);

button = gamgi_gtk_dialog_button_create ("Cancel", "red");
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
gtk_widget_grab_focus (button);
g_signal_connect (GTK_OBJECT (button), "clicked",
(GtkSignalFunc) gamgi_gtk_dialog_task0_remove, window);
gtk_widget_show (button);

return treeview;
}

void gamgi_gtk_select_text (GtkTreeStore *store, 
GtkTreeIter *iter_parent, gamgi_text *text)
{
gamgi_dlist *dlist;
gamgi_text *child;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT text);

dlist = text->text_start;
while (dlist != NULL)
  {
  child = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, child);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_orbital (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_orbital *orbital)
{
gamgi_dlist *dlist;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT orbital);

dlist = orbital->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_orbital_select (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog;
GtkWidget *treeview;
GtkTreeStore *store;
gamgi_dlist *dlist;

dialog = gamgi_gtk_dialog_task0_create ("Orbital Select", window);
window->action = GAMGI_GTK_ORBITAL_SELECT;

treeview = gamgi_gtk_select_dialog (window, static_orbital_ok);
store = gtk_tree_store_new (1, G_TYPE_STRING);

dlist = gamgi_engine_dlist_orbital_gamgi (NULL);
while (dlist != NULL)
  {
  gamgi_gtk_select_orbital (store, NULL, GAMGI_CAST_ORBITAL dlist->data);
  dlist = gamgi_engine_dlist_remove_start (dlist);
  }

gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
g_object_unref (store);

gtk_widget_show (dialog);
}

void gamgi_gtk_select_bond (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_bond *bond)
{
gamgi_dlist *dlist;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT bond);

dlist = bond->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = bond->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_atom (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_atom *atom)
{
gamgi_dlist *dlist;
gamgi_bond *bond;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT atom);

dlist = atom->bond_start;
while (dlist != NULL)
  {
  bond = GAMGI_CAST_BOND dlist->data;
  gamgi_gtk_select_bond (store, &iter, bond);
  dlist = dlist->next;
  }

dlist = atom->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = atom->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_direction (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_direction *direction)
{
gamgi_dlist *dlist;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT direction);

dlist = direction->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = direction->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = direction->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_plane (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_plane *plane)
{
gamgi_dlist *dlist;
gamgi_direction *direction;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT plane);

dlist = plane->direction_start;
while (dlist != NULL)
  {
  direction = GAMGI_CAST_DIRECTION dlist->data;
  gamgi_gtk_select_direction (store, &iter, direction);
  dlist = dlist->next;
  }

dlist = plane->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = plane->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = plane->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_group (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_group *group)
{
gamgi_dlist *dlist;
gamgi_group *child;
gamgi_plane *plane;
gamgi_direction *direction;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT group);

dlist = group->group_start;
while (dlist != NULL)
  {
  child = GAMGI_CAST_GROUP dlist->data;
  gamgi_gtk_select_group (store, &iter, child);
  dlist = dlist->next;
  }

dlist = group->plane_start;
while (dlist != NULL)
  {
  plane = GAMGI_CAST_PLANE dlist->data;
  gamgi_gtk_select_plane (store, &iter, plane);
  dlist = dlist->next;
  }

dlist = group->direction_start;
while (dlist != NULL)
  {
  direction = GAMGI_CAST_DIRECTION dlist->data;
  gamgi_gtk_select_direction (store, &iter, direction);
  dlist = dlist->next;
  }

dlist = group->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = group->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = group->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_molecule (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_molecule *molecule)
{
gamgi_dlist *dlist;
gamgi_group *group;
gamgi_plane *plane;
gamgi_direction *direction;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT molecule);

dlist = molecule->group_start;
while (dlist != NULL)
  {
  group = GAMGI_CAST_GROUP dlist->data;
  gamgi_gtk_select_group (store, &iter, group);
  dlist = dlist->next;
  }

dlist = molecule->plane_start;
while (dlist != NULL)
  {
  plane = GAMGI_CAST_PLANE dlist->data;
  gamgi_gtk_select_plane (store, &iter, plane);
  dlist = dlist->next;
  }

dlist = molecule->direction_start;
while (dlist != NULL)
  {
  direction = GAMGI_CAST_DIRECTION dlist->data;
  gamgi_gtk_select_direction (store, &iter, direction);
  dlist = dlist->next;
  }

dlist = molecule->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = molecule->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = molecule->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_cluster (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_cluster *cluster)
{
gamgi_dlist *dlist;
gamgi_cluster *child;
gamgi_molecule *molecule;
gamgi_group *group;
gamgi_plane *plane;
gamgi_direction *direction;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT cluster);

dlist = cluster->cluster_start;
while (dlist != NULL)
  {
  child = GAMGI_CAST_CLUSTER dlist->data;
  gamgi_gtk_select_cluster (store, &iter, child);
  dlist = dlist->next;
  }

dlist = cluster->molecule_start;
while (dlist != NULL)
  {
  molecule = GAMGI_CAST_MOLECULE dlist->data;
  gamgi_gtk_select_molecule (store, &iter, molecule);
  dlist = dlist->next;
  }

dlist = cluster->group_start;
while (dlist != NULL)
  {
  group = GAMGI_CAST_GROUP dlist->data;
  gamgi_gtk_select_group (store, &iter, group);
  dlist = dlist->next;
  }

dlist = cluster->plane_start;
while (dlist != NULL)
  {
  plane = GAMGI_CAST_PLANE dlist->data;
  gamgi_gtk_select_plane (store, &iter, plane);
  dlist = dlist->next;
  }

dlist = cluster->direction_start;
while (dlist != NULL)
  {
  direction = GAMGI_CAST_DIRECTION dlist->data;
  gamgi_gtk_select_direction (store, &iter, direction);
  dlist = dlist->next;
  }

dlist = cluster->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = cluster->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = cluster->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_cell (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_cell *cell)
{
gamgi_dlist *dlist;
gamgi_cluster *cluster;
gamgi_molecule *molecule;
gamgi_group *group;
gamgi_plane *plane;
gamgi_direction *direction;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT cell);

dlist = cell->cluster_start;
while (dlist != NULL)
  {
  cluster = GAMGI_CAST_CLUSTER dlist->data;
  gamgi_gtk_select_cluster (store, &iter, cluster);
  dlist = dlist->next;
  }

dlist = cell->molecule_start;
while (dlist != NULL)
  {
  molecule = GAMGI_CAST_MOLECULE dlist->data;
  gamgi_gtk_select_molecule (store, &iter, molecule);
  dlist = dlist->next;
  }

dlist = cell->group_start;
while (dlist != NULL)
  {
  group = GAMGI_CAST_GROUP dlist->data;
  gamgi_gtk_select_group (store, &iter, group);
  dlist = dlist->next;
  }

dlist = cell->plane_start;
while (dlist != NULL)
  {
  plane = GAMGI_CAST_PLANE dlist->data;
  gamgi_gtk_select_plane (store, &iter, plane);
  dlist = dlist->next;
  }

dlist = cell->direction_start;
while (dlist != NULL)
  {
  direction = GAMGI_CAST_DIRECTION dlist->data;
  gamgi_gtk_select_direction (store, &iter, direction);
  dlist = dlist->next;
  }

dlist = cell->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = cell->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = cell->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_arrow (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_arrow *arrow)
{
gamgi_dlist *dlist;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT arrow);

dlist = arrow->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }
}

void gamgi_gtk_arrow_select (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog;
GtkWidget *treeview;
GtkTreeStore *store;
gamgi_dlist *dlist;

dialog = gamgi_gtk_dialog_task0_create ("Arrow Select", window);
window->action = GAMGI_GTK_ARROW_SELECT;

treeview = gamgi_gtk_select_dialog (window, static_arrow_ok);
store = gtk_tree_store_new (1, G_TYPE_STRING);

dlist = gamgi_engine_dlist_arrow_gamgi (NULL);
while (dlist != NULL)
  {
  gamgi_gtk_select_arrow (store, NULL, GAMGI_CAST_ARROW dlist->data);
  dlist = gamgi_engine_dlist_remove_start (dlist);
  }

gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
g_object_unref (store);

gtk_widget_show (dialog);
}

void gamgi_gtk_select_shape (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_shape *shape)
{
gamgi_dlist *dlist;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT shape);

dlist = shape->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_shape_select (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog;
GtkWidget *treeview;
GtkTreeStore *store;
gamgi_dlist *dlist;

dialog = gamgi_gtk_dialog_task0_create ("Shape Select", window);
window->action = GAMGI_GTK_SHAPE_SELECT;

treeview = gamgi_gtk_select_dialog (window, static_shape_ok);
store = gtk_tree_store_new (1, G_TYPE_STRING);

dlist = gamgi_engine_dlist_shape_gamgi (NULL);
while (dlist != NULL)
  {
  gamgi_gtk_select_shape (store, NULL, GAMGI_CAST_SHAPE dlist->data);
  dlist = gamgi_engine_dlist_remove_start (dlist);
  }

gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
g_object_unref (store);

gtk_widget_show (dialog);
}

void gamgi_gtk_select_graph (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_graph *graph)
{
gamgi_dlist *dlist;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT graph);

dlist = graph->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }
}

void gamgi_gtk_graph_select (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog;
GtkWidget *treeview;
GtkTreeStore *store;
gamgi_dlist *dlist;

dialog = gamgi_gtk_dialog_task0_create ("Graph Select", window);
window->action = GAMGI_GTK_GRAPH_SELECT;

treeview = gamgi_gtk_select_dialog (window, static_graph_ok);
store = gtk_tree_store_new (1, G_TYPE_STRING);

dlist = gamgi_engine_dlist_graph_gamgi (NULL);
while (dlist != NULL)
  {
  gamgi_gtk_select_graph (store, NULL, GAMGI_CAST_GRAPH dlist->data);
  dlist = gamgi_engine_dlist_remove_start (dlist);
  }

gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
g_object_unref (store);

gtk_widget_show (dialog);
}

void gamgi_gtk_select_assembly (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_assembly *assembly)
{
gamgi_dlist *dlist;
gamgi_assembly *child;
gamgi_graph *graph;
gamgi_shape *shape;
gamgi_arrow *arrow;
gamgi_cell *cell;
gamgi_cluster *cluster;
gamgi_molecule *molecule;
gamgi_group *group;
gamgi_plane *plane;
gamgi_direction *direction;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT assembly);

dlist = assembly->assembly_start;
while (dlist != NULL)
  {
  child = GAMGI_CAST_ASSEMBLY dlist->data;
  gamgi_gtk_select_assembly (store, &iter, child);
  dlist = dlist->next;
  }

dlist = assembly->graph_start;
while (dlist != NULL)
  {
  graph = GAMGI_CAST_GRAPH dlist->data;
  gamgi_gtk_select_graph (store, &iter, graph);
  dlist = dlist->next;
  }

dlist = assembly->shape_start;
while (dlist != NULL)
  {
  shape = GAMGI_CAST_SHAPE dlist->data;
  gamgi_gtk_select_shape (store, &iter, shape);
  dlist = dlist->next;
  }

dlist = assembly->arrow_start;
while (dlist != NULL)
  {
  arrow = GAMGI_CAST_ARROW dlist->data;
  gamgi_gtk_select_arrow (store, &iter, arrow);
  dlist = dlist->next;
  }

dlist = assembly->cell_start;
while (dlist != NULL)
  {
  cell = GAMGI_CAST_CELL dlist->data;
  gamgi_gtk_select_cell (store, &iter, cell);
  dlist = dlist->next;
  }

dlist = assembly->cluster_start;
while (dlist != NULL)
  {
  cluster = GAMGI_CAST_CLUSTER dlist->data;
  gamgi_gtk_select_cluster (store, &iter, cluster);
  dlist = dlist->next;
  }

dlist = assembly->molecule_start;
while (dlist != NULL)
  {
  molecule = GAMGI_CAST_MOLECULE dlist->data;
  gamgi_gtk_select_molecule (store, &iter, molecule);
  dlist = dlist->next;
  }

dlist = assembly->group_start;
while (dlist != NULL)
  {
  group = GAMGI_CAST_GROUP dlist->data;
  gamgi_gtk_select_group (store, &iter, group);
  dlist = dlist->next;
  }

dlist = assembly->plane_start;
while (dlist != NULL)
  {
  plane = GAMGI_CAST_PLANE dlist->data;
  gamgi_gtk_select_plane (store, &iter, plane);
  dlist = dlist->next;
  }

dlist = assembly->direction_start;
while (dlist != NULL)
  {
  direction = GAMGI_CAST_DIRECTION dlist->data;
  gamgi_gtk_select_direction (store, &iter, direction);
  dlist = dlist->next;
  }

dlist = assembly->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = assembly->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }

dlist = assembly->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_light (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_light *light)
{
gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT light);
}

void gamgi_gtk_select_layer (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_layer *layer)
{
gamgi_dlist *dlist;
gamgi_light *light;
gamgi_assembly *assembly;
gamgi_graph *graph;
gamgi_shape *shape;
gamgi_arrow *arrow;
gamgi_cell *cell;
gamgi_cluster *cluster;
gamgi_molecule *molecule;
gamgi_group *group;
gamgi_plane *plane;
gamgi_direction *direction;
gamgi_atom *atom;
gamgi_orbital *orbital;
gamgi_text *text;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT layer);

dlist = layer->light_start;
while (dlist != NULL)
  {
  light = GAMGI_CAST_LIGHT dlist->data;
  gamgi_gtk_select_light (store, &iter, light);
  dlist = dlist->next;
  }

dlist = layer->assembly_start;
while (dlist != NULL)
  {
  assembly = GAMGI_CAST_ASSEMBLY dlist->data;
  gamgi_gtk_select_assembly (store, &iter, assembly);
  dlist = dlist->next;
  }

dlist = layer->graph_start;
while (dlist != NULL)
  {
  graph = GAMGI_CAST_GRAPH dlist->data;
  gamgi_gtk_select_graph (store, &iter, graph);
  dlist = dlist->next;
  }

dlist = layer->shape_start;
while (dlist != NULL)
  {
  shape = GAMGI_CAST_SHAPE dlist->data;
  gamgi_gtk_select_shape (store, &iter, shape);
  dlist = dlist->next;
  }

dlist = layer->arrow_start;
while (dlist != NULL)
  {
  arrow = GAMGI_CAST_ARROW dlist->data;
  gamgi_gtk_select_arrow (store, &iter, arrow);
  dlist = dlist->next;
  }

dlist = layer->cell_start;
while (dlist != NULL)
  {
  cell = GAMGI_CAST_CELL dlist->data;
  gamgi_gtk_select_cell (store, &iter, cell);
  dlist = dlist->next;
  }

dlist = layer->cluster_start;
while (dlist != NULL)
  {
  cluster = GAMGI_CAST_CLUSTER dlist->data;
  gamgi_gtk_select_cluster (store, &iter, cluster);
  dlist = dlist->next;
  }

dlist = layer->molecule_start;
while (dlist != NULL)
  {
  molecule = GAMGI_CAST_MOLECULE dlist->data;
  gamgi_gtk_select_molecule (store, &iter, molecule);
  dlist = dlist->next;
  }

dlist = layer->group_start;
while (dlist != NULL)
  {
  group = GAMGI_CAST_GROUP dlist->data;
  gamgi_gtk_select_group (store, &iter, group);
  dlist = dlist->next;
  }

dlist = layer->plane_start;
while (dlist != NULL)
  {
  plane = GAMGI_CAST_PLANE dlist->data;
  gamgi_gtk_select_plane (store, &iter, plane);
  dlist = dlist->next;
  }

dlist = layer->direction_start;
while (dlist != NULL)
  {
  direction = GAMGI_CAST_DIRECTION dlist->data;
  gamgi_gtk_select_direction (store, &iter, direction);
  dlist = dlist->next;
  }

dlist = layer->atom_start;
while (dlist != NULL)
  {
  atom = GAMGI_CAST_ATOM dlist->data;
  gamgi_gtk_select_atom (store, &iter, atom);
  dlist = dlist->next;
  }

dlist = layer->orbital_start;
while (dlist != NULL)
  {
  orbital = GAMGI_CAST_ORBITAL dlist->data;
  gamgi_gtk_select_orbital (store, &iter, orbital);
  dlist = dlist->next;
  }
 
dlist = layer->text_start;
while (dlist != NULL)
  {
  text = GAMGI_CAST_TEXT dlist->data;
  gamgi_gtk_select_text (store, &iter, text);
  dlist = dlist->next;
  }

}

void gamgi_gtk_select_window (GtkTreeStore *store,
GtkTreeIter *iter_parent, gamgi_window *window)
{
gamgi_dlist *dlist;
gamgi_layer *layer;
GtkTreeIter iter;

iter = gamgi_gtk_select_row (store, iter_parent, GAMGI_CAST_OBJECT window);

dlist = window->layer_start;
while (dlist != NULL)
  {
  layer = GAMGI_CAST_LAYER dlist->data;
  gamgi_gtk_select_layer (store, &iter, layer);
  dlist = dlist->next;
  }
}
