/***************************************
 *
 * $GAMGI/src/math/gamgi_math_modify.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_math.h"

#include "gamgi_gtk_dialog.h"
#include "gamgi_math_vector.h"
#include "gamgi_math_matrix.h"

/*********** external function **********
 *                                      *
 *       GAMGI_MATH_MODIFY_LENGTH       *
 *                                      *
 ****************************************/

void gamgi_math_modify_length (gamgi_atom *atom1, 
gamgi_atom *atom2, double length, double *translate)
{
double old;

gamgi_math_vector_absolute (translate, 
atom1->position[0] - atom2->position[0],
atom1->position[1] - atom2->position[1], 
atom1->position[2] - atom2->position[2]);

old = gamgi_math_vector_length (translate);

gamgi_math_vector_scale (translate, translate, length/old - 1.0);
}

/*********** external function **********
 *                                      *
 *     GAMGI_MATH_MODIFY_TRANSLATE      *
 *                                      *
 ****************************************/

void gamgi_math_modify_translate (gamgi_atom *atom, 
double *translate)
{
atom->position[0] += translate[0];
atom->position[1] += translate[1];
atom->position[2] += translate[2];
}

/*********** external function **********
 *                                      *
 *        GAMGI_MATH_MODIFY_ANGLE       *
 *                                      *
 ****************************************/

int gamgi_math_modify_angle (gamgi_atom *atom1, 
gamgi_atom *atom2, gamgi_atom *atom3, double new,
double *origin, double *rotate, gamgi_layer *layer)
{
double v21[3], v23[3], axis[3], view[3];
double old, angle, axis_length;

gamgi_math_vector_absolute (origin, 
atom2->position[0], atom2->position[1], atom2->position[2]);

gamgi_math_vector_absolute (v21, 
atom1->position[0] - atom2->position[0],
atom1->position[1] - atom2->position[1], 
atom1->position[2] - atom2->position[2]);

gamgi_math_vector_absolute (v23, 
atom3->position[0] - atom2->position[0],
atom3->position[1] - atom2->position[1], 
atom3->position[2] - atom2->position[2]);

gamgi_math_vector_cross (v21, v23, axis);
axis_length = gamgi_math_vector_length (axis);

/***********************
 * 3 atoms are aligned *
 ***********************/

if (axis_length < GAMGI_MATH_TOLERANCE_LENGTH) return FALSE;
else
  {
  /*************** 
   * normal case *
   ***************/

  gamgi_math_vector_scale (axis, axis, 1.0/axis_length);

  old = gamgi_math_vector_angle (v21, v23);

  /********************************************
   * Define a vector going from the position  *
   * where the user is to the image center.   *
   * Clearly this vector points away from the *
   * user and is perpendicular to the screen. *
   ********************************************/

  gamgi_math_vector_sub (layer->center, layer->eye, view);

  /***********************************************************
   * the angle to rotate should be:                          *
   *    angle = new - old;                                   *
   * if axis is on the other side, the rotation is reversed: *
   *    angle = old - new;                                   *
   * if axis is pointing to us, then old is negative:        *
   *    angle = new + old;                                   *
   ***********************************************************/

  if (gamgi_math_vector_dot (axis, view) > 0)
    angle = old - new;
  else
    angle = old + new;

  gamgi_math_matrix_rotation (angle, axis, rotate);
  }

return TRUE;
}

/*********** external function **********
 *                                      *
 *       GAMGI_MATH_MODIFY_TORSION      *
 *                                      *
 ****************************************/

int gamgi_math_modify_torsion (gamgi_atom *atom1, 
gamgi_atom *atom2, gamgi_atom *atom3, gamgi_atom *atom4, 
double new, double *origin, double *rotate, 
gamgi_layer *layer)
{
double v23[3], v21[3], v34[3], v32[3];
double w1[3], w2[3], axis[3], view[3];
double old, angle, w1_length, w2_length, axis_length;

gamgi_math_vector_absolute (origin, 
atom2->position[0], atom2->position[1], atom2->position[2]);

gamgi_math_vector_absolute (v23, 
atom3->position[0] - atom2->position[0],
atom3->position[1] - atom2->position[1], 
atom3->position[2] - atom2->position[2]);

gamgi_math_vector_absolute (v21, 
atom1->position[0] - atom2->position[0],
atom1->position[1] - atom2->position[1], 
atom1->position[2] - atom2->position[2]);

gamgi_math_vector_absolute (v34, 
atom4->position[0] - atom3->position[0],
atom4->position[1] - atom3->position[1], 
atom4->position[2] - atom3->position[2]);

gamgi_math_vector_absolute (v32, 
atom2->position[0] - atom3->position[0],
atom2->position[1] - atom3->position[1], 
atom2->position[2] - atom3->position[2]);

gamgi_math_vector_cross (v23, v21, w1);
gamgi_math_vector_cross (v34, v32, w2);

w1_length = gamgi_math_vector_length (w1);
w2_length = gamgi_math_vector_length (w2);

/****************************
 * 3 or 4 atoms are aligned *
 ****************************/

if (w1_length < GAMGI_MATH_TOLERANCE_LENGTH || 
w2_length < GAMGI_MATH_TOLERANCE_LENGTH) return FALSE;
else
  {
  /********************************************
   * Define a vector going from the position  *
   * where the user is to the image center.   *
   * Clearly this vector points away from the *
   * user and is perpendicular to the screen. *
   ********************************************/

  gamgi_math_vector_sub (layer->center, layer->eye, view);

  gamgi_math_vector_cross (w1, w2, axis);
  axis_length = gamgi_math_vector_length (axis);

  if (axis_length < GAMGI_MATH_TOLERANCE_LENGTH) 
    {
    /************************
     * old = 0 || old = 180 *
     ************************/

    if (gamgi_math_vector_dot (w1, w2) > 0)
      old = 0.0;
    else
      old = 180.0;

    gamgi_math_vector_copy (v23, axis);
    gamgi_math_vector_normal (axis);

    /***********************************************************
     * the angle to rotate should be:                          *
     *    angle = new - old;                                   *
     * if axis is on the other side, the rotation is reversed: *
     *    angle = old - new;                                   *
     ***********************************************************/

     if (gamgi_math_vector_dot (axis, view) > 0)
       angle = old - new;
     else
       angle = new - old;
    }
  else
    { 
    /***************
     * normal case *
     ***************/

    gamgi_math_vector_scale (axis, axis, 1.0/axis_length);
    old = gamgi_math_vector_angle (w1, w2);
  
    /***********************************************************
     * the angle to rotate should be:                          *
     *    angle = new - old;                                   *
     * if axis is on the other side, the rotation is reversed: *
     *    angle = old - new;                                   *
     * if axis is pointing to us, then old is negative:        *
     *    angle = new + old;                                   *
     ***********************************************************/

    if (gamgi_math_vector_dot (axis, view) > 0)
      angle = old - new;
    else
      angle = old + new;
    }
  gamgi_math_matrix_rotation (angle, axis, rotate);
  }

return TRUE;
}

/*********** external function **********
 *                                      *
 *        GAMGI_MATH_MODIFY_ROTATE      *
 *                                      *
 ****************************************/

void gamgi_math_modify_rotate (gamgi_atom *atom,       
double *origin, double *rotate)
{
double v1[3], v2[3];

v1[0] = atom->position[0];
v1[1] = atom->position[1];
v1[2] = atom->position[2];

gamgi_math_vector_sub (v1, origin, v1);
gamgi_math_matrix_vector (rotate, v1, v2);
gamgi_math_vector_add (v2, origin, v2);

atom->position[0] = v2[0];
atom->position[1] = v2[1];
atom->position[2] = v2[2];
}
