/******************************************
 *
 * $GAMGI/src/mesa/gamgi_mesa_scale.c
 *
 * Copyright (C) 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_mesa.h"
#include "gamgi_math.h"
#include "gamgi_global.h"

void gamgi_mesa_scale_light (gamgi_light *light, double scale)
{
/**************
 * spot light *
 **************/

/*********************************************************
 * this method guarantees that after scaling the SAME    *
 * amount up and down with the mouse or left and right   *
 * with the ruler, the initial and final scaling factors *
 * are exactly the equal. For example, if s0 is the      *
 * initial scaling, after scaling +s and -s, we get:     *
 * (s0 + s0 * s) + (s0 + s0 * s) * 1/(1/-s - 1) = s0     *
 *********************************************************/

if (light->angle != 180.0)
  {
  if (scale > 0.0)
    {
    light->angle *= 1.0 + scale;
    if (light->angle > 90.0) light->angle = 90.0;
    }
  else
    {
    light->angle *= 1 / (1.0 - scale);
    if (light->angle < GAMGI_MATH_TOLERANCE_ANGLE)
      light->angle = GAMGI_MATH_TOLERANCE_ANGLE;
    }
  }

}

void gamgi_mesa_scale_default (gamgi_object *object, double scale)
{
/*********************************************************
 * this method guarantees that after scaling the SAME    *
 * amount up and down with the mouse or left and right   *
 * with the ruler, the initial and final scaling factors *
 * are exactly the same. For example, if s0 is the       *
 * initial scaling, after scaling +s and -s, we get:     *
 * (s0 + s0 * s) + (s0 + s0 * s) * 1/(1/-s - 1) = s0     *
 *********************************************************/

if (scale > 0.0)
  {
  object->scale *= 1.0 + scale;
  if (object->scale > GAMGI_MESA_SCALE_UPPER)
    object->scale = GAMGI_MESA_SCALE_UPPER;
  }
else
  {
  object->scale *= 1 / (1.0 - scale);
  if (object->scale < GAMGI_MESA_SCALE_LOWER)
    object->scale = GAMGI_MESA_SCALE_LOWER;
  }

}

void gamgi_mesa_scale_object (gamgi_object *object, double scale)
{
gamgi_group *group;
gamgi_plane *plane;
gamgi_direction *direction;

switch (object->class)
  {
  case GAMGI_ENGINE_DIRECTION:
  direction = GAMGI_CAST_DIRECTION object;
  if (direction->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_scale_object (object->object, scale);
  else
    gamgi_mesa_scale_default (object, scale);
  break;

  case GAMGI_ENGINE_PLANE:
  plane = GAMGI_CAST_PLANE object;
  if (plane->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_scale_object (object->object, scale);
  else
    gamgi_mesa_scale_default (object, scale);
  break;

  case GAMGI_ENGINE_GROUP:
  group = GAMGI_CAST_GROUP object;
  if (group->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_scale_object (object->object, scale);
  else
    gamgi_mesa_scale_default (object, scale);
  break;

  case GAMGI_ENGINE_LIGHT:
  gamgi_mesa_scale_light (GAMGI_CAST_LIGHT object, scale);
  break;

  default:
  gamgi_mesa_scale_default (object, scale);
  break;
  }

}

void gamgi_mesa_scale (gamgi_window *window,
gamgi_object *object, double scale)
{
gamgi_dlist *dlist;

if (window->axes == TRUE)
  {
  /*******************
   * scale view axes *
   *******************/

  if (object == GAMGI_CAST_OBJECT window)
    {
    /************************
     * in all window layers *
     ************************/

    for (dlist = window->layer_start; dlist != NULL; dlist = dlist->next)
      {
      gamgi_mesa_scale_object (GAMGI_CAST_OBJECT dlist->data, scale);
      }
    }

  /*************************
   * just in current layer *
   *************************/

  else gamgi_mesa_scale_object (GAMGI_CAST_OBJECT window->layer, scale);
  }

if (window->axes == FALSE)
  {
  /*****************
   * scale objects *
   *****************/

  if (object == GAMGI_CAST_OBJECT window)
    {
    /************************
     * in all window layers *
     ************************/

    for (dlist = window->layer_start; dlist != NULL; dlist = dlist->next)
      {
      gamgi_mesa_scale_object (GAMGI_CAST_OBJECT dlist->data, scale);
      }
    }

  /*************************
   * just in current layer *
   *************************/

  else gamgi_mesa_scale_object (object, scale);
  }

/***********************
 * redraw OpenGL image *
 ***********************/

gtk_widget_queue_draw (window->area);
}
