/**
 * File:          $RCSfile: orthog_line.h,v $
 * Module:        Line segment fitting algorithm
 * Part of:       Gandalf Library
 *
 * Revision:      $Revision: 1.12 $
 * Last edited:   $Date: 2002/05/16 08:43:38 $
 * Author:        $Author: pm $
 * Copyright:     (c) 2000 Imagineer Software Limited
 */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _GAN_ORTHOG_LINE_H
#define _GAN_ORTHOG_LINE_H

#include <gandalf/vision/line_feature.h>
#include <gandalf/vision/edge_feature.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \addtogroup Vision
 * \{
 */

/**
 * \addtogroup FeatureDetection
 * \{
 */

Gan_LineFeatureMap *gan_orthog_line_q ( Gan_EdgeFeatureMap *edge_map,
                                        unsigned min_length,
                                        unsigned cut_size,
                                        float rms_error_thres,
                                        Gan_LocalFeatureMapParams *lpms,
                                        Gan_Bool copy_points,
                                        Gan_LineFeatureMap *line_map );

/**
 * \brief Macro: Computes image lines using an orthogonal regression algorithm.
 * \param edge_map The input edge map
 * \param min_length The minimum line length
 * \param cut_size The length to cut off the ends of each line
 * \param rms_error_thres Threshold on RMS error of line fit
 * \param lpms Pointer to local feature map parameters or NULL
 * \param copy_points Whether to copy the fitted edge points into a line
 *
 * Applies a recursive orthogonal regression line finder to
 * edges found in an image. Macro call to gan_orthog_line_q().
 *
 * \return Non-\c NULL a pointer to the computed line map structure, or
 *         \c NULL on failure.
 * \sa gan_orthog_line_q().
 */
#ifdef GAN_GENERATE_DOCUMENTATION
Gan_LineFeatureMap *
 gan_orthog_line_s ( Gan_EdgeFeatureMap *edge_map, unsigned min_length,
                     unsigned cut_size, float rms_error_thres,
                     Gan_LocalFeatureMapParams *lpms, Gan_Bool copy_points );
#else
#define gan_orthog_line_s(edge_map,min_length,cut_size,rms_error_thres,lpms,copy_points) gan_orthog_line_q(edge_map,min_length,cut_size,rms_error_thres,lpms,copy_points,NULL)
#endif

/**
 * \}
 */

/**
 * \}
 */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef _GAN_ORTHOG_LINE_H */
