/**
 * File:          $RCSfile: dpx_io.h,v $
 * Module:        DPX format image file I/O functions
 * Part of:       Gandalf Library
 *
 * Revision:      $Revision: 1.4 $
 * Last edited:   $Date: 2005/05/15 02:05:43 $
 * Author:        $Author: pm $
 * Copyright:     (c) 2000 Imagineer Software Limited
 */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _GAN_IMAGE_DPX_IO_H
#define _GAN_IMAGE_DPX_IO_H

#include <stdio.h>
#include <gandalf/common/misc_defs.h>
#include <gandalf/image/image_defs.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief DPX Transfer characteristics
 */
typedef enum Gan_DPXTransferCharacteristic
{
    GAN_DPXTRANSFER_USER_DEFINED      =  0,
    GAN_DPXTRANSFER_PRINTING_DENSITY  =  1,
    GAN_DPXTRANSFER_LINEAR            =  2,
    GAN_DPXTRANSFER_LOGARITHMIC       =  3,
    GAN_DPXTRANSFER_UNSPECIFIED_VIDEO =  4,
    GAN_DPXTRANSFER_SMPTE240M         =  5,
    GAN_DPXTRANSFER_CCIR709_1         =  6,
    GAN_DPXTRANSFER_CCIR601_2BG       =  7,
    GAN_DPXTRANSFER_CCIR601_2M        =  8,
    GAN_DPXTRANSFER_NTSC              =  9,
    GAN_DPXTRANSFER_PAL               = 10,
    GAN_DPXTRANSFER_ZLINEAR           = 11,
    GAN_DPXTRANSFER_ZHOMOGENEOUS      = 12,
    GAN_DPXTRANSFER_DEFAULT
} Gan_DPXTransferCharacteristic;

typedef enum Gan_DPXColorimetricCharacteristics
{
    GAN_DPXCOLORIMETRIC_USER_DEFINED      =  0,
    GAN_DPXCOLORIMETRIC_PRINTING_DENSITY  =  1,
    GAN_DPXCOLORIMETRIC_UNSPECIFIED_VIDEO =  4,
    GAN_DPXCOLORIMETRIC_SMPTE240M         =  5,
    GAN_DPXCOLORIMETRIC_CCIR709_1         =  6,
    GAN_DPXCOLORIMETRIC_CCIR601_2BG       =  7,
    GAN_DPXCOLORIMETRIC_CCIR601_2M        =  8,
    GAN_DPXCOLORIMETRIC_NTSC              =  9,
    GAN_DPXCOLORIMETRIC_PAL               = 10,
    GAN_DPXCOLORIMETRIC_DEFAULT
} Gan_DPXColorimetricCharacteristics;

/**
 * \brief DPX Write control structure
 */
typedef struct Gan_DPXWriteControlStruct
{
   /// bit size; 0 means default
   unsigned int bit_size;

   /// transfer characteristic
   Gan_DPXTransferCharacteristic transfer;

   /// colorimetric characteristic
   Gan_DPXColorimetricCharacteristics colorimetric;
} Gan_DPXWriteControlStruct;

/* functions exported so that Cineon I/O can use them */
void vReverseEndiannessUI32(gan_uint32* pui32Val);
void vReverseEndiannessUI16(gan_uint16* pui16Val);
Gan_Image *pgiRead8BitDPXImageData(FILE* pfInFile, Gan_Bool bReversedEndianness, gan_uint16 ui16Packing,
                                   gan_uint32 ui32eolPadding, gan_uint32 ui32eoImagePadding,
                                   Gan_ImageFormat eFormat, Gan_Type eType,
                                   gan_uint32 ui32PixelsPerLine, gan_uint32 ui32LinesPerImageEle,
                                   Gan_Image* pgiImage);
Gan_Image *pgiRead10BitDPXImageData(FILE* pfInFile, Gan_Bool bReversedEndianness, gan_uint16 ui16bPacked,
                                    gan_uint32 ui32eolPadding, gan_uint32 ui32eoImagePadding,
                                    Gan_ImageFormat eFormat, Gan_Type eType,
                                    gan_uint32 ui32PixelsPerLine, gan_uint32 ui32LinesPerImageEle,
                                    Gan_Image* pgiImage);
Gan_Bool bWrite8BitDPXImageData(FILE* pfOutFile, Gan_Image* pgiImage, Gan_Bool bReverseBytes);
Gan_Bool bWrite10BitDPXImageData(FILE* pfOutFile, Gan_Image* pgiImage, Gan_Bool bReverseBytes);

/* Prototypes for public functions in dpx_io.c */
void gan_initialise_dpx_write_control_struct(Gan_DPXWriteControlStruct *controlstr);
Gan_Image *gan_read_dpx_image_stream ( FILE *infile, Gan_Image *image );
Gan_Image *gan_read_dpx_image ( const char *filename, Gan_Image *image );
Gan_Bool   gan_write_dpx_image_stream ( FILE *outfile, Gan_Image *image, Gan_DPXWriteControlStruct *controlstr );
Gan_Bool   gan_write_dpx_image ( const char *filename, Gan_Image *image, Gan_DPXWriteControlStruct *controlstr );

#ifdef __cplusplus
}
#endif

#endif /* #ifndef _GAN_IMAGE_DPX_IO_H */
