#ifndef GEXEC_FUNCS_H
#define GEXEC_FUNCS_H 1

#include <ganglia.h>
#include <errno.h>

#ifndef SYS_CALL
#define SYS_CALL(RC,SYSCALL) \
   do {                      \
       RC = SYSCALL;         \
   } while (RC < 0 && errno == EINTR);
#endif

extern int gexec_errno;

#define GEXEC_TIMEOUT 60

typedef struct
   {
      char ip[16];
      char name[MAXHOSTNAMELEN];
      char domain[MAXHOSTNAMELEN];
      double load_one;
      double load_five;
      double load_fifteen;
      double cpu_user;
      double cpu_nice;
      double cpu_system;
      double cpu_idle;
      unsigned int proc_run;
      unsigned int proc_total;
      unsigned int cpu_num;
      unsigned long last_reported;
      int gexec_on;
      int name_resolved;
   }
gexec_host_t;

typedef struct
   {
		char name[256];
      unsigned long localtime;
      unsigned int num_hosts;
		llist_entry *hosts;
      unsigned int num_gexec_hosts;
      llist_entry *gexec_hosts;
      unsigned int num_dead_hosts;
      llist_entry *dead_hosts;

      /* Used internally */
      int malloc_error;
      gexec_host_t *host;
      int host_up;
      int start;
	}
gexec_cluster_t;

BEGIN_C_DECLS
int gexec_cluster_free ( gexec_cluster_t *cluster );
int gexec_cluster (gexec_cluster_t *cluster, char *ip, unsigned short port);
END_C_DECLS

#endif /* GEXEC_FUNCS_H */
