/*
 * "Copyright (c) 2001 by Matt Massie and The Regents of the University
 * of California.  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */        
#ifndef GANGLIACONF_H
#define GANGLIACONF_H 1

#if HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#ifndef SYNAPSE_FAILURE
#define SYNAPSE_FAILURE -1
#endif
#ifndef SYNAPSE_SUCCESS
#define SYNAPSE_SUCCESS 0
#endif

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE !0
#endif

#ifndef SYS_CALL
#define SYS_CALL(RC,SYSCALL) \
   do {                      \
       RC = SYSCALL;         \
   } while (RC < 0 && errno == EINTR); 
#endif

#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif
 
#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif
 
#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif    

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h> 
#include <syslog.h>      /* for syslog() */  
#include <netdb.h>
#include <pthread.h>
#include <limits.h>
#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/resource.h>
#ifdef HAVE_POLL_H
#include <sys/poll.h>
#endif
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h> 
#include <sys/ioctl.h>
#include <netinet/in.h>  /* htons() */
#include <arpa/inet.h>
#include <net/if.h>
#include <netinet/tcp.h>
#include <unistd.h>  
#include <errno.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <getopt.h>

#include <ganglia/error.h>
#include <ganglia/daemon_init.h>
#include <ganglia/daemon_inetd.h>
#include <ganglia/file.h>
#include <ganglia/net.h>
#include <ganglia/debug_msg.h>
#include <ganglia/my_inet_ntop.h>

/* Miscellaneous constants */
#ifndef MAXLINE
#define MAXLINE      4096       /* max text line length */
#endif
#ifndef MAXSOCKADDR
#define MAXSOCKADDR  128        /* max socket address structure size */
#endif
#ifndef BUFFSIZE
#define BUFFSIZE     8192       /* buffer size for reads and writes */
#endif

/* Just in case */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#endif  /* GANGLIACONF_H */

