/* gasql_conf.h
 *
 * Copyright (C) 1999,2000 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _GASQL_CONF_H
#define _GASQL_CONF_H
#include <dlfcn.h>

#include "sqlaccess.h"
#include "sqldb.h"
#include <libgnomeprint/gnome-printer.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-printer-dialog.h>

/*
 * main configuration structure
 */

struct _gASQL_Main_Config
{
	/* main interface widgets */
	GtkWidget *app;
	GtkWidget *appbar;
	GtkWidget *error_dlg;
	GtkWidget *manager_bonobo_win;	/* to run the gnome-db manager */

	/* pages in the notebook */
	GtkWidget *welcome;
	GtkWidget *nb;		/* notebook */
	GtkWidget *working_box;	/* hb which contains the shortcut and the notebook */
	GtkWidget *tables_page;
	GtkWidget *sequences_page;
	GtkWidget *queries_page;

	/* menu widgets */
	GSList *widgets_show_on_connect;
	GSList *widgets_show_on_disconnect;
	GSList *widgets_sensitive_on_connect;
	GSList *widgets_sensitive_on_disconnect;

	/* Memory contents */
	SqlAccess *srv;
	SqlDb *db;
	GtkWidget *config_dlg;
	gboolean conn_open_requested;	/* set to TRUE if we want to open the
					   connection right after it is configured */
	GtkWidget *config_plugins_dlg;
	GSList *widdbrel_list;	/* pointers on WidRelData structs */
	GSList *queries;	/* pointers to Sqlquery objects */
	guint id_serial;	/* to identify in a unique way each query, it is
				   use as a sequence. Each new query (or whatever)
				   that uses it makes it being increased by one. */

	/* file to open, ... */
	gchar *working_file;
	gboolean save_up_to_date;
	gboolean close_after_saving;
	gboolean quit_after_saving;

	/* plugins */
	gchar *plugins_dir;

	/* integrity check */
	GtkWidget *check_dlg;	/* GnomeDialog if opened */
	GtkWidget *check_pbar;	/* progress bar for the checking */
	GtkWidget *check_link_name;	/* label to hold the current link name */
	GtkWidget *check_errors;	/* clist for the errors */
	gboolean check_perform;

	/* config dialogs with bonobo controls inside */
	GtkWidget *users_list_dlg;
	GtkWidget *users_groups_dlg;
	GtkWidget *users_acl_dlg;

	/* printing support */
	GnomePrinter *printer;
	GnomePrintContext *printcontext;

	/* initial preferences */
	gchar *datasource;
	gchar *user_name;
	gchar *user_passwd;
	gchar *file_to_open;
};


void gasql_conf_init (gASQL_Main_Config * c);

/*
 * the widgets given here will be automatically shown/hidden
 * or their sensitiveness modified upon connection/deconnection
 */
void gasql_conf_register_show_on_connect (gASQL_Main_Config * c,
					  GtkWidget * wid);
void gasql_conf_register_show_on_disconnect (gASQL_Main_Config * c,
					     GtkWidget * wid);
void gasql_conf_register_sensitive_on_connect (gASQL_Main_Config * c,
					       GtkWidget * wid);
void gasql_conf_register_sensitive_on_disconnect (gASQL_Main_Config * c,
						  GtkWidget * wid);

/* returns an unique number for this conf structure */
guint get_id_serial (gASQL_Main_Config * c);

/* returns a string which will have to be freed */
gchar *gasql_get_title (gASQL_Main_Config * c);

/* CB connected to "conn_opened" and "conn_closed" of SqlAccess obj.*/
void gasql_widgets_conn_cb (GtkObject * obj, gASQL_Main_Config * c);

#endif
