from logfile import logfile
from math import log

class Hyperchem(logfile):
    def __init__(self,filename):
        self.filename=filename

    def getGeoOpt(self):
        # Returns a tuple of three items:
        # The first is a string of lines to be written to the screen
        # The second is a list of numbers (to be plotted) (as string)
        # The third is a list of numbers (to be plotted) (as string)

        pass
        
    def getSCF(self):
        # Returns a tuple of two items:
        # The first is a string of lines to be written to the screen
        # The second is a list of numbers (to be plotted) (as string)

        pass

    def getIR_Raman(self):
        # Returns a tuple as follows:
        # Item 1: screenoutput (STRING)
        # Item 2: freqs (FLOATS
        # Item 3: symmetry (STRING)
        # Item 4: ir (FLOAT)
        # Item 5: raman (may be empty list) (FLOAT)

        pass

    def getUV_Vis(self):
        # Returns a tuple of energy,wavelength,osc,sym,CIS
        
        inputfile=open(self.filename,"r")
        
        line=inputfile.readline()

        energy=[]; wave=[]; osc=[]; sym=[]; CIS=[]
        
        while len(line)>0:
            if line.find("(Transition) Excitation Energy")>-1:
                temp=line.split()
                wave.append(float(temp[-2]))
                line=inputfile.readline()
                energy.append(float(line.split()[-2])/8065.6) # convert to cm-1 (to be converted back later!)
                line=inputfile.readline(); line=inputfile.readline(); line=inputfile.readline()
                line=inputfile.readline()
                osc.append(float(line.split()[-1]))
                sym.append('?')
                CIS.append([[147,178,.3]])
                
            line=inputfile.readline()

        inputfile.close()
        
        return energy,wave,osc,sym,CIS


    def getenergylevels(self):
        # Returns an array of evalue, sym and the HOMO
        # Re: the number of the HOMO - the orbitals are numbered starting from zero
        # evalues are in eV

        # The details returned come from the *final* report of evalues and
        # the last list of symmetries in the log file
        # This is fine for GeoOpt and SP, but may be weird for TD and Freq(?)

        inputfile=open(self.filename,"r")

        line=inputfile.readline()
        HOMO=-1 
        while len(line)>0:
            if line.find("                       Eigenvalues(a.u.) and Eigenvectors")==0:
                # Start of the symmetry and evalue section
                symmetry=[]; evalue=[]; # Wipes the slate clean every time
                j=0
                while j<MO:
                    line=inputfile.readline() # This is a blank line
                    line=inputfile.readline() # The number of the MO
                    j=j+len(line.split())-2
                    line=inputfile.readline() # The symmetries
                    temp=line.strip().split()[1:]
                    for i in range(0,len(temp),2):
                        symmetry.append(temp[i]+" "+temp[i+1])
                    line=inputfile.readline() # The evalues
                    temp=line.strip().split()
                    evalue.extend(temp[1:])
                    line=inputfile.readline() # A blank line
                    for i in range(0,MO):
                        line=inputfile.readline()
            if line.find("Number of Double Occupied Levels")==0:
                HOMO=int(line.split()[-1])
            if line.find("Total Orbitals")==0:
                MO=int(line.split()[-1])
 
            line=inputfile.readline()
            
        inputfile.close()

        optional=[]

        return evalue,symmetry,HOMO,optional

    def getbasisinfo(self,groups):
        pass
            
            
