#!/usr/bin/env python
import os
import sys

from kiwi.dist import setup, listfiles, listpackages

from gazpacho import __version__

data_files = [
    ('share/doc/gazpacho', ('AUTHORS', 'ChangeLog', 'CONTRIBUTORS',
                            'COPYING', 'README', 'NEWS')),
    ('share/doc/gazpacho/examples', listfiles('examples', '*')),
    ('$datadir/catalogs', listfiles('catalogs', 'base.xml')),
    ('$datadir/pixmaps', listfiles('pixmaps', '*.png')),
    ('$datadir/resources/base', listfiles('resources', 'base', '*.png')),
    ('$datadir/glade', listfiles('glade', '*.glade')),
    ]
resources = dict(locale='$prefix/share/locale')
global_resources = dict(
    doc='$prefix/share/doc/gazpacho',
    pixmap='$datadir/pixmaps',
    glade='$datadir/glade',
    resource='$datadir/resources',
    catalog='$datadir/catalogs')

# When building the installer, install some extra stuff.
if 'bdist_wininst' in sys.argv:
    import shutil
    src = os.path.join('bin', 'gazpacho')
    shutil.copy2(src, os.path.join('bin', 'launch-gazpacho.py'))
    shutil.copy2(src, os.path.join('bin', 'launch-gazpacho.pyw'))
    scripts = ['bin/launch-gazpacho.py',
               'bin/launch-gazpacho.pyw']
else:
    scripts = ['bin/gazpacho']
    data_files.append(('share/applications',
                       ['gazpacho.desktop']))

setup(name='gazpacho',
      version=__version__,
      description='GTK+ GUI Designer',
      author='SICEm S.L.',
      author_email='lgs@sicem.biz',
      url='http://gazpacho.sicem.biz',
      license='LGPL',
      packages=listpackages('gazpacho'),
      scripts=scripts,
      data_files=data_files,
      resources=resources,
      global_resources=global_resources)

if 'bdist_wininst' in sys.argv:
    for script in scripts:
        os.unlink(script)
