;; Scheduling description for IBM RS64 processors.
;;   Copyright (C) 2003, 2004 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the
;; Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
;; MA 02110-1301, USA.

(define_automaton "rs64,rs64fp")
(define_cpu_unit "iu_rs64" "rs64")
(define_cpu_unit "mciu_rs64" "rs64")
(define_cpu_unit "fpu_rs64" "rs64fp")
(define_cpu_unit "lsu_rs64,bpu_rs64" "rs64")

;; RS64a 64-bit IU, LSU, FPU, BPU

(define_insn_reservation "rs64a-load" 2
  (and (eq_attr "type" "load,load_ext,load_ext_u,load_ext_ux,load_ux,load_u")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-store" 1
  (and (eq_attr "type" "store,store_ux,store_u,fpstore,fpstore_ux,fpstore_u")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-fpload" 3
  (and (eq_attr "type" "fpload,fpload_ux,fpload_u")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-llsc" 2
  (and (eq_attr "type" "load_l,store_c")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-integer" 1
  (and (eq_attr "type" "integer,insert_word")
       (eq_attr "cpu" "rs64a"))
  "iu_rs64")

(define_insn_reservation "rs64a-two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "rs64a"))
  "iu_rs64,iu_rs64")

(define_insn_reservation "rs64a-three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "rs64a"))
  "iu_rs64,iu_rs64,iu_rs64")

(define_insn_reservation "rs64a-imul" 20
  (and (eq_attr "type" "imul,imul_compare")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64*13")

(define_insn_reservation "rs64a-imul2" 12
  (and (eq_attr "type" "imul2")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64*5")

(define_insn_reservation "rs64a-imul3" 8
  (and (eq_attr "type" "imul3")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64*2")

(define_insn_reservation "rs64a-lmul" 34
  (and (eq_attr "type" "lmul,lmul_compare")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64*34")

(define_insn_reservation "rs64a-idiv" 66
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64*66")

(define_insn_reservation "rs64a-ldiv" 66
  (and (eq_attr "type" "ldiv")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64*66")

(define_insn_reservation "rs64a-compare" 3
  (and (eq_attr "type" "cmp,fast_compare,compare,delayed_compare")
       (eq_attr "cpu" "rs64a"))
  "iu_rs64,nothing,bpu_rs64")

(define_insn_reservation "rs64a-fpcompare" 5
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64,fpu_rs64,bpu_rs64")

(define_insn_reservation "rs64a-fp" 4
  (and (eq_attr "type" "fp,dmul")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64,fpu_rs64")

(define_insn_reservation "rs64a-sdiv" 31
  (and (eq_attr "type" "sdiv,ddiv")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64,fpu_rs64*31")

(define_insn_reservation "rs64a-sqrt" 49
  (and (eq_attr "type" "ssqrt,dsqrt")
       (eq_attr "cpu" "rs64a"))
  "mciu_rs64,fpu_rs64*49")

(define_insn_reservation "rs64a-mfcr" 2
  (and (eq_attr "type" "mfcr")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-mtcr" 3
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-mtjmpr" 3
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-mfjmpr" 2
  (and (eq_attr "type" "mfjmpr")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

(define_insn_reservation "rs64a-jmpreg" 1
  (and (eq_attr "type" "jmpreg,branch,cr_logical,delayed_cr")
       (eq_attr "cpu" "rs64a"))
  "bpu_rs64")

(define_insn_reservation "rs64a-isync" 6
  (and (eq_attr "type" "isync")
       (eq_attr "cpu" "rs64a"))
  "bpu_rs64")

(define_insn_reservation "rs64a-sync" 1
  (and (eq_attr "type" "sync")
       (eq_attr "cpu" "rs64a"))
  "lsu_rs64")

