#ifndef __STRING_H_
#define __STRING_H_

#ifdef __OPTIMIZE__
#include "l-string.h"
#else
extern char * strcpy (char *dest, const char *src);
extern char * strncpy (char *dest, const char *src, size_t count);
extern char * strcat (char *dest, const char * src);
extern char * strncat (char *dest, const char * src, size_t count);
extern int strcmp (const char *cs, const char * ct);
extern int strncmp (const char *cs, const char * ct, size_t count);
extern char * strchr (const char *s, int c);
extern char * strrchr (const char *s, int c);
extern size_t strlen (const char *s);
extern void * memcpy (void *to, const void * from, size_t n);
extern void * memmove (void *dest, const void * src, size_t n);
extern void * memchr (const void *cs, int c, size_t count);
extern void * memset (void *s, int c, size_t count);
extern size_t strnlen (const char *s, size_t count);
#define memcmp __builtin_memcmp
#endif /* __OPTIMIZE__  */

#endif /* __STRING_H_ */
