package GCImport::GCImportGCfilms;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use GCImport::GCImportBase;

{
    package GCImport::GCImporterGCfilms;
    use base qw(GCImport::GCImportBaseClass);
    
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        bless ($self, $class);
        return $self;
    }

    sub getName
    {
        return "GCfilms (.gcf)";
    }
    
    sub getFilePattern
    {
       return "*.gcf";
    }
    
    sub getOptions
    {
        my $self = shift;
        my @options;
        return \@options;
    }
    
    # Ignored for the moment
    sub wantsFieldsSelection
    {
        return 0;
    }
    sub getEndInfo
    {
        return "";
    }
    
    sub getMoviesArray
    {
        my ($self, $file) = @_;
        my @result;        
        
        open MOVIES, $file;

        my $i = 0;

        while (<MOVIES>)
        {
            chomp;
            my @values =  split m/\|/;

            $result[$i] = {};
            $result[$i]->{id} = $values[0];
            $result[$i]->{title} = $values[1];
            $result[$i]->{date} = $values[2];
            $result[$i]->{time} = $values[3];
            $result[$i]->{director} = $values[4];
            $result[$i]->{nat} = $values[5];
            $result[$i]->{type} = $values[6];
            $result[$i]->{image} = $values[7];
            $result[$i]->{actors} = $values[8];
            $result[$i]->{orig} = $values[9];
            $result[$i]->{synopsis} = $values[10];
            $result[$i]->{url} = $values[11];
            $result[$i]->{seen} = $values[12];
            $result[$i]->{format} = $values[13];
            $result[$i]->{number} = $values[14];
            $result[$i]->{place} = $values[15];
            $result[$i]->{rating} = $values[16];
            $result[$i]->{comment} = $values[17];
            $result[$i]->{audio} = $values[18];
            $result[$i]->{subt} = $values[19];
            $result[$i]->{borrower} = $values[20];
            $result[$i]->{lendDate} = $values[21];
            $result[$i]->{history} = $values[22];
	    
            $i++;
        }
        close MOVIES;

        return \@result;     
    }
}

1;
