package GCImport::GCImportList;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCImport::GCImportBase;

{
    package GCImport::GCImporterList;

    use base qw(GCImport::GCImportBaseClass);

    use GCPlugins;

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        
        bless ($self, $class);
        return $self;
    }

    sub wantsFieldsSelection
    {
        return 0;
    }

    sub wantsFileSelection
    {
        return 1;
    }
    
    sub getName
    {
        my ($self, $parent) = @_;
        
        return $parent->{lang}->{ImportListName};
        return "List";
    }
    
    sub getFilePattern
    {
       return "*.*";
    }
    
    sub getOptions
    {
        my $self = shift;
        
        my $pluginsList = '';
        foreach (sort keys %GCPlugins::pluginsMap)
	    {
            my $plugin = $GCPlugins::pluginsMap{$_};
            $pluginsList .= $plugin->getName . ',';
        }
        
        
        return [
            {
                name => 'plugin',
                type => 'list',
                label => 'ImportListPlugin',
                valuesList => $pluginsList
            },

            {
                name => 'first',
                type => 'checkBox',
                label => 'ImportListUseFirst',
                default => '1'
            },
        ];
        
        
    }
      
    sub getMoviesArray
    {
        my ($self, $file) = @_;
        my @result;

        #First we try to get the correct plugin
        my $plugin = $GCPlugins::pluginsMap{$self->{options}->{plugin}};

        open MOVIES, $file;

        my $i = 0;

        while (<MOVIES>)
        {
            chomp;
            
            # $_ contains the title to search
            $plugin->{title} = $_;
            $plugin->{type} = 'load';

            #Initialize what will be pushed in the array
            my $info = {'title' => $_};
        
            $self->{options}->{parent}->setWaitCursor($self->{options}->{lang}->{StatusSearch}.' ('.$_.')');
            $plugin->load;

    		my $movieNumber = $plugin->getMoviesNumber();

		    if ($movieNumber != 0)
		    {
                $plugin->{type} = 'info';
        		if (($movieNumber == 1) || ($self->{options}->{first}))
                {
                    $plugin->{wantedIdx} = 0;
                }
                else
                {
                    my $withNext = 0;
                    my @movies = $plugin->getMovies();
                    $self->{options}->{parent}->{resultsDialog}->setWithNext(0);
                    $self->{options}->{parent}->{resultsDialog}->setSearchPlugin($plugin);
                    $self->{options}->{parent}->{resultsDialog}->setList($_, @movies);
                    $self->{options}->{parent}->{resultsDialog}->show;
                    if ($self->{options}->{parent}->{resultsDialog}->{validated})
		            {
                        $plugin->{wantedIdx} = $self->{options}->{parent}->{resultsDialog}->{movieIndex};
                    }
                }
                $info = $plugin->getMovieInfo;
                $info->{image} = '' if $info->{image} eq 'empty';
                $info->{image} = $self->{options}->{parent}->downloadPicture($info->{image});
                $info->{comment} = $self->{options}->{lang}->{ImportListCommentAuto}
                                 . '<br>'
                                 . $self->{options}->{lang}->{ImportListCommentSite}
                                 . $plugin->getName()
                                 . '<br>'
                                  . $self->{options}->{lang}->{ImportListCommentTitle}
                                 . $_
                                 . '<br>';
		    }
            
            push @result, $info;
            $self->{options}->{parent}->restoreCursor;            
        }
        close MOVIES;


        return \@result;
    }
    
    
    sub getEndInfo
    {
        my $self = shift;
        my $message;
                
        return $message;
    }
}

1;