package GCPlugins::GCDVDZone2;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

###################################
#														   #
#			Plugin soumis par MeV			   #
#														   #
###################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginDVDZone2;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        return if $self->{parsingEnded};
        
        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{class} eq "dvd-search-title")
                {
                    my $url = $attr->{href};
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieList}[$self->{movieIdx}]->{'actors'} =~ s/, $// if $self->{movieIdx} >= 0;
                    $self->{movieIdx}++;
                    $self->{isMember} = 0;
                    $self->{movieList}[$self->{movieIdx}]->{'url'} = $url;
                    $self->{movieList}[$self->{movieIdx}]->{'actors'} = '';
                }
                elsif ($attr->{title} eq 'Filmography')
                {
                    $self->{isMember} = 1;
                }
            }
            if (($tagname eq 'td') && ($attr->{align} eq 'center') && ($attr->{class} eq 'search-list'))
            {
                $self->{couldBeYear} = 1;
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if ($attr->{src} =~ /^http:\/\/www\.dvdzone2\.com\/pictures\/big\//)
                {
                    $self->{curInfo}->{image} = $attr->{src};
                }
            }
            elsif ($tagname eq "p")
            {
                $self->{insideSynopsis} = 1;
            }
            elsif ($tagname eq "span")
            {
                if (($attr->{class} eq "detail-title"))
                {
                    $self->{insideName}=1;
            	}
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
        $self->{isMember} = 0;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $self->capWord($origtext);
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            elsif ($self->{isMember})
            {
                if (!$self->{movieList}[$self->{movieIdx}]->{'director'})
                {
                    $self->{movieList}[$self->{movieIdx}]->{'director'} = $origtext;
                }
                else
                {
                    $self->{movieList}[$self->{movieIdx}]->{'actors'} .= $origtext.', ';
                }
            }
            elsif (($self->{couldBeYear}))
            {
                $self->{movieList}[$self->{movieIdx}]->{'year'} = $1 if $origtext =~ m/([0-9]{4})/;
                $self->{couldBeYear} = 0;
            }
        }
        else
        {
            $origtext =~ s/ : //g if !$self->{insideSynopsis};
            if ($self->{insideType})
            {
                $origtext =~ s/ - /,/g;
                $self->{curInfo}->{type} .= $origtext;
                $self->{insideType} = 0;
            }
            elsif ($self->{insideDate})
            {
                $self->{curInfo}->{date} = $origtext;
                $self->{insideDate} = 0;
            }
            elsif ($self->{insideDirector})
            {
                $origtext =~ s/ - /, /g;
                $self->{curInfo}->{director} = $origtext if !$self->{curInfo}->{director};
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} .= $origtext . "\n\n";
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{insideNat})
            {
                $self->{curInfo}->{nat} = $origtext;
                $self->{insideNat} = 0;
            }
            elsif ($self->{insideTime})
            {
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideActors})
            {
                $origtext =~ s/ - /, /g;
                $self->{curInfo}->{actors} = $origtext if !$self->{curInfo}->{actors};
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideOrig})
            {
                $self->{curInfo}->{orig} = $self->capWord($origtext) if !$self->{curInfo}->{orig};
                $self->{insideOrig} = 0;
            }
            elsif (($self->{inside}->{span}) && ($self->{insideName}))
            {
                $self->{curInfo}->{title} = $self->capWord($origtext) if !$self->{curInfo}->{title};
            }
            elsif ($self->{inside}->{b})
            {
                $self->{insideDate}=1 if $origtext =~ m/Year/;
                $self->{insideDirector} = 1 if $origtext =~ m/Director\(s\)/;
                $self->{insideType} = 1 if $origtext =~ m/Genres/;
                $self->{insideOrig} = 1 if $origtext =~ m/Original title/;
                $self->{insideTime} = 1 if $origtext =~ m/Duration/;
                $self->{insideNat} = 1 if $origtext =~ m/Country/;
                $self->{insideActors} = 1 if $origtext =~ m/Actors/;
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html =~ s/<a class="underline" href="http:\/\/www\.dvdzone2\.com\/dvd\/search\.asp\?t=7&par=[0-9]*" title="Filmography">([^<]*)<\/a>/$1/g;
        $html =~ s/&nbsp;/ /g;
        
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.dvdzone2.com/dvd/search.asp?t=1&pl=all&kw=$word";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return $url unless $url eq '';
        return 'http://www.dvdzone2.com/dvd';
    }

    sub getName
    {
        return "DVDZone2.com";
    }
    
    sub getImageFile
    {
        return "dvdzone2.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'EN';
    }
}

1;
