; NSIS for GCfilms ( http://home.gna.org/gcfilms/ )
; Based on Frozen Bubble NSIS

; Helper defines
!define PRODUCT_NAME "GCfilms"
!define PRODUCT_VERSION "5.3"
!define PRODUCT_PUBLISHER "Tian"
!define PRODUCT_WEB_SITE "http://home.gna.org/gcfilms/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PRODUCT_NAME}"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "gcfilms\LICENSE"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
;!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "GCfilms"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; MUI end ------

; Languages
!include "gcf_lang.nsh"

${LANG_LOAD} "English"
${LANG_LOAD} "French"

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}_${PRODUCT_VERSION}_Setup.exe"
InstallDir "$PROGRAMFILES\GCfilms"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

InstType "$(INSTALL_GCFILMS_DEP)"
InstType "$(INSTALL_GCFILMS_ONLY)"
InstType "$(INSTALL_FULL)"

Function .onInit
  !define MUI_LANGDLL_ALWAYSSHOW
  !insertmacro MUI_LANGDLL_DISPLAY

  ;Prevent Multiple Instances:
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "GCFimsSetup") i .r1 ?e'
  Pop $R0
  StrCmp $R0 0 +3
  MessageBox MB_OK|MB_ICONEXCLAMATION "The ${PRODUCT_NAME} ${PRODUCT_VERSION} installer is already running."
  Abort
    
  Banner::show /NOUNLOAD "Checking for Perl..."

  ReadRegStr $0 HKLM "Software\Perl" BinDir
  StrCmp $0 "" 0 +2
  StrCpy $0 perl.exe
  nsExec::Exec '"$0" -v'
  Pop $5
  StrCmp $5 0 Success
  MessageBox MB_YESNO|MB_ICONEXCLAMATION "The installer can not find \
Perl on this computer!$\r$\nPlease install Perl and \
run this installer again.$\r$\nPress cancel if you are sure you have Perl \
installed.$\r$\n$\r$\nWould you like the installer to open Perl's \
download page for you?" IDNO NoDownload
  ExecShell open http://www.activestate.com/Products/Download/Get.plex?id=ActivePerl
  
  NoDownload:
    Banner::destroy
    Abort
    
  Success:
    Banner::destroy
    ReadRegStr $R0 HKLM \
     "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
     "UninstallString"
    StrCmp $R0 "" NoRemove
    Return
   NoRemove:
    SectionSetText 0 ""    ; and make invisible so user doesn't see it
    Return
FunctionEnd

Section "$(SEC_UN)" SEC00
  SectionIn 3
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
  "UninstallString"
  StrCmp $R0 "" NoRemove  
  call RemovePrevious
 NoRemove:
SectionEnd

Section "!GCfilms" SEC01
  SectionIn 1 2 3 RO
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File /r "gcfilms\*"
  
  Call SetFileAssociation
  
; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\GCfilms.lnk" "perl.exe" '"$INSTDIR\bin\gcfilms"' $INSTDIR\share\gcfilms\icons\gcfilms_logo32.ico "" SW_SHOWMINIMIZED
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

SectionGroup /e "GTK-Perl" GroupSec01

Section "$(SEC_LIB)" SEC02
  SectionIn 1 3
  SetOutPath "$INSTDIR\usr"
  SetOverwrite try
  File /r "usr\*"
  Push $4
  Call IsNT
  Pop $1
  StrCmp $1 0 SkipProfileSelection
  ;Call select_NT_profile
  ;Pop  $4
  StrCpy $4 "all"
 SkipProfileSelection:
  Push "$INSTDIR\usr\lib"
  Call AddToPath
  Push "$INSTDIR\usr\bin"
  Call AddToPath
  Pop $4
SectionEnd

Section "$(SEC_PPM)" SEC03
  SectionIn 1 3
  SetOutPath "$TEMP"
  SetOverwrite on
  File "gtk-perl\*"
  ExecWait "perl -e $\"`ppm install ExtUtils-PkgConfig.ppd`$\"" $1
  ExecWait "perl -e $\"`ppm install Glib.ppd`$\"" $1
  ExecWait "perl -e $\"`ppm install Gtk2.ppd`$\"" $1
  StrCmp $1 0 "" Failed
  Delete "ExtUtils-PkgConfig*"
  Delete "Glib*"
  Delete "Gtk2*"
  Delete "Gtk2*"
  Return
  
  Failed:
  MessageBox MB_OK|MB_ICONSTOP "Installation failed. Please install \
Gtk-Perl manually and run this installer again."
  Abort
SectionEnd

SectionGroupEnd

Section "$(SEC_DSK)" SEC04
  SectionIn 1 3
  CreateShortCut "$DESKTOP\GCfilms.lnk" "perl.exe" '"$INSTDIR\bin\gcfilms"' $INSTDIR\share\gcfilms\icons\gcfilms_logo64.ico "" SW_SHOWMINIMIZED
SectionEnd

Section "$(SEC_QUICK)" SEC05
  SectionIn 3
  StrCmp $QUICKLAUNCH $TEMP +2
  CreateShortCut "$QUICKLAUNCH\GCfilms.lnk" "perl.exe" '"$INSTDIR\bin\gcfilms"' $INSTDIR\share\gcfilms\icons\gcfilms_logo32.ico "" SW_SHOWMINIMIZED
SectionEnd

;Section "$(SEC_SRC)" SEC06
;  SectionIn 3
;  SetOutPath "$INSTDIR\setup_src"
;  SetOverwrite try
;  File "gcfilms.nsi"
;  File "gcf_lang.nsh"
;  File "gcf_English.nsh"
;  File "gcf_French.nsh"
;SectionEnd

Section -AdditionalIcons
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\bin\gcfilms"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\gcfilms"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC00} "$(DESC_UN)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "$(DESC_GCFILMS)"
  !insertmacro MUI_DESCRIPTION_TEXT ${GroupSec01} "$(DESC_GTKPERL)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "$(DESC_GTK)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "$(DESC_PERL)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "$(DESC_DESKTOP)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} "$(DESC_QUICK)"
  ;!insertmacro MUI_DESCRIPTION_TEXT ${SEC06} "$(DESC_SOURCES)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) has been successfullly removed from your computer."
FunctionEnd

Function un.onInit
  !insertmacro MUI_UNGETLANGUAGE
FunctionEnd

Section Uninstall

  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "$(UN_QUESTION)" IDYES DoUnInstall
  
  Abort "$(UN_ABORTED)"
  Quit
  
  DoUnInstall:
  
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$DESKTOP\GCfilms.lnk"
  Delete "$QUICKLAUNCH\GCfilms.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\GCfilms.lnk"
  RMDir "$SMPROGRAMS\$ICONS_GROUP"

  RMDir /r "$INSTDIR"

  Call un.RemoveFileAssociation

  ;Push $4
  ;Call un.IsNT
  ;Pop $1
  ;StrCmp $1 0 SkipProfileSelection
  ;Call un.select_NT_profile
  ;Pop  $4
 ;SkipProfileSelection:
  StrCpy $5 "all"
  Push "$INSTDIR\usr\lib"
  Call un.RemoveFromPath
  StrCpy $5 "all"
  Push "$INSTDIR\usr\bin"
  Call un.RemoveFromPath
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd

;----------------------------------------
; based upon a script of "Written by KiCHiK 2003-01-18 05:57:02"
;----------------------------------------
!verbose 3
!include "WinMessages.nsh"
!verbose 4
;----------------------------------------------------
!define NT_current_env 'HKCU "Environment"'
!define NT_all_env     'HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"'
;====================================================
; IsNT - Returns 1 if the current system is NT, 0
;        otherwise.
;     Output: head of the stack
;====================================================
!macro IsNT UN
Function ${UN}IsNT
  Push $0
  ReadRegStr $0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
  StrCmp $0 "" 0 IsNT_yes
  ; we are not NT.
  Pop $0
  Push 0
  Return

  IsNT_yes:
    ; NT!!!
    Pop $0
    Push 1
FunctionEnd
!macroend
!insertmacro IsNT ""
!insertmacro IsNT "un."
;====================================================
; AddToPath - Adds the given dir to the search path.
;        Input - head of the stack
;        Note - Win9x systems requires reboot
;====================================================
Function AddToPath
   Exch $0
   Push $1
   Push $2
  
   Call IsNT
   Pop $1
   StrCmp $1 1 AddToPath_NT
      ; Not on NT
      StrCpy $1 $WINDIR 2
      FileOpen $1 "$1\autoexec.bat" a
      FileSeek $1 0 END
      GetFullPathName /SHORT $0 $0
      FileWrite $1 "$\r$\nSET PATH=%PATH%;$0$\r$\n"
      FileClose $1
      Goto AddToPath_done

   AddToPath_NT:
      ;Push $4
      ;Call select_NT_profile
      ;Pop  $4

      AddToPath_NT_selection_done:
      StrCmp $4 "current" read_path_NT_current
         ReadRegStr $1 ${NT_all_env} "PATH"
         Goto read_path_NT_resume
      read_path_NT_current:
         ReadRegStr $1 ${NT_current_env} "PATH"
      read_path_NT_resume:
         ;StrCmp $1 "" AddToPath_NTdoIt
         StrCpy $2 "$1;$0"
         Goto AddToPath_NTdoIt
      AddToPath_NTdoIt:
         StrCmp $4 "current" write_path_NT_current
            ClearErrors
            ; Try to change for all users
            WriteRegExpandStr ${NT_all_env} "PATH" $2
            IfErrors 0 write_path_NT_resume
            ;MessageBox MB_YESNO|MB_ICONQUESTION "$(INSTALL_ALL_ERROR)" \
            ;   IDNO write_path_NT_failed
            ; change selection
            StrCpy $4 "current"
            Goto AddToPath_NT_selection_done
         write_path_NT_current:
            ClearErrors
            WriteRegExpandStr ${NT_current_env} "PATH" $2
            IfErrors 0 write_path_NT_resume
            MessageBox MB_OK|MB_ICONINFORMATION ""
            Goto write_path_NT_failed
         write_path_NT_resume:
         SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
         DetailPrint "Added path for user ($4), $0"
         write_path_NT_failed:
      
      ;Pop $4
   AddToPath_done:
   Pop $2
   Pop $1
   Pop $0
FunctionEnd

;====================================================
; RemoveFromPath - Remove a given dir from the path
;     Input: head of the stack
;====================================================
Function un.RemoveFromPath
   Exch $0
   Push $1
   Push $2
   Push $3
   Push $4
   Push $5
   Push $6
   
   StrCpy $6 $0
   
   Call un.IsNT
   Pop $1
   ;StrCpy $5 "all"
   StrCmp $1 1 unRemoveFromPath_NT
      ; Not on NT
      StrCpy $1 $WINDIR 2
      FileOpen $1 "$1\autoexec.bat" r
      GetTempFileName $4
      FileOpen $2 $4 w
      GetFullPathName /SHORT $0 $0
      StrCpy $0 "SET PATH=%PATH%;$0"
      SetRebootFlag true
      Goto unRemoveFromPath_dosLoop
     
      unRemoveFromPath_dosLoop:
         FileRead $1 $3
         StrCmp $3 "$0$\r$\n" unRemoveFromPath_dosLoop
         StrCmp $3 "$0$\n" unRemoveFromPath_dosLoop
         StrCmp $3 "$0" unRemoveFromPath_dosLoop
         StrCmp $3 "" unRemoveFromPath_dosLoopEnd
         FileWrite $2 $3
         Goto unRemoveFromPath_dosLoop

      unRemoveFromPath_dosLoopEnd:
         FileClose $2
         FileClose $1
         StrCpy $1 $WINDIR 2
         Delete "$1\autoexec.bat"
         CopyFiles /SILENT $4 "$1\autoexec.bat"
         Delete $4
         Goto unRemoveFromPath_done
 
   unRemoveFromPath_NT:
      StrLen $2 $0

      StrCmp $5 "current" un_read_path_NT_current
         ReadRegStr $1 ${NT_all_env} "PATH"
         Goto un_read_path_NT_resume
      un_read_path_NT_current:
         ReadRegStr $1 ${NT_current_env} "PATH"
      un_read_path_NT_resume:

      Push $1
      Push $0
      Call un.StrStr ; Find $0 in $1
      Pop $0 ; pos of our dir
      IntCmp $0 -1 unRemoveFromPath_loopIfNeeded
         ; else, it is in path
         StrCpy $3 $1 $0 ; $3 now has the part of the path before our dir
         IntOp $2 $2 + $0 ; $2 now contains the pos after our dir in the path (';')
         IntOp $2 $2 + 1 ; $2 now containts the pos after our dir and the semicolon.
         StrLen $0 $1
         StrCpy $1 $1 $0 $2
         StrCpy $3 "$3$1"

         StrCmp $5 "current" un_write_path_NT_current
            WriteRegExpandStr ${NT_all_env} "PATH" $3
            Goto un_write_path_NT_resume
         un_write_path_NT_current:
            WriteRegExpandStr ${NT_current_env} "PATH" $3
         un_write_path_NT_resume:
         SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
      unRemoveFromPath_loopIfNeeded:
            StrCmp $5 "current" unRemoveFromPath_done
            StrCpy $5 "current"
            Push $6
            Call un.RemoveFromPath
   unRemoveFromPath_done:
   Pop $6
   Pop $5
   Pop $4
   Pop $3
   Pop $2
   Pop $1
   Pop $0
FunctionEnd
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Uninstall sutff
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;====================================================
; StrStr - Finds a given string in another given string.
;               Returns -1 if not found and the pos if found.
;          Input: head of the stack - string to find
;                      second in the stack - string to find in
;          Output: head of the stack
;====================================================
Function un.StrStr
  Push $0
  Exch
  Pop $0 ; $0 now have the string to find
  Push $1
  Exch 2
  Pop $1 ; $1 now have the string to find in
  Exch
  Push $2
  Push $3
  Push $4
  Push $5

  StrCpy $2 -1
  StrLen $3 $0
  StrLen $4 $1
  IntOp $4 $4 - $3

  unStrStr_loop:
    IntOp $2 $2 + 1
    IntCmp $2 $4 0 0 unStrStrReturn_notFound
    StrCpy $5 $1 $3 $2
    StrCmp $5 $0 unStrStr_done unStrStr_loop

  unStrStrReturn_notFound:
    StrCpy $2 -1

  unStrStr_done:
    Pop $5
    Pop $4
    Pop $3
    Exch $2
    Exch 2
    Pop $0
    Pop $1
FunctionEnd
;====================================================

;====================================================
; Usefull for file association
;====================================================
Function SetFileAssociation
    !define Index "Line${__LINE__}"
      ReadRegStr $1 HKCR ".gcf" ""
      StrCmp $1 "" "${Index}-NoBackup"
        StrCmp $1 "GCfilmsFile" "${Index}-NoBackup"
        WriteRegStr HKCR ".gcf" "backup_val" $1
    "${Index}-NoBackup:"
      WriteRegStr HKCR ".gcf" "" "GCfilmsFile"
      ReadRegStr $0 HKCR "GCfilmsFile" ""
      StrCmp $0 "" 0 "${Index}-Skip"
        WriteRegStr HKCR "GCfilmsFile" "" "GCfilms movies collection"
        WriteRegStr HKCR "GCfilmsFile\shell" "" "open"
        WriteRegStr HKCR "GCfilmsFile\DefaultIcon" "" "$INSTDIR\share\gcfilms\icons\gcfilms_logo32.ico"
    "${Index}-Skip:"
      WriteRegStr HKCR "GCfilmsFile\shell\open\command" "" \
        '"perl" "$INSTDIR\bin\gcfilms" "%1"'
    !undef Index
    Call RefreshShellIcons
FunctionEnd

Function un.RemoveFileAssociation
    !define Index "Line${__LINE__}"
      ReadRegStr $1 HKCR ".gcf" ""
      StrCmp $1 "GCfilmsFile" 0 "${Index}-NoOwn" ; only do this if we own it
        ReadRegStr $1 HKCR ".gcf" "backup_val"
        StrCmp $1 "" 0 "${Index}-Restore" ; if backup="" then delete the whole key
          DeleteRegKey HKCR ".gcf"
        Goto "${Index}-NoOwn"
    "${Index}-Restore:"
          WriteRegStr HKCR ".gcf" "" $1
          DeleteRegValue HKCR ".gcf" "backup_val"
       
        DeleteRegKey HKCR "GCfilmsFile" ;Delete key with association settings
    
    "${Index}-NoOwn:"
    !undef Index
    Call un.RefreshShellIcons
FunctionEnd

!define SHCNE_ASSOCCHANGED 0x08000000
!define SHCNF_IDLIST 0

Function RefreshShellIcons
  ; By jerome tremblay - april 2003
  System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) v \
  (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
FunctionEnd

Function un.RefreshShellIcons
  ; By jerome tremblay - april 2003
  System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) v \
  (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
FunctionEnd

Function RemovePrevious
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
  "UninstallString"

  ;Run the uninstaller
  ClearErrors
  ExecWait '$R0 _?=$INSTDIR' ;Do not copy the uninstaller to a temp file
   
  IfErrors no_remove_uninstaller
    ;You can either use Delete /REBOOTOK in the uninstaller or add some code
    ;here to remove to remove the uninstaller. Use a registry key to check
    ;whether the user has chosen to uninstall. If you are using an uninstaller
    ;components page, make sure all sections are uninstalled.
  no_remove_uninstaller:

FunctionEnd

