package GCExport::GCExportTellico;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCExport::GCExportBase;

{
    package GCExport::GCExporterTellico;

    use base qw(GCExport::GCExportBaseClass);
    use GCUtils;

    eval "use MIME::Base64"; my $hasBase64 = $@ ? 0 : 1;
    eval "use Digest::MD5"; my $hasMD5 = $@ ? 0 : 1;

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{errors} = '';
        $self->{errors} .= "MIME::Base64\n" if (!$hasBase64);
        $self->{errors} .= "Digest::MD5\n" if (!$hasMD5);
        
        return $self;
    }

    sub getName
    {
        my $self = shift;
        
        return "Tellico";
    }
    
    sub needsUTF8
    {
        my $self = shift;
    
        return 1;
    }

    sub getOptions
    {
        my $self = shift;
        
        return [];
    }
      
    sub wantsFieldsSelection
    {
        return 0;
    }
    
    sub preProcess
    {
        my $self =  shift;
        
        $self->{imagesInfos} = [];
    }

    sub getHeader
    {
        my ($self, $number) = @_;
        my $result;

        $result = '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE tellico PUBLIC "-//Robby Stephenson/DTD Tellico V7.0//EN" "http://periapsis.org/tellico/dtd/v7/tellico.dtd">
<tellico xmlns="http://periapsis.org/tellico/" syntaxVersion="7" >
 <collection title="GCfilms collection" entryTitle="Videos" type="3" >
  <fields>
   <field name="_default" />
   <field flags="2" title="Rating" category="Personal" allowed="5;4;3;2;1" format="4" type="3" name="rating" />
  </fields>
';

        return $result;
    }
    
    sub encodeImage
    {
        my ($self, $file) = @_;

        my $image = GCUtils::getDisplayedImage($file, $self->{options}->{defaultImage}, $self->{orig});
        (my $suffix = $image) =~ s/.*?(\.[^.]*)$/$1/;
        $suffix = '.jpeg' if $suffix eq '.jpg';
        my $capsSuffix = uc $suffix;
        open PIC, "<$image" or return (undef,undef,undef);
        my $data = do {local $/; <PIC>};
        close PIC;
        my $pictureId =  Digest::MD5::md5_hex($data).$suffix;
        my %infos;
        $infos{id} = $pictureId;
        $infos{format} = $capsSuffix;
        $infos{width} = 120;
        $infos{height} = 160;
        $infos{data} = MIME::Base64::encode_base64($data);
        return \%infos;
    }

    sub getItem
    {
        my ($self, $movie, $number) = @_;
        my $result;
        
        (my $synopsis = $movie->{synopsis}) =~ s/<br>/\n/gm;
        (my $comments = $movie->{comment}) =~ s/<br>/\n/gm;
        use integer;
        my $rating = $movie->{rating} / 2;
        no integer;
        
        my $age = $movie->{age};
        my $certification;
        
        if ($age == 1)
        {
            $certification = 'U (USA)';
        }
        elsif ($age == 2)
        {
            $certification = 'G (USA)';
        }
        elsif ($age <= 5)
        {
             $certification = 'PG (USA)';
        }
        elsif ($age <= 13)
        {
            $certification = 'PG-13 (USA)';
        }
        elsif ($age <= 17)
        {
            $certification = 'R (USA)';
        }

        my $imageInfos = $self->encodeImage($movie->{image});
        push @{$self->{imagesInfos}}, $imageInfos;

        $result = '  <entry>
   <title>'.$movie->{title}.'</title>
   <year>'.$movie->{year}.'</year>
   <certification>'.$certification.'</certification>
   <genres>
';
        foreach (split ',', $movie->{type})
        {
            $result .= "    <genre>$_</genre>\n";
        }
        $result .= '   </genres>
   <nationalitys>
    <nationality>'.$movie->{nat}.'</nationality>
   </nationalitys>
   <casts>
';
        foreach (split ',', $movie->{actors})
        {
            $result .= "    <cast><column>$_</column></cast>\n";
        }
        $result .= '   </casts>
   <directors>
    <director>'.$movie->{director}.'</director>
   </directors>
   <languages>
';
        foreach (split ',', $movie->{audio})
        {
            $result .= "    <language>$_</language>\n";
        }
        $result .= '   </languages>
   <running-time>'.$movie->{time}.'</running-time>
   <plot>'.$synopsis.'</plot>
   <rating>'.$rating.'</rating>
   <comments>'.$comments.'</comments>
';
        if (($movie->{borrower}) && ($movie->{borrower} ne 'none'))
        {
            $result .= '   <loaned>true</loaned>
';
        }
        
        $result .= '   <cover>'.$imageInfos->{id}.'</cover>
';
        
        $result .= '  </entry>
';

        return $result;
    }
    
    sub getFooter
    {
        my $self = shift;
        my $result;
        
        $result = '  <images>
';
        foreach (@{$self->{imagesInfos}})
        {
            $result .= '   <image id="'.$_->{id}.'" format="'.$_->{format}.
                       '" width="'.$_->{width}.'" height="'.$_->{height}.'">'.
                       $_->{data}.'</image>';
        }
        $result .='  </images>
 </collection>
</tellico>
';
        
        return $result;
    }

    # postProcess
    # Called after all processing. Use it if you need to perform extra stuff on the header.
    # $header is a reference to the header string.
    sub postProcess
    {
        my ($self, $header, $body) = @_;

        # Your code here
        # As header is a reference, it can be modified on place with $$header
    }

    # getEndInfo
    # Used to display some information to user when export is ended.
    # To localize your message, use $self->{options}->{lang}.
    # Returns a string that will be displayed in a message box.
    sub getEndInfo
    {
        my $self = shift;
        my $message;
        
        # Your code here
        # Don't do put anything in message if you don't want information to be displayed.
        
        return $message;
    }
}

1;