package GCPlugins::GCAnimeNfoA;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginAnimeNfoA;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
							if ($attr->{href} =~ m/animetitle,[0-9]*,[a-z]*,[a-z0-9_]*\.html/)
							{
									$self->{isMovie} = 1;
              		$self->{isInfo} = 1;
              		$self->{movieIdx}++;
              		$self->{movieList}[$self->{movieIdx}]->{'url'} = $attr->{href};
							}
						}
						elsif ($tagname eq "font")
						{
							if ($attr->{class} eq "DefaultFont")
							{
									$self->{couldBeYear} = 1;
							}
						}
        }
        else
        {
						if ($tagname eq "font")
						{
							if ($attr->{class} eq "DefaultFont")
							{
									$self->{insideInfos} = 1;
							}
						}
						elsif ($tagname eq "img")
						{
							if (($attr->{border} eq "0") && ($attr->{src} =~ m/^image\/anime_[0-9]*\.jpg$/) && ($attr->{width} eq "120") && ($attr->{height} eq "140"))
							{
									$self->{curInfo}->{image} = "http://www.animenfo.com/" . $attr->{src};
							}
						}
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            elsif ($self->{couldBeYear})
            {
                $self->{movieList}[$self->{movieIdx}]->{"year"} = $origtext if $origtext =~ m/^[0-9]{4}$/;
                $self->{couldBeYear} = 0;
                return;
            }
        }
        else
        {
            if ($self->{insideInfos})
            {
								if ($origtext eq "Title")
								{
									$self->{insideName} = 1;
								}
								elsif ($origtext eq "Japanese Title")
								{
									$self->{insideOrig} = 1;
								}
								elsif ($origtext eq "Genres")
								{
									$self->{insideType} = 1;
								}
								elsif ($origtext eq "Year Published")
								{
									$self->{insideDate} = 1;
								}
								elsif ($origtext eq "Studio")
								{
									$self->{insideDirector} = 1;
								}
								elsif ($origtext =~ m/Description/)
								{
									$self->{insideSynopsis} = 1;
								}
								elsif ($self->{insideName})
								{
	         	      $self->{curInfo}->{title} = $origtext;
									$self->{insideName} = 0;
								}
								elsif ($self->{insideOrig})
								{
	         	      $self->{curInfo}->{orig} = $origtext if $origtext ne "Official Site";
									$self->{insideOrig} = 0;
								}
								elsif ($self->{insideType})
								{
	         	      $self->{curInfo}->{type} = $origtext;
									$self->{insideType} = 0;
								}
								elsif ($self->{insideDate})
								{
	         	      $self->{curInfo}->{date} = $origtext if $origtext =~ m/[0-9]{4}/;
									$self->{insideDate} = 0;
								}
								elsif ($self->{insideDirector})
								{
	         	      $self->{curInfo}->{director} = $origtext if $origtext ne "US Distribution";
									$self->{insideDirector} = 0;
								}
								elsif ($self->{insideSynopsis})
								{
	         	      $self->{curInfo}->{synopsis} = $origtext if !$self->{curInfo}->{synopsis};
									$self->{insideSynopsis} = 0;
								}
  	            $self->{insideInfos} = 0;
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

				$html =~ s/<br \/>/\n/g;
				$html =~ s/<script language='JavaScript'>.*?<\/script>//g;
				$html =~ s/<a onMouseOut='[^']*' onMouseOver='[^']*' href='animebygenre\.php\?genre=[0-9]*'>([^<]*)<\/a>/$1/g;
				$html =~ s/<a href='animebyyear\.php\?year=[0-9]{4}'>([0-9]{4})<\/a>/<font class='DefaultFont'>$1<\/font>/;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.animenfo.com/search.php?option=keywords&queryin=anime_titles&query=$word";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.animenfo.com/' . $url;
    }

    sub getName
    {
        return "AnimeNfo Anime";
    }
    
    sub getImageFile
    {
        return "animenfo.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'EN';
    }

    sub hasSearchActors
    {
        return 0;
    }

    sub hasSearchDirector
    {
        return 0;
    }
}

1;
