// -*- C++ -*-

/* 
 * GChemPaint library
 * filechooser.cc 
 *
 * Copyright (C) 2004-2005 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "filechooser.h"
#include "application.h"
#include <glib/gi18n.h>

gcpFileChooser::gcpFileChooser(gcpApplication* App, bool Save, gcpDocument* pDoc)
{
	char* filename;
	m_pDoc = pDoc;
	dialog = (GtkFileChooser*) gtk_file_chooser_dialog_new (
															(Save)? _("Save as"): _("Open"),
															App->GetWindow(),
															(Save)? GTK_FILE_CHOOSER_ACTION_SAVE: GTK_FILE_CHOOSER_ACTION_OPEN,
															(Save)? GTK_STOCK_SAVE: GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
															GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
															NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
	GtkFileChooser* chooser = GTK_FILE_CHOOSER (dialog);
	GtkFileFilter* filter = gtk_file_filter_new ();
	gtk_file_filter_add_mime_type (filter, "application/x-gchempaint");
	gtk_file_filter_add_mime_type (filter, "chemical/x-chemdraw");
	gtk_file_filter_add_mime_type (filter, "chemical/x-cml");
	gtk_file_filter_add_mime_type (filter, "chemical/x-mdl-molfile");
	gtk_file_filter_add_mime_type (filter, "chemical/x-pdb");
	gtk_file_chooser_set_filter (chooser, filter);
	if (!Save)
		gtk_file_chooser_set_select_multiple (chooser, true);
	// Now add network directories
	gtk_file_chooser_set_local_only (chooser, false);
	char const* dir = App->GetCurDir ();
	if (dir)
		gtk_file_chooser_set_current_folder_uri (chooser, dir);
	while (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		if (Save)
		{
			filename = gtk_file_chooser_get_uri (chooser);
			if (!App->FileProcess(filename, 0, Save, GTK_WINDOW (dialog), m_pDoc))
				{
					g_free (filename);
					break;
				}
		}
		else
		{
			GSList* files = gtk_file_chooser_get_uris (chooser);
			GSList* iter = files;
			while (iter)
			{
				filename = (char*) iter->data;
				if (!App->FileProcess(filename, 0, Save, GTK_WINDOW (dialog), m_pDoc))
				{
					g_free (filename);
					break;
				}
				g_free (filename);
				iter = iter->next;
			}
			g_slist_free (files);
			break;
		}
	}
	gtk_widget_destroy (GTK_WIDGET (dialog));
}

gcpFileChooser::~gcpFileChooser()
{
}

void gcpFileChooser::Destroy()
{
}

bool gcpFileChooser::Apply()
{
	return true;
}
