/* StandaloneAppletContext.java -- an applet's context within the
   standalone viewer
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.net.URL;
import java.util.Iterator;
import java.util.List;


/**
 * StandaloneAppletContext represents the context within a webpage of a
 * group of applets that all share the same codebase.
 */
class StandaloneAppletContext extends CommonAppletContext
{
  private List appletWindows;

  StandaloneAppletContext(List appletWindows)
  {
    this.appletWindows = appletWindows;
  }

  public void showDocument(URL url, String target)
  {
    System.err.println("showDocument is not implemented in standalone mode");
  }

  // In standalone mode, there are potentially several windows, each
  // with its own status bar.  In plugin mode, all the applets in the
  // same context (on the same page) share the browser's status bar.
  // The best way to simulate the plugin mode behaviour in standalone
  // mode is to show the same status on each window's status bar.
  public void showStatus(String status)
  {
    Iterator window = appletWindows.iterator();
    while (window.hasNext())
      ((StandaloneAppletWindow) window.next()).showStatus(status);
  }
}
