package GCMenu;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################
use utf8;
use Gtk2;

use strict;
{
    package GCMenuBar;
    use base 'Gtk2::MenuBar';

    use GCExport;
    use GCImport;

    sub addHistoryMenu
    {
        my $self = shift;
        my $parent = $self->{parent};

        $parent->{options}->historysize (5) if $parent->{options}->historysize eq "";
        $parent->{options}->history ("none|" x ($parent->{options}->historysize - 1) . "none") if $parent->{options}->history eq "";

        my @tmpHistory = split(/\|/, $parent->{options}->history);
        my $current_size = scalar @tmpHistory;
        if ($current_size < $parent->{options}->historysize)
        {
            $parent->{options}->history ($parent->{options}->history . "|none" x ($parent->{options}->historysize - $current_size));
        }
        elsif ($current_size > $parent->{options}->historysize)
        {
            my $size = $parent->{options}->historysize - 1;
            (my $history = $parent->{options}->history) =~ s/^((?:[^\|]*\|){$size})?([^\|]*)\|.*$/$1$2/;
            $parent->{options}->history ($history);
        }

        my @history_array = split /\|/, $parent->{options}->history;
        foreach my $filename(@history_array)
        {
            next if $filename eq "none";
            next if $filename eq "";
            my $item = Gtk2::MenuItem->new_with_label($filename);
            $item->signal_connect ("activate" => sub {
                        $parent->openFile($filename);
                    });
            $self->{menuHistory}->append($item);
            $item->show();
        }
        $self->{menuHistoryItem}->set_submenu($self->{menuHistory});
    }

    sub setBookmarks
    {
        my ($self, $bookmarks) = @_;
        $self->{bookmarks} = $bookmarks;
        $self->addBookmarksDir($self->{bookmarks}, undef);
        $self->{menuBookmarks}->show_all;
    }

    sub clearBookmarks
    {
        my $self = shift;
        my $i = 0;
        foreach ($self->{menuBookmarks}->get_children)
        {
            $i++;
            next if $i < 5;
            $self->{menuBookmarks}->remove($_);
            $_->destroy;
        }
    }
    
    sub addBookmarksDir
    {
        my ($self, $dir, $parent) = @_;
        if ($parent)
        {
            my $subMenu = Gtk2::Menu->new();
            my $item = Gtk2::MenuItem->new_with_mnemonic($dir->{name});
            $item->set_submenu($subMenu);
            $parent->append($item);
            $parent = $subMenu;
            $dir->{menu} = $subMenu;
        }
        else
        {
            $parent = $self->{menuBookmarks};
        }
        foreach my $sub(@{$dir->{dir}})
        {
            $self->addBookmarksDir($sub, $parent);
        }
        return if !$dir->{file};
        foreach my $file(@{$dir->{file}})
        {
            $self->addBookmark($file, $parent);
        }
    }
    
    sub addBookmark
    {
        my ($self, $bookmark, $parent) = @_;
        
        my $item = Gtk2::MenuItem->new_with_mnemonic($bookmark->{name});
        $item->signal_connect ('activate' => sub {
                    $self->{parent}->openFile($bookmark->{path});
                });        
        $parent->append($item);
        
    }

    sub setModel
    {
        my ($self, $model) = @_;
        $self->{model} = $model;
        $self->createFilters($model,
                             $model->{fieldsInfo});
        $self->initExportList($model);
        $self->{editFieldsItem}->set_sensitive($model->isPersonal);
    }

    sub initFilters
    {
        my ($self, $info) = @_;

        $self->selectAll;
        $self->block;
        my $fieldsInfo = $self->{fieldsInfo};
        foreach (keys %$info)
        {
            my $activeIdx = 0;
            my $filtersInfo = $self->{filtersInfo}->{$_};
            next if !$filtersInfo;
            
            if ($fieldsInfo->{$_}->{type} eq 'options')
            {
                foreach my $valueInfo(@{$self->{model}->getValues($fieldsInfo->{$_}->{'values'})})
                {
                    last if $valueInfo->{value} eq $info->{$_};
                    $activeIdx++;
                }
                $activeIdx++ if $activeIdx >= $fieldsInfo->{$_}->{separator};
            }
            elsif ($fieldsInfo->{$_}->{type} eq 'number')
            {
                #The value that means no check
                my $boundary = $fieldsInfo->{$_}->{min};
                $boundary = $fieldsInfo->{$_}->{max}
                    if ($filtersInfo->{type}->{comparison} =~ /^l/);
                if ($info->{$_} != $boundary)
                {
                    $activeIdx = 1;
                    $self->{numberValues}->{$_} = $info->{$_};
                }
            }
            elsif ($fieldsInfo->{$_}->{type} eq 'date')
            {
                #The value that means no check
                if ($info->{$_})
                {
                    $activeIdx = 1;
                    $self->{dateValues}->{$_} = $info->{$_};
                }
            }
            elsif (($fieldsInfo->{$_}->{type} eq 'history text')
                || ($fieldsInfo->{$_}->{type} eq 'single list'))
            {
                my @values;
                @values = @{$self->{parent}->{panel}->getValues($_)}
                    if ($fieldsInfo->{$_}->{type} eq 'history text');
                @values = @{$self->{parent}->{panel}->getValues($_)->[0]}
                    if ($fieldsInfo->{$_}->{type} eq 'single list');
                foreach my $value(@values)
                {
                    last if $value eq $info->{$_};
                    $activeIdx++;
                }
                $activeIdx = 0 if $activeIdx >= $#values;
            }
            elsif ($fieldsInfo->{$_}->{type} eq 'yesno')
            {
                $activeIdx = 1;
                $activeIdx = 0 if (($filtersInfo->{values} eq 'off') && ($info->{$_} == 1))
                               || (($filtersInfo->{values} eq 'on') && ($info->{$_} == 0));
                $activeIdx = 2 if ($filtersInfo->{values} eq 'both') && ($info->{$_} == 0);
            }
            
            $self->{'menuFilter'.$_}->set_active($activeIdx);
            $self->{'menuFilter'.$_}->get_active->set_active(1);
        }

        $self->unblock;
    }
    
    sub initExportList
    {
        my ($self, $model) = @_;
        
        my $modelName = $model->getName;
        #It will hide the export modules that don't support current model
        foreach my $exporter(@GCExport::exportersArray)
        {
            my $item = $self->{exporters}->{$exporter->getName};
            my @models = @{$exporter->getModels};
            my $show = 0;
            $show = 1 if !@models;
            foreach (@models)
            {
                $show = 1 if $modelName eq $_;
                last if $show;
            }
            $item->hide if !$show;
            $item->show if $show;
        }
    }
    
    sub createFilters
    {
        my ($self, $model, $fieldsInfo) = @_;
        foreach (@{$self->{existingFilters}})
        {
            $self->{menuDisplay}->remove($_);
        }
        
        $self->{existingFilters} = [];
        $self->{existingFiltersMenu} = [];
        $self->{dynamicFilters} = {};
        $self->{fieldsInfo} = $fieldsInfo;
        $self->{filtersInfo} = {};
        my $position = 1;
        foreach my $filter(@{$model->{filters}})
        {
            next if $filter->{quick} ne 'true';
            my $field = $filter->{field};
            $self->{filtersInfo}->{$field} = $filter;
            $self->{'menuFilter'.$field} = Gtk2::Menu->new();
            
            my $all = Gtk2::RadioMenuItem->new_with_mnemonic(undef,$self->{parent}->{lang}->{MenuNoFilter});
            $self->{'group'.$field} = $all->get_group();
            $self->{'menuFilter'.$field}->append($all);
            $all->signal_connect('activate' => sub {
                $self->changeFilter(shift, $field, '');
            });

            if (($fieldsInfo->{$field}->{type} eq 'history text') ||
                ($fieldsInfo->{$field}->{type} eq 'single list'))
            {
                $self->{dynamicFilters}->{$field} = 1;
                #$self->checkFilter($field);
            }
            elsif ($fieldsInfo->{$field}->{type} eq 'yesno')
            {
                $filter->{'values'} = 'both' if ! $filter->{'values'} ;
                if (($filter->{'values'} eq 'on') || ($filter->{'values'} eq 'both'))
                {
                    my $labelOn = $filter->{labelon} || 'CheckYes';
                    my $on = Gtk2::RadioMenuItem->new_with_mnemonic($self->{'group'.$field},
                                                                    $model->getDisplayedText($labelOn));
                    $self->{'menuFilter'.$field}->append($on);
                    $on->signal_connect('activate' => sub {
                        $self->changeFilter(shift, $field, 1);
                    });
                }
                if (($filter->{'values'} eq 'off') || ($filter->{'values'} eq 'both'))
                {
                    my $labelOff = $filter->{labeloff} || 'CheckNo';
                    my $off = Gtk2::RadioMenuItem->new_with_mnemonic($self->{'group'.$field},
                                                                     $model->getDisplayedText($labelOff));
                    $self->{'menuFilter'.$field}->append($off);
                    $off->signal_connect('activate' => sub {
                        $self->changeFilter(shift, $field, 0);
                    });
                }
            }
            elsif ($fieldsInfo->{$field}->{type} eq 'options')
            {
                $self->{dynamicFilters}->{$field} = 1
                    if $field eq $self->{parent}->{model}->{commonFields}->{borrower}->{name};
                my $i = 0;
                foreach my $valueInfo(@{$model->getValues($fieldsInfo->{$field}->{'values'})})
                {
                    $self->{'menuFilter'.$field}->append(Gtk2::SeparatorMenuItem->new)
                        if (exists $fieldsInfo->{$field}->{separator})
                        && ($fieldsInfo->{$field}->{separator} == $i);
                    $i++;
                    next if $valueInfo->{displayed} eq '';
                    my $item = Gtk2::RadioMenuItem->new_with_mnemonic($self->{'group'.$field},
                                                                      $valueInfo->{displayed});
                    $self->{'menuFilter'.$field}->append($item);
                    $item->signal_connect('activate' => sub {
                        $self->changeFilter(shift, $field, $valueInfo->{value});
                    });
                }
            }
            elsif ($fieldsInfo->{$field}->{type} eq 'number')
            {
                my $item = Gtk2::RadioMenuItem->new_with_mnemonic($self->{'group'.$field},
                                                                  $model->getDisplayedText($filter->{labelselect}));
                $self->{'menuFilter'.$field}->append($item);
                $item->signal_connect('activate' => sub {
                    my $widget = shift;
                    return if ! $widget->get_active;
                    return if $self->{deactivated};
                    my $title = $model->getDisplayedText($filter->{labelselect});
                    $title =~ s/_//g;
                    $title =~ s/\.\.\.//g;
                    my $dialog = new GCNumberEntryDialog($self->{parent},
                                                         $title,
                                                         $fieldsInfo->{$field}->{min},
                                                         $fieldsInfo->{$field}->{max},
                                                         $fieldsInfo->{$field}->{step});
                    $dialog->setValue($self->{numberValues}->{$field})
                        if $self->{numberValues} != undef;
                    my $value = $dialog->getUserValue;
                    if ($value >= 0)
                    {
                        $self->changeFilter($widget, $field, $value);
                        $self->{numberValues}->{$field} = $value;
                    }
                });
            }
            elsif ($fieldsInfo->{$field}->{type} eq 'date')
            {
                my $item = Gtk2::RadioMenuItem->new_with_mnemonic($self->{'group'.$field},
                                                                  $model->getDisplayedText($filter->{labelselect}));
                $self->{'menuFilter'.$field}->append($item);
                $item->signal_connect('activate' => sub {
                    my $widget = shift;
                    return if ! $widget->get_active;
                    return if $self->{deactivated};
                    my $title = $model->getDisplayedText($filter->{labelselect});
                    $title =~ s/_//g;
                    $title =~ s/\.\.\.//g;
                    my $dialog = new GCDateSelectionDialog($self->{parent});

                    $dialog->date(GCPreProcess::restoreDate($self->{dateValues}->{$field}))
                        if $self->{dateValues} != undef;
                    if ($dialog->show)
                    {
                        my $value = GCPreProcess::reverseDate($dialog->date);
                        $self->changeFilter($widget, $field, $value);
                        $self->{dateValues}->{$field} = $value;
                    }
                });
            }
            
            my $label = $fieldsInfo->{$field}->{displayed};
            $label = $model->getDisplayedText($filter->{label}) if $filter->{label};            
            $self->{'item'.$field} = Gtk2::MenuItem->new_with_mnemonic($label);
            $self->{'item'.$field}->set_submenu($self->{'menuFilter'.$field});
            $self->{menuDisplay}->insert($self->{'item'.$field}, $position);
            $self->{'item'.$field}->show_all;
            
            push @{$self->{existingFilters}}, $self->{'item'.$field};
            push @{$self->{existingFiltersMenu}}, $self->{'menuFilter'.$field};
            
            $position++;
        }
    }
    
    sub refreshFilters
    {
        my $self = shift;
        
        foreach (keys %{$self->{dynamicFilters}})
        {
            $self->checkFilter($_);
        }
    }
    
    sub checkFilter
    {
        my ($self, $field) = @_;

        return if ! exists $self->{dynamicFilters}->{$field};
        $self->{deactivated} = 1;
        my $values = $self->{parent}->{panel}->getValues($field);
        $values = $values->[0] if ref($values->[0]) eq 'ARRAY';
        my $current = $self->{'menuFilter'.$field}->get_active->child->get_label;
        my $first = 1;
        foreach ($self->{'menuFilter'.$field}->get_children)
        {
            if ($first)
            {
                $first = 0;
                $_->set_active(1);
            }
            else
            {
                $self->{'menuFilter'.$field}->remove($_);
            }
        }
        my $active = 0;
        my $i = 0;
        foreach (@$values)
        {
            next if !$_;
            my ($label, $value) = ($_, $_);
            if (ref($_) eq 'HASH')
            {
                $label = $_->{displayed};
                $value = $_->{value};
            }
            my $item = Gtk2::RadioMenuItem->new_with_mnemonic($self->{'group'.$field}, $label);
            $self->{'menuFilter'.$field}->append($item);
            $item->signal_connect('activate' => sub {
                $self->changeFilter(shift, $field, $value);
            });
            if ($label eq $current)
            {
                $item->set_active(1);
                $active = $i + 1;
            }
            $i++;
        }
        $self->{'menuFilter'.$field}->show_all;
        $self->{'menuFilter'.$field}->set_active($active);

        $self->{deactivated} = 0;
    }
    
    sub changeFilter
    {
        my ($self, $widget, $filter, $value) = @_;
        return if $self->{deactivated};
        return if ! $widget->get_active;
        $self->{parent}->setFilter($filter, $value);
    }
    
    sub setSaveActive
    {
        my ($self, $value) = @_;
        $self->{savedb}->set_sensitive($value);
    }
    
    sub setAddBookmarkActive
    {
        my ($self, $value) = @_;
        $self->{addBookmark}->set_sensitive($value);
    }
    
    sub setCollectionLock
    {
        my ($self, $value) = @_;
        $self->{menuEditLockItemsItem}->set_active(0);
    }
    
    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{parent} = $parent;
        $self->{accel} = Gtk2::AccelGroup->new();

        ############################
        # File Menu
        ############################

        $self->{menuFile} = Gtk2::Menu->new();

        my $fto = Gtk2::TearoffMenuItem->new();
        $self->{menuFile}->append($fto);

        my $newdb = Gtk2::ImageMenuItem->new_from_stock('gtk-new', $self->{accel});
        $newdb->signal_connect ('activate' => sub {
            $self->{parent}->newList;
        });
        $self->{menuFile}->append($newdb);

        my $opendb = Gtk2::ImageMenuItem->new_from_stock('gtk-open', $self->{accel});
        $opendb->signal_connect ('activate' => sub {
            $self->{parent}->openList;
        });
        $self->{menuFile}->append($opendb);

        $self->{menuFile}->append(Gtk2::SeparatorMenuItem->new);
        ############################

        $self->{savedb} = Gtk2::ImageMenuItem->new_from_stock('gtk-save', $self->{accel});
        $self->{savedb}->signal_connect ('activate' => sub {
            $self->{parent}->saveList;
        });
        $self->{menuFile}->append($self->{savedb});

        my $saveasdb = Gtk2::ImageMenuItem->new_from_stock('gtk-save-as', $self->{accel});
        $saveasdb->signal_connect ('activate' => sub {
            $self->{parent}->saveAs;
        });
        $self->{menuFile}->append($saveasdb);


        $self->{menuFile}->append(Gtk2::SeparatorMenuItem->new);
        ############################

        my $newitem = Gtk2::ImageMenuItem->new_from_stock('gtk-add', $self->{accel});
        $newitem->signal_connect ('activate' => sub {
            $self->{parent}->newItem;
        });
        $self->{menuFile}->append($newitem);

        my $properties = Gtk2::ImageMenuItem->new_from_stock('gtk-properties', $self->{accel});
        $properties->signal_connect ('activate' => sub {
            $self->{parent}->properties;
        });
        $self->{menuFile}->append($properties);

        my $lend = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuLend});
        $lend->signal_connect ('activate' => sub {
            $self->{parent}->showBorrowed;
        });
        $self->{menuFile}->append($lend);

        $self->{menuFile}->append(Gtk2::SeparatorMenuItem->new);
        ############################

           $self->{menuHistoryItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuHistory});
        $self->{menuHistory} = Gtk2::Menu->new();
            addHistoryMenu($self);
        $self->{menuFile}->append($self->{menuHistoryItem});

        $self->{menuFile}->append(Gtk2::SeparatorMenuItem->new);
        ############################
                
        my $importItem = Gtk2::ImageMenuItem->new_from_stock('gtk-convert', $self->{accel});
        $self->{menuImport} = Gtk2::Menu->new();
       
        foreach my $importer(@GCImport::importersArray)
        {
            $importer->setLangName($parent->{options}->lang);
            my $item = Gtk2::MenuItem->new_with_mnemonic($importer->getName);
            $item->signal_connect ('activate' => sub {
                    $self->{parent}->import($importer);
                });
            $self->{menuImport}->append($item);
        }        
        $importItem->set_submenu($self->{menuImport});
        $self->{menuFile}->append($importItem);        

        my $exportItem = Gtk2::ImageMenuItem->new_from_stock('gtk-revert-to-saved', $self->{accel});
        $self->{menuExport} = Gtk2::Menu->new();
        $self->{exporters} = {};
        foreach my $exporter(@GCExport::exportersArray)
        {
            $exporter->setLangName($parent->{options}->lang);
            my $item = Gtk2::MenuItem->new_with_mnemonic($exporter->getName);
            $item->signal_connect ('activate' => sub {
                    $self->{parent}->export($exporter);
                });
            $self->{menuExport}->append($item);
            $self->{exporters}->{$exporter->getName} = $item;
        }        
        $exportItem->set_submenu($self->{menuExport});
        $self->{menuFile}->append($exportItem);        

        $self->{menuFile}->append(Gtk2::SeparatorMenuItem->new);
        ############################

        my $leave = Gtk2::ImageMenuItem->new_from_stock('gtk-quit', $self->{accel});
        $self->{menuFile}->append($leave);
        $leave->signal_connect('activate' ,sub {
            $self->{parent}->leave;
        });

        my $fileitem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuFile});
        $fileitem->set_submenu($self->{menuFile});

        $self->append($fileitem);

        ############################
        # Edit Menu
        ############################
        $self->{menuEdit} = Gtk2::Menu->new();
        my $eto = Gtk2::TearoffMenuItem->new();
        $self->{menuEdit}->append($eto);

        my $duplicateItem = Gtk2::ImageMenuItem->new_from_stock('gtk-dnd', $self->{accel});
        $duplicateItem->signal_connect('activate' , sub {
            $self->{parent}->duplicateItem;
        });
        $self->{menuEdit}->append($duplicateItem);

        my $deleteCurrentItem = Gtk2::ImageMenuItem->new_from_stock('gtk-delete', $self->{accel});
        $deleteCurrentItem->signal_connect('activate' , sub {
            $self->{parent}->deleteCurrentItem;
        });
        $self->{menuEdit}->append($deleteCurrentItem);

        $self->{menuEdit}->append(Gtk2::SeparatorMenuItem->new);
        ############################

        $self->{editFieldsItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuEditFields});
        $self->{editFieldsItem}->signal_connect('activate' , sub {
            $self->{parent}->editModel;
        });
        $self->{menuEdit}->append($self->{editFieldsItem});

        $self->{menuEdit}->append(Gtk2::SeparatorMenuItem->new);
        ############################

        my $queryReplaceItem = Gtk2::ImageMenuItem->new_from_stock('gtk-find-and-replace', $self->{accel});
        $queryReplaceItem->signal_connect('activate' , sub {
            $self->{parent}->queryReplace;
        });
        $self->{menuEdit}->append($queryReplaceItem);

        $self->{menuEdit}->append(Gtk2::SeparatorMenuItem->new);
        ############################

        my $lockItemsItem = Gtk2::CheckMenuItem->new_with_mnemonic($parent->{lang}->{MenuEditLockItems});
        $self->{menuEdit}->append($lockItemsItem);
         #$lockItemsItem->set_active($parent->{items}->getLock);
        $lockItemsItem->signal_connect('activate' , sub {
                        my $parent = $self;
                        my $self = shift;
                        return if $parent->{deactivated};
                        $parent->{parent}->setLock($self->get_active);
                        $self->toggled();
        },$lockItemsItem);
        $self->{menuEditLockItemsItem}=$lockItemsItem;
        $lockItemsItem->{parent}=$self->{menuEdit};

        my $edititem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuEdit});
        $edititem->set_submenu($self->{menuEdit});
        $self->append($edititem);

        ############################
        # Display Menu
        ############################
        $self->{menuDisplay} = Gtk2::Menu->new();

        my $dto = Gtk2::TearoffMenuItem->new();
        $self->{menuDisplay}->append($dto);

        $self->{menuDisplay}->append(new Gtk2::SeparatorMenuItem);
        ############################

        my $search = Gtk2::ImageMenuItem->new_from_stock('gtk-find', $self->{accel});
        $search->signal_connect('activate' , sub {
                $self->{parent}->search('all');
        }); 
        $self->{menuDisplay}->append($search);

        my $advancedSearch = Gtk2::ImageMenuItem->new_with_mnemonic($parent->{lang}->{MenuAdvancedSearch});
        my $advancedImage = Gtk2::Image->new_from_stock('gtk-find', 'menu');
        $advancedSearch->set_image($advancedImage);
        $advancedSearch->signal_connect('activate' , sub {
                $self->{parent}->advancedSearch;
        }); 
        $self->{menuDisplay}->append($advancedSearch);

        my $random = Gtk2::ImageMenuItem->new_from_stock('gtk-execute', $self->{accel});
        $random->signal_connect('activate' , sub {
                $self->{parent}->randomItem;
        }); 
        $self->{menuDisplay}->append($random);

        $self->{menuDisplay}->append(new Gtk2::SeparatorMenuItem);
        ############################

        my $allItems = Gtk2::ImageMenuItem->new_with_mnemonic($parent->{lang}->{MenuViewAllItems});
        my $refreshImage = Gtk2::Image->new_from_stock('gtk-refresh', 'menu');
        $allItems->set_image($refreshImage);
        $allItems->signal_connect('activate' , sub {
                $self->selectAll
        });
        $self->{menuDisplay}->append($allItems);

        $self->{displayItem} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuDisplay});
        $self->{displayItem}->set_submenu($self->{menuDisplay});

        $self->append($self->{displayItem});

        ############################
        # Configuration Menu
        ############################
        $self->{menuConfig} = Gtk2::Menu->new();
        my $cto = Gtk2::TearoffMenuItem->new();
        $self->{menuConfig}->append($cto);
        my $options = Gtk2::ImageMenuItem->new_from_stock('gtk-preferences',$self->{accel});
        $options->signal_connect('activate' , sub {
            my ($widget, $window) = @_;
            $window->options;
        }, $self->{parent});
        $self->{menuConfig}->append($options);

        my $displayOptions = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuDisplayOptions});
        $displayOptions->signal_connect ('activate' => sub {
            $self->{parent}->displayOptions;
        });
        $self->{menuConfig}->append($displayOptions);

        my $borrowers = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuBorrowers});
        $borrowers->signal_connect ('activate' => sub {
            $self->{parent}->borrowers;
        });
        $self->{menuConfig}->append($borrowers);

        my $configitem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuConfiguration});
        $configitem->set_submenu($self->{menuConfig});
        $self->append($configitem);

        ############################
        # Bookmarks Menu
        ############################
        $self->{menuBookmarks} = Gtk2::Menu->new();
        my $bto = Gtk2::TearoffMenuItem->new();
        $self->{menuBookmarks}->append($bto);
        $self->{addBookmark} = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuBookmarksAdd});
        $self->{addBookmark}->signal_connect('activate' , sub {
            $self->{parent}->addBookmark;
        });
        $self->{menuBookmarks}->append($self->{addBookmark});

        my $editBookmark = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuBookmarksEdit});
        $editBookmark->signal_connect('activate' , sub {
            $self->{parent}->editBookmark;
        });
        $self->{menuBookmarks}->append($editBookmark);

        $self->{menuBookmarks}->append(new Gtk2::SeparatorMenuItem);

        my $bookmarksitem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuBookmarks});
        $bookmarksitem->set_submenu($self->{menuBookmarks});
        $self->append($bookmarksitem);

        ############################
        # Help Menu
        ############################
        $self->{menuHelp} = Gtk2::Menu->new();
        my $hto = Gtk2::TearoffMenuItem->new();
        $self->{menuHelp}->append($hto);
        my $help = Gtk2::ImageMenuItem->new_from_stock('gtk-help',$self->{accel});
        $help->signal_connect('activate' , sub {
            my ($widget, $window) = @_;
            $window->help;
        }, $self->{parent});
        $self->{menuHelp}->append($help);
        my $plugins = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuAllPlugins});
        $plugins->signal_connect ('activate' => sub {
            $self->{parent}->showAllPlugins;
        });
        $self->{menuHelp}->append($plugins);
        my $depend = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{InstallDependencies});
        $depend->signal_connect ('activate' => sub {
            $self->{parent}->showDependencies;
        });
        $self->{menuHelp}->append($depend);
        my $bug = Gtk2::ImageMenuItem->new_with_mnemonic($parent->{lang}->{MenuBugReport});
        $bug->signal_connect('activate' , sub {
            my ($widget, $window) = @_;
            $window->reportBug;
        }, $self->{parent});
        $self->{menuHelp}->append($bug);
        my $about = Gtk2::ImageMenuItem->new_from_stock('gtk-about',$self->{accel});
        $about->signal_connect('activate' , sub {
            my ($widget, $window) = @_;
            $window->about;
        }, $self->{parent});
        $self->{menuHelp}->append($about);

        my $helpitem = Gtk2::MenuItem->new_with_mnemonic($parent->{lang}->{MenuHelp});
        $helpitem->set_submenu($self->{menuHelp});
        $self->append($helpitem);

        $parent->add_accel_group($self->{accel});

        $self->{deactivateFilters} = 0;
        $self->{contextUpdating} = 0;

        $self->setSaveActive(0);
        return $self;
    }

    sub setLock
    {
        my ($self, $value) = @_;
        $self->block;
        $self->{menuEditLockItemsItem}->set_active($value);
        $self->unblock;
    }

    sub selectAll
    {
        my $self = shift;
        
        $self->block;
        $self->{parent}->removeSearch;
        
        foreach (@{$self->{existingFiltersMenu}})
        {
            $_->set_active(0);
            $_->get_active->set_active(1);
        }
        $self->unblock;
    }
    
    sub block
    {
        my $self = shift;

        $self->{parent}->blockListUpdates(1);
        $self->{deactivated} = 1;
    }
    
    sub unblock
    {
        my $self = shift;

        $self->{deactivated} = 0;
        $self->{parent}->blockListUpdates(0);
    }
}

{
    package GCToolBar;
    use base 'Gtk2::Toolbar';

    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        bless($self, $class);

        $self->{parent} = $parent;
        $self->{lang} = $parent->{lang};
        
        $self->set_name('GCToolbar');

        $self->{add} = $self->insert_stock("gtk-add" ,$self->{lang}->{NewItemTooltip}, undef, sub {$parent->newItem}, undef, -1);
        $self->{save} = $self->insert_stock("gtk-save" ,$self->{lang}->{SaveListTooltip}, undef, sub {$parent->saveList}, undef, -1);
        $self->insert_stock("gtk-preferences" ,$self->{lang}->{PreferencesTooltip}, undef, sub {$parent->options}, undef, -1);
        $self->append_space;
        $self->insert_stock("gtk-find" ,$self->{lang}->{SearchTooltip}, undef, sub {$parent->search('all')}, undef, -1);
        $self->insert_stock("gtk-refresh" ,$self->{lang}->{ToolbarAllTooltip}, undef, sub {$parent->allItems}, undef, -1);
        $self->{tonight} = $self->insert_stock("gtk-execute" ,$self->{lang}->{RandomTooltip}, undef, sub {$parent->randomItem}, undef, -1);
        $self->{play} = $self->insert_stock("gtk-media-play" ,$self->{lang}->{PlayTooltip}, undef, sub {$parent->playItem}, undef, -1);
        $self->append_space;

        $self->{groupLabel} = new Gtk2::Label($self->{lang}->{ToolbarGroupBy});
        $self->append_widget($self->{groupLabel}, undef, undef);
        $self->{groupOption} = new GCFieldSelector(0, undef, 1);
        $self->{groupOption}->set_focus_on_click(0);
        $self->{groupOption}->signal_connect('changed' => sub {
            return if $self->{blocked};
            my $field = $self->{groupOption}->getValue;
            return if $self->{currentGroupField} eq $field;
            $self->{parent}->setGrouping($field);
        });
        $self->{groupBox} = new Gtk2::VBox(0,0);
        $self->{groupBox}->set_border_width($GCUtils::halfMargin);
        $self->{groupBox}->pack_start($self->{groupOption}, 1, 0, 0);
        $parent->{tooltips}->set_tip($self->{groupOption}, $self->{lang}->{ToolbarGroupByTooltip}, '');
        
        $self->append_widget($self->{groupBox}, undef, undef);
        $self->{blocked} = 1;
        $self->setSaveActive(0);
        $self->{showFieldsSelection} = 1;

        return $self;
    }
    
#    sub setShowFieldsSelection
#    {
#        my ($self, $value) = @_;
#        if ($value != $self->{showFieldsSelection})
#        {
#            if ($value)
#            {
#                print "HEre\n";
#                $self->append_widget($self->{groupLabel}, undef, undef);
#                $self->append_widget($self->{groupBox}, undef, undef);
#                $self->{groupOption}->setValues($self->{groupOption}->getValues);
#                $self->{groupOption}->hide_all;
#                $self->{groupOption}->show_all;
#                $self->{groupBox}->show_all;
#                $self->{groupOption}->popup;
#                $self->hide_all;
#            }
#            else
#            {
#                $self->remove($self->{groupLabel});
#                $self->remove($self->{groupBox});
#            }
#        }
#        $self->{showFieldsSelection} = $value;
#    }
    
    sub setShowFieldsSelection
    {
        my ($self, $value) = @_;
        if ($value)
        {
            $self->{groupLabel}->show;
            $self->{groupBox}->show;
        }
        else
        {
            $self->{groupLabel}->hide;
            $self->{groupBox}->hide;
        }
    }

    sub setSaveActive
    {
        my ($self, $value) = @_;
        $self->{save}->set_sensitive($value);
    }
    
    sub setAddActive
    {
        my ($self, $value) = @_;
        $self->{add}->set_sensitive($value);
    }
    
    sub setModel
    {
        my ($self, $model) = @_;
        $self->{blocked} = 1;
        $self->{groupOption}->setModel($model);
        $self->setGroupField($model->{preferences}->groupBy, 1);
        
        # Hide tonight button if needed
        $self->{tonight}->show_all;
        $self->{tonight}->hide if !$model->hasRandom;
        
        # Hide play button if needed
        $self->{play}->show_all;
        $self->{play}->hide if !$model->hasPlay;

        $self->{blocked} = 0;
    }
    
    sub setGroupField
    {
        my ($self, $field, $force) = @_;
        my $i = 0;
        return if ($self->{currentGroupField} eq $field) && !$force;
        $self->{currentGroupField} = $field;
        $self->{groupOption}->setValue($field);
    }
}

1;