package GCPlugins::GCgames::GCAlapage;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCgames::GCgamesCommon;

{
    package GCPlugins::GCgames::GCPluginAlapage;

    use base 'GCPlugins::GCgames::GCgamesPluginsBase';

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq 'div')
            {
                $self->{isGame} = 0 ;
            }
            elsif (($tagname eq 'td') && ($attr->{class} eq 'tx12gris'))
            {
                $self->{isGame} = 1 ;
                $self->{isUrl} = 1 ;
            }
            elsif (($tagname eq 'a') && ($self->{isUrl}) && ($self->{isGame}))
            {
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href};
                $self->{isUrl} = 0 ;
            }
            elsif (($tagname eq 'u') && ($self->{isGame}))
            {
                $self->{isName} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_genre") >= 0) && ($attr->{class} eq 'roll') && ($self->{isGame}))
            {
                $self->{isGenre} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_consoles") >= 0) && ($attr->{class} eq 'roll') && ($self->{isGame}))
            {
                $self->{isPlatform} = 1 ;
            }
        }
        elsif ($self->{parsingTips})
        {
        }
        else
        {

            if (($tagname eq 'span') && ($attr->{style} eq 'color:#414B55;'))
            {
                $self->{isName} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_consoles") >= 0) && ($attr->{class} eq 'roll') && ($self->{curInfo}->{platform} eq '') )
            {
                $self->{isPlatform} = 1 ;
            }
            elsif ($tagname eq 'tpfcouverture')
            {
                $self->{isBox} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"javascript:{agrandir") >= 0) && ( $self->{isBox} eq 1) )
            {
                my @reference = split(/'/,$attr->{href});
                $self->{curInfo}->{boxpic} = 'http://imgdata.echo.fr/disque_r?' .$reference[1] .'r.jpg';
                $self->{isBox} = 0 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_genre") >= 0) && ($attr->{class} eq 'roll'))
            {
                $self->{isGenre} = 1 ;
            }
            elsif (($tagname eq 'a') && ( index($attr->{href},"mot_editeur") >= 0) && ($attr->{class} eq 'roll'))
            {
                $self->{isEditor} = 1 ;
            }
            elsif ($tagname eq 'tpfdateparution')
            {
                $self->{isDate} = 1 ;
            }
            elsif (($tagname eq 'span') && ($attr->{class} eq 'tx12noir') && ($self->{isDate} eq 1))
            {
                $self->{isDate} = 2 ;
            }
            elsif (($tagname eq 'a') && ($attr->{name} eq 'commentaires'))
            {
                $self->{isDescription} = 1 ;
            }
            elsif (($tagname eq 'div') && ($attr->{align} eq 'justify') && ($self->{isDescription} eq 1))
            {
                $self->{isDescription} = 2 ;
            }
        }
    }

    sub end
    {
	my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isName})
            {
                $self->{itemsList}[$self->{itemIdx}]->{name} = $origtext;
                $self->{isName} = 0;
            }
            elsif ($self->{isGenre})
            {
                my ($dummy, $style) = split(/\//,$origtext);
                # Enleve les blancs en debut de chaine
                $style =~ s/^\s+//;
                $self->{itemsList}[$self->{itemIdx}]->{genre} = $style;
                $self->{isGenre} = 0;
            }
            elsif ($self->{isPlatform})
            {
                $self->{itemsList}[$self->{itemIdx}]->{platform} = $origtext;
                $self->{itemsList}[$self->{itemIdx}]->{platform} =~ s/SONY //;
                $self->{itemsList}[$self->{itemIdx}]->{platform} =~ s/PC COMPATIBLES/PC/;
                $self->{isPlatform} = 0;
            }
        }
        elsif ($self->{parsingTips})
        {
        }
        else
        {
            # Enleve les blancs en debut de chaine
            $origtext =~ s/^\s+//;
            if ($self->{isName})
            {
                $self->{curInfo}->{name} = $origtext;
                $self->{isName} = 0 ;

                if ($self->{ean} ne '')
                {
                   $self->{curInfo}->{ean} = $self->{ean};
                }

            }
            elsif ($self->{isGenre})
            {
                # On enleve le premier element qui est le nom de la console
                my ($dummy, @array) = split(/\//,$origtext);
                my $element;
                foreach $element (@array)
                {
                   $element =~ s/^\s+//;
                   $self->{curInfo}->{genre} .= $element;
                   $self->{curInfo}->{genre} .= "\n";
                }
                $self->{isGenre} = 0;
            }
            elsif ($self->{isEditor})
            {
                $self->{curInfo}->{editor} = $origtext;
                $self->{isEditor} = 0 ;
            }
            elsif ($self->{isPlatform})
            {
                $self->{curInfo}->{platform} = $origtext;
                $self->{curInfo}->{platform} =~ s/SONY //;
                $self->{curInfo}->{platform} =~ s/PC COMPATIBLES/PC/;
                $self->{isPlatform} = 0 ;
            }
            elsif ($self->{isDate} eq 2)
            {
                $self->{curInfo}->{released} = $origtext;
                $self->{isDate} = 0 ;
            }
            elsif ($self->{isDescription} eq 2)
            {
                $self->{curInfo}->{description} = $origtext;
                $self->{isDescription} = 0 ;
            }

        }
    } 

    sub getTipsUrl
    {
        my $self = shift;
        
        return ;

    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            name => 1,
            platform => 1,
            genre => 1
        };

        $self->{isName} = 0;
        $self->{isGame} = 0;
        $self->{isUrl} = 0;
        $self->{isPlatform} = 0;
        $self->{isEditor} = 0;
        $self->{isDate} = 0;
        $self->{isGenre} = 0;
        $self->{isDescription} = 0;
        $self->{isBox} = 0;
        $self->{ean} = '';

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
        }
        else
        {
            my $found = index($html,"<!--DEBUT ARTICLE-->");
            if ( $found >= 0 )
            {
               $html = substr($html, $found +length('<!--DEBUT ARTICLE-->'),length($html)- $found -length('<!--DEBUT ARTICLE-->'));
            }
            {
                no utf8;
               $found = index($html,"<TD width=\"100%\" class=\"tx14grisbold\">&nbsp;D�posez votre avis</TD>");
            }
            if ( $found >= 0 )
            {
               $html = substr($html, 0, $found);
            }
            $html =~ s/> ISBN : </><tpfisbn><\/tpfisbn></g;
            $html =~ s/>Date de Parution :&nbsp;&nbsp;</><tpfdateparution><\/tpfdateparution></ig;
            $html =~ s/<A href="javascript:{agrandir\(/<tpfcouverture><\/tpfcouverture><A href="javascript:{agrandir\(/;
            $html =~ s|<li>|\n* |g;
            $html =~ s|<br>|\n|g;
            $html =~ s|<br />|\n|g;
            # Erreur sur la page d Alapage sur "HITS COLLECTION 2006"
            $html =~ s|<br<|\n|g;
            $html =~ s|<b>||g;
            $html =~ s|</b>||g;
            $html =~ s|<i>||g;
            $html =~ s|</i>||g;
            $html =~ s|\x{92}|'|g;
        }
        return $html;
    }
    
    sub getSearchUrl
    {
        my ($self, $word) = @_;

        if ($self->{searchField} eq 'ean')
        {
            $self->{ean} = $word;
        }
        else
        {
            $self->{ean} = '';
        }

        return 'http://www.alapage.com/mx/?tp=L&type=52&requete='.$word;
    }
    
    sub getItemUrl
    {
	my ($self, $url) = @_;

        return "http://www.alapage.com" . $url;
    }

    sub getName
    {
        return 'Alapage';
    }
    
    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'FR';
    }

    sub getSearchFieldsArray
    {
        return ['ean', 'name'];
    }
}

1;

