package GCModule;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use File::Basename;
use GCUtils 'glob';

use base 'Exporter';
our @EXPORT = qw(@modulesArray);

our @modulesArray;

sub loadModules
{
    
    foreach (glob $ENV{GCS_LIB_DIR}.'/GCModule/*.pm')
    {
        my $module = basename($_, '.pm')."\n";
        eval "use GCModule::$module";
        (my $moduler = $module) =~ s/^GCModule/GCMod/;
        
        my $obj;
        eval "\$obj = new GCModule::$moduler";
        die "Fatal error with moduler $module\n$@" if $@;
        
        push @modulesArray, $obj if ! $obj->{errors};
    }
}


1;
