/*
 * FILE : gdal_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Build 883)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
/***********************************************************************
 * $Header: /cvsroot/osrs/gdal/pymod/gdal_wrap.c,v 1.84 2004/02/25 09:04:33 dron Exp $
 * swig_lib/python/python.cfg
 *
 * Contains variable linking and pointer type-checking code.
 ************************************************************************/

#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"

/* Definitions for Windows/Unix exporting */
#if defined(_WIN32) || defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a) __declspec(dllexport) a
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a) a _export
#	else
#	    define SWIGEXPORT(a) a
#	endif
#   endif
#else
#   define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGSTATICRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGSTATICRUNTIME(a) static a
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATICRUNTIME(PyObject *)
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATICRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}

/* -----------------------------------------------------------------------------
 * Pointer type-checking
 * ----------------------------------------------------------------------------- */

/* SWIG pointer structure */
typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */
typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */
#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Register a new datatype with the type-checker */
SWIGSTATICRUNTIME(void) 
SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {
  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */
  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
  }

  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++) {
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN++];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
  }

  /* Check for existing entries */
  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */
SWIGSTATICRUNTIME(void) 
SWIG_MakePtr(char *c, const void *ptr, char *type) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char result[24], *r; 
  r = result;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= result)
      *(c++) = *(r--);
    strcpy (c, type);
  } else {
    strcpy (c, "NULL");
  }
}

/* Function for getting a pointer value */
SWIGSTATICRUNTIME(char *) 
SWIG_GetPtr(char *c, void **ptr, char *t)
{
  unsigned long p;
  char temp_type[256], *name;
  int  i, len, start, end;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  register int d;

  p = 0;
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) return (char *) 0;
    else return c;
  }
  c++;
  /* Extract hex value from pointer */
  while (d = *c) {
    if ((d >= '0') && (d <= '9'))
      p = (p << 4) + (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      p = (p << 4) + (d - ('a'-10));
    else
      break; 
    c++;
  }
  *ptr = (void *) p;
  if ((!t) || (strcmp(t,c)==0)) return (char *) 0;

  if (!SwigPtrSort) {
    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
    for (i = 0; i < 256; i++) SwigStart[i] = SwigPtrN;
    for (i = SwigPtrN-1; i >= 0; i--) SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
    for (i = 255; i >= 1; i--) {
      if (SwigStart[i-1] > SwigStart[i])
	SwigStart[i-1] = SwigStart[i];
    }
    SwigPtrSort = 1;
    for (i = 0; i < SWIG_CACHESIZE; i++) SwigCache[i].stat = 0;
  }
  /* First check cache for matches.  Uses last cache value as starting point */
  cache = &SwigCache[SwigLastCache];
  for (i = 0; i < SWIG_CACHESIZE; i++) {
    if (cache->stat && (strcmp(t,cache->name) == 0) && (strcmp(c,cache->mapped) == 0)) {
      cache->stat++;
      if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
      return (char *) 0;
    }
    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
    if (!SwigLastCache) cache = SwigCache;
    else cache++;
  }
  /* Type mismatch.  Look through type-mapping table */
  start = SwigStart[(int) t[1]];
  end = SwigStart[(int) t[1]+1];
  sp = &SwigPtrTable[start];

  /* Try to find a match */
  while (start <= end) {
    if (strncmp(t,sp->name,sp->len) == 0) {
      name = sp->name;
      len = sp->len;
      tp = sp->next;
      /* Try to find entry for our given datatype */
      while(tp) {
	if (tp->len >= 255) {
	  return c;
	}
	strcpy(temp_type,tp->name);
	strncat(temp_type,t+len,255-tp->len);
	if (strcmp(c,temp_type) == 0) {
	  strcpy(SwigCache[SwigCacheIndex].mapped,c);
	  strcpy(SwigCache[SwigCacheIndex].name,t);
	  SwigCache[SwigCacheIndex].stat = 1;
	  SwigCache[SwigCacheIndex].tp = tp;
	  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
	  /* Get pointer value */
	  *ptr = (void *) p;
	  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
	  return (char *) 0;
	}
	tp = tp->next;
      }
    }
    sp++;
    start++;
  }
  return c;
} 

/* New object-based GetPointer function. This uses the Python abstract
 * object interface to automatically dereference the 'this' attribute
 * of shadow objects. */

SWIGSTATICRUNTIME(char *)
SWIG_GetPtrObj(PyObject *obj, void **ptr, char *type) {
  PyObject *sobj = obj;
  char     *str;
  if (!PyString_Check(obj)) {
    sobj = PyObject_GetAttrString(obj,"this");
    if (!sobj) return "";
  }
  str = PyString_AsString(sobj);
  return SWIG_GetPtr(str,ptr,type);
}

#ifdef __cplusplus
}
#endif


#define SWIG_init    init_gdal

#define SWIG_name    "_gdal"

#include "gdal.h"
#include "../alg/gdal_alg.h"
#include "cpl_conv.h"
#include "cpl_string.h"
#include "ogr_srs_api.h"
#include "gdal_py.h"
#include "cpl_minixml.h"
#include "ogr_api.h"

CPL_CVSID("$Id: gdal_wrap.c,v 1.84 2004/02/25 09:04:33 dron Exp $");

#ifdef SWIGTYPE_GDALDatasetH
#  define SWIG_GetPtr_2(s,d,t)  SWIG_ConvertPtr( s, d,(SWIGTYPE##t),1)
#else
#  define SWIG_GetPtr_2(s,d,t)  SWIG_GetPtr( s, d, #t)
#endif

typedef char **stringList;
typedef char *NULLableString;



#include <ctype.h>

/*------------------------------------------------------------------
  ptrcast(value,type)

  Constructs a new pointer value.   Value may either be a string
  or an integer. Type is a string corresponding to either the
  C datatype or mangled datatype.

  ptrcast(0,"Vector *")
               or
  ptrcast(0,"Vector_p")   
  ------------------------------------------------------------------ */

static PyObject *ptrcast(PyObject *_PTRVALUE, char *type) {

  char *r,*s;
  void *ptr;
  PyObject *obj;
  char *typestr,*c;

  /* Produce a "mangled" version of the type string.  */

  typestr = (char *) malloc(strlen(type)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr;
  *(r++) = '_';
  c = type;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
        *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;

  /* Check to see what kind of object _PTRVALUE is */
  
  if (PyInt_Check(_PTRVALUE)) {
    ptr = (void *) PyInt_AsLong(_PTRVALUE);
    /* Received a numerical value. Make a pointer out of it */
    r = (char *) malloc(strlen(typestr)+22);
    if (ptr) {
      SWIG_MakePtr(r, ptr, typestr);
    } else {
      sprintf(r,"_0%s",typestr);
    }
    obj = PyString_FromString(r);
    free(r);
  } else if (PyString_Check(_PTRVALUE)) {
    /* Have a real pointer value now.  Try to strip out the pointer
       value */
    s = PyString_AsString(_PTRVALUE);
    r = (char *) malloc(strlen(type)+22);
    
    /* Now extract the pointer value */
    if (!SWIG_GetPtr(s,&ptr,0)) {
      if (ptr) {
	SWIG_MakePtr(r,ptr,typestr);
      } else {
	sprintf(r,"_0%s",typestr);
      }
      obj = PyString_FromString(r);
    } else {
      obj = NULL;
    }
    free(r);
  } else {
    obj = NULL;
  }
  free(typestr);
  if (!obj) 
    PyErr_SetString(PyExc_TypeError,"Type error in ptrcast. Argument is not a valid pointer value.");
  return obj;
}

/*------------------------------------------------------------------
  ptrvalue(ptr,type = 0)

  Attempts to dereference a pointer value.  If type is given, it 
  will try to use that type.  Otherwise, this function will attempt
  to "guess" the proper datatype by checking against all of the 
  builtin C datatypes. 
  ------------------------------------------------------------------ */

static PyObject *ptrvalue(PyObject *_PTRVALUE, int index, char *type) {
  void     *ptr;
  char     *s;
  PyObject *obj;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrvalue. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrvalue. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference NULL pointer.");
    return NULL;
  }

  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    obj = PyInt_FromLong((long) *(((int *) ptr) + index));
  } else if (strcmp(type,"double") == 0) {
    obj = PyFloat_FromDouble((double) *(((double *) ptr)+index));
  } else if (strcmp(type,"short") == 0) {
    obj = PyInt_FromLong((long) *(((short *) ptr)+index));
  } else if (strcmp(type,"long") == 0) {
    obj = PyInt_FromLong((long) *(((long *) ptr)+index));
  } else if (strcmp(type,"float") == 0) {
    obj = PyFloat_FromDouble((double) *(((float *) ptr)+index));
  } else if (strcmp(type,"char") == 0) {
    obj = PyString_FromString(((char *) ptr)+index);
  } else if (strcmp(type,"char *") == 0) {
    char *c = *(((char **) ptr)+index);
    if (c) obj = PyString_FromString(c);
    else obj = PyString_FromString("NULL");
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference unsupported datatype.");
    return NULL;
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrcreate(type,value = 0,numelements = 1)

  Attempts to create a new object of given type.  Type must be
  a basic C datatype.  Will not create complex objects.
  ------------------------------------------------------------------ */

static PyObject *ptrcreate(char *type, PyObject *_PYVALUE, int numelements) {
  void     *ptr;
  PyObject *obj;
  int       sz;
  char     *cast;
  char      temp[40];

  /* Check the type string against a variety of possibilities */

  if (strcmp(type,"int") == 0) {
    sz = sizeof(int)*numelements;
    cast = "_int_p";
  } else if (strcmp(type,"short") == 0) {
    sz = sizeof(short)*numelements;
    cast = "_short_p";
  } else if (strcmp(type,"long") == 0) {
    sz = sizeof(long)*numelements;
    cast = "_long_p";
  } else if (strcmp(type,"double") == 0) {
    sz = sizeof(double)*numelements;
    cast = "_double_p";
  } else if (strcmp(type,"float") == 0) {
    sz = sizeof(float)*numelements;
    cast = "_float_p";
  } else if (strcmp(type,"char") == 0) {
    sz = sizeof(char)*numelements;
    cast = "_char_p";
  } else if (strcmp(type,"char *") == 0) {
    sz = sizeof(char *)*(numelements+1);
    cast = "_char_pp";
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to create unknown datatype."); 
    return NULL;
  }
   
  /* Create the new object */
  
  ptr = (void *) malloc(sz);
  if (!ptr) {
    PyErr_SetString(PyExc_MemoryError,"Out of memory in swig_create."); 
    return NULL;
  }

  /* Now try to set its default value */

  if (_PYVALUE) {
    if (strcmp(type,"int") == 0) {
      int *ip,i,ivalue;
      ivalue = (int) PyInt_AsLong(_PYVALUE);
      ip = (int *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"short") == 0) {
      short *ip,ivalue;
      int i;
      ivalue = (short) PyInt_AsLong(_PYVALUE);
      ip = (short *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"long") == 0) {
      long *ip,ivalue;
      int i;
      ivalue = (long) PyInt_AsLong(_PYVALUE);
      ip = (long *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"double") == 0) {
      double *ip,ivalue;
      int i;
      ivalue = (double) PyFloat_AsDouble(_PYVALUE);
      ip = (double *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"float") == 0) {
      float *ip,ivalue;
      int i;
      ivalue = (float) PyFloat_AsDouble(_PYVALUE);
      ip = (float *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"char") == 0) {
      char *ip,*ivalue;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char *) ptr;
      strncpy(ip,ivalue,numelements-1);
    } else if (strcmp(type,"char *") == 0) {
      char **ip, *ivalue;
      int  i;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char **) ptr;
      for (i = 0; i < numelements; i++) {
	if (ivalue) {
	  ip[i] = (char *) malloc(strlen(ivalue)+1);
	  strcpy(ip[i],ivalue);
	} else {
	  ip[i] = 0;
	}
      }
      ip[numelements] = 0;
    }
  } 
  /* Create the pointer value */
  
  SWIG_MakePtr(temp,ptr,cast);
  obj = PyString_FromString(temp);
  return obj;
}


/*------------------------------------------------------------------
  ptrset(ptr,value,index = 0,type = 0)

  Attempts to set the value of a pointer variable.  If type is
  given, we will use that type.  Otherwise, we'll guess the datatype.
  ------------------------------------------------------------------ */

static PyObject *ptrset(PyObject *_PTRVALUE, PyObject *_PYVALUE, int index, char *type) {
  void     *ptr;
  char     *s;
  PyObject *obj;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrset. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrset. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to set NULL pointer.");
    return NULL;
  }
  
  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    *(((int *) ptr)+index) = (int) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"double") == 0) {
    *(((double *) ptr)+index) = (double) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"short") == 0) {
    *(((short *) ptr)+index) = (short) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"long") == 0) {
    *(((long *) ptr)+index) = (long) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"float") == 0) {
    *(((float *) ptr)+index) = (float) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"char") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    strcpy(((char *) ptr)+index, c);
  } else if (strcmp(type,"char *") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    char **ca = (char **) ptr;
    if (ca[index]) free(ca[index]);
    if (strcmp(c,"NULL") == 0) {
      ca[index] = 0;
    } else {
      ca[index] = (char *) malloc(strlen(c)+1);
      strcpy(ca[index],c);
    }
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to set unsupported datatype.");
    return NULL;
  }
  Py_INCREF(Py_None);
  return Py_None;
}


/*------------------------------------------------------------------
  ptradd(ptr,offset)

  Adds a value to an existing pointer value.  Will do a type-dependent
  add for basic datatypes.  For other datatypes, will do a byte-add.
  ------------------------------------------------------------------ */

static PyObject *ptradd(PyObject *_PTRVALUE, int offset) {

  char *r,*s;
  void *ptr,*junk;
  PyObject *obj;
  char *type;

  /* Check to see what kind of object _PTRVALUE is */
  
  if (PyString_Check(_PTRVALUE)) {
    /* Have a potential pointer value now.  Try to strip out the value */
    s = PyString_AsString(_PTRVALUE);

    /* Try to handle a few common datatypes first */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      ptr = (void *) (((int *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      ptr = (void *) (((double *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      ptr = (void *) (((short *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      ptr = (void *) (((long *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      ptr = (void *) (((float *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      ptr = (void *) (((char *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,0)) {
      ptr = (void *) (((char *) ptr) + offset);
    } else {
      PyErr_SetString(PyExc_TypeError,"Type error in ptradd. Argument is not a valid pointer value.");
      return NULL;
    }
    type = SWIG_GetPtr(s,&junk,"INVALID POINTER");
    r = (char *) malloc(strlen(type)+20);
    if (ptr) {
      SWIG_MakePtr(r,ptr,type);
    } else {
      sprintf(r,"_0%s",type);
    }
    obj = PyString_FromString(r);
    free(r);
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrmap(type1,type2)

  Allows a mapping between type1 and type2. (Like a typedef)
  ------------------------------------------------------------------ */

static void ptrmap(char *type1, char *type2) {

  char *typestr1,*typestr2,*c,*r;

  /* Produce a "mangled" version of the type string.  */

  typestr1 = (char *) malloc(strlen(type1)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr1;
  *(r++) = '_';
  c = type1;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  
  typestr2 = (char *) malloc(strlen(type2)+2);

  /* Go through and munge the typestring */
  
  r = typestr2;
  *(r++) = '_';
  c = type2;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  SWIG_RegisterMapping(typestr1,typestr2,0);
  SWIG_RegisterMapping(typestr2,typestr1,0);
}

/*------------------------------------------------------------------
  ptrfree(ptr)

  Destroys a pointer value
  ------------------------------------------------------------------ */

PyObject *ptrfree(PyObject *_PTRVALUE) {
  void *ptr, *junk;
  char *s;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrfree. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrfree. Argument is not a valid pointer value.");
    return NULL;
  }

  /* Check to see if this pointer is a char ** */
  if (!SWIG_GetPtr(s,&junk,"_char_pp")) {
    char **c = (char **) ptr;
    if (c) {
      int i = 0;
      while (c[i]) {
	free(c[i]);
	i++;
      }
    }
  } 
  if (ptr)
    free((char *) ptr);

  Py_INCREF(Py_None);
  return Py_None;
}


static PyObject *
py_DictToStringList(PyObject *self, PyObject *args) {

    PyObject *psDict;
    char **papszMetadata = NULL;
    int nPos = 0;
    PyObject *psKey, *psValue;
    char  szSwigTarget[48];

    self = self;
    if(!PyArg_ParseTuple(args,"O!:DictToStringList",
			 &PyDict_Type, &psDict))
        return NULL;

    while( PyDict_Next( psDict, &nPos, &psKey, &psValue ) ) 
    {
        char *pszKey, *pszValue;
        
	if( !PyArg_Parse( psKey, "s", &pszKey )
	    || !PyArg_Parse( psValue, "s", &pszValue ) )
        {
	    PyErr_SetString(PyExc_TypeError,
                    "Metadata dictionary keys and values must be strings.");
            return NULL;
        }

        papszMetadata = CSLSetNameValue( papszMetadata, pszKey, pszValue );
    }

    SWIG_MakePtr( szSwigTarget, papszMetadata, "_stringList" );	

    return Py_BuildValue( "s", szSwigTarget );
}

static PyObject *
py_StringListToDict(PyObject *self, PyObject *args) {

    PyObject *psDict;
    char **papszMetadata = NULL;
    int i;
    char  *pszSwigStringList = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"s:StringListToDict", &pszSwigStringList) )
        return NULL;

    if (SWIG_GetPtr_2(pszSwigStringList,(void **) &papszMetadata,_stringList) )
    {
        PyErr_SetString(PyExc_TypeError,
   	      "Type error with stringlist.  Expected _stringList." );
        return NULL;
    }

    psDict = PyDict_New();
    
    for( i = 0; i < CSLCount(papszMetadata); i++ )
    {
	char	*pszKey;
	const char *pszValue;

	pszValue = CPLParseNameValue( papszMetadata[i], &pszKey );
	if( pszValue != NULL )
	    PyDict_SetItem( psDict, 
                            Py_BuildValue("s", pszKey ), 
                            Py_BuildValue("s", pszValue ) );
	CPLFree( pszKey );
    }

    return psDict;
}

static PyObject *
py_ListToStringList(PyObject *self, PyObject *args) {

    PyObject *psList;
    char **papszStringList = NULL;
    char  szSwigTarget[48];
    int   iEntry;

    self = self;
    if(!PyArg_ParseTuple(args,"O!:ListToStringList",
			 &PyList_Type, &psList))
        return NULL;

    for( iEntry=0; iEntry < PyList_Size( psList ); iEntry++ )
    {
	char *pszItem = NULL;
        
	if( !PyArg_Parse( PyList_GET_ITEM(psList,iEntry), "s", &pszItem ) )
        {
	    PyErr_SetString(PyExc_TypeError,
	                    "String list item not a string.");
            return NULL;
        }

	papszStringList = CSLAddString( papszStringList, pszItem );
    }

    SWIG_MakePtr( szSwigTarget, papszStringList, "_stringList" );	

    return Py_BuildValue( "s", szSwigTarget );
}

static PyObject *
py_StringListToList(PyObject *self, PyObject *args) {

    PyObject *psList;
    char **papszStringList = NULL;
    int i, nCount;
    char  *pszSwigStringList = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"s:StringListToList", &pszSwigStringList) )
        return NULL;

    if (SWIG_GetPtr_2(pszSwigStringList,(void **) &papszStringList,
	              _stringList) )
    {
        PyErr_SetString(PyExc_TypeError,
   	      "Type error with stringlist.  Expected _stringList." );
        return NULL;
    }

    nCount = CSLCount(papszStringList);
    psList = PyList_New(nCount);

    for( i = 0; i < nCount; i++ )
	PyList_SetItem( psList, i, Py_BuildValue( "s", papszStringList[i] ));

    return psList;
}

static PyObject *ptrptrcreate(PyObject *self, PyObject *args) {

    char *type = "void";
    char fulltype[100];
    int  count = 1;
    char swig_ptr[100];
    void *ptrptr;

    self = self;
    if(!PyArg_ParseTuple(args,"|si:ptrptrcreate", &type, &count ) )
        return NULL;

    ptrptr = calloc(sizeof(void*),count);

    sprintf( fulltype, "_%s_pp", type );
    SWIG_MakePtr( swig_ptr, ptrptr, fulltype );

    return Py_BuildValue( "s", swig_ptr );
}
    
static PyObject *ptrptrset(PyObject *self, PyObject *args) {

    int    array_index = 0;
    char   *swig_target = NULL, *swig_value;
    void   *value = NULL;
    void   **target = NULL;
    
    self = self;
    if(!PyArg_ParseTuple(args,"ss|i:ptrptrset", 
                         &swig_target, &swig_value, &array_index))
        return NULL;

    SWIG_GetPtr_2( swig_value, &value, NULL );
    SWIG_GetPtr_2( swig_target, (void **) &target, NULL );

    if( target != NULL )
	target[array_index] = value;

    Py_INCREF(Py_None);
    return Py_None;
}
    
static PyObject *ptrptrvalue(PyObject *self, PyObject *args) {

    int    array_index = 0;
    char   *swig_target = NULL;
    void   *value = NULL;
    void   **target = NULL;
    char   result_ptr[100];
    
    self = self;
    if(!PyArg_ParseTuple(args,"s|i:ptrptrvalue", 
                         &swig_target, &array_index))
        return NULL;

    SWIG_GetPtr_2( swig_target, (void **) &target, NULL );

    if( target != NULL )
        value = target[array_index];

    if( value == NULL )
        strcpy( result_ptr, "NULL" );
    else
    {
        char type2[100], *type_off;

        type_off = strstr(swig_target+1,"_"); 
        if( type_off != NULL )
        {
	    strcpy( type2, type_off );
            if( type2[strlen(type2)-1] == 'p' )
                type2[strlen(type2)-1] = '\0'; /* trim trailing 'p' */
        }
        else
            strcpy( type2, "_void_p" );
        
        SWIG_MakePtr( result_ptr, value, type2 );
    }

    return Py_BuildValue( "s", result_ptr );
}
    
        


typedef struct {
    PyObject *psPyCallback;
    PyObject *psPyCallbackData;
    int nLastReported;
} PyProgressData;

/************************************************************************/
/*                          PyProgressProxy()                           */
/************************************************************************/

int PyProgressProxy( double dfComplete, const char *pszMessage, void *pData )

{
    PyProgressData *psInfo = (PyProgressData *) pData;
    PyObject *psArgs, *psResult;
    int      bContinue = TRUE;

    if( psInfo->nLastReported == (int) (100.0 * dfComplete) )
        return TRUE;

    if( psInfo->psPyCallback == NULL || psInfo->psPyCallback == Py_None )
        return TRUE;

    psInfo->nLastReported = (int) 100.0 * dfComplete;
    
    if( pszMessage == NULL )
        pszMessage = "";

    if( psInfo->psPyCallbackData == NULL )
        psArgs = Py_BuildValue("(dsO)", dfComplete, pszMessage, Py_None );
    else
        psArgs = Py_BuildValue("(dsO)", dfComplete, pszMessage, 
	                       psInfo->psPyCallbackData );

    psResult = PyEval_CallObject( psInfo->psPyCallback, psArgs);
    Py_XDECREF(psArgs);

    if( psResult == NULL )
    {
        return TRUE;
    }

    if( psResult == Py_None )
    {
	Py_XDECREF(Py_None);
        return TRUE;
    }

    if( !PyArg_Parse( psResult, "i", &bContinue ) )
    {
        PyErr_SetString(PyExc_ValueError, "bad progress return value");
	return FALSE;
    }

    Py_XDECREF(psResult);

    return bContinue;    
}


/************************************************************************/
/*                           GDALBuildOverviews()                       */
/************************************************************************/
static PyObject *
py_GDALBuildOverviews(PyObject *self, PyObject *args) {

    char *pszSwigDS = NULL;
    GDALDatasetH hDS = NULL;   
    char *pszResampling = "NEAREST";
    PyObject *psPyOverviewList = NULL, *psPyBandList = NULL;
    int   nOverviews, *panOverviewList, i;
    int    eErr;
    PyProgressData sProgressInfo;

    self = self;
    sProgressInfo.psPyCallback = NULL;
    sProgressInfo.psPyCallbackData = NULL;
    if(!PyArg_ParseTuple(args,"ssO!O!|OO:GDALBuildOverviews",	
			 &pszSwigDS, &pszResampling, 
		         &PyList_Type, &psPyOverviewList, 
			 &PyList_Type, &psPyBandList,
                         &(sProgressInfo.psPyCallback), 
		         &(sProgressInfo.psPyCallbackData) ) )
        return NULL;

    if (SWIG_GetPtr_2(pszSwigDS,(void **) &hDS,_GDALDatasetH)) {
        PyErr_SetString(PyExc_TypeError,
	   	        "Type error in argument 1 of GDALBuildOverviews."
			" Expected _GDALDatasetH.");
        return NULL;
    }

    nOverviews = PyList_Size(psPyOverviewList);
    panOverviewList = (int *) CPLCalloc(sizeof(int),nOverviews);
    for( i = 0; i < nOverviews; i++ )
    {
	if( !PyArg_Parse( PyList_GET_ITEM(psPyOverviewList,i), "i", 
			  panOverviewList+i) )
        {
	    PyErr_SetString(PyExc_ValueError, "bad overview value");
	    return NULL;
        }
    }

    eErr = GDALBuildOverviews( hDS, pszResampling, nOverviews, panOverviewList,
			       0, NULL, PyProgressProxy, &sProgressInfo );

    CPLFree( panOverviewList );

    return Py_BuildValue( "i", eErr );
}


/************************************************************************/
/*                           GDALCreateCopy()                           */
/************************************************************************/
static PyObject *
py_GDALCreateCopy(PyObject *self, PyObject *args) {

    PyObject *poPyOptions=NULL;
    char *pszSwigDriver=NULL, *pszFilename=NULL, *pszSwigSourceDS=NULL;
    int  bStrict = FALSE;
    GDALDriverH hDriver = NULL;
    GDALDatasetH hSourceDS = NULL, hTargetDS = NULL;   
    char **papszOptions = NULL;
    PyProgressData sProgressInfo;

    self = self;
    sProgressInfo.nLastReported = -1;
    sProgressInfo.psPyCallback = NULL;
    sProgressInfo.psPyCallbackData = NULL;
    if(!PyArg_ParseTuple(args,"sss|iO!OO:GDALCreateCopy",	
			 &pszSwigDriver, &pszFilename, &pszSwigSourceDS, 
			 &bStrict, &PyList_Type, &poPyOptions,
			 &(sProgressInfo.psPyCallback), 
		         &(sProgressInfo.psPyCallbackData)) )
        return NULL;

    if (SWIG_GetPtr_2(pszSwigDriver,(void **) &hDriver,_GDALDriverH)) {
        PyErr_SetString(PyExc_TypeError,
	   	        "Type error in argument 1 of GDALCreateCopy."
			" Expected _GDALDriverH.");
        return NULL;
    }
	
    if (SWIG_GetPtr_2(pszSwigSourceDS,(void **) &hSourceDS, _GDALDatasetH )) {
        PyErr_SetString(PyExc_TypeError,
	   	        "Type error in argument 3 of GDALCreateCopy."
			" Expected _GDALDatasetH.");
        return NULL;
    }

    if( poPyOptions != NULL )
    {
        int i;

	for( i = 0; i < PyList_Size(poPyOptions); i++ )
        {
            char *pszItem = NULL;

	    if( !PyArg_Parse(PyList_GET_ITEM(poPyOptions,i), "s", 
			     &pszItem) )
            {
	        PyErr_SetString(PyExc_ValueError, "bad option list item");
	        return NULL;
            }
            papszOptions = CSLAddString( papszOptions, pszItem );
        }
    }

    hTargetDS = GDALCreateCopy( hDriver, pszFilename, hSourceDS, bStrict, 
			        papszOptions, PyProgressProxy, &sProgressInfo);
	
    CSLDestroy( papszOptions );

    if( hTargetDS == NULL )
    {
        Py_INCREF(Py_None);
	return Py_None;
    }
    else
    {
        char  szSwigTarget[48];

#ifdef SWIGTYPE_GDALDatasetH
	SWIG_MakePtr( szSwigTarget, hTargetDS, SWIGTYPE_GDALDatasetH );	
#else
	SWIG_MakePtr( szSwigTarget, hTargetDS, "_GDALDatasetH" );	
#endif
	return Py_BuildValue( "s", szSwigTarget );
    }
}


/************************************************************************/
/*                             GDALCreate()                             */
/************************************************************************/
static PyObject *
py_GDALCreate(PyObject *self, PyObject *args) {

    PyObject *poPyOptions=NULL;
    char *pszSwigDriver=NULL, *pszFilename=NULL;
    int  nXSize, nYSize, nBands, nDataType;
    GDALDriverH hDriver = NULL;
    GDALDatasetH hTargetDS = NULL;   
    char **papszOptions = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"ssiiii|O!:GDALCreate",	
			 &pszSwigDriver, &pszFilename, 
			 &nXSize, &nYSize, &nBands, &nDataType,
			 &PyList_Type, &poPyOptions ))
        return NULL;

    if (SWIG_GetPtr_2(pszSwigDriver,(void **) &hDriver, _GDALDriverH )) {
        PyErr_SetString(PyExc_TypeError,
	   	        "Type error in argument 1 of GDALCreate."
			" Expected _GDALDriverH.");
        return NULL;
    }
	
    if( poPyOptions != NULL )
    {
        int i;

	for( i = 0; i < PyList_Size(poPyOptions); i++ )
        {
            char *pszItem = NULL;

	    if( !PyArg_Parse(PyList_GET_ITEM(poPyOptions,i), "s", 
			     &pszItem) )
            {
	        PyErr_SetString(PyExc_ValueError, "bad option list item");
	        return NULL;
            }
            papszOptions = CSLAddString( papszOptions, pszItem );
        }
    }

    hTargetDS = GDALCreate( hDriver, pszFilename, nXSize, nYSize, nBands, 
			    nDataType, papszOptions );
	
    CSLDestroy( papszOptions );

    if( hTargetDS == NULL )
    {
        Py_INCREF(Py_None);
	return Py_None;
    }
    else
    {
        char  szSwigTarget[48];

#ifdef SWIGTYPE_GDALDatasetH
	SWIG_MakePtr( szSwigTarget, hTargetDS, SWIGTYPE_GDALDatasetH );	
#else
	SWIG_MakePtr( szSwigTarget, hTargetDS, "_GDALDatasetH" );	
#endif
	return Py_BuildValue( "s", szSwigTarget );
    }
}


/************************************************************************/
/*                         GDALReadRaster()                             */
/************************************************************************/
static PyObject *
py_GDALReadRaster(PyObject *self, PyObject *args) {

    PyObject *result = NULL;
    GDALRasterBandH  _arg0;
    char *_argc0 = NULL;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    GDALDataType  _arg7;
    char *result_string;
    int  result_size;

    self = self;
    if(!PyArg_ParseTuple(args,"siiiiiii|O:GDALReadRaster",
                         &_argc0,&_arg1,&_arg2,&_arg3,&_arg4,
                         &_arg5,&_arg6,&_arg7,&result))
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_GDALRasterBandH )) {
            PyErr_SetString(PyExc_TypeError,
			    "Type error in argument 1 of GDALReadRaster."
			    " Expected _GDALRasterBandH.");
            return NULL;
        }
    }

    /* we either receive a buffer object to use or
     * allocate a suitable string object */
    if( result && result != Py_None )
    {
	if( PyObject_AsWriteBuffer(result, (void**) &result_string, &result_size) )
	{
	    PyErr_SetString(PyExc_TypeError, "No writable buffer from object");
	    return NULL;
	}
	if( result_size != _arg5 * _arg6 * (GDALGetDataTypeSize(_arg7)/8) )
	{
	    PyErr_SetString(PyExc_TypeError, "Unaligned buffer");
	    return NULL;
	}

	Py_INCREF(result);
    } else {
	result_size = _arg5 * _arg6 * (GDALGetDataTypeSize(_arg7)/8);
	result = PyString_FromStringAndSize(NULL, result_size);
	if( !result )
	    return NULL;
	result_string = PyString_AsString(result);
    }

    if( GDALRasterIO(_arg0, GF_Read, _arg1, _arg2, _arg3, _arg4, 
		     (void *) result_string, 
		     _arg5, _arg6, _arg7, 0, 0 ) != CE_None )
    {
	Py_XDECREF(result);
	PyErr_SetString(PyExc_TypeError,CPLGetLastErrorMsg());
	return NULL;
    }

    return result;
}


/************************************************************************/
/*                          GDALWriteRaster()                           */
/************************************************************************/
static PyObject *
py_GDALWriteRaster(PyObject *self, PyObject *args) {

    GDALRasterBandH  _arg0;
    char *_argc0 = NULL;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    char *strbuffer_arg = NULL;
    int  strbuffer_size;
    int  _arg5;
    int  _arg6;
    GDALDataType  _arg7;

    self = self;
    if(!PyArg_ParseTuple(args,"siiiis#iii:GDALWriteRaster",
                         &_argc0,&_arg1,&_arg2,&_arg3,&_arg4,
                         &strbuffer_arg,&strbuffer_size,&_arg5,&_arg6,&_arg7)) 
        return NULL;



    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_GDALRasterBandH)) {
            PyErr_SetString(PyExc_TypeError,
			    "Type error in argument 1 of GDALWriteRaster."
			    " Expected _GDALRasterBandH.");
            return NULL;
        }
    }
	
    if( GDALRasterIO(_arg0, GF_Write, _arg1, _arg2, _arg3, _arg4, 
		     (void *) strbuffer_arg,
		     _arg5, _arg6, _arg7, 0, 0 ) != CE_None )
    {
	PyErr_SetString(PyExc_TypeError,CPLGetLastErrorMsg());
	return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}


/************************************************************************/
/*                            GDALGetGCPs()                             */
/************************************************************************/
static PyObject *
py_GDALGetGCPs(PyObject *self, PyObject *args) {

    GDALDatasetH  _arg0;
    char *_argc0 = NULL;
    const GDAL_GCP * pasGCPList;
    PyObject *psList;
    int iGCP;

    self = self;
    if(!PyArg_ParseTuple(args,"s:GDALGetGCPs",&_argc0))
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_GDALDatasetH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of GDALGetGCPs."
                            "  Expected _GDALDatasetH.");
            return NULL;
        }
    }

    pasGCPList = GDALGetGCPs( _arg0 );	

    psList = PyList_New(GDALGetGCPCount(_arg0));
    for( iGCP = 0; pasGCPList != NULL && iGCP < GDALGetGCPCount(_arg0); iGCP++)
    {
	PyList_SetItem(psList, iGCP, 
                       Py_BuildValue("(ssddddd)", 
                                     pasGCPList[iGCP].pszId,
                                     pasGCPList[iGCP].pszInfo,
                                     pasGCPList[iGCP].dfGCPPixel,
                                     pasGCPList[iGCP].dfGCPLine,
                                     pasGCPList[iGCP].dfGCPX,
                                     pasGCPList[iGCP].dfGCPY,
                                     pasGCPList[iGCP].dfGCPZ ) );
    }

    return psList;
}

/************************************************************************/
/*                            GDALSetGCPs()                             */
/************************************************************************/
static PyObject *
py_GDALSetGCPs(PyObject *self, PyObject *args) {

    GDALDatasetH  _arg0;
    char *_argc0 = NULL;
    GDAL_GCP * pasGCPList;
    char * pszProjection = "";
    PyObject *psList;
    int iGCP, nGCPCount;
    CPLErr eErr;

    self = self;
    if(!PyArg_ParseTuple(args,"sO!s:GDALSetGCPs",
			&_argc0, &PyList_Type, &psList, &pszProjection))
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_GDALDatasetH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of GDALSetGCPs."
                            "  Expected _GDALDatasetH.");
            return NULL;
        }
    }

    nGCPCount = PyList_Size(psList);
    pasGCPList = (GDAL_GCP *) CPLCalloc(sizeof(GDAL_GCP),nGCPCount);
    GDALInitGCPs( nGCPCount, pasGCPList );

    for( iGCP = 0; iGCP < nGCPCount; iGCP++ )
    {
        char *pszId = NULL, *pszInfo = NULL;

	if( !PyArg_Parse( PyList_GET_ITEM(psList,iGCP), "(ssddddd)", 
	                  &pszId, &pszInfo, 
	                  &(pasGCPList[iGCP].dfGCPPixel),
	                  &(pasGCPList[iGCP].dfGCPLine),
	                  &(pasGCPList[iGCP].dfGCPX),
	                  &(pasGCPList[iGCP].dfGCPY),
	                  &(pasGCPList[iGCP].dfGCPZ) ) )
        {
	    PyErr_SetString(PyExc_ValueError, "improper GCP tuple");
	    return NULL;
        }

        CPLFree( pasGCPList[iGCP].pszId );
	pasGCPList[iGCP].pszId = CPLStrdup(pszId);
        CPLFree( pasGCPList[iGCP].pszInfo );
	pasGCPList[iGCP].pszInfo = CPLStrdup(pszInfo);
    }

    eErr = GDALSetGCPs( _arg0, nGCPCount, pasGCPList, pszProjection );
	
    GDALDeinitGCPs( nGCPCount, pasGCPList );
    CPLFree( pasGCPList );    

    if( eErr != CE_None )
    {	
	PyErr_SetString(PyExc_ValueError,CPLGetLastErrorMsg());
	return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/************************************************************************/
/*                         GDALGCPsToGeoTransform()                     */
/************************************************************************/
static PyObject *
py_GDALGCPsToGeoTransform(PyObject *self, PyObject *args) {

    GDAL_GCP * pasGCPList;
    PyObject *psList;
    int iGCP, nGCPCount;
    int    bSuccess;
    int    bApproxOK = TRUE;
    double adfGeoTransform[6];

    self = self;
    if(!PyArg_ParseTuple(args,"O!i:GDALGCPsToGeoTransform",
			&PyList_Type, &psList, &bApproxOK))
        return NULL;

    nGCPCount = PyList_Size(psList);
    pasGCPList = (GDAL_GCP *) CPLCalloc(sizeof(GDAL_GCP),nGCPCount);
    GDALInitGCPs( nGCPCount, pasGCPList );

    for( iGCP = 0; iGCP < nGCPCount; iGCP++ )
    {
        char *pszId = NULL, *pszInfo = NULL;

	if( !PyArg_Parse( PyList_GET_ITEM(psList,iGCP), "(ssddddd)", 
	                  &pszId, &pszInfo, 
	                  &(pasGCPList[iGCP].dfGCPPixel),
	                  &(pasGCPList[iGCP].dfGCPLine),
	                  &(pasGCPList[iGCP].dfGCPX),
	                  &(pasGCPList[iGCP].dfGCPY),
	                  &(pasGCPList[iGCP].dfGCPZ) ) )
        {
	    PyErr_SetString(PyExc_ValueError, "improper GCP tuple");
	    return NULL;
        }

        CPLFree( pasGCPList[iGCP].pszId );
	pasGCPList[iGCP].pszId = CPLStrdup(pszId);
        CPLFree( pasGCPList[iGCP].pszInfo );
	pasGCPList[iGCP].pszInfo = CPLStrdup(pszInfo);
    }
   
    bSuccess = GDALGCPsToGeoTransform( nGCPCount, pasGCPList, adfGeoTransform,
                                       bApproxOK );
	
    GDALDeinitGCPs( nGCPCount, pasGCPList );
    CPLFree( pasGCPList );    

    if( bSuccess )
    {	
        return Py_BuildValue( "dddddd", 
	                      adfGeoTransform[0],
	                      adfGeoTransform[1],
	                      adfGeoTransform[2],
	                      adfGeoTransform[3],
	                      adfGeoTransform[4],
	                      adfGeoTransform[5] );
    }
    else
    {
        Py_INCREF(Py_None);
        return Py_None;
    }
}


/************************************************************************/
/*                       GDALGetRasterHistogram()                       */
/************************************************************************/
static PyObject *
py_GDALGetRasterHistogram(PyObject *self, PyObject *args) {

    GDALRasterBandH  hBand;
    char *_argc0 = NULL;
    double dfMin = -0.5, dfMax = 255.5;
    int nBuckets = 256, bIncludeOutOfRange = FALSE, bApproxOK = FALSE;
    int *panHistogram, i;
    PyObject *psList;

    self = self;
    if(!PyArg_ParseTuple(args,"s|ddiii:GDALGetRasterHistogram",&_argc0,
			 &dfMin, &dfMax, &nBuckets, &bIncludeOutOfRange, 
	 	         &bApproxOK))
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &hBand,_GDALRasterBandH)) {
            PyErr_SetString(PyExc_TypeError,
                          "Type error in argument 1 of GDALGetRasterHistogram."
                          "  Expected _GDALRasterBandH.");
            return NULL;
        }
    }
	
    panHistogram = (int *) CPLCalloc(sizeof(int),nBuckets);
    GDALGetRasterHistogram(hBand, dfMin, dfMax, nBuckets, panHistogram, 
			   bIncludeOutOfRange, bApproxOK, 
		           GDALDummyProgress, NULL);

    psList = PyList_New(nBuckets);
    for( i = 0; i < nBuckets; i++ )
	PyList_SetItem(psList, i, Py_BuildValue("i", panHistogram[i] ));

    CPLFree( panHistogram );

    return psList;
}

/************************************************************************/
/*                           GDALBuildOverviews()                       */
/************************************************************************/
static PyObject *
py_GDALComputeMedianCutPCT(PyObject *self, PyObject *args) {

    char *pszSwigRed, *pszSwigGreen, *pszSwigBlue;
    char *pszSwigCT = NULL;
    GDALRasterBandH   hRed, hGreen, hBlue;
    GDALColorTableH   hColorTable = NULL;
    int               nColors = 256;
    int               eErr;
    PyProgressData sProgressInfo;

    self = self;
    sProgressInfo.nLastReported = -1;
    sProgressInfo.psPyCallback = NULL;
    sProgressInfo.psPyCallbackData = NULL;
    if(!PyArg_ParseTuple(args,"sssis|OO:GDALComputeMedianCutPCT",	
			 &pszSwigRed, &pszSwigGreen, &pszSwigBlue,
			 &nColors, &pszSwigCT,
                         &(sProgressInfo.psPyCallback), 
		         &(sProgressInfo.psPyCallbackData) ) )
        return NULL;

    if (SWIG_GetPtr_2(pszSwigRed,(void **) &hRed,_GDALRasterBandH)
	|| SWIG_GetPtr_2(pszSwigGreen,(void **) &hGreen,_GDALRasterBandH)
	|| SWIG_GetPtr_2(pszSwigBlue,(void **) &hBlue,_GDALRasterBandH))
    {
        PyErr_SetString(PyExc_TypeError,
   	      "Type error with raster band in GDALComputeMedianCutPCT."
	      " Expected _GDALRasterBandH." );
        return NULL;
    }

    if (SWIG_GetPtr_2(pszSwigCT,(void **) &hColorTable,_GDALColorTableH))
    {
        PyErr_SetString(PyExc_TypeError,
   	      "Type error with argument 5 in GDALComputeMedianCutPCT."
	      " Expected _GDALColorTableH." );
        return NULL;
    }

    eErr = GDALComputeMedianCutPCT( hRed, hGreen, hBlue, NULL,
	                            nColors, hColorTable, 
	                            PyProgressProxy, &sProgressInfo );

    return Py_BuildValue( "i", eErr );
}


/************************************************************************/
/*                         GDALDitherRGB2PCT()                          */
/************************************************************************/
static PyObject *
py_GDALDitherRGB2PCT(PyObject *self, PyObject *args) {

    char *pszSwigRed, *pszSwigGreen, *pszSwigBlue, *pszSwigTarget;
    char *pszSwigCT = NULL;
    GDALRasterBandH   hRed, hGreen, hBlue, hTarget;
    GDALColorTableH   hColorTable = NULL;
    int               eErr;
    PyProgressData sProgressInfo;

    self = self;
    sProgressInfo.nLastReported = -1;
    sProgressInfo.psPyCallback = NULL;
    sProgressInfo.psPyCallbackData = NULL;
    if(!PyArg_ParseTuple(args,"sssss|OO:GDALDitherRGB2PCT",	
			 &pszSwigRed, &pszSwigGreen, &pszSwigBlue,
	                 &pszSwigTarget,
			 &pszSwigCT,
                         &(sProgressInfo.psPyCallback), 
		         &(sProgressInfo.psPyCallbackData) ) )
        return NULL;

    if (SWIG_GetPtr_2(pszSwigRed,(void **) &hRed,_GDALRasterBandH)
	|| SWIG_GetPtr_2(pszSwigGreen,(void **) &hGreen,_GDALRasterBandH)
	|| SWIG_GetPtr_2(pszSwigBlue,(void **) &hBlue,_GDALRasterBandH)
	|| SWIG_GetPtr_2(pszSwigTarget,(void **) &hTarget,_GDALRasterBandH))
    {
        PyErr_SetString(PyExc_TypeError,
   	      "Type error with raster band in GDALDitherRGB2PCT."
	      " Expected _GDALRasterBandH." );
        return NULL;
    }

    if (SWIG_GetPtr_2(pszSwigCT,(void **) &hColorTable,_GDALColorTableH))
    {
        PyErr_SetString(PyExc_TypeError,
   	      "Type error with argument 5 in GDALDitherRGB2PCT."
	      " Expected _GDALColorTableH." );
        return NULL;
    }

    eErr = GDALDitherRGB2PCT( hRed, hGreen, hBlue, hTarget, 
		              hColorTable, 	
	                      PyProgressProxy, &sProgressInfo );

    return Py_BuildValue( "i", eErr );
}


/************************************************************************/
/*                          OSRImportFromESRI()                         */
/************************************************************************/
static PyObject *
py_OSRImportFromESRI(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char *_argc0 = NULL;
    int err;
    PyObject *py_prj = NULL;
    char **prj = NULL;
    int    i;

    self = self;
    if(!PyArg_ParseTuple(args,"sO!:OSRImportFromESRI",
	&_argc0, &PyList_Type, &py_prj) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRImportFromESRI."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    for( i = 0; i < PyList_Size(py_prj); i++ )
    {
        char      *line = NULL;
        if( !PyArg_Parse( PyList_GET_ITEM(py_prj,i), "s", &line ) )
        {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 2 of OSRImportFromESRI."
                            "  Expected list of strings.");
            return NULL;
        }
        prj = CSLAddString( prj, line );
    }

    err = OSRImportFromESRI( _arg0, prj );
    CSLDestroy( prj );

    return Py_BuildValue( "i", err );
}

/************************************************************************/
/*                          OSRImportFromPCI()                          */
/************************************************************************/
static PyObject *
py_OSRImportFromPCI(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char    *_argc0 = NULL;
    int     err;
    PyObject *py_parms = NULL;
    char    *proj, *units = NULL;
    double  *parms = NULL;
    int     i;

    self = self;
    if(!PyArg_ParseTuple(args,"ss|sO!:OSRImportFromPCI",
	&_argc0, &proj, &units, &PyTuple_Type, &py_parms) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRImportFromPCI."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }

    parms = CPLMalloc(17 * sizeof(double));
    if (py_parms)
    {
        for( i = 0; i < 17; i++ )
        {
            if (i < PyTuple_Size(py_parms))
            {
                if(!PyArg_Parse(PyTuple_GET_ITEM(py_parms,i), "d", &parms[i]))
                {
                    PyErr_SetString(PyExc_TypeError,
                                "Type error in argument 4 of OSRImportFromPCI."
                                "  Expected tuple of floats.");
                    return NULL;
                }
            }
            else
                parms[i] = 0.0;
        }
    }
    else
    {
        for ( i = 0; i < 17; i++ )
            parms[i] = 0.0;
    }

    err = OSRImportFromPCI( _arg0, proj, units, parms );

    if (parms)
        CPLFree(parms);
    return Py_BuildValue( "i", err );
}

/************************************************************************/
/*                          OSRImportFromWkt()                          */
/************************************************************************/
static PyObject *
py_OSRImportFromWkt(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char *_argc0 = NULL;
    char *wkt;
    int err;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:OSRImportFromWkt",&_argc0,&wkt) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRImportFromWkt."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    err = OSRImportFromWkt( _arg0, &wkt );

    return Py_BuildValue( "i", err );
}

/************************************************************************/
/*                          OSRImportFromUSGS()                         */
/************************************************************************/
static PyObject *
py_OSRImportFromUSGS(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char    *_argc0 = NULL;
    int     err;
    PyObject *py_parms = NULL;
    long    iProjSys, iZone, iDatum;
    double  *parms = NULL;
    int     i;

    self = self;
    if(!PyArg_ParseTuple(args,"sllO!l:OSRImportFromUSGS",
	&_argc0, &iProjSys, &iZone, &PyTuple_Type, &py_parms, &iDatum) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRImportFromUSGS."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }

    parms = CPLMalloc(15 * sizeof(double));
    if (py_parms)
    {
        for( i = 0; i < 15; i++ )
        {
            if (i < PyTuple_Size(py_parms))
            {
                if(!PyArg_Parse(PyTuple_GET_ITEM(py_parms,i), "d", &parms[i]))
                {
                    PyErr_SetString(PyExc_TypeError,
                                "Type error in argument 4 of OSRImportFromUSGS."
                                "  Expected tuple of floats.");
                    return NULL;
                }
            }
            else
                parms[i] = 0.0;
        }
    }
    else
    {
        for ( i = 0; i < 15; i++ )
            parms[i] = 0.0;
    }

    err = OSRImportFromUSGS( _arg0, iProjSys, iZone, parms, iDatum );

    if (parms)
        CPLFree(parms);
    return Py_BuildValue( "i", err );
}

/************************************************************************/
/*                          OSRExportToPCI()                            */
/************************************************************************/
static PyObject *
py_OSRExportToPCI(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char *_argc0 = NULL;
    char *proj = NULL, *units = NULL;
    double *parms;
    int err;
    PyObject *ret;

    self = self;
    if(!PyArg_ParseTuple(args,"s:OSRExportToPCI",&_argc0) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRExportToPCI."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    err = OSRExportToPCI( _arg0, &proj, &units, &parms );
    if( err != OGRERR_NONE )
    {
        PyErr_SetString(PyExc_TypeError,
                        "Failed to export given SpatialReference.");
        return NULL;
    }

    ret = Py_BuildValue( "(ss(ddddddddddddddddd))", proj, units,
                         parms[0], parms[1], parms[2], parms[3], parms[4],
                         parms[5], parms[6], parms[7], parms[8], parms[9],
                         parms[10], parms[11], parms[12], parms[13],
                         parms[14], parms[15], parms[16] );
    CPLFree( proj );
    CPLFree( units );
    CPLFree( parms );
    return ret;
}

/************************************************************************/
/*                          OSRExportToProj4()                          */
/************************************************************************/
static PyObject *
py_OSRExportToProj4(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char *_argc0 = NULL;
    char *wkt = NULL;
    int err;
    PyObject *ret;

    self = self;
    if(!PyArg_ParseTuple(args,"s:OSRExportToProj4",&_argc0) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRExportToProj4."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    err = OSRExportToProj4( _arg0, &wkt );
    if( wkt == NULL )
	wkt = "";

    ret = Py_BuildValue( "s", wkt );
    OGRFree( wkt );
    return ret;
}

/************************************************************************/
/*                           OSRExportToWkt()                           */
/************************************************************************/
static PyObject *
py_OSRExportToWkt(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char *_argc0 = NULL;
    char *wkt = NULL;
    int err;
    PyObject *ret;

    self = self;
    if(!PyArg_ParseTuple(args,"s:OSRExportToWkt",&_argc0) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRExportToWkt."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    err = OSRExportToWkt( _arg0, &wkt );
    if( wkt == NULL )
	wkt = "";

    ret = Py_BuildValue( "s", wkt );
    OGRFree( wkt );
    return ret;
}

/************************************************************************/
/*                        OSRExportToPrettyWkt()                        */
/************************************************************************/
static PyObject *
py_OSRExportToPrettyWkt(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char *_argc0 = NULL;
    char *wkt = NULL;
    int  bSimplify = FALSE;
    int err;
    PyObject *ret;

    self = self;
    if(!PyArg_ParseTuple(args,"s|i:OSRExportToPrettyWkt",&_argc0, &bSimplify) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRExportToWkt."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    err = OSRExportToPrettyWkt( _arg0, &wkt, bSimplify );
    if( wkt == NULL )
	wkt = "";

    ret = Py_BuildValue( "s", wkt );
    OGRFree( wkt );
    return ret;
}

/************************************************************************/
/*                          OSRExportToUSGS()                           */
/************************************************************************/
static PyObject *
py_OSRExportToUSGS(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char    *_argc0 = NULL;
    long    iProjSys, iZone, iDatum;
    double  *parms;
    int     err;
    PyObject *ret;

    self = self;
    if(!PyArg_ParseTuple(args,"s:OSRExportToUSGS",&_argc0) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRExportToUSGS."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    err = OSRExportToUSGS( _arg0, &iProjSys, &iZone, &parms, &iDatum );
    if( err != OGRERR_NONE )
    {
        PyErr_SetString(PyExc_TypeError,
                        "Failed to export given SpatialReference.");
        return NULL;
    }

    ret = Py_BuildValue( "(ll(ddddddddddddddd)l)", iProjSys, iZone,
                         parms[0], parms[1], parms[2], parms[3], parms[4],
                         parms[5], parms[6], parms[7], parms[8], parms[9],
                         parms[10], parms[11], parms[12], parms[13],
                         parms[14], iDatum );
    CPLFree( parms );
    return ret;
}

/************************************************************************/
/*                           OSRExportToXML()                           */
/************************************************************************/
static PyObject *
py_OSRExportToXML(PyObject *self, PyObject *args) {

    OGRSpatialReferenceH _arg0;
    char *_argc0 = NULL;
    char *pszDialect = NULL;
    char *pszXML = NULL;
    int err;
    PyObject *ret;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:OSRExportToXML",&_argc0, &pszDialect) )
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,(void **) &_arg0,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OSRExportToXML."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }
	
    err = OSRExportToXML( _arg0, &pszXML, pszDialect );
    if( pszXML == NULL )
	pszXML = CPLStrdup("");

    ret = Py_BuildValue( "s", pszXML );
    OGRFree( pszXML );
    return ret;
}

/************************************************************************/
/*                             OCTTransform                             */
/************************************************************************/
static PyObject *
py_OCTTransform(PyObject *self, PyObject *args) {

    OGRCoordinateTransformationH _arg0;
    PyObject *pnts;
    char *_argc0 = NULL;
    double *x, *y, *z;
    int    pnt_count, i;

    self = self;
    if(!PyArg_ParseTuple(args,"sO!:OCTTransform",&_argc0, &PyList_Type, &pnts))
        return NULL;

    if (_argc0) {
        if (SWIG_GetPtr_2(_argc0,
			  (void **) &_arg0,_OGRCoordinateTransformationH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OCTTransform."
                            "  Expected _OGRCoordinateTransformationH.");
            return NULL;
        }
    }

    pnt_count = PyList_Size(pnts);
    x = (double *) CPLCalloc(sizeof(double),pnt_count);
    y = (double *) CPLCalloc(sizeof(double),pnt_count);
    z = (double *) CPLCalloc(sizeof(double),pnt_count);
    for( i = 0; i < pnt_count; i++ )
    {
	if( !PyArg_ParseTuple(PyList_GET_ITEM(pnts,i), "dd|d", x+i, y+i, z+i) )
        {
	    CPLFree( x );
	    CPLFree( y );
	    CPLFree( z );
	    return NULL;
        }
    }  	

    /* perform the transformation */
    if( !OCTTransform( _arg0, pnt_count, x, y, z ) )
    {
        CPLFree( x );
        CPLFree( y );
        CPLFree( z );

        PyErr_SetString(PyExc_TypeError,"OCTTransform failed.");
	return NULL;
    }

    /* make a new points list */
    pnts = PyList_New(pnt_count);
    for( i = 0; i < pnt_count; i++ )
    {
	PyList_SetItem(pnts, i, Py_BuildValue("(ddd)", x[i], y[i], z[i] ) );
    }

    CPLFree( x );
    CPLFree( y );
    CPLFree( z );

    return pnts;
}

/************************************************************************/
/*                        OPTGetProjectionMethods()                     */
/************************************************************************/
static PyObject *
py_OPTGetProjectionMethods(PyObject *self, PyObject *args) {

    PyObject *py_MList;
    char     **papszMethods;
    int      iMethod;
    
    self = self;
    args = args;

    papszMethods = OPTGetProjectionMethods();
    py_MList = PyList_New(CSLCount(papszMethods));

    for( iMethod = 0; papszMethods[iMethod] != NULL; iMethod++ )
    {
	char    *pszUserMethodName;
	char    **papszParameters;
	PyObject *py_PList;
	int       iParam;

	papszParameters = OPTGetParameterList( papszMethods[iMethod], 
					       &pszUserMethodName );
        if( papszParameters == NULL )
            return NULL;

	py_PList = PyList_New(CSLCount(papszParameters));
	for( iParam = 0; papszParameters[iParam] != NULL; iParam++ )
       	{
	    char    *pszType;
	    char    *pszUserParamName;
            double  dfDefault;

	    OPTGetParameterInfo( papszMethods[iMethod], 
				 papszParameters[iParam], 
				 &pszUserParamName, 
				 &pszType, &dfDefault );
	    PyList_SetItem(py_PList, iParam, 
			   Py_BuildValue("(sssd)", 
					 papszParameters[iParam], 
					 pszUserParamName, 
                                         pszType, dfDefault ));
	}
	
	CSLDestroy( papszParameters );

	PyList_SetItem(py_MList, iMethod, 
		       Py_BuildValue("(ssO)", 
		                     papszMethods[iMethod], 
				     pszUserMethodName, 
		                     py_PList));
    }

    CSLDestroy( papszMethods );

    return py_MList;
}

/************************************************************************/
/*                          XMLTreeToPyList()                           */
/************************************************************************/

static PyObject *XMLTreeToPyList( CPLXMLNode *psTree )

{
    PyObject *pyList;
    int      nChildCount = 0, iChild;
    CPLXMLNode *psChild;

    for( psChild = psTree->psChild; 
         psChild != NULL; 
         psChild = psChild->psNext )
        nChildCount++;

    pyList = PyList_New(nChildCount+2);

    PyList_SetItem( pyList, 0, Py_BuildValue( "i", (int) psTree->eType ) );
    PyList_SetItem( pyList, 1, Py_BuildValue( "s", psTree->pszValue ) );

    for( psChild = psTree->psChild, iChild = 2; 
         psChild != NULL; 
         psChild = psChild->psNext, iChild++ )
    {
        PyList_SetItem( pyList, iChild, XMLTreeToPyList( psChild ) );
    }

    return pyList; 
}

/************************************************************************/
/*                         CPLParseXMLString()                          */
/************************************************************************/
static PyObject *
py_CPLParseXMLString(PyObject *self, PyObject *args) {

    char *pszText = NULL;
    CPLXMLNode  *psXMLTree = NULL;
    PyObject    *pyList;

    self = self;
    if(!PyArg_ParseTuple(args,"s:CPLParseXMLString", &pszText ))
        return NULL;

    psXMLTree = CPLParseXMLString( pszText );
    if( psXMLTree == NULL )
    {
	PyErr_SetString(PyExc_TypeError,CPLGetLastErrorMsg());
	return NULL;
    }

    if( psXMLTree != NULL && psXMLTree->psNext != NULL )
    {
	CPLXMLNode *psFirst = psXMLTree;

	/* create a "pseudo" root if we have multiple elements */
        psXMLTree = CPLCreateXMLNode( NULL, CXT_Element, "" );
	psXMLTree->psChild = psFirst;
    }

    pyList = XMLTreeToPyList( psXMLTree );

    CPLDestroyXMLNode( psXMLTree );

    return pyList;
}

/************************************************************************/
/*                          PyListToXMLTree()                           */
/************************************************************************/

static CPLXMLNode *PyListToXMLTree( PyObject *pyList )

{
    int      nChildCount = 0, iChild, nType;
    CPLXMLNode *psThisNode;
    CPLXMLNode *psChild;
    char       *pszText = NULL;

    nChildCount = PyList_Size(pyList) - 2;
    if( nChildCount < 0 )
    {
        PyErr_SetString(PyExc_TypeError,"Error in input XMLTree." );
	return NULL;
    }

    PyArg_Parse( PyList_GET_ITEM(pyList,0), "i", &nType );
    PyArg_Parse( PyList_GET_ITEM(pyList,1), "s", &pszText );
    psThisNode = CPLCreateXMLNode( NULL, (CPLXMLNodeType) nType, pszText );

    for( iChild = 0; iChild < nChildCount; iChild++ )
    {
        psChild = PyListToXMLTree( PyList_GET_ITEM(pyList,iChild+2) );
        CPLAddXMLChild( psThisNode, psChild );
    }

    return psThisNode;
}

/************************************************************************/
/*                         CPLSerializeXMLTree()                        */
/************************************************************************/
static PyObject *
py_CPLSerializeXMLTree(PyObject *self, PyObject *args) {

    char *pszText = NULL;
    CPLXMLNode  *psXMLTree = NULL;
    PyObject    *pyList = NULL, *pyResult = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"O!:CPLSerializeXMLTree", 
			 &PyList_Type, &pyList ))
        return NULL;

    psXMLTree = PyListToXMLTree( pyList );
    if( psXMLTree == NULL )
	return NULL;

    if( psXMLTree->eType == CXT_Element 
        && psXMLTree->pszValue[0] == '\0' )
    {
	CPLXMLNode *psChild;

        /* We want to avoid including the root as an element level */
        pszText = NULL;
	for( psChild = psXMLTree->psChild; 
             psChild != NULL; psChild = psChild->psNext )
        {
            char *pszTextChunk;

            pszTextChunk = CPLSerializeXMLTree( psChild );
            if( pszText == NULL )
                pszText = pszTextChunk;
            else
            {
		pszText = (char *)
		    CPLRealloc(pszText, 
                               strlen(pszText)+strlen(pszTextChunk)+1);
                strcat( pszText, pszTextChunk );
                CPLFree( pszTextChunk );
            } 
        }
    }
    else
        pszText = CPLSerializeXMLTree( psXMLTree );

    CPLDestroyXMLNode( psXMLTree );

    pyResult = Py_BuildValue( "s", pszText );
    CPLFree( pszText );

    return pyResult;
}


/************************************************************************/
/*                             CPLDebug()                               */
/************************************************************************/
static PyObject *
py_CPLDebug(PyObject *self, PyObject *args) {

    char *pszText = NULL;
    char *pszMsgClass = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:CPLDebug", &pszMsgClass, &pszText ))
        return NULL;

    CPLDebug( pszMsgClass, "%s", pszText );

    Py_INCREF(Py_None);
    return Py_None;
}


/************************************************************************/
/*                              CPLError()                              */
/************************************************************************/
static PyObject *
py_CPLError(PyObject *self, PyObject *args) {

    char *pszText = NULL;
    int  nErrClass, nErrCode;

    self = self;
    if(!PyArg_ParseTuple(args,"iis:CPLError", &nErrClass, &nErrCode, &pszText))
        return NULL;

    CPLError( nErrClass, nErrCode, "%s", pszText );

    Py_INCREF(Py_None);
    return Py_None;
}


typedef struct _PyErrorHandlerData {
    PyObject *psPyErrorHandler;
    struct _PyErrorHandlerData *psPrevious;
} PyErrorHandlerData;

static PyErrorHandlerData *psPyHandlerStack = NULL;

/************************************************************************/
/*                        PyErrorHandlerProxy()                         */
/************************************************************************/

void PyErrorHandlerProxy( CPLErr eErrType, int nErrorCode, const char *pszMsg )

{
    PyObject *psArgs;
    PyObject *psResult;

    CPLAssert( psPyHandlerStack != NULL );
    if( psPyHandlerStack == NULL )
        return;

    psArgs = Py_BuildValue("(iis)", (int) eErrType, nErrorCode, pszMsg );

    psResult = PyEval_CallObject( psPyHandlerStack->psPyErrorHandler, psArgs);
    Py_XDECREF(psArgs);

    if( psResult != NULL )
    {
        Py_XDECREF( psResult );
    }
}

/************************************************************************/
/*                        CPLPushErrorHandler()                         */
/************************************************************************/
static PyObject *
py_CPLPushErrorHandler(PyObject *self, PyObject *args) {

    PyObject *psPyCallback = NULL;
    PyErrorHandlerData *psCBData = NULL;
    char *pszCallbackName = NULL;
    CPLErrorHandler pfnHandler = NULL;

    self = self;

    if(!PyArg_ParseTuple(args,"O:CPLPushErrorHandler",	&psPyCallback ) )
        return NULL;

    psCBData = (PyErrorHandlerData *) CPLCalloc(sizeof(PyErrorHandlerData),1);
    psCBData->psPrevious = psPyHandlerStack;
    psPyHandlerStack = psCBData;

    if( PyArg_Parse( psPyCallback, "s", &pszCallbackName ) )
    {
        if( EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
	    pfnHandler = CPLQuietErrorHandler;
        else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
	    pfnHandler = CPLDefaultErrorHandler;
        else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
            pfnHandler = CPLLoggingErrorHandler;
        else
        {
	    PyErr_SetString(PyExc_ValueError,
   	            "Unsupported callback name in CPLPushErrorHandler");
            return NULL;
        }
    }
    else
    {
	PyErr_Clear();
	pfnHandler = PyErrorHandlerProxy;
        psCBData->psPyErrorHandler = psPyCallback;
        Py_INCREF( psPyCallback );
    }

    CPLPushErrorHandler( pfnHandler );

    Py_INCREF(Py_None);
    return Py_None;
}



/************************************************************************/
/*                         CPLPopErrorHandler()                         */
/************************************************************************/

static PyObject *
py_CPLPopErrorHandler(PyObject *self, PyObject *args) 
{
    PyErrorHandlerData *psCBData = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,":CPLPopErrorHandler" ) )
        return NULL;

    CPLPopErrorHandler();

    if( psPyHandlerStack != NULL )
    {								
	psCBData = psPyHandlerStack;
        psPyHandlerStack = psCBData->psPrevious;

        if( psCBData->psPyErrorHandler != NULL )
        {
            Py_XDECREF( psCBData->psPyErrorHandler );
        }
        CPLFree( psCBData );	
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/************************************************************************/
/*                         OGR_G_CreateFromWkb()			*/
/* 									*/
/*	Operates as:							*/
/*	  OGRGeometryH OGR_G_CreateFromWkb( bin_string, 		*/
/*					    OGRSpatialReferenceH ); 	*/
/************************************************************************/
static PyObject *
py_OGR_G_CreateFromWkb(PyObject *self, PyObject *args) {

    char *wkb_in = NULL, *srs_in = NULL;
    OGRSpatialReferenceH hSRS = NULL;
    OGRErr eErr;
    OGRGeometryH hGeom = NULL;
    int    wkb_len = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"z#s:OGR_G_CreateFromWkb", &wkb_in, &wkb_len,
                         &srs_in))
        return NULL;

    if( srs_in && strlen(srs_in) > 0 ) {
        if (SWIG_GetPtr_2(srs_in,
			  (void **) &hSRS,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 2 of OGR_G_CreateFromWkb."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }

    eErr = OGR_G_CreateFromWkb( wkb_in, hSRS, &hGeom );

    if( eErr != CE_None )
    {
        if( eErr == OGRERR_CORRUPT_DATA )
            PyErr_SetString(PyExc_ValueError,
	                    "Corrupt WKB geometry passed to OGR_G_CreateFromWkb." );
	else
            PyErr_SetString(PyExc_ValueError,
	                    "OGR_G_CreateFromWkb failed." );

        return NULL;
    }
    else
    {
	char _ptemp[128];
        SWIG_MakePtr(_ptemp, (char *) hGeom,"_OGRGeometryH");
        return Py_BuildValue("s",_ptemp);
    }
}

/************************************************************************/
/*                        OGR_G_CreateFromWkt()                         */
/*                                                                      */
/*      Operates as:                                                    */
/*        OGRGeometryH OGR_G_CreateFromWkt( string,                     */
/*                                          OGRSpatialReferenceH );     */
/************************************************************************/
static PyObject *
py_OGR_G_CreateFromWkt(PyObject *self, PyObject *args) {

    char *wkt_in = NULL, *srs_in = NULL;
    OGRSpatialReferenceH hSRS = NULL;
    OGRErr eErr;
    OGRGeometryH hGeom = NULL;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:OGR_G_CreateFromWkt", &wkt_in, 
                         &srs_in))
        return NULL;

    if( srs_in && strlen(srs_in) > 0 ) {
        if (SWIG_GetPtr_2(srs_in,
			  (void **) &hSRS,_OGRSpatialReferenceH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 2 of OGR_G_CreateFromWkt."
                            "  Expected _OGRSpatialReferenceH.");
            return NULL;
        }
    }

    eErr = OGR_G_CreateFromWkt( &wkt_in, hSRS, &hGeom );

    if( eErr != CE_None )
    {
        if( eErr == OGRERR_CORRUPT_DATA )
            PyErr_SetString(PyExc_ValueError,
	                    "Corrupt WKT geometry passed to OGR_G_CreateFromWkt." );
	else
            PyErr_SetString(PyExc_ValueError,
	                    "OGR_G_CreateFromWkt failed." );

        return NULL;
    }
    else
    {
	char _ptemp[128];
        SWIG_MakePtr(_ptemp, (char *) hGeom,"_OGRGeometryH");
        return Py_BuildValue("s",_ptemp);
    }
}

/************************************************************************/
/*                        OGR_G_ExportToWkb()                           */
/************************************************************************/
static PyObject *
py_OGR_G_ExportToWkb(PyObject *self, PyObject *args) {

    char *geom_in = NULL;
    OGRGeometryH hGeom;
    unsigned char *pabyWkb = NULL;
    int            nWkbSize = 0, byte_order;
    OGRErr eErr;

    self = self;
    if(!PyArg_ParseTuple(args,"si:OGR_G_ExportToWkb", &geom_in, &byte_order))
        return NULL;

    if( geom_in ) {
        if (SWIG_GetPtr_2(geom_in,
			  (void **) &hGeom,_OGRGeometryH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OGR_G_ExportToWkb."
                            "  Expected _OGRGeometryH.");
            return NULL;
        }
    }

    nWkbSize = OGR_G_WkbSize( hGeom );
    pabyWkb = (unsigned char *) CPLMalloc( nWkbSize );
    eErr = OGR_G_ExportToWkb( hGeom, (OGRwkbByteOrder) byte_order, pabyWkb );

    if( eErr != CE_None )
    {
	CPLFree( pabyWkb );
        return NULL;
    }
    else
    {
        PyObject *result = NULL;
	result = PyString_FromStringAndSize( pabyWkb, nWkbSize );
        CPLFree( pabyWkb );
        return result;
    }
}

/************************************************************************/
/*                         OGR_G_ExportToWkt()                          */
/************************************************************************/
static PyObject *
py_OGR_G_ExportToWkt(PyObject *self, PyObject *args) {

    char *geom_in = NULL;
    OGRGeometryH hGeom;
    char         *pszWkt;
    OGRErr eErr;

    self = self;
    if(!PyArg_ParseTuple(args,"s:OGR_G_ExportToWkt", &geom_in))
        return NULL;

    if( geom_in ) {
        if (SWIG_GetPtr_2(geom_in,
			  (void **) &hGeom,_OGRGeometryH)) {
            PyErr_SetString(PyExc_TypeError,
                            "Type error in argument 1 of OGR_G_ExportToWkb."
                            "  Expected _OGRGeometryH.");
            return NULL;
        }
    }

    eErr = OGR_G_ExportToWkt( hGeom, &pszWkt );

    if( eErr != CE_None )
        return NULL;
    else
    {
        PyObject *result = NULL;

	result = Py_BuildValue( "s", pszWkt );
	CPLFree( pszWkt );
        return result;
    }
}

/************************************************************************/
/*                           OGR_F_GetField()                           */
/************************************************************************/
static PyObject *
py_OGR_F_GetField(PyObject *self, PyObject *args) {

    OGRFeatureH  hFeat;
    char  *feat_in = NULL;
    int    iField;
    PyObject *result = NULL;	

    self = self;
    if(!PyArg_ParseTuple(args,"si:OGR_F_GetField", &feat_in, &iField))
        return NULL;

    if (SWIG_GetPtr_2(feat_in,(void **) &hFeat,_OGRFeatureH)) {
        PyErr_SetString(PyExc_TypeError,
                        "Type error in argument 1 of OGR_F_GetField."
                        "  Expected _OGRFeatureH.");
        return NULL;
    }

    if( !OGR_F_IsFieldSet( hFeat, iField ) )
    {  
         Py_INCREF( Py_None );
         result = Py_None;
    }
    else
    {
        OGRFieldType eFType;
	int          nCount, i;
	const int   *panList = NULL;
	const double  *padfList = NULL;
        PyObject *psList;
        char        **papszList;

        eFType = OGR_Fld_GetType( OGR_F_GetFieldDefnRef( hFeat, iField ) );

        switch( eFType ) 
        {
          case OFTInteger:
            result = Py_BuildValue( "i", 
                       OGR_F_GetFieldAsInteger( hFeat, iField ) );
	    break;
          case OFTReal:
            result = Py_BuildValue( "d", 
                       OGR_F_GetFieldAsDouble( hFeat, iField ) );
	    break;
          case OFTString:
            result = Py_BuildValue( "s", 
                       OGR_F_GetFieldAsString( hFeat, iField ) );
	    break;
          case OFTBinary:
            result = PyString_FromStringAndSize("",0);
            break;
          case OFTIntegerList:
            panList = OGR_F_GetFieldAsIntegerList(hFeat,iField,&nCount);
            psList = PyList_New( nCount );
            for( i=0; i < nCount; i++ )
                PyList_SetItem(psList, i, Py_BuildValue("i", panList[i]));
            result = psList;
            break;
          case OFTRealList:
            padfList = OGR_F_GetFieldAsDoubleList(hFeat,iField,&nCount);
            psList = PyList_New( nCount );
            for( i=0; i < nCount; i++ )
                PyList_SetItem(psList, i, Py_BuildValue("d", padfList[i]));
            result = psList;
            break;
          case OFTStringList:
            papszList = OGR_F_GetFieldAsStringList(hFeat,iField);
            nCount = CSLCount(papszList);
            psList = PyList_New( nCount );
            for( i=0; i < nCount; i++ )
                PyList_SetItem(psList, i, Py_BuildValue("s", papszList[i]));
            result = psList;
            break;
          default:
            CPLAssert( FALSE );
            break;
        }
    }

    return result;
}

/************************************************************************/
/*                      OGRBuildPolygonFromEdges()                      */
/************************************************************************/
static PyObject *
py_OGRBuildPolygonFromEdges(PyObject *self, PyObject *args) {

    OGRGeometryH  hLineCollection, hPolygon;
    char  *lines_in = NULL;
    int    bBestEffort, bAutoClose;
    double dfTolerance;
    OGRErr eErr;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"siid:OGRBuildPolygonFromEdges", &lines_in, 
                         &bBestEffort, &bAutoClose, &dfTolerance ))
        return NULL;

    if (SWIG_GetPtr_2(lines_in,(void **) &hLineCollection,_OGRGeometryH)) {
        PyErr_SetString(PyExc_TypeError,
                        "Type error in argument 1 of OGRBuildPolygonFromEdges."
                        "  Expected _OGRGeometryH.");
        return NULL;
    }

    hPolygon = OGRBuildPolygonFromEdges( hLineCollection, bBestEffort, 
                                         bAutoClose, dfTolerance, &eErr );

    if( eErr != OGRERR_NONE )
    {
        PyErr_SetString(PyExc_ValueError,
                        "Failed to assemble some or all edges into polygon rings." );
	return NULL;
    }

    SWIG_MakePtr(_ptemp, (char *) hPolygon,"_OGRGeometryH");
    return Py_BuildValue("s",_ptemp);
}
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_ptrcast(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:ptrcast",&_obj0,&_arg1)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptrcast(_arg0,_arg1);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrvalue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    int  _arg1 = (int ) 0;
    char * _arg2 = (char *) 0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O|is:ptrvalue",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptrvalue(_arg0,_arg1,_arg2);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    PyObject * _arg1;
    int  _arg2 = (int ) 0;
    char * _arg3 = (char *) 0;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO|is:ptrset",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
  _arg0 = _obj0;
}
{
  _arg1 = _obj1;
}
    _result = (PyObject *)ptrset(_arg0,_arg1,_arg2,_arg3);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrcreate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    char * _arg0;
    PyObject * _arg1 = (PyObject *) 0;
    int  _arg2 = (int ) 1;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s|Oi:ptrcreate",&_arg0,&_obj1,&_arg2)) 
        return NULL;
    if (_obj1)
{
  _arg1 = _obj1;
}
    _result = (PyObject *)ptrcreate(_arg0,_arg1,_arg2);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrfree(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:ptrfree",&_obj0)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptrfree(_arg0);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptradd(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:ptradd",&_obj0,&_arg1)) 
        return NULL;
{
  _arg0 = _obj0;
}
    _result = (PyObject *)ptradd(_arg0,_arg1);
{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:ptrmap",&_arg0,&_arg1)) 
        return NULL;
    ptrmap(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_CPLErrorReset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":CPLErrorReset")) 
        return NULL;
    CPLErrorReset();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_CPLGetLastErrorNo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":CPLGetLastErrorNo")) 
        return NULL;
    _result = (int )CPLGetLastErrorNo();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_CPLGetLastErrorMsg(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":CPLGetLastErrorMsg")) 
        return NULL;
    _result = (char *)CPLGetLastErrorMsg();
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_CSLDestroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stringList  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:CSLDestroy",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stringList")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of CSLDestroy. Expected _stringList.");
        return NULL;
        }
    }
    CSLDestroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALGetDataTypeSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDataType  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALGetDataTypeSize",&_arg0)) 
        return NULL;
    _result = (int )GDALGetDataTypeSize(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALDataTypeIsComplex(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDataType  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALDataTypeIsComplex",&_arg0)) 
        return NULL;
    _result = (int )GDALDataTypeIsComplex(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDataTypeName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALDataType  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALGetDataTypeName",&_arg0)) 
        return NULL;
    _result = (char *)GDALGetDataTypeName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDataTypeByName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDataType  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:GDALGetDataTypeByName",&_arg0)) 
        return NULL;
    _result = (GDALDataType )GDALGetDataTypeByName(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetColorInterpretationName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALColorInterp  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALGetColorInterpretationName",&_arg0)) 
        return NULL;
    _result = (char *)GDALGetColorInterpretationName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetPaletteInterpretationName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALPaletteInterp  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALGetPaletteInterpretationName",&_arg0)) 
        return NULL;
    _result = (char *)GDALGetPaletteInterpretationName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALDecToDMS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    double  _arg0;
    char * _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"dsi:GDALDecToDMS",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (char *)GDALDecToDMS(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALPackedDMSToDec(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    double  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"d:GDALPackedDMSToDec",&_arg0)) 
        return NULL;
    _result = (double )GDALPackedDMSToDec(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALDecToPackedDMS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    double  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"d:GDALDecToPackedDMS",&_arg0)) 
        return NULL;
    _result = (double )GDALDecToPackedDMS(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALTermProgress(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    double  _arg0;
    char * _arg1;
    void * _arg2;
    PyObject * _argo2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"dsO:GDALTermProgress",&_arg0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of GDALTermProgress. Expected _void_p.");
        return NULL;
        }
    }
    _result = (int )GDALTermProgress(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetMetadata(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stringList  _result;
    GDALMajorObjectH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Os:GDALGetMetadata",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetMetadata. Expected _GDALMajorObjectH.");
        return NULL;
        }
    }
    _result = (stringList )GDALGetMetadata(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_stringList");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALSetMetadata(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    CPLErr * _result;
    GDALMajorObjectH  _arg0;
    stringList  _arg1;
    char * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OOs:GDALSetMetadata",&_argo0,&_argo1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALSetMetadata. Expected _GDALMajorObjectH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_stringList")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of GDALSetMetadata. Expected _stringList.");
        return NULL;
        }
    }
    _result = (CPLErr *) malloc(sizeof(CPLErr ));
    *(_result) = GDALSetMetadata(_arg0,_arg1,_arg2);
    SWIG_MakePtr(_ptemp, (void *) _result,"_CPLErr_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDescription(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALMajorObjectH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetDescription",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetDescription. Expected _GDALMajorObjectH.");
        return NULL;
        }
    }
    _result = (char *)GDALGetDescription(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALSetDescription(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALMajorObjectH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:GDALSetDescription",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALSetDescription. Expected _GDALMajorObjectH.");
        return NULL;
        }
    }
    GDALSetDescription(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALAllRegister(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":GDALAllRegister")) 
        return NULL;
    GDALAllRegister();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALRegister_NUMPY(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":GDALRegister_NUMPY")) 
        return NULL;
    GDALRegister_NUMPY();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALOpen(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDatasetH  _result;
    char * _arg0;
    GDALAccess  _arg1;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"si:GDALOpen",&_arg0,&_arg1)) 
        return NULL;
    _result = (GDALDatasetH )GDALOpen(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALDatasetH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALOpenShared(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDatasetH  _result;
    char * _arg0;
    GDALAccess  _arg1;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"si:GDALOpenShared",&_arg0,&_arg1)) 
        return NULL;
    _result = (GDALDatasetH )GDALOpenShared(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALDatasetH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALGetDriverByName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDriverH  _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:GDALGetDriverByName",&_arg0)) 
        return NULL;
    _result = (GDALDriverH )GDALGetDriverByName(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALDriverH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALGetDriverCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":GDALGetDriverCount")) 
        return NULL;
    _result = (int )GDALGetDriverCount();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDriver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDriverH  _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALGetDriver",&_arg0)) 
        return NULL;
    _result = (GDALDriverH )GDALGetDriver(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALDriverH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALRegisterDriver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDriverH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALRegisterDriver",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALRegisterDriver. Expected _GDALDriverH.");
        return NULL;
        }
    }
    _result = (int )GDALRegisterDriver(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALDeregisterDriver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDriverH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALDeregisterDriver",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALDeregisterDriver. Expected _GDALDriverH.");
        return NULL;
        }
    }
    GDALDeregisterDriver(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALDeleteDataset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDriverH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:GDALDeleteDataset",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALDeleteDataset. Expected _GDALDriverH.");
        return NULL;
        }
    }
    _result = (int )GDALDeleteDataset(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDriverShortName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALDriverH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetDriverShortName",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetDriverShortName. Expected _GDALDriverH.");
        return NULL;
        }
    }
    _result = (char *)GDALGetDriverShortName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDriverLongName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALDriverH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetDriverLongName",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetDriverLongName. Expected _GDALDriverH.");
        return NULL;
        }
    }
    _result = (char *)GDALGetDriverLongName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDriverHelpTopic(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALDriverH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetDriverHelpTopic",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetDriverHelpTopic. Expected _GDALDriverH.");
        return NULL;
        }
    }
    _result = (char *)GDALGetDriverHelpTopic(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetDatasetDriver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDriverH  _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetDatasetDriver",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetDatasetDriver. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (GDALDriverH )GDALGetDatasetDriver(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALDriverH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALClose(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALClose",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALClose. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    GDALClose(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterXSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterXSize",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterXSize. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (int )GDALGetRasterXSize(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterYSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterYSize",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterYSize. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (int )GDALGetRasterYSize(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterCount. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (int )GDALGetRasterCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterBand(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALRasterBandH  _result;
    GDALDatasetH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:GDALGetRasterBand",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterBand. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (GDALRasterBandH )GDALGetRasterBand(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALRasterBandH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALGetProjectionRef(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetProjectionRef",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetProjectionRef. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (char *)GDALGetProjectionRef(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALSetProjection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:GDALSetProjection",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALSetProjection. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (int )GDALSetProjection(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetGeoTransform(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    double * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:GDALGetGeoTransform",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetGeoTransform. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of GDALGetGeoTransform. Expected _double_p.");
        return NULL;
        }
    }
    _result = (int )GDALGetGeoTransform(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALSetGeoTransform(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    double * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:GDALSetGeoTransform",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALSetGeoTransform. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of GDALSetGeoTransform. Expected _double_p.");
        return NULL;
        }
    }
    _result = (int )GDALSetGeoTransform(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALReferenceDataset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALReferenceDataset",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALReferenceDataset. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (int )GDALReferenceDataset(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALDereferenceDataset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALDereferenceDataset",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALDereferenceDataset. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (int )GDALDereferenceDataset(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetGCPCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetGCPCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetGCPCount. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (int )GDALGetGCPCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetGCPProjection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetGCPProjection",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetGCPProjection. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    _result = (char *)GDALGetGCPProjection(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GDALFlushCache(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDatasetH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALFlushCache",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALFlushCache. Expected _GDALDatasetH.");
        return NULL;
        }
    }
    GDALFlushCache(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterDataType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALDataType  _result;
    GDALRasterBandH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterDataType",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterDataType. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (GDALDataType )GDALGetRasterDataType(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetBlockSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALRasterBandH  _arg0;
    int * _arg1;
    int * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;
    PyObject * _argo2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:GDALGetBlockSize",&_argo0,&_argo1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetBlockSize. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of GDALGetBlockSize. Expected _int_p.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of GDALGetBlockSize. Expected _int_p.");
        return NULL;
        }
    }
    GDALGetBlockSize(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterBandXSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALRasterBandH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterBandXSize",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterBandXSize. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (int )GDALGetRasterBandXSize(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterBandYSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALRasterBandH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterBandYSize",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterBandYSize. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (int )GDALGetRasterBandYSize(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterColorInterpretation(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALColorInterp  _result;
    GDALRasterBandH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterColorInterpretation",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterColorInterpretation. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (GDALColorInterp )GDALGetRasterColorInterpretation(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterColorTable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALColorTableH  _result;
    GDALRasterBandH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetRasterColorTable",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterColorTable. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (GDALColorTableH )GDALGetRasterColorTable(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALColorTableH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALSetRasterColorTable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALRasterBandH  _arg0;
    GDALColorTableH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:GDALSetRasterColorTable",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALSetRasterColorTable. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of GDALSetRasterColorTable. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    _result = (int )GDALSetRasterColorTable(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetRasterNoDataValue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GDALRasterBandH  _arg0;
    int * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:GDALGetRasterNoDataValue",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetRasterNoDataValue. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of GDALGetRasterNoDataValue. Expected _int_p.");
        return NULL;
        }
    }
    _result = (double )GDALGetRasterNoDataValue(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALSetRasterNoDataValue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALRasterBandH  _arg0;
    double  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:GDALSetRasterNoDataValue",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALSetRasterNoDataValue. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (int )GDALSetRasterNoDataValue(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALComputeRasterMinMax(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALRasterBandH  _arg0;
    int  _arg1;
    double * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:GDALComputeRasterMinMax",&_argo0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALComputeRasterMinMax. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of GDALComputeRasterMinMax. Expected _double_p.");
        return NULL;
        }
    }
    GDALComputeRasterMinMax(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALGetOverviewCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALRasterBandH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetOverviewCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetOverviewCount. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (int )GDALGetOverviewCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetOverview(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALRasterBandH  _result;
    GDALRasterBandH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:GDALGetOverview",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetOverview. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (GDALRasterBandH )GDALGetOverview(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALRasterBandH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALFlushRasterCache(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALRasterBandH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALFlushRasterCache",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALFlushRasterCache. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (int )GDALFlushRasterCache(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALCreateColorTable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALColorTableH  _result;
    GDALPaletteInterp  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALCreateColorTable",&_arg0)) 
        return NULL;
    _result = (GDALColorTableH )GDALCreateColorTable(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALColorTableH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALDestroyColorTable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALColorTableH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALDestroyColorTable",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALDestroyColorTable. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    GDALDestroyColorTable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALCloneColorTable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALColorTableH  _result;
    GDALColorTableH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALCloneColorTable",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALCloneColorTable. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    _result = (GDALColorTableH )GDALCloneColorTable(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALColorTableH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALGetPaletteInterpretation(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALPaletteInterp  _result;
    GDALColorTableH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetPaletteInterpretation",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetPaletteInterpretation. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    _result = (GDALPaletteInterp )GDALGetPaletteInterpretation(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetColorEntryCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALColorTableH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GDALGetColorEntryCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetColorEntryCount. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    _result = (int )GDALGetColorEntryCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetColorEntry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALColorEntry * _result;
    GDALColorTableH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:GDALGetColorEntry",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetColorEntry. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    _result = (GDALColorEntry *)GDALGetColorEntry(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_GDALColorEntry_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_GDALGetColorEntryAsRGB(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALColorTableH  _arg0;
    int  _arg1;
    GDALColorEntry * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:GDALGetColorEntryAsRGB",&_argo0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALGetColorEntryAsRGB. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_GDALColorEntry_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of GDALGetColorEntryAsRGB. Expected _GDALColorEntry_p.");
        return NULL;
        }
    }
    _result = (int )GDALGetColorEntryAsRGB(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALSetColorEntry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GDALColorTableH  _arg0;
    int  _arg1;
    GDALColorEntry * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:GDALSetColorEntry",&_argo0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALSetColorEntry. Expected _GDALColorTableH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_GDALColorEntry_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of GDALSetColorEntry. Expected _GDALColorEntry_p.");
        return NULL;
        }
    }
    GDALSetColorEntry(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALSetCacheMax(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:GDALSetCacheMax",&_arg0)) 
        return NULL;
    GDALSetCacheMax(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GDALGetCacheMax(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":GDALGetCacheMax")) 
        return NULL;
    _result = (int )GDALGetCacheMax();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALGetCacheUsed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":GDALGetCacheUsed")) 
        return NULL;
    _result = (int )GDALGetCacheUsed();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALFlushCacheBlock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":GDALFlushCacheBlock")) 
        return NULL;
    _result = (int )GDALFlushCacheBlock();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GDALChecksumImage(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GDALRasterBandH  _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiiii:GDALChecksumImage",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of GDALChecksumImage. Expected _GDALRasterBandH.");
        return NULL;
        }
    }
    _result = (int )GDALChecksumImage(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRNewSpatialReference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRSpatialReferenceH  _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:OSRNewSpatialReference",&_arg0)) 
        return NULL;
    _result = (OGRSpatialReferenceH )OSRNewSpatialReference(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRSpatialReferenceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OSRDestroySpatialReference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRDestroySpatialReference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRDestroySpatialReference. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    OSRDestroySpatialReference(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OSRReference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRReference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRReference. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRReference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRDereference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRDereference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRDereference. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRDereference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRImportFromEPSG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OSRImportFromEPSG",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRImportFromEPSG. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRImportFromEPSG(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRImportFromProj4(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OSRImportFromProj4",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRImportFromProj4. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRImportFromProj4(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRCloneGeogCS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRSpatialReferenceH  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRCloneGeogCS",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRCloneGeogCS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (OGRSpatialReferenceH )OSRCloneGeogCS(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRSpatialReferenceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OSRImportFromXML(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OSRImportFromXML",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRImportFromXML. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRImportFromXML(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRMorphToESRI(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRMorphToESRI",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRMorphToESRI. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRMorphToESRI(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRMorphFromESRI(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRMorphFromESRI",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRMorphFromESRI. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRMorphFromESRI(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRValidate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRValidate",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRValidate. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRValidate(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRFixupOrdering(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRFixupOrdering",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRFixupOrdering. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRFixupOrdering(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRFixup(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRFixup",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRFixup. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRFixup(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRStripCTParms(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRStripCTParms",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRStripCTParms. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRStripCTParms(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetAttrValue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    char * _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oss:OSRSetAttrValue",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetAttrValue. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetAttrValue(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetAttrValue(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osi:OSRGetAttrValue",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetAttrValue. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (char *)OSRGetAttrValue(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetAngularUnits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    double  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osd:OSRSetAngularUnits",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetAngularUnits. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetAngularUnits(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetAngularUnits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRSpatialReferenceH  _arg0;
    char ** _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRGetAngularUnits",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetAngularUnits. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_char_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRGetAngularUnits. Expected _char_pp.");
        return NULL;
        }
    }
    _result = (double )OSRGetAngularUnits(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetLinearUnits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    double  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osd:OSRSetLinearUnits",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetLinearUnits. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetLinearUnits(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetLinearUnits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRSpatialReferenceH  _arg0;
    char ** _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRGetLinearUnits",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetLinearUnits. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_char_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRGetLinearUnits. Expected _char_pp.");
        return NULL;
        }
    }
    _result = (double )OSRGetLinearUnits(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRIsGeographic(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRIsGeographic",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRIsGeographic. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRIsGeographic(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRIsProjected(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OSRIsProjected",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRIsProjected. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRIsProjected(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRIsSameGeogCS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    OGRSpatialReferenceH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRIsSameGeogCS",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRIsSameGeogCS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRIsSameGeogCS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRIsSameGeogCS(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRIsSame(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    OGRSpatialReferenceH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRIsSame",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRIsSame. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRIsSame. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRIsSame(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetProjCS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OSRSetProjCS",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetProjCS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetProjCS(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetWellKnownGeogCS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OSRSetWellKnownGeogCS",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetWellKnownGeogCS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetWellKnownGeogCS(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetFromUserInput(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OSRSetFromUserInput",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetFromUserInput. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetFromUserInput(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRCopyGeogCSFrom(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    OGRSpatialReferenceH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRCopyGeogCSFrom",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRCopyGeogCSFrom. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRCopyGeogCSFrom. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRCopyGeogCSFrom(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetTOWGS84(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddddd:OSRSetTOWGS84",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetTOWGS84. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetTOWGS84(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetTOWGS84(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double * _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:OSRGetTOWGS84",&_argo0,&_argo1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetTOWGS84. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRGetTOWGS84. Expected _double_p.");
        return NULL;
        }
    }
    _result = (int )OSRGetTOWGS84(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetGeogCS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    char * _arg2;
    char * _arg3;
    double  _arg4;
    double  _arg5;
    char * _arg6;
    double  _arg7;
    char * _arg8;
    double  _arg9;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osssddsdsd:OSRSetGeogCS",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetGeogCS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetGeogCS(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetSemiMajor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRSpatialReferenceH  _arg0;
    int * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRGetSemiMajor",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetSemiMajor. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRGetSemiMajor. Expected _int_p.");
        return NULL;
        }
    }
    _result = (double )OSRGetSemiMajor(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetSemiMinor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRSpatialReferenceH  _arg0;
    int * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRGetSemiMinor",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetSemiMinor. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRGetSemiMinor. Expected _int_p.");
        return NULL;
        }
    }
    _result = (double )OSRGetSemiMinor(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetInvFlattening(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRSpatialReferenceH  _arg0;
    int * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRGetInvFlattening",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetInvFlattening. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRGetInvFlattening. Expected _int_p.");
        return NULL;
        }
    }
    _result = (double )OSRGetInvFlattening(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetAuthority(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    char * _arg2;
    int  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ossi:OSRSetAuthority",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetAuthority. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetAuthority(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetAuthorityCode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OSRGetAuthorityCode",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetAuthorityCode. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (char *)OSRGetAuthorityCode(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetAuthorityName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OSRGetAuthorityName",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetAuthorityName. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (char *)OSRGetAuthorityName(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetProjParm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    double  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osd:OSRSetProjParm",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetProjParm. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetProjParm(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetProjParm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    double  _arg2;
    int * _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OsdO:OSRGetProjParm",&_argo0,&_arg1,&_arg2,&_argo3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetProjParm. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo3) {
        if (_argo3 == Py_None) { _arg3 = NULL; }
        else if (SWIG_GetPtrObj(_argo3,(void **) &_arg3,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of OSRGetProjParm. Expected _int_p.");
        return NULL;
        }
    }
    _result = (double )OSRGetProjParm(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetNormProjParm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    double  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osd:OSRSetNormProjParm",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetNormProjParm. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetNormProjParm(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetNormProjParm(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRSpatialReferenceH  _arg0;
    char * _arg1;
    double  _arg2;
    int * _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OsdO:OSRGetNormProjParm",&_argo0,&_arg1,&_arg2,&_argo3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetNormProjParm. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo3) {
        if (_argo3 == Py_None) { _arg3 = NULL; }
        else if (SWIG_GetPtrObj(_argo3,(void **) &_arg3,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of OSRGetNormProjParm. Expected _int_p.");
        return NULL;
        }
    }
    _result = (double )OSRGetNormProjParm(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetUTM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:OSRSetUTM",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetUTM. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetUTM(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRGetUTMZone(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    int * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OSRGetUTMZone",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRGetUTMZone. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OSRGetUTMZone. Expected _int_p.");
        return NULL;
        }
    }
    _result = (int )OSRGetUTMZone(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetStatePlaneWithUnits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiisd:OSRSetStatePlaneWithUnits",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetStatePlaneWithUnits. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetStatePlaneWithUnits(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetACEA(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddddd:OSRSetACEA",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetACEA. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetACEA(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetAE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetAE",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetAE. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetAE(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetCEA(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetCEA",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetCEA. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetCEA(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetCS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetCS",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetCS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetCS(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetEC(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddddd:OSRSetEC",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetEC. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetEC(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetEckertIV(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OSRSetEckertIV",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetEckertIV. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetEckertIV(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetEckertVI(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OSRSetEckertVI",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetEckertVI. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetEckertVI(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetEquirectangular(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetEquirectangular",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetEquirectangular. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetEquirectangular(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetGS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OSRSetGS",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetGS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetGS(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetGnomonic(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetGnomonic",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetGnomonic. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetGnomonic(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetHOM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddddd:OSRSetHOM",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetHOM. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetHOM(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetHOM2PNO(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRErr * _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    double  _arg8;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Odddddddd:OSRSetHOM2PNO",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetHOM2PNO. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (OGRErr *) malloc(sizeof(OGRErr ));
    *(_result) = OSRSetHOM2PNO(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    SWIG_MakePtr(_ptemp, (void *) _result,"_OGRErr_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_OSRSetKrovak(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddddd:OSRSetKrovak",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetKrovak. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetKrovak(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetLAEA(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetLAEA",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetLAEA. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetLAEA(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetLCC(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddddd:OSRSetLCC",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetLCC. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetLCC(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetLCC1SP(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddd:OSRSetLCC1SP",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetLCC1SP. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetLCC1SP(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetLCCB(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddddd:OSRSetLCCB",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetLCCB. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetLCCB(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetMC(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetMC",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetMC. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetMC(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetMercator(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddd:OSRSetMercator",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetMercator. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetMercator(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetMollweide(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OSRSetMollweide",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetMollweide. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetMollweide(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetNZMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetNZMG",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetNZMG. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetNZMG(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetOS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddd:OSRSetOS",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetOS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetOS(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetOrthographic(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetOrthographic",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetOrthographic. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetOrthographic(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetPolyconic(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetPolyconic",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetPolyconic. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetPolyconic(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetPS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddd:OSRSetPS",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetPS. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetPS(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetRobinson(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OSRSetRobinson",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetRobinson. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetRobinson(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetSinusoidal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OSRSetSinusoidal",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetSinusoidal. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetSinusoidal(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetStereographic(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddd:OSRSetStereographic",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetStereographic. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetStereographic(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetSOC(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetSOC",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetSOC. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetSOC(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetTM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddd:OSRSetTM",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetTM. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetTM(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetTMG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:OSRSetTMG",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetTMG. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetTMG(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetTMSO(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddddd:OSRSetTMSO",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetTMSO. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetTMSO(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OSRSetVDG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSpatialReferenceH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OSRSetVDG",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OSRSetVDG. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OSRSetVDG(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OCTNewCoordinateTransformation(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRCoordinateTransformationH  _result;
    OGRSpatialReferenceH  _arg0;
    OGRSpatialReferenceH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OCTNewCoordinateTransformation",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OCTNewCoordinateTransformation. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OCTNewCoordinateTransformation. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (OGRCoordinateTransformationH )OCTNewCoordinateTransformation(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRCoordinateTransformationH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OCTDestroyCoordinateTransformation(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRCoordinateTransformationH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OCTDestroyCoordinateTransformation",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OCTDestroyCoordinateTransformation. Expected _OGRCoordinateTransformationH.");
        return NULL;
        }
    }
    OCTDestroyCoordinateTransformation(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_DestroyGeometry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_DestroyGeometry",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_DestroyGeometry. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    OGR_G_DestroyGeometry(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_CreateGeometry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _result;
    OGRwkbGeometryType  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:OGR_G_CreateGeometry",&_arg0)) 
        return NULL;
    _result = (OGRGeometryH )OGR_G_CreateGeometry(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRGeometryH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetDimension(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_GetDimension",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetDimension. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_GetDimension(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetCoordinateDimension(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_GetCoordinateDimension",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetCoordinateDimension. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_GetCoordinateDimension(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_Clone(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_Clone",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_Clone. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (OGRGeometryH )OGR_G_Clone(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRGeometryH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetEnvelope(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _arg0;
    OGREnvelope * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_GetEnvelope",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetEnvelope. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_GetEnvelope. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    OGR_G_GetEnvelope(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_WkbSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_WkbSize",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_WkbSize. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_WkbSize(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetGeometryType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRwkbGeometryType  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_GetGeometryType",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetGeometryType. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (OGRwkbGeometryType )OGR_G_GetGeometryType(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetGeometryName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_GetGeometryName",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetGeometryName. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (char *)OGR_G_GetGeometryName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_FlattenTo2D(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_FlattenTo2D",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_FlattenTo2D. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    OGR_G_FlattenTo2D(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_ExportToGML(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_ExportToGML",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_ExportToGML. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (char *)OGR_G_ExportToGML(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_CreateFromGML(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:OGR_G_CreateFromGML",&_arg0)) 
        return NULL;
    _result = (OGRGeometryH )OGR_G_CreateFromGML(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRGeometryH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_G_AssignSpatialReference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _arg0;
    OGRSpatialReferenceH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_AssignSpatialReference",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_AssignSpatialReference. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_AssignSpatialReference. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    OGR_G_AssignSpatialReference(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetSpatialReference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRSpatialReferenceH  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_GetSpatialReference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetSpatialReference. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (OGRSpatialReferenceH )OGR_G_GetSpatialReference(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRSpatialReferenceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_G_Transform(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    OGRCoordinateTransformationH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_Transform",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_Transform. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_Transform. Expected _OGRCoordinateTransformationH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_Transform(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_TransformTo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    OGRSpatialReferenceH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_TransformTo",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_TransformTo. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_TransformTo. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_TransformTo(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_Intersect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    OGRGeometryH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_Intersect",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_Intersect. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_Intersect. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_Intersect(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_Equal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    OGRGeometryH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_Equal",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_Equal. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_Equal. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_Equal(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_Empty(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_Empty",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_Empty. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    OGR_G_Empty(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetPointCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_GetPointCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetPointCount. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_GetPointCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRGeometryH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_G_GetX",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetX. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (double )OGR_G_GetX(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetY(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRGeometryH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_G_GetY",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetY. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (double )OGR_G_GetY(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetZ(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRGeometryH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_G_GetZ",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetZ. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (double )OGR_G_GetZ(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_SetPoint(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _arg0;
    int  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiddd:OGR_G_SetPoint",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_SetPoint. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    OGR_G_SetPoint(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_AddPoint(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:OGR_G_AddPoint",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_AddPoint. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    OGR_G_AddPoint(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetGeometryCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_G_GetGeometryCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetGeometryCount. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_GetGeometryCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_GetGeometryRef(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _result;
    OGRGeometryH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_G_GetGeometryRef",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_GetGeometryRef. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (OGRGeometryH )OGR_G_GetGeometryRef(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRGeometryH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_G_AddGeometry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    OGRGeometryH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_AddGeometry",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_AddGeometry. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_AddGeometry. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_AddGeometry(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_G_AddGeometryDirectly(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRGeometryH  _arg0;
    OGRGeometryH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_G_AddGeometryDirectly",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_G_AddGeometryDirectly. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_G_AddGeometryDirectly. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_G_AddGeometryDirectly(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_Create(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _result;
    char * _arg0;
    OGRFieldType  _arg1;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"si:OGR_Fld_Create",&_arg0,&_arg1)) 
        return NULL;
    _result = (OGRFieldDefnH )OGR_Fld_Create(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFieldDefnH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_Destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_Fld_Destroy",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_Destroy. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_Fld_Destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_SetName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_Fld_SetName",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_SetName. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_Fld_SetName(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_GetNameRef(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRFieldDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_Fld_GetNameRef",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_GetNameRef. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    _result = (char *)OGR_Fld_GetNameRef(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_GetType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldType  _result;
    OGRFieldDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_Fld_GetType",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_GetType. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    _result = (OGRFieldType )OGR_Fld_GetType(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_SetType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _arg0;
    OGRFieldType  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_Fld_SetType",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_SetType. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_Fld_SetType(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_GetJustify(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRJustification  _result;
    OGRFieldDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_Fld_GetJustify",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_GetJustify. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    _result = (OGRJustification )OGR_Fld_GetJustify(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_SetJustify(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _arg0;
    OGRJustification  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_Fld_SetJustify",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_SetJustify. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_Fld_SetJustify(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_GetWidth(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFieldDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_Fld_GetWidth",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_GetWidth. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_Fld_GetWidth(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_SetWidth(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_Fld_SetWidth",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_SetWidth. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_Fld_SetWidth(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_GetPrecision(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFieldDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_Fld_GetPrecision",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_GetPrecision. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_Fld_GetPrecision(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_SetPrecision(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_Fld_SetPrecision",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_SetPrecision. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_Fld_SetPrecision(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_Fld_Set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _arg0;
    char * _arg1;
    OGRFieldType  _arg2;
    int  _arg3;
    int  _arg4;
    OGRJustification  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osiiii:OGR_Fld_Set",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Fld_Set. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_Fld_Set(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_GetFieldTypeName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRFieldType  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:OGR_GetFieldTypeName",&_arg0)) 
        return NULL;
    _result = (char *)OGR_GetFieldTypeName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_Create(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureDefnH  _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:OGR_FD_Create",&_arg0)) 
        return NULL;
    _result = (OGRFeatureDefnH )OGR_FD_Create(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFeatureDefnH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_Destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_FD_Destroy",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_Destroy. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    OGR_FD_Destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_GetName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_FD_GetName",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_GetName. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (char *)OGR_FD_GetName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_GetFieldCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_FD_GetFieldCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_GetFieldCount. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_FD_GetFieldCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_GetFieldDefn(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _result;
    OGRFeatureDefnH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_FD_GetFieldDefn",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_GetFieldDefn. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (OGRFieldDefnH )OGR_FD_GetFieldDefn(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFieldDefnH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_GetFieldIndex(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureDefnH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_FD_GetFieldIndex",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_GetFieldIndex. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_FD_GetFieldIndex(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_AddFieldDefn(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureDefnH  _arg0;
    OGRFieldDefnH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_FD_AddFieldDefn",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_AddFieldDefn. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_FD_AddFieldDefn. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    OGR_FD_AddFieldDefn(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_GetGeomType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRwkbGeometryType  _result;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_FD_GetGeomType",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_GetGeomType. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (OGRwkbGeometryType )OGR_FD_GetGeomType(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_SetGeomType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureDefnH  _arg0;
    OGRwkbGeometryType  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_FD_SetGeomType",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_SetGeomType. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    OGR_FD_SetGeomType(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_Reference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_FD_Reference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_Reference. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_FD_Reference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_Dereference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_FD_Dereference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_Dereference. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_FD_Dereference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_FD_GetReferenceCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_FD_GetReferenceCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_FD_GetReferenceCount. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_FD_GetReferenceCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_Create(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _result;
    OGRFeatureDefnH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_Create",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_Create. Expected _OGRFeatureDefnH.");
        return NULL;
        }
    }
    _result = (OGRFeatureH )OGR_F_Create(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFeatureH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_Destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_Destroy",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_Destroy. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    OGR_F_Destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetDefnRef(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureDefnH  _result;
    OGRFeatureH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_GetDefnRef",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetDefnRef. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (OGRFeatureDefnH )OGR_F_GetDefnRef(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFeatureDefnH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetGeometryDirectly(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    OGRGeometryH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_F_SetGeometryDirectly",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetGeometryDirectly. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_F_SetGeometryDirectly. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_SetGeometryDirectly(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetGeometry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    OGRGeometryH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_F_SetGeometry",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetGeometry. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_F_SetGeometry. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_SetGeometry(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetGeometryRef(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _result;
    OGRFeatureH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_GetGeometryRef",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetGeometryRef. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (OGRGeometryH )OGR_F_GetGeometryRef(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRGeometryH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_Clone(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _result;
    OGRFeatureH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_Clone",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_Clone. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (OGRFeatureH )OGR_F_Clone(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFeatureH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_Equal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    OGRFeatureH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_F_Equal",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_Equal. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_F_Equal. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_Equal(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_GetFieldCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldCount. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_GetFieldCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldDefnRef(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFieldDefnH  _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_F_GetFieldDefnRef",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldDefnRef. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (OGRFieldDefnH )OGR_F_GetFieldDefnRef(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFieldDefnH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldIndex(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_F_GetFieldIndex",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldIndex. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_GetFieldIndex(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_IsFieldSet(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_F_IsFieldSet",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_IsFieldSet. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_IsFieldSet(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_UnsetField(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_F_UnsetField",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_UnsetField. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    OGR_F_UnsetField(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldAsInteger(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_F_GetFieldAsInteger",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldAsInteger. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_GetFieldAsInteger(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldAsDouble(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_F_GetFieldAsDouble",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldAsDouble. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (double )OGR_F_GetFieldAsDouble(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldAsString(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_F_GetFieldAsString",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldAsString. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (char *)OGR_F_GetFieldAsString(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldAsIntegerList(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int * _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    int * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:OGR_F_GetFieldAsIntegerList",&_argo0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldAsIntegerList. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGR_F_GetFieldAsIntegerList. Expected _int_p.");
        return NULL;
        }
    }
    _result = (int *)OGR_F_GetFieldAsIntegerList(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_int_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldAsDoubleList(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double * _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    int * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:OGR_F_GetFieldAsDoubleList",&_argo0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldAsDoubleList. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGR_F_GetFieldAsDoubleList. Expected _int_p.");
        return NULL;
        }
    }
    _result = (double *)OGR_F_GetFieldAsDoubleList(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_double_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFieldAsStringList(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char ** _result;
    OGRFeatureH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_F_GetFieldAsStringList",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFieldAsStringList. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (char **)OGR_F_GetFieldAsStringList(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_char_pp");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFieldInteger(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:OGR_F_SetFieldInteger",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFieldInteger. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    OGR_F_SetFieldInteger(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFieldDouble(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    int  _arg1;
    double  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oid:OGR_F_SetFieldDouble",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFieldDouble. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    OGR_F_SetFieldDouble(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFieldString(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    int  _arg1;
    char * _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ois:OGR_F_SetFieldString",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFieldString. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    OGR_F_SetFieldString(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFieldIntegerList(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    int  _arg1;
    int  _arg2;
    int * _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiiO:OGR_F_SetFieldIntegerList",&_argo0,&_arg1,&_arg2,&_argo3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFieldIntegerList. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo3) {
        if (_argo3 == Py_None) { _arg3 = NULL; }
        else if (SWIG_GetPtrObj(_argo3,(void **) &_arg3,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of OGR_F_SetFieldIntegerList. Expected _int_p.");
        return NULL;
        }
    }
    OGR_F_SetFieldIntegerList(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFieldDoubleList(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    int  _arg1;
    int  _arg2;
    double * _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiiO:OGR_F_SetFieldDoubleList",&_argo0,&_arg1,&_arg2,&_argo3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFieldDoubleList. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo3) {
        if (_argo3 == Py_None) { _arg3 = NULL; }
        else if (SWIG_GetPtrObj(_argo3,(void **) &_arg3,"_double_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of OGR_F_SetFieldDoubleList. Expected _double_p.");
        return NULL;
        }
    }
    OGR_F_SetFieldDoubleList(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFieldStringList(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    int  _arg1;
    char ** _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:OGR_F_SetFieldStringList",&_argo0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFieldStringList. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_char_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGR_F_SetFieldStringList. Expected _char_pp.");
        return NULL;
        }
    }
    OGR_F_SetFieldStringList(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetFID(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    long  _result;
    OGRFeatureH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_GetFID",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetFID. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (long )OGR_F_GetFID(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFID(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    long  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:OGR_F_SetFID",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFID. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_SetFID(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_DumpReadable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    FILE * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_F_DumpReadable",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_DumpReadable. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_FILE_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_F_DumpReadable. Expected _FILE_p.");
        return NULL;
        }
    }
    OGR_F_DumpReadable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetFrom(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRFeatureH  _arg0;
    OGRFeatureH  _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:OGR_F_SetFrom",&_argo0,&_argo1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetFrom. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_F_SetFrom. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_F_SetFrom(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_GetStyleString(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRFeatureH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_F_GetStyleString",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_GetStyleString. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (char *)OGR_F_GetStyleString(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_F_SetStyleString(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_F_SetStyleString",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_F_SetStyleString. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    OGR_F_SetStyleString(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetSpatialFilter(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRGeometryH  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_GetSpatialFilter",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetSpatialFilter. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (OGRGeometryH )OGR_L_GetSpatialFilter(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRGeometryH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_L_SetSpatialFilter(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRLayerH  _arg0;
    OGRGeometryH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_L_SetSpatialFilter",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_SetSpatialFilter. Expected _OGRLayerH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_L_SetSpatialFilter. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    OGR_L_SetSpatialFilter(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_L_SetAttributeFilter(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    NULLableString  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_L_SetAttributeFilter",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_SetAttributeFilter. Expected _OGRLayerH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_L_SetAttributeFilter. Expected _NULLableString.");
        return NULL;
        }
    }
    _result = (int )OGR_L_SetAttributeFilter(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_ResetReading(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_ResetReading",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_ResetReading. Expected _OGRLayerH.");
        return NULL;
        }
    }
    OGR_L_ResetReading(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetNextFeature(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_GetNextFeature",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetNextFeature. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (OGRFeatureH )OGR_L_GetNextFeature(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFeatureH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetFeature(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureH  _result;
    OGRLayerH  _arg0;
    long  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:OGR_L_GetFeature",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetFeature. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (OGRFeatureH )OGR_L_GetFeature(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFeatureH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_L_SetFeature(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    OGRFeatureH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_L_SetFeature",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_SetFeature. Expected _OGRLayerH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_L_SetFeature. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_SetFeature(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_CreateFeature(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    OGRFeatureH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_L_CreateFeature",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_CreateFeature. Expected _OGRLayerH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_L_CreateFeature. Expected _OGRFeatureH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_CreateFeature(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_DeleteFeature(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    long  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:OGR_L_DeleteFeature",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_DeleteFeature. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_DeleteFeature(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetLayerDefn(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRFeatureDefnH  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_GetLayerDefn",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetLayerDefn. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (OGRFeatureDefnH )OGR_L_GetLayerDefn(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRFeatureDefnH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetSpatialRef(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRSpatialReferenceH  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_GetSpatialRef",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetSpatialRef. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (OGRSpatialReferenceH )OGR_L_GetSpatialRef(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRSpatialReferenceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetFeatureCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_L_GetFeatureCount",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetFeatureCount. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_GetFeatureCount(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetExtent(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    OGREnvelope * _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:OGR_L_GetExtent",&_argo0,&_argo1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetExtent. Expected _OGRLayerH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_L_GetExtent. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (int )OGR_L_GetExtent(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_TestCapability(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_L_TestCapability",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_TestCapability. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_TestCapability(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_CreateField(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    OGRFieldDefnH  _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:OGR_L_CreateField",&_argo0,&_argo1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_CreateField. Expected _OGRLayerH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_L_CreateField. Expected _OGRFieldDefnH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_CreateField(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_StartTransaction(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_StartTransaction",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_StartTransaction. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_StartTransaction(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_CommitTransaction(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_CommitTransaction",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_CommitTransaction. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_CommitTransaction(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_RollbackTransaction(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_RollbackTransaction",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_RollbackTransaction. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_RollbackTransaction(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_Reference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_Reference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_Reference. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_Reference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_Dereference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_Dereference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_Dereference. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_Dereference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_GetRefCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_GetRefCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_GetRefCount. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_GetRefCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_L_SyncToDisk(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRLayerH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_L_SyncToDisk",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_L_SyncToDisk. Expected _OGRLayerH.");
        return NULL;
        }
    }
    _result = (int )OGR_L_SyncToDisk(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_Destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_DS_Destroy",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_Destroy. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    OGR_DS_Destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_GetName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_DS_GetName",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_GetName. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (char *)OGR_DS_GetName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_GetLayerCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_DS_GetLayerCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_GetLayerCount. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGR_DS_GetLayerCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_GetLayer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRLayerH  _result;
    OGRDataSourceH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_DS_GetLayer",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_GetLayer. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (OGRLayerH )OGR_DS_GetLayer(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRLayerH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_GetLayerByName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRLayerH  _result;
    OGRDataSourceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_DS_GetLayerByName",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_GetLayerByName. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (OGRLayerH )OGR_DS_GetLayerByName(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRLayerH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_DeleteLayer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:OGR_DS_DeleteLayer",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_DeleteLayer. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGR_DS_DeleteLayer(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_TestCapability(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_DS_TestCapability",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_TestCapability. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGR_DS_TestCapability(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_ExecuteSQL(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRLayerH  _result;
    OGRDataSourceH  _arg0;
    char * _arg1;
    OGRGeometryH  _arg2;
    char * _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OsOs:OGR_DS_ExecuteSQL",&_argo0,&_arg1,&_argo2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_ExecuteSQL. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGR_DS_ExecuteSQL. Expected _OGRGeometryH.");
        return NULL;
        }
    }
    _result = (OGRLayerH )OGR_DS_ExecuteSQL(_arg0,_arg1,_arg2,_arg3);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRLayerH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_ReleaseResultSet(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _arg0;
    OGRLayerH  _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OGR_DS_ReleaseResultSet",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_ReleaseResultSet. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_DS_ReleaseResultSet. Expected _OGRLayerH.");
        return NULL;
        }
    }
    OGR_DS_ReleaseResultSet(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_Reference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_DS_Reference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_Reference. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGR_DS_Reference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_Dereference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_DS_Dereference",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_Dereference. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGR_DS_Dereference(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_GetRefCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_DS_GetRefCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_GetRefCount. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGR_DS_GetRefCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_GetSummaryRefCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_DS_GetSummaryRefCount",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_GetSummaryRefCount. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGR_DS_GetSummaryRefCount(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_CopyLayer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRLayerH  _result;
    OGRDataSourceH  _arg0;
    OGRLayerH  _arg1;
    char * _arg2;
    stringList  _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;
    PyObject * _argo3 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OOsO:OGR_DS_CopyLayer",&_argo0,&_argo1,&_arg2,&_argo3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_CopyLayer. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_DS_CopyLayer. Expected _OGRLayerH.");
        return NULL;
        }
    }
    if (_argo3) {
        if (_argo3 == Py_None) { _arg3 = NULL; }
        else if (SWIG_GetPtrObj(_argo3,(void **) &_arg3,"_stringList")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of OGR_DS_CopyLayer. Expected _stringList.");
        return NULL;
        }
    }
    _result = (OGRLayerH )OGR_DS_CopyLayer(_arg0,_arg1,_arg2,_arg3);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRLayerH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_DS_CreateLayer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRLayerH  _result;
    OGRDataSourceH  _arg0;
    char * _arg1;
    OGRSpatialReferenceH  _arg2;
    OGRwkbGeometryType  _arg3;
    stringList  _arg4;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;
    PyObject * _argo4 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OsOiO:OGR_DS_CreateLayer",&_argo0,&_arg1,&_argo2,&_arg3,&_argo4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_DS_CreateLayer. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGR_DS_CreateLayer. Expected _OGRSpatialReferenceH.");
        return NULL;
        }
    }
    if (_argo4) {
        if (_argo4 == Py_None) { _arg4 = NULL; }
        else if (SWIG_GetPtrObj(_argo4,(void **) &_arg4,"_stringList")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 5 of OGR_DS_CreateLayer. Expected _stringList.");
        return NULL;
        }
    }
    _result = (OGRLayerH )OGR_DS_CreateLayer(_arg0,_arg1,_arg2,_arg3,_arg4);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRLayerH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_Dr_GetName(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    OGRSFDriverH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGR_Dr_GetName",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Dr_GetName. Expected _OGRSFDriverH.");
        return NULL;
        }
    }
    _result = (char *)OGR_Dr_GetName(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Dr_Open(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _result;
    OGRSFDriverH  _arg0;
    char * _arg1;
    int  _arg2;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Osi:OGR_Dr_Open",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Dr_Open. Expected _OGRSFDriverH.");
        return NULL;
        }
    }
    _result = (OGRDataSourceH )OGR_Dr_Open(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRDataSourceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_Dr_TestCapability(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSFDriverH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_Dr_TestCapability",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Dr_TestCapability. Expected _OGRSFDriverH.");
        return NULL;
        }
    }
    _result = (int )OGR_Dr_TestCapability(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGR_Dr_CreateDataSource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _result;
    OGRSFDriverH  _arg0;
    char * _arg1;
    stringList  _arg2;
    PyObject * _argo0 = 0;
    PyObject * _argo2 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OsO:OGR_Dr_CreateDataSource",&_argo0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Dr_CreateDataSource. Expected _OGRSFDriverH.");
        return NULL;
        }
    }
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,"_stringList")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGR_Dr_CreateDataSource. Expected _stringList.");
        return NULL;
        }
    }
    _result = (OGRDataSourceH )OGR_Dr_CreateDataSource(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRDataSourceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_Dr_CopyDataSource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _result;
    OGRSFDriverH  _arg0;
    OGRDataSourceH  _arg1;
    char * _arg2;
    stringList  _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;
    PyObject * _argo3 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OOsO:OGR_Dr_CopyDataSource",&_argo0,&_argo1,&_arg2,&_argo3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Dr_CopyDataSource. Expected _OGRSFDriverH.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of OGR_Dr_CopyDataSource. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    if (_argo3) {
        if (_argo3 == Py_None) { _arg3 = NULL; }
        else if (SWIG_GetPtrObj(_argo3,(void **) &_arg3,"_stringList")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of OGR_Dr_CopyDataSource. Expected _stringList.");
        return NULL;
        }
    }
    _result = (OGRDataSourceH )OGR_Dr_CopyDataSource(_arg0,_arg1,_arg2,_arg3);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRDataSourceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGR_Dr_DeleteDataSource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRSFDriverH  _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:OGR_Dr_DeleteDataSource",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGR_Dr_DeleteDataSource. Expected _OGRSFDriverH.");
        return NULL;
        }
    }
    _result = (int )OGR_Dr_DeleteDataSource(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGROpen(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _result;
    char * _arg0;
    int  _arg1;
    void * _arg2;
    PyObject * _argo2 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"siO:OGROpen",&_arg0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGROpen. Expected _void_p.");
        return NULL;
        }
    }
    _result = (OGRDataSourceH )OGROpen(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRDataSourceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGRRegisterDriver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRSFDriverH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGRRegisterDriver",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGRRegisterDriver. Expected _OGRSFDriverH.");
        return NULL;
        }
    }
    OGRRegisterDriver(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGRGetDriverCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":OGRGetDriverCount")) 
        return NULL;
    _result = (int )OGRGetDriverCount();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGRGetDriver(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRSFDriverH  _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:OGRGetDriver",&_arg0)) 
        return NULL;
    _result = (OGRSFDriverH )OGRGetDriver(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRSFDriverH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGROpenShared(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _result;
    char * _arg0;
    int  _arg1;
    OGRSFDriverH * _arg2;
    PyObject * _argo2 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"siO:OGROpenShared",&_arg0,&_arg1,&_argo2)) 
        return NULL;
    if (_argo2) {
        if (_argo2 == Py_None) { _arg2 = NULL; }
        else if (SWIG_GetPtrObj(_argo2,(void **) &_arg2,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of OGROpenShared. Expected _OGRSFDriverH_p.");
        return NULL;
        }
    }
    _result = (OGRDataSourceH )OGROpenShared(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRDataSourceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGRReleaseDataSource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    OGRDataSourceH  _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGRReleaseDataSource",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGRReleaseDataSource. Expected _OGRDataSourceH.");
        return NULL;
        }
    }
    _result = (int )OGRReleaseDataSource(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGRGetOpenDSCount(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":OGRGetOpenDSCount")) 
        return NULL;
    _result = (int )OGRGetOpenDSCount();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_OGRGetOpenDS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    OGRDataSourceH  _result;
    int  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"i:OGRGetOpenDS",&_arg0)) 
        return NULL;
    _result = (OGRDataSourceH )OGRGetOpenDS(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_OGRDataSourceH");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_OGRRegisterAll(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":OGRRegisterAll")) 
        return NULL;
    OGRRegisterAll();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_OGRSetGenerate_DB2_V72_BYTE_ORDER(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:OGRSetGenerate_DB2_V72_BYTE_ORDER",&_arg0)) 
        return NULL;
    _result = (int )OGRSetGenerate_DB2_V72_BYTE_ORDER(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define OGREnvelope_MinX_set(_swigobj,_swigval) (_swigobj->MinX = _swigval,_swigval)
static PyObject *_wrap_OGREnvelope_MinX_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    double  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:OGREnvelope_MinX_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MinX_set. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MinX_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define OGREnvelope_MinX_get(_swigobj) ((double ) _swigobj->MinX)
static PyObject *_wrap_OGREnvelope_MinX_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGREnvelope_MinX_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MinX_get. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MinX_get(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define OGREnvelope_MaxX_set(_swigobj,_swigval) (_swigobj->MaxX = _swigval,_swigval)
static PyObject *_wrap_OGREnvelope_MaxX_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    double  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:OGREnvelope_MaxX_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MaxX_set. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MaxX_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define OGREnvelope_MaxX_get(_swigobj) ((double ) _swigobj->MaxX)
static PyObject *_wrap_OGREnvelope_MaxX_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGREnvelope_MaxX_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MaxX_get. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MaxX_get(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define OGREnvelope_MinY_set(_swigobj,_swigval) (_swigobj->MinY = _swigval,_swigval)
static PyObject *_wrap_OGREnvelope_MinY_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    double  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:OGREnvelope_MinY_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MinY_set. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MinY_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define OGREnvelope_MinY_get(_swigobj) ((double ) _swigobj->MinY)
static PyObject *_wrap_OGREnvelope_MinY_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGREnvelope_MinY_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MinY_get. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MinY_get(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define OGREnvelope_MaxY_set(_swigobj,_swigval) (_swigobj->MaxY = _swigval,_swigval)
static PyObject *_wrap_OGREnvelope_MaxY_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    double  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:OGREnvelope_MaxY_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MaxY_set. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MaxY_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

#define OGREnvelope_MaxY_get(_swigobj) ((double ) _swigobj->MaxY)
static PyObject *_wrap_OGREnvelope_MaxY_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    OGREnvelope * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:OGREnvelope_MaxY_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_OGREnvelope_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of OGREnvelope_MaxY_get. Expected _OGREnvelope_p.");
        return NULL;
        }
    }
    _result = (double )OGREnvelope_MaxY_get(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyMethodDef _gdalMethods[] = {
	 { "OGREnvelope_MaxY_get", _wrap_OGREnvelope_MaxY_get, METH_VARARGS },
	 { "OGREnvelope_MaxY_set", _wrap_OGREnvelope_MaxY_set, METH_VARARGS },
	 { "OGREnvelope_MinY_get", _wrap_OGREnvelope_MinY_get, METH_VARARGS },
	 { "OGREnvelope_MinY_set", _wrap_OGREnvelope_MinY_set, METH_VARARGS },
	 { "OGREnvelope_MaxX_get", _wrap_OGREnvelope_MaxX_get, METH_VARARGS },
	 { "OGREnvelope_MaxX_set", _wrap_OGREnvelope_MaxX_set, METH_VARARGS },
	 { "OGREnvelope_MinX_get", _wrap_OGREnvelope_MinX_get, METH_VARARGS },
	 { "OGREnvelope_MinX_set", _wrap_OGREnvelope_MinX_set, METH_VARARGS },
	 { "OGRSetGenerate_DB2_V72_BYTE_ORDER", _wrap_OGRSetGenerate_DB2_V72_BYTE_ORDER, METH_VARARGS },
	 { "OGRBuildPolygonFromEdges", py_OGRBuildPolygonFromEdges, METH_VARARGS },
	 { "OGRRegisterAll", _wrap_OGRRegisterAll, METH_VARARGS },
	 { "OGRGetOpenDS", _wrap_OGRGetOpenDS, METH_VARARGS },
	 { "OGRGetOpenDSCount", _wrap_OGRGetOpenDSCount, METH_VARARGS },
	 { "OGRReleaseDataSource", _wrap_OGRReleaseDataSource, METH_VARARGS },
	 { "OGROpenShared", _wrap_OGROpenShared, METH_VARARGS },
	 { "OGRGetDriver", _wrap_OGRGetDriver, METH_VARARGS },
	 { "OGRGetDriverCount", _wrap_OGRGetDriverCount, METH_VARARGS },
	 { "OGRRegisterDriver", _wrap_OGRRegisterDriver, METH_VARARGS },
	 { "OGROpen", _wrap_OGROpen, METH_VARARGS },
	 { "OGR_Dr_DeleteDataSource", _wrap_OGR_Dr_DeleteDataSource, METH_VARARGS },
	 { "OGR_Dr_CopyDataSource", _wrap_OGR_Dr_CopyDataSource, METH_VARARGS },
	 { "OGR_Dr_CreateDataSource", _wrap_OGR_Dr_CreateDataSource, METH_VARARGS },
	 { "OGR_Dr_TestCapability", _wrap_OGR_Dr_TestCapability, METH_VARARGS },
	 { "OGR_Dr_Open", _wrap_OGR_Dr_Open, METH_VARARGS },
	 { "OGR_Dr_GetName", _wrap_OGR_Dr_GetName, METH_VARARGS },
	 { "OGR_DS_CreateLayer", _wrap_OGR_DS_CreateLayer, METH_VARARGS },
	 { "OGR_DS_CopyLayer", _wrap_OGR_DS_CopyLayer, METH_VARARGS },
	 { "OGR_DS_GetSummaryRefCount", _wrap_OGR_DS_GetSummaryRefCount, METH_VARARGS },
	 { "OGR_DS_GetRefCount", _wrap_OGR_DS_GetRefCount, METH_VARARGS },
	 { "OGR_DS_Dereference", _wrap_OGR_DS_Dereference, METH_VARARGS },
	 { "OGR_DS_Reference", _wrap_OGR_DS_Reference, METH_VARARGS },
	 { "OGR_DS_ReleaseResultSet", _wrap_OGR_DS_ReleaseResultSet, METH_VARARGS },
	 { "OGR_DS_ExecuteSQL", _wrap_OGR_DS_ExecuteSQL, METH_VARARGS },
	 { "OGR_DS_TestCapability", _wrap_OGR_DS_TestCapability, METH_VARARGS },
	 { "OGR_DS_DeleteLayer", _wrap_OGR_DS_DeleteLayer, METH_VARARGS },
	 { "OGR_DS_GetLayerByName", _wrap_OGR_DS_GetLayerByName, METH_VARARGS },
	 { "OGR_DS_GetLayer", _wrap_OGR_DS_GetLayer, METH_VARARGS },
	 { "OGR_DS_GetLayerCount", _wrap_OGR_DS_GetLayerCount, METH_VARARGS },
	 { "OGR_DS_GetName", _wrap_OGR_DS_GetName, METH_VARARGS },
	 { "OGR_DS_Destroy", _wrap_OGR_DS_Destroy, METH_VARARGS },
	 { "OGR_L_SyncToDisk", _wrap_OGR_L_SyncToDisk, METH_VARARGS },
	 { "OGR_L_GetRefCount", _wrap_OGR_L_GetRefCount, METH_VARARGS },
	 { "OGR_L_Dereference", _wrap_OGR_L_Dereference, METH_VARARGS },
	 { "OGR_L_Reference", _wrap_OGR_L_Reference, METH_VARARGS },
	 { "OGR_L_RollbackTransaction", _wrap_OGR_L_RollbackTransaction, METH_VARARGS },
	 { "OGR_L_CommitTransaction", _wrap_OGR_L_CommitTransaction, METH_VARARGS },
	 { "OGR_L_StartTransaction", _wrap_OGR_L_StartTransaction, METH_VARARGS },
	 { "OGR_L_CreateField", _wrap_OGR_L_CreateField, METH_VARARGS },
	 { "OGR_L_TestCapability", _wrap_OGR_L_TestCapability, METH_VARARGS },
	 { "OGR_L_GetExtent", _wrap_OGR_L_GetExtent, METH_VARARGS },
	 { "OGR_L_GetFeatureCount", _wrap_OGR_L_GetFeatureCount, METH_VARARGS },
	 { "OGR_L_GetSpatialRef", _wrap_OGR_L_GetSpatialRef, METH_VARARGS },
	 { "OGR_L_GetLayerDefn", _wrap_OGR_L_GetLayerDefn, METH_VARARGS },
	 { "OGR_L_DeleteFeature", _wrap_OGR_L_DeleteFeature, METH_VARARGS },
	 { "OGR_L_CreateFeature", _wrap_OGR_L_CreateFeature, METH_VARARGS },
	 { "OGR_L_SetFeature", _wrap_OGR_L_SetFeature, METH_VARARGS },
	 { "OGR_L_GetFeature", _wrap_OGR_L_GetFeature, METH_VARARGS },
	 { "OGR_L_GetNextFeature", _wrap_OGR_L_GetNextFeature, METH_VARARGS },
	 { "OGR_L_ResetReading", _wrap_OGR_L_ResetReading, METH_VARARGS },
	 { "OGR_L_SetAttributeFilter", _wrap_OGR_L_SetAttributeFilter, METH_VARARGS },
	 { "OGR_L_SetSpatialFilter", _wrap_OGR_L_SetSpatialFilter, METH_VARARGS },
	 { "OGR_L_GetSpatialFilter", _wrap_OGR_L_GetSpatialFilter, METH_VARARGS },
	 { "OGR_F_SetStyleString", _wrap_OGR_F_SetStyleString, METH_VARARGS },
	 { "OGR_F_GetStyleString", _wrap_OGR_F_GetStyleString, METH_VARARGS },
	 { "OGR_F_SetFrom", _wrap_OGR_F_SetFrom, METH_VARARGS },
	 { "OGR_F_DumpReadable", _wrap_OGR_F_DumpReadable, METH_VARARGS },
	 { "OGR_F_SetFID", _wrap_OGR_F_SetFID, METH_VARARGS },
	 { "OGR_F_GetFID", _wrap_OGR_F_GetFID, METH_VARARGS },
	 { "OGR_F_GetField", py_OGR_F_GetField, METH_VARARGS },
	 { "OGR_F_SetFieldStringList", _wrap_OGR_F_SetFieldStringList, METH_VARARGS },
	 { "OGR_F_SetFieldDoubleList", _wrap_OGR_F_SetFieldDoubleList, METH_VARARGS },
	 { "OGR_F_SetFieldIntegerList", _wrap_OGR_F_SetFieldIntegerList, METH_VARARGS },
	 { "OGR_F_SetFieldString", _wrap_OGR_F_SetFieldString, METH_VARARGS },
	 { "OGR_F_SetFieldDouble", _wrap_OGR_F_SetFieldDouble, METH_VARARGS },
	 { "OGR_F_SetFieldInteger", _wrap_OGR_F_SetFieldInteger, METH_VARARGS },
	 { "OGR_F_GetFieldAsStringList", _wrap_OGR_F_GetFieldAsStringList, METH_VARARGS },
	 { "OGR_F_GetFieldAsDoubleList", _wrap_OGR_F_GetFieldAsDoubleList, METH_VARARGS },
	 { "OGR_F_GetFieldAsIntegerList", _wrap_OGR_F_GetFieldAsIntegerList, METH_VARARGS },
	 { "OGR_F_GetFieldAsString", _wrap_OGR_F_GetFieldAsString, METH_VARARGS },
	 { "OGR_F_GetFieldAsDouble", _wrap_OGR_F_GetFieldAsDouble, METH_VARARGS },
	 { "OGR_F_GetFieldAsInteger", _wrap_OGR_F_GetFieldAsInteger, METH_VARARGS },
	 { "OGR_F_UnsetField", _wrap_OGR_F_UnsetField, METH_VARARGS },
	 { "OGR_F_IsFieldSet", _wrap_OGR_F_IsFieldSet, METH_VARARGS },
	 { "OGR_F_GetFieldIndex", _wrap_OGR_F_GetFieldIndex, METH_VARARGS },
	 { "OGR_F_GetFieldDefnRef", _wrap_OGR_F_GetFieldDefnRef, METH_VARARGS },
	 { "OGR_F_GetFieldCount", _wrap_OGR_F_GetFieldCount, METH_VARARGS },
	 { "OGR_F_Equal", _wrap_OGR_F_Equal, METH_VARARGS },
	 { "OGR_F_Clone", _wrap_OGR_F_Clone, METH_VARARGS },
	 { "OGR_F_GetGeometryRef", _wrap_OGR_F_GetGeometryRef, METH_VARARGS },
	 { "OGR_F_SetGeometry", _wrap_OGR_F_SetGeometry, METH_VARARGS },
	 { "OGR_F_SetGeometryDirectly", _wrap_OGR_F_SetGeometryDirectly, METH_VARARGS },
	 { "OGR_F_GetDefnRef", _wrap_OGR_F_GetDefnRef, METH_VARARGS },
	 { "OGR_F_Destroy", _wrap_OGR_F_Destroy, METH_VARARGS },
	 { "OGR_F_Create", _wrap_OGR_F_Create, METH_VARARGS },
	 { "OGR_FD_GetReferenceCount", _wrap_OGR_FD_GetReferenceCount, METH_VARARGS },
	 { "OGR_FD_Dereference", _wrap_OGR_FD_Dereference, METH_VARARGS },
	 { "OGR_FD_Reference", _wrap_OGR_FD_Reference, METH_VARARGS },
	 { "OGR_FD_SetGeomType", _wrap_OGR_FD_SetGeomType, METH_VARARGS },
	 { "OGR_FD_GetGeomType", _wrap_OGR_FD_GetGeomType, METH_VARARGS },
	 { "OGR_FD_AddFieldDefn", _wrap_OGR_FD_AddFieldDefn, METH_VARARGS },
	 { "OGR_FD_GetFieldIndex", _wrap_OGR_FD_GetFieldIndex, METH_VARARGS },
	 { "OGR_FD_GetFieldDefn", _wrap_OGR_FD_GetFieldDefn, METH_VARARGS },
	 { "OGR_FD_GetFieldCount", _wrap_OGR_FD_GetFieldCount, METH_VARARGS },
	 { "OGR_FD_GetName", _wrap_OGR_FD_GetName, METH_VARARGS },
	 { "OGR_FD_Destroy", _wrap_OGR_FD_Destroy, METH_VARARGS },
	 { "OGR_FD_Create", _wrap_OGR_FD_Create, METH_VARARGS },
	 { "OGR_GetFieldTypeName", _wrap_OGR_GetFieldTypeName, METH_VARARGS },
	 { "OGR_Fld_Set", _wrap_OGR_Fld_Set, METH_VARARGS },
	 { "OGR_Fld_SetPrecision", _wrap_OGR_Fld_SetPrecision, METH_VARARGS },
	 { "OGR_Fld_GetPrecision", _wrap_OGR_Fld_GetPrecision, METH_VARARGS },
	 { "OGR_Fld_SetWidth", _wrap_OGR_Fld_SetWidth, METH_VARARGS },
	 { "OGR_Fld_GetWidth", _wrap_OGR_Fld_GetWidth, METH_VARARGS },
	 { "OGR_Fld_SetJustify", _wrap_OGR_Fld_SetJustify, METH_VARARGS },
	 { "OGR_Fld_GetJustify", _wrap_OGR_Fld_GetJustify, METH_VARARGS },
	 { "OGR_Fld_SetType", _wrap_OGR_Fld_SetType, METH_VARARGS },
	 { "OGR_Fld_GetType", _wrap_OGR_Fld_GetType, METH_VARARGS },
	 { "OGR_Fld_GetNameRef", _wrap_OGR_Fld_GetNameRef, METH_VARARGS },
	 { "OGR_Fld_SetName", _wrap_OGR_Fld_SetName, METH_VARARGS },
	 { "OGR_Fld_Destroy", _wrap_OGR_Fld_Destroy, METH_VARARGS },
	 { "OGR_Fld_Create", _wrap_OGR_Fld_Create, METH_VARARGS },
	 { "OGR_G_ExportToWkt", py_OGR_G_ExportToWkt, METH_VARARGS },
	 { "OGR_G_ExportToWkb", py_OGR_G_ExportToWkb, METH_VARARGS },
	 { "OGR_G_CreateFromWkt", py_OGR_G_CreateFromWkt, METH_VARARGS },
	 { "OGR_G_CreateFromWkb", py_OGR_G_CreateFromWkb, METH_VARARGS },
	 { "OGR_G_AddGeometryDirectly", _wrap_OGR_G_AddGeometryDirectly, METH_VARARGS },
	 { "OGR_G_AddGeometry", _wrap_OGR_G_AddGeometry, METH_VARARGS },
	 { "OGR_G_GetGeometryRef", _wrap_OGR_G_GetGeometryRef, METH_VARARGS },
	 { "OGR_G_GetGeometryCount", _wrap_OGR_G_GetGeometryCount, METH_VARARGS },
	 { "OGR_G_AddPoint", _wrap_OGR_G_AddPoint, METH_VARARGS },
	 { "OGR_G_SetPoint", _wrap_OGR_G_SetPoint, METH_VARARGS },
	 { "OGR_G_GetZ", _wrap_OGR_G_GetZ, METH_VARARGS },
	 { "OGR_G_GetY", _wrap_OGR_G_GetY, METH_VARARGS },
	 { "OGR_G_GetX", _wrap_OGR_G_GetX, METH_VARARGS },
	 { "OGR_G_GetPointCount", _wrap_OGR_G_GetPointCount, METH_VARARGS },
	 { "OGR_G_Empty", _wrap_OGR_G_Empty, METH_VARARGS },
	 { "OGR_G_Equal", _wrap_OGR_G_Equal, METH_VARARGS },
	 { "OGR_G_Intersect", _wrap_OGR_G_Intersect, METH_VARARGS },
	 { "OGR_G_TransformTo", _wrap_OGR_G_TransformTo, METH_VARARGS },
	 { "OGR_G_Transform", _wrap_OGR_G_Transform, METH_VARARGS },
	 { "OGR_G_GetSpatialReference", _wrap_OGR_G_GetSpatialReference, METH_VARARGS },
	 { "OGR_G_AssignSpatialReference", _wrap_OGR_G_AssignSpatialReference, METH_VARARGS },
	 { "OGR_G_CreateFromGML", _wrap_OGR_G_CreateFromGML, METH_VARARGS },
	 { "OGR_G_ExportToGML", _wrap_OGR_G_ExportToGML, METH_VARARGS },
	 { "OGR_G_FlattenTo2D", _wrap_OGR_G_FlattenTo2D, METH_VARARGS },
	 { "OGR_G_GetGeometryName", _wrap_OGR_G_GetGeometryName, METH_VARARGS },
	 { "OGR_G_GetGeometryType", _wrap_OGR_G_GetGeometryType, METH_VARARGS },
	 { "OGR_G_WkbSize", _wrap_OGR_G_WkbSize, METH_VARARGS },
	 { "OGR_G_GetEnvelope", _wrap_OGR_G_GetEnvelope, METH_VARARGS },
	 { "OGR_G_Clone", _wrap_OGR_G_Clone, METH_VARARGS },
	 { "OGR_G_GetCoordinateDimension", _wrap_OGR_G_GetCoordinateDimension, METH_VARARGS },
	 { "OGR_G_GetDimension", _wrap_OGR_G_GetDimension, METH_VARARGS },
	 { "OGR_G_CreateGeometry", _wrap_OGR_G_CreateGeometry, METH_VARARGS },
	 { "OGR_G_DestroyGeometry", _wrap_OGR_G_DestroyGeometry, METH_VARARGS },
	 { "CPLPopErrorHandler", py_CPLPopErrorHandler, METH_VARARGS },
	 { "CPLPushErrorHandler", py_CPLPushErrorHandler, METH_VARARGS },
	 { "CPLError", py_CPLError, METH_VARARGS },
	 { "CPLDebug", py_CPLDebug, METH_VARARGS },
	 { "CPLSerializeXMLTree", py_CPLSerializeXMLTree, METH_VARARGS },
	 { "CPLParseXMLString", py_CPLParseXMLString, METH_VARARGS },
	 { "OPTGetProjectionMethods", py_OPTGetProjectionMethods, METH_VARARGS },
	 { "OCTTransform", py_OCTTransform, METH_VARARGS },
	 { "OCTDestroyCoordinateTransformation", _wrap_OCTDestroyCoordinateTransformation, METH_VARARGS },
	 { "OCTNewCoordinateTransformation", _wrap_OCTNewCoordinateTransformation, METH_VARARGS },
	 { "OSRExportToXML", py_OSRExportToXML, METH_VARARGS },
	 { "OSRExportToUSGS", py_OSRExportToUSGS, METH_VARARGS },
	 { "OSRExportToPrettyWkt", py_OSRExportToPrettyWkt, METH_VARARGS },
	 { "OSRExportToWkt", py_OSRExportToWkt, METH_VARARGS },
	 { "OSRExportToProj4", py_OSRExportToProj4, METH_VARARGS },
	 { "OSRExportToPCI", py_OSRExportToPCI, METH_VARARGS },
	 { "OSRImportFromUSGS", py_OSRImportFromUSGS, METH_VARARGS },
	 { "OSRImportFromWkt", py_OSRImportFromWkt, METH_VARARGS },
	 { "OSRImportFromPCI", py_OSRImportFromPCI, METH_VARARGS },
	 { "OSRImportFromESRI", py_OSRImportFromESRI, METH_VARARGS },
	 { "OSRSetVDG", _wrap_OSRSetVDG, METH_VARARGS },
	 { "OSRSetTMSO", _wrap_OSRSetTMSO, METH_VARARGS },
	 { "OSRSetTMG", _wrap_OSRSetTMG, METH_VARARGS },
	 { "OSRSetTM", _wrap_OSRSetTM, METH_VARARGS },
	 { "OSRSetSOC", _wrap_OSRSetSOC, METH_VARARGS },
	 { "OSRSetStereographic", _wrap_OSRSetStereographic, METH_VARARGS },
	 { "OSRSetSinusoidal", _wrap_OSRSetSinusoidal, METH_VARARGS },
	 { "OSRSetRobinson", _wrap_OSRSetRobinson, METH_VARARGS },
	 { "OSRSetPS", _wrap_OSRSetPS, METH_VARARGS },
	 { "OSRSetPolyconic", _wrap_OSRSetPolyconic, METH_VARARGS },
	 { "OSRSetOrthographic", _wrap_OSRSetOrthographic, METH_VARARGS },
	 { "OSRSetOS", _wrap_OSRSetOS, METH_VARARGS },
	 { "OSRSetNZMG", _wrap_OSRSetNZMG, METH_VARARGS },
	 { "OSRSetMollweide", _wrap_OSRSetMollweide, METH_VARARGS },
	 { "OSRSetMercator", _wrap_OSRSetMercator, METH_VARARGS },
	 { "OSRSetMC", _wrap_OSRSetMC, METH_VARARGS },
	 { "OSRSetLCCB", _wrap_OSRSetLCCB, METH_VARARGS },
	 { "OSRSetLCC1SP", _wrap_OSRSetLCC1SP, METH_VARARGS },
	 { "OSRSetLCC", _wrap_OSRSetLCC, METH_VARARGS },
	 { "OSRSetLAEA", _wrap_OSRSetLAEA, METH_VARARGS },
	 { "OSRSetKrovak", _wrap_OSRSetKrovak, METH_VARARGS },
	 { "OSRSetHOM2PNO", _wrap_OSRSetHOM2PNO, METH_VARARGS },
	 { "OSRSetHOM", _wrap_OSRSetHOM, METH_VARARGS },
	 { "OSRSetGnomonic", _wrap_OSRSetGnomonic, METH_VARARGS },
	 { "OSRSetGS", _wrap_OSRSetGS, METH_VARARGS },
	 { "OSRSetEquirectangular", _wrap_OSRSetEquirectangular, METH_VARARGS },
	 { "OSRSetEckertVI", _wrap_OSRSetEckertVI, METH_VARARGS },
	 { "OSRSetEckertIV", _wrap_OSRSetEckertIV, METH_VARARGS },
	 { "OSRSetEC", _wrap_OSRSetEC, METH_VARARGS },
	 { "OSRSetCS", _wrap_OSRSetCS, METH_VARARGS },
	 { "OSRSetCEA", _wrap_OSRSetCEA, METH_VARARGS },
	 { "OSRSetAE", _wrap_OSRSetAE, METH_VARARGS },
	 { "OSRSetACEA", _wrap_OSRSetACEA, METH_VARARGS },
	 { "OSRSetStatePlaneWithUnits", _wrap_OSRSetStatePlaneWithUnits, METH_VARARGS },
	 { "OSRGetUTMZone", _wrap_OSRGetUTMZone, METH_VARARGS },
	 { "OSRSetUTM", _wrap_OSRSetUTM, METH_VARARGS },
	 { "OSRGetNormProjParm", _wrap_OSRGetNormProjParm, METH_VARARGS },
	 { "OSRSetNormProjParm", _wrap_OSRSetNormProjParm, METH_VARARGS },
	 { "OSRGetProjParm", _wrap_OSRGetProjParm, METH_VARARGS },
	 { "OSRSetProjParm", _wrap_OSRSetProjParm, METH_VARARGS },
	 { "OSRGetAuthorityName", _wrap_OSRGetAuthorityName, METH_VARARGS },
	 { "OSRGetAuthorityCode", _wrap_OSRGetAuthorityCode, METH_VARARGS },
	 { "OSRSetAuthority", _wrap_OSRSetAuthority, METH_VARARGS },
	 { "OSRGetInvFlattening", _wrap_OSRGetInvFlattening, METH_VARARGS },
	 { "OSRGetSemiMinor", _wrap_OSRGetSemiMinor, METH_VARARGS },
	 { "OSRGetSemiMajor", _wrap_OSRGetSemiMajor, METH_VARARGS },
	 { "OSRSetGeogCS", _wrap_OSRSetGeogCS, METH_VARARGS },
	 { "OSRGetTOWGS84", _wrap_OSRGetTOWGS84, METH_VARARGS },
	 { "OSRSetTOWGS84", _wrap_OSRSetTOWGS84, METH_VARARGS },
	 { "OSRCopyGeogCSFrom", _wrap_OSRCopyGeogCSFrom, METH_VARARGS },
	 { "OSRSetFromUserInput", _wrap_OSRSetFromUserInput, METH_VARARGS },
	 { "OSRSetWellKnownGeogCS", _wrap_OSRSetWellKnownGeogCS, METH_VARARGS },
	 { "OSRSetProjCS", _wrap_OSRSetProjCS, METH_VARARGS },
	 { "OSRIsSame", _wrap_OSRIsSame, METH_VARARGS },
	 { "OSRIsSameGeogCS", _wrap_OSRIsSameGeogCS, METH_VARARGS },
	 { "OSRIsProjected", _wrap_OSRIsProjected, METH_VARARGS },
	 { "OSRIsGeographic", _wrap_OSRIsGeographic, METH_VARARGS },
	 { "OSRGetLinearUnits", _wrap_OSRGetLinearUnits, METH_VARARGS },
	 { "OSRSetLinearUnits", _wrap_OSRSetLinearUnits, METH_VARARGS },
	 { "OSRGetAngularUnits", _wrap_OSRGetAngularUnits, METH_VARARGS },
	 { "OSRSetAngularUnits", _wrap_OSRSetAngularUnits, METH_VARARGS },
	 { "OSRGetAttrValue", _wrap_OSRGetAttrValue, METH_VARARGS },
	 { "OSRSetAttrValue", _wrap_OSRSetAttrValue, METH_VARARGS },
	 { "OSRStripCTParms", _wrap_OSRStripCTParms, METH_VARARGS },
	 { "OSRFixup", _wrap_OSRFixup, METH_VARARGS },
	 { "OSRFixupOrdering", _wrap_OSRFixupOrdering, METH_VARARGS },
	 { "OSRValidate", _wrap_OSRValidate, METH_VARARGS },
	 { "OSRMorphFromESRI", _wrap_OSRMorphFromESRI, METH_VARARGS },
	 { "OSRMorphToESRI", _wrap_OSRMorphToESRI, METH_VARARGS },
	 { "OSRImportFromXML", _wrap_OSRImportFromXML, METH_VARARGS },
	 { "OSRCloneGeogCS", _wrap_OSRCloneGeogCS, METH_VARARGS },
	 { "OSRImportFromProj4", _wrap_OSRImportFromProj4, METH_VARARGS },
	 { "OSRImportFromEPSG", _wrap_OSRImportFromEPSG, METH_VARARGS },
	 { "OSRDereference", _wrap_OSRDereference, METH_VARARGS },
	 { "OSRReference", _wrap_OSRReference, METH_VARARGS },
	 { "OSRDestroySpatialReference", _wrap_OSRDestroySpatialReference, METH_VARARGS },
	 { "OSRNewSpatialReference", _wrap_OSRNewSpatialReference, METH_VARARGS },
	 { "GDALChecksumImage", _wrap_GDALChecksumImage, METH_VARARGS },
	 { "GDALDitherRGB2PCT", py_GDALDitherRGB2PCT, METH_VARARGS },
	 { "GDALComputeMedianCutPCT", py_GDALComputeMedianCutPCT, METH_VARARGS },
	 { "GDALGetRasterHistogram", py_GDALGetRasterHistogram, METH_VARARGS },
	 { "GDALGCPsToGeoTransform", py_GDALGCPsToGeoTransform, METH_VARARGS },
	 { "GDALSetGCPs", py_GDALSetGCPs, METH_VARARGS },
	 { "GDALGetGCPs", py_GDALGetGCPs, METH_VARARGS },
	 { "GDALWriteRaster", py_GDALWriteRaster, METH_VARARGS },
	 { "GDALReadRaster", py_GDALReadRaster, METH_VARARGS },
	 { "GDALCreate", py_GDALCreate, METH_VARARGS },
	 { "GDALCreateCopy", py_GDALCreateCopy, METH_VARARGS },
	 { "GDALBuildOverviews", py_GDALBuildOverviews, METH_VARARGS },
	 { "GDALFlushCacheBlock", _wrap_GDALFlushCacheBlock, METH_VARARGS },
	 { "GDALGetCacheUsed", _wrap_GDALGetCacheUsed, METH_VARARGS },
	 { "GDALGetCacheMax", _wrap_GDALGetCacheMax, METH_VARARGS },
	 { "GDALSetCacheMax", _wrap_GDALSetCacheMax, METH_VARARGS },
	 { "GDALSetColorEntry", _wrap_GDALSetColorEntry, METH_VARARGS },
	 { "GDALGetColorEntryAsRGB", _wrap_GDALGetColorEntryAsRGB, METH_VARARGS },
	 { "GDALGetColorEntry", _wrap_GDALGetColorEntry, METH_VARARGS },
	 { "GDALGetColorEntryCount", _wrap_GDALGetColorEntryCount, METH_VARARGS },
	 { "GDALGetPaletteInterpretation", _wrap_GDALGetPaletteInterpretation, METH_VARARGS },
	 { "GDALCloneColorTable", _wrap_GDALCloneColorTable, METH_VARARGS },
	 { "GDALDestroyColorTable", _wrap_GDALDestroyColorTable, METH_VARARGS },
	 { "GDALCreateColorTable", _wrap_GDALCreateColorTable, METH_VARARGS },
	 { "GDALFlushRasterCache", _wrap_GDALFlushRasterCache, METH_VARARGS },
	 { "GDALGetOverview", _wrap_GDALGetOverview, METH_VARARGS },
	 { "GDALGetOverviewCount", _wrap_GDALGetOverviewCount, METH_VARARGS },
	 { "GDALComputeRasterMinMax", _wrap_GDALComputeRasterMinMax, METH_VARARGS },
	 { "GDALSetRasterNoDataValue", _wrap_GDALSetRasterNoDataValue, METH_VARARGS },
	 { "GDALGetRasterNoDataValue", _wrap_GDALGetRasterNoDataValue, METH_VARARGS },
	 { "GDALSetRasterColorTable", _wrap_GDALSetRasterColorTable, METH_VARARGS },
	 { "GDALGetRasterColorTable", _wrap_GDALGetRasterColorTable, METH_VARARGS },
	 { "GDALGetRasterColorInterpretation", _wrap_GDALGetRasterColorInterpretation, METH_VARARGS },
	 { "GDALGetRasterBandYSize", _wrap_GDALGetRasterBandYSize, METH_VARARGS },
	 { "GDALGetRasterBandXSize", _wrap_GDALGetRasterBandXSize, METH_VARARGS },
	 { "GDALGetBlockSize", _wrap_GDALGetBlockSize, METH_VARARGS },
	 { "GDALGetRasterDataType", _wrap_GDALGetRasterDataType, METH_VARARGS },
	 { "GDALFlushCache", _wrap_GDALFlushCache, METH_VARARGS },
	 { "GDALGetGCPProjection", _wrap_GDALGetGCPProjection, METH_VARARGS },
	 { "GDALGetGCPCount", _wrap_GDALGetGCPCount, METH_VARARGS },
	 { "GDALDereferenceDataset", _wrap_GDALDereferenceDataset, METH_VARARGS },
	 { "GDALReferenceDataset", _wrap_GDALReferenceDataset, METH_VARARGS },
	 { "GDALSetGeoTransform", _wrap_GDALSetGeoTransform, METH_VARARGS },
	 { "GDALGetGeoTransform", _wrap_GDALGetGeoTransform, METH_VARARGS },
	 { "GDALSetProjection", _wrap_GDALSetProjection, METH_VARARGS },
	 { "GDALGetProjectionRef", _wrap_GDALGetProjectionRef, METH_VARARGS },
	 { "GDALGetRasterBand", _wrap_GDALGetRasterBand, METH_VARARGS },
	 { "GDALGetRasterCount", _wrap_GDALGetRasterCount, METH_VARARGS },
	 { "GDALGetRasterYSize", _wrap_GDALGetRasterYSize, METH_VARARGS },
	 { "GDALGetRasterXSize", _wrap_GDALGetRasterXSize, METH_VARARGS },
	 { "GDALClose", _wrap_GDALClose, METH_VARARGS },
	 { "GDALGetDatasetDriver", _wrap_GDALGetDatasetDriver, METH_VARARGS },
	 { "GDALGetDriverHelpTopic", _wrap_GDALGetDriverHelpTopic, METH_VARARGS },
	 { "GDALGetDriverLongName", _wrap_GDALGetDriverLongName, METH_VARARGS },
	 { "GDALGetDriverShortName", _wrap_GDALGetDriverShortName, METH_VARARGS },
	 { "GDALDeleteDataset", _wrap_GDALDeleteDataset, METH_VARARGS },
	 { "GDALDeregisterDriver", _wrap_GDALDeregisterDriver, METH_VARARGS },
	 { "GDALRegisterDriver", _wrap_GDALRegisterDriver, METH_VARARGS },
	 { "GDALGetDriver", _wrap_GDALGetDriver, METH_VARARGS },
	 { "GDALGetDriverCount", _wrap_GDALGetDriverCount, METH_VARARGS },
	 { "GDALGetDriverByName", _wrap_GDALGetDriverByName, METH_VARARGS },
	 { "GDALOpenShared", _wrap_GDALOpenShared, METH_VARARGS },
	 { "GDALOpen", _wrap_GDALOpen, METH_VARARGS },
	 { "GDALRegister_NUMPY", _wrap_GDALRegister_NUMPY, METH_VARARGS },
	 { "GDALAllRegister", _wrap_GDALAllRegister, METH_VARARGS },
	 { "GDALSetDescription", _wrap_GDALSetDescription, METH_VARARGS },
	 { "GDALGetDescription", _wrap_GDALGetDescription, METH_VARARGS },
	 { "GDALSetMetadata", _wrap_GDALSetMetadata, METH_VARARGS },
	 { "GDALGetMetadata", _wrap_GDALGetMetadata, METH_VARARGS },
	 { "GDALTermProgress", _wrap_GDALTermProgress, METH_VARARGS },
	 { "GDALDecToPackedDMS", _wrap_GDALDecToPackedDMS, METH_VARARGS },
	 { "GDALPackedDMSToDec", _wrap_GDALPackedDMSToDec, METH_VARARGS },
	 { "GDALDecToDMS", _wrap_GDALDecToDMS, METH_VARARGS },
	 { "GDALGetPaletteInterpretationName", _wrap_GDALGetPaletteInterpretationName, METH_VARARGS },
	 { "GDALGetColorInterpretationName", _wrap_GDALGetColorInterpretationName, METH_VARARGS },
	 { "GDALGetDataTypeByName", _wrap_GDALGetDataTypeByName, METH_VARARGS },
	 { "GDALGetDataTypeName", _wrap_GDALGetDataTypeName, METH_VARARGS },
	 { "GDALDataTypeIsComplex", _wrap_GDALDataTypeIsComplex, METH_VARARGS },
	 { "GDALGetDataTypeSize", _wrap_GDALGetDataTypeSize, METH_VARARGS },
	 { "CSLDestroy", _wrap_CSLDestroy, METH_VARARGS },
	 { "CPLGetLastErrorMsg", _wrap_CPLGetLastErrorMsg, METH_VARARGS },
	 { "CPLGetLastErrorNo", _wrap_CPLGetLastErrorNo, METH_VARARGS },
	 { "CPLErrorReset", _wrap_CPLErrorReset, METH_VARARGS },
	 { "ptrptrcreate", ptrptrcreate, METH_VARARGS },
	 { "ptrptrvalue", ptrptrvalue, METH_VARARGS },
	 { "ptrptrset", ptrptrset, METH_VARARGS },
	 { "StringListToList", py_StringListToList, METH_VARARGS },
	 { "ListToStringList", py_ListToStringList, METH_VARARGS },
	 { "StringListToDict", py_StringListToDict, METH_VARARGS },
	 { "DictToStringList", py_DictToStringList, METH_VARARGS },
	 { "ptrmap", _wrap_ptrmap, METH_VARARGS },
	 { "ptradd", _wrap_ptradd, METH_VARARGS },
	 { "ptrfree", _wrap_ptrfree, METH_VARARGS },
	 { "ptrcreate", _wrap_ptrcreate, METH_VARARGS },
	 { "ptrset", _wrap_ptrset, METH_VARARGS },
	 { "ptrvalue", _wrap_ptrvalue, METH_VARARGS },
	 { "ptrcast", _wrap_ptrcast, METH_VARARGS },
	 { "NumPyArrayToGDALFilename", py_NumPyArrayToGDALFilename, METH_VARARGS },
	 { NULL, NULL }
};
#ifdef __cplusplus
}
#endif
/*
 * This table is used by the pointer type-checker
 */
static struct { char *n1; char *n2; void *(*pcnv)(void *); } _swig_mapping[] = {
    { "_signed_long","_long",0},
    { "_char_pp","_stringList",0},
    { "_long","_unsigned_long",0},
    { "_long","_signed_long",0},
    { "_GDALRWFlag","_OGRJustification",0},
    { "_GDALRWFlag","_OGRFieldType",0},
    { "_GDALRWFlag","_OGRwkbGeometryType",0},
    { "_GDALRWFlag","_GDALPaletteInterp",0},
    { "_GDALRWFlag","_GDALColorInterp",0},
    { "_GDALRWFlag","_int",0},
    { "_GDALRWFlag","_signed_int",0},
    { "_GDALRWFlag","_unsigned_int",0},
    { "_GDALRWFlag","_GDALDataType",0},
    { "_GDALRWFlag","_GDALAccess",0},
    { "_stringList","_char_pp",0},
    { "_short_p","_GDALColorEntry",0},
    { "_GDALColorEntry","_short_p",0},
    { "_GDALPaletteInterp","_OGRJustification",0},
    { "_GDALPaletteInterp","_OGRFieldType",0},
    { "_GDALPaletteInterp","_OGRwkbGeometryType",0},
    { "_GDALPaletteInterp","_int",0},
    { "_GDALPaletteInterp","_signed_int",0},
    { "_GDALPaletteInterp","_unsigned_int",0},
    { "_GDALPaletteInterp","_GDALDataType",0},
    { "_GDALPaletteInterp","_GDALAccess",0},
    { "_GDALPaletteInterp","_GDALRWFlag",0},
    { "_GDALPaletteInterp","_GDALColorInterp",0},
    { "_GDALDataType","_OGRJustification",0},
    { "_GDALDataType","_OGRFieldType",0},
    { "_GDALDataType","_OGRwkbGeometryType",0},
    { "_GDALDataType","_GDALPaletteInterp",0},
    { "_GDALDataType","_GDALColorInterp",0},
    { "_GDALDataType","_GDALRWFlag",0},
    { "_GDALDataType","_GDALAccess",0},
    { "_GDALDataType","_int",0},
    { "_GDALDataType","_signed_int",0},
    { "_GDALDataType","_unsigned_int",0},
    { "_OGRFieldType","_OGRJustification",0},
    { "_OGRFieldType","_int",0},
    { "_OGRFieldType","_signed_int",0},
    { "_OGRFieldType","_unsigned_int",0},
    { "_OGRFieldType","_GDALDataType",0},
    { "_OGRFieldType","_GDALAccess",0},
    { "_OGRFieldType","_GDALRWFlag",0},
    { "_OGRFieldType","_GDALColorInterp",0},
    { "_OGRFieldType","_GDALPaletteInterp",0},
    { "_OGRFieldType","_OGRwkbGeometryType",0},
    { "_unsigned_long","_long",0},
    { "_signed_int","_OGRJustification",0},
    { "_signed_int","_OGRFieldType",0},
    { "_signed_int","_OGRwkbGeometryType",0},
    { "_signed_int","_GDALPaletteInterp",0},
    { "_signed_int","_GDALColorInterp",0},
    { "_signed_int","_GDALRWFlag",0},
    { "_signed_int","_GDALAccess",0},
    { "_signed_int","_GDALDataType",0},
    { "_signed_int","_int",0},
    { "_OGRwkbGeometryType","_OGRJustification",0},
    { "_OGRwkbGeometryType","_OGRFieldType",0},
    { "_OGRwkbGeometryType","_int",0},
    { "_OGRwkbGeometryType","_signed_int",0},
    { "_OGRwkbGeometryType","_unsigned_int",0},
    { "_OGRwkbGeometryType","_GDALDataType",0},
    { "_OGRwkbGeometryType","_GDALAccess",0},
    { "_OGRwkbGeometryType","_GDALRWFlag",0},
    { "_OGRwkbGeometryType","_GDALColorInterp",0},
    { "_OGRwkbGeometryType","_GDALPaletteInterp",0},
    { "_GDALAccess","_OGRJustification",0},
    { "_GDALAccess","_OGRFieldType",0},
    { "_GDALAccess","_OGRwkbGeometryType",0},
    { "_GDALAccess","_GDALPaletteInterp",0},
    { "_GDALAccess","_GDALColorInterp",0},
    { "_GDALAccess","_GDALRWFlag",0},
    { "_GDALAccess","_int",0},
    { "_GDALAccess","_signed_int",0},
    { "_GDALAccess","_unsigned_int",0},
    { "_GDALAccess","_GDALDataType",0},
    { "_unsigned_short","_short",0},
    { "_signed_short","_short",0},
    { "_unsigned_int","_OGRJustification",0},
    { "_unsigned_int","_OGRFieldType",0},
    { "_unsigned_int","_OGRwkbGeometryType",0},
    { "_unsigned_int","_GDALPaletteInterp",0},
    { "_unsigned_int","_GDALColorInterp",0},
    { "_unsigned_int","_GDALRWFlag",0},
    { "_unsigned_int","_GDALAccess",0},
    { "_unsigned_int","_GDALDataType",0},
    { "_unsigned_int","_int",0},
    { "_short","_unsigned_short",0},
    { "_short","_signed_short",0},
    { "_int","_OGRJustification",0},
    { "_int","_OGRFieldType",0},
    { "_int","_OGRwkbGeometryType",0},
    { "_int","_GDALPaletteInterp",0},
    { "_int","_GDALColorInterp",0},
    { "_int","_GDALRWFlag",0},
    { "_int","_GDALAccess",0},
    { "_int","_GDALDataType",0},
    { "_int","_unsigned_int",0},
    { "_int","_signed_int",0},
    { "_GDALColorInterp","_OGRJustification",0},
    { "_GDALColorInterp","_OGRFieldType",0},
    { "_GDALColorInterp","_OGRwkbGeometryType",0},
    { "_GDALColorInterp","_GDALPaletteInterp",0},
    { "_GDALColorInterp","_int",0},
    { "_GDALColorInterp","_signed_int",0},
    { "_GDALColorInterp","_unsigned_int",0},
    { "_GDALColorInterp","_GDALDataType",0},
    { "_GDALColorInterp","_GDALAccess",0},
    { "_GDALColorInterp","_GDALRWFlag",0},
    { "_OGRJustification","_int",0},
    { "_OGRJustification","_signed_int",0},
    { "_OGRJustification","_unsigned_int",0},
    { "_OGRJustification","_GDALDataType",0},
    { "_OGRJustification","_GDALAccess",0},
    { "_OGRJustification","_GDALRWFlag",0},
    { "_OGRJustification","_GDALColorInterp",0},
    { "_OGRJustification","_GDALPaletteInterp",0},
    { "_OGRJustification","_OGRwkbGeometryType",0},
    { "_OGRJustification","_OGRFieldType",0},
{0,0,0}};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) init_gdal() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("_gdal", _gdalMethods);
	 d = PyModule_GetDict(m);
{
   int i;
   for (i = 0; _swig_mapping[i].n1; i++)
        SWIG_RegisterMapping(_swig_mapping[i].n1,_swig_mapping[i].n2,_swig_mapping[i].pcnv);
}
}
