/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.types;

import ch.ehi.basics.tools.AbstractVisitor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class NlsString
implements Serializable {
    private static transient String defaultLanguage = "";
    private Map entries = null;

    public NlsString() {
        this.entries = new HashMap();
    }

    public NlsString(String value) {
        this.entries = new HashMap();
        this.entries.put(defaultLanguage, value);
    }

    public NlsString(String language, String value) {
        this.entries = new HashMap();
        this.entries.put(language != null ? language : defaultLanguage, value);
    }

    public NlsString(NlsString src) {
        this.entries = src == null ? new HashMap() : new HashMap(src.entries);
    }

    public NlsString(NlsString src, String value) {
        this.entries = src == null ? new HashMap() : new HashMap(src.entries);
        this.entries.put(defaultLanguage, value);
    }

    public NlsString(NlsString src, String language, String value) {
        this.entries = src == null ? new HashMap() : new HashMap(src.entries);
        this.entries.put(language != null ? language : defaultLanguage, value);
    }

    public NlsString(Map allValues) {
        this.entries = new HashMap(allValues);
    }

    public String getValue() {
        return this.getBestEntry(defaultLanguage);
    }

    public String getValue(String language) {
        return this.getBestEntry(language != null ? language : defaultLanguage);
    }

    public Map getAllValues() {
        HashMap ret = new HashMap();
        ret.putAll(this.entries);
        return ret;
    }

    public static String getDefaultLanguage() {
        return defaultLanguage;
    }

    public static void setDefaultLanguage(String language) {
        defaultLanguage = language != null ? language : "";
    }

    private String getBestEntry(String language) {
        if (this.entries.size() == 0) {
            return "";
        }
        if (this.entries.containsKey(language)) {
            return (String)this.entries.get(language);
        }
        if (language.equals("rm")) {
            if (this.entries.containsKey("de")) {
                return (String)this.entries.get("de");
            }
            if (this.entries.containsKey("fr")) {
                return (String)this.entries.get("fr");
            }
            if (this.entries.containsKey("en")) {
                return (String)this.entries.get("en");
            }
        }
        if (language.equals("it")) {
            if (this.entries.containsKey("fr")) {
                return (String)this.entries.get("fr");
            }
            if (this.entries.containsKey("de")) {
                return (String)this.entries.get("de");
            }
            if (this.entries.containsKey("rm")) {
                return (String)this.entries.get("rm");
            }
            if (this.entries.containsKey("en")) {
                return (String)this.entries.get("en");
            }
        }
        if (language.equals("fr")) {
            if (this.entries.containsKey("de")) {
                return (String)this.entries.get("de");
            }
            if (this.entries.containsKey("it")) {
                return (String)this.entries.get("it");
            }
            if (this.entries.containsKey("rm")) {
                return (String)this.entries.get("rm");
            }
            if (this.entries.containsKey("en")) {
                return (String)this.entries.get("en");
            }
        }
        if (language.equals("en")) {
            if (this.entries.containsKey("de")) {
                return (String)this.entries.get("de");
            }
            if (this.entries.containsKey("fr")) {
                return (String)this.entries.get("fr");
            }
            if (this.entries.containsKey("it")) {
                return (String)this.entries.get("it");
            }
            if (this.entries.containsKey("rm")) {
                return (String)this.entries.get("rm");
            }
        }
        if (language.equals("de")) {
            if (this.entries.containsKey("fr")) {
                return (String)this.entries.get("fr");
            }
            if (this.entries.containsKey("it")) {
                return (String)this.entries.get("it");
            }
            if (this.entries.containsKey("rm")) {
                return (String)this.entries.get("rm");
            }
            if (this.entries.containsKey("en")) {
                return (String)this.entries.get("en");
            }
        }
        if (this.entries.containsKey(defaultLanguage)) {
            return (String)this.entries.get(defaultLanguage);
        }
        return (String)this.entries.values().iterator().next();
    }

    public void unlinkAll() {
    }

    public void enumerateChildren(AbstractVisitor visitor) {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NlsString)) {
            return false;
        }
        NlsString other = (NlsString)obj;
        return other.entries.equals(this.entries);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.getValue() + ")";
    }
}

