/*=========================================================================

  Program: GDCM (Grassroots DICOM). A DICOM library
  Module:  $URL$

  Copyright (c) 2006-2009 Mathieu Malaterre
  All rights reserved.
  See Copyright.txt or http://gdcm.sourceforge.net/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __gdcmImageReader_h
#define __gdcmImageReader_h

#include "gdcmPixmapReader.h"
#include "gdcmImage.h"

namespace gdcm
{

class MediaStorage;
/**
 * \brief ImageReader
 * \note its role is to convert the DICOM DataSet into a gdcm::Image
 * representation
 * By default it is also loading the lookup table and overlay when found as they impact the rendering or the image
 *
 * See PS 3.3-2008, Table C.7-11b IMAGE PIXEL MACRO ATTRIBUTES for the list of attribute that belong to
 * what gdcm calls a 'Image'
 * 
 */
class GDCM_EXPORT ImageReader : public PixmapReader
{
public:
  ImageReader();
  ~ImageReader();

  /// Read the DICOM image. There are two reason for failure:
  /// 1. The input filename is not DICOM
  /// 2. The input DICOM file does not contains an Image.
  
  bool Read();

  // Following methods are valid only after a call to 'Read'

  /// Return the read image
  const Image& GetImage() const;
  Image& GetImage();
  //void SetImage(Image const &img);

protected:
  bool ReadImage(MediaStorage const &ms);
  bool ReadACRNEMAImage();
};

} // end namespace gdcm

#endif //__gdcmImageReader_h

