from utils.Observable import Observable


class Win32Backend(Observable):

    OBS_UPDATE = 0
    CONFIG_LOCATION = "/apps/gdesklets"

    UNDEF = "-- undef --"
    

    def __init__(self):

        self.__registry = {}



    def __on_notify(self, path, value):

        if (value):
            self.update_observer(self.OBS_UPDATE, path, value)



    def set(self, *args):

        """
        Sets a configuration entry.
        """

        value = args[-1]
            
        #v = gconf.Value(gconf.VALUE_STRING)
        #v.set_string(args[-1])
        path = self.CONFIG_LOCATION
        if args: path += "/" + "/".join(args[:-1])
        self.__registry[path] = value
        self.__on_notify(path, value)


    def get(self, *args):

        """
        Returns a configuration entry.
        """

        path = self.CONFIG_LOCATION
        if args: path += "/" + "/".join(args)
        v = self.__registry.get(path)
        if (v):
            return v
        else:
            return ""



    def clear(self, *paths):

         """
         Removes the given folder.
         """

         path = self.CONFIG_LOCATION
         if paths: path += "/" + "/".join(paths)
         #self.__client.unset(path)
         # irrelevant?



    def list(self, *args):

        """Returns a list of all directories at the given path."""

        return []
    
        #path = self.CONFIG_LOCATION
        #if args: path += "/" + "/".join(args)
        #dirs = self.__client.all_dirs(path)
        #entries = self.__client.all_entries(path)

        #ret = [ d[len(path) + 1:] for d in dirs ]

        #for e in entries:
        #    ret.append(e.get_key()[len(path) + 1:])

        #return ret


backend = Win32Backend()
