#
# Registry for DataTargets. To add a new target just add an appropriate entry
# to _REGISTRY.
#

__all__ = ("create", "get_target_class")


from TargetAlignment     import TargetAlignment
from TargetArray         import TargetArray
from TargetEntry         import TargetEntry
from TargetExpander      import TargetExpander
from TargetFrame         import TargetFrame
from TargetGauge         import TargetGauge
from TargetGroup         import TargetGroup
from TargetImage         import TargetImage
from TargetLabel         import TargetLabel
from TargetMenu          import TargetMenu
from TargetMenuItem      import TargetMenuItem

if (not HAVE_WIN32):
    from TargetBonoboControl import TargetBonoboControl
    from TargetCanvas        import TargetCanvas
    from TargetHTML          import TargetHTML
    from TargetPlotter       import TargetPlotter

_targets = {
    "alignment" : TargetAlignment,
    "array"     : TargetArray,
    "display"   : TargetGroup,
    "entry"     : TargetEntry,
    "expander"  : TargetExpander,
    "frame"     : TargetFrame,
    "gauge"     : TargetGauge,
    "group"     : TargetGroup,
    "image"     : TargetImage,
    "label"     : TargetLabel,
    "menu"      : TargetMenu,
    "menu-item" : TargetMenuItem,
}

if (not HAVE_WIN32):
    _targets.update({
        "canvas"    : TargetCanvas,
        "embed"     : TargetBonoboControl,
        "html"      : TargetHTML,
        "plotter"   : TargetPlotter,
        })



#
# Creates and returns the given target.
#
def create(name, parent):

    try:
        clss = _targets[name]
    except KeyError:
        log("Unknown target type \"%s\"." % name)
        raise KeyError

    obj = clss(name, parent)
    return obj

#
# Returns the class for the given target name.
#
def get_target_class(name):

    return _targets[name]

