/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

/* data structures */

struct canvas_pak
{
gint active;
gpointer model;
gint x,y;              /* origin */
gint width,height;     /* canvas dimensions */
gint size;
GtkWidget *glarea;
};


struct pipe_pak
{
gdouble v1[3];
gdouble v2[3];
gdouble radius;
gdouble colour[4];
};

/* prototypes */

gint gl_init_visual(void);
struct canvas_pak *gl_new_canvas(gint width, gint height);

void gl_get_world_coords(gint , gint , gdouble *);

GSList *gl_seek_bond(GtkWidget *, gint, gint, struct model_pak *);

void gl_select_box(GtkWidget *);
void opengl_draw(struct canvas_pak *, struct model_pak *);

gchar *get_mode_label(struct model_pak *);

void set_colour(GdkColor *, gint );

gint redraw_handler(gpointer *);

void gl_init_projection(struct model_pak *);
void draw_objs(struct canvas_pak *, struct model_pak *);
void redraw_canvas(gint );

void stereo_close_window(void);
void stereo_open_window(void);
void stereo_draw(void);

