
/* rendering consts */
#define BALL_SIZE 0.27
#define AMBIENCE_MAX 0.025
#define TRIPLE_SCALE 0.65
#define DOUBLE_SCALE 0.8
#define POVRAY_FONT "timrom.ttf"
/* convert from gdis pixel offset to OpenGL cartesian Angs */
#define PIX2ANG 0.03

/* unified render (povray & openGL) */
enum 
{
STICK, BALL_STICK, CPK, LIQUORICE,
LIGHT_TYPE, DIRECTIONAL, POSITIONAL,
SCALE, HALO_QUALITY, FAST_ROTATION,
ANTIALIAS, SHADOWLESS, DRAW_AXES, PERSPECTIVE, WIRE_FRAME, FOG,
ANIMATE, ANIMATE_TYPE, ANIM_GIF, ANIM_MPEG, ANIM_NAME, ANIM_FRAME,
MORPH_STYLE, MORPH_FINISH
};

/*********************/
/* POVray structures */
/*********************/
struct light_pak
{
gint type;
gdouble x[3];
gdouble colour[3];
gdouble ambient;
gdouble diffuse;
gdouble specular;
};

/* TODO - replace with general render pak? */
struct povray_pak
{
gint background;   /* colour */
gint camera[3];
gint num_lights;
gint shadowless;
gint animate;
gint atype;
gint axes;
gint delay;
gdouble ambience;
gdouble frad;       /* frame radius */
gchar filename[FILELEN];
gint wire_frame;
gdouble ref_index;
gdouble transmit;
gchar morph_finish[LINELEN];
};


/* prototypes */
GSList *render_get_pipes(gint, struct model_pak *);



