/*
 *      gb.c - this file is part of Geany, a fast and lightweight IDE
 *
 *      Copyright 2005-2008 Enrico Tröger <enrico(dot)troeger(at)uvena(dot)de>
 *      Copyright 2006-2008 Nick Treleaven <nick(dot)treleaven(at)btinternet(dot)com>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: gb.c 2150 2008-01-06 18:11:57Z eht16 $
 */

/*
 * GTK-Bandit.
 */

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>
#ifdef HAVE_FCNTL_H
	#include <fcntl.h>
#endif
#include <gdk-pixbuf/gdk-pixdata.h>

#define MAX_PICS 10
#define LOOP_DELAY 200000	// micro seconds

#define IMAGE_LOGO			10
#define IMAGE_BUTTON_UP		11
#define IMAGE_BUTTON_DOWN	12


unsigned short lap;
gint points;
unsigned short iconset;
GtkWidget *image1, *image2, *image3, *image4, *label1, *label2, *label3, *okbutton1, *textview1;
gchar info_texts[4][50];
gchar *help_text;
gint random_fd;
gboolean is_running;
static GdkPixbuf **icons;

static gint gb_destroyapp (GtkWidget *widget, gpointer gdata);
static gint destroydialog (GtkWidget *widget, gpointer data);
static void update_labels(GtkWidget *window, gint init, gint won);
static void on_button1_clicked(GtkButton *button, gpointer user_data);
static void on_button4_clicked(GtkButton *button, gpointer user_data);
static void on_button5_clicked(GtkButton *button, gpointer user_data);



static void create_window(void)
{
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *button1;
	GtkWidget *hbox2;
	GtkWidget *button4;
	GtkWidget *button5;

	gb_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(gb_window), "Happy Easter!");
	gtk_window_set_resizable(GTK_WINDOW(gb_window), FALSE);
	gtk_window_set_position(GTK_WINDOW(gb_window), GTK_WIN_POS_CENTER);
	gtk_window_set_destroy_with_parent(GTK_WINDOW(gb_window), TRUE);
	gtk_window_set_type_hint(GTK_WINDOW(gb_window), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(gb_window), TRUE);
	gtk_window_set_modal(GTK_WINDOW(gb_window), TRUE);
	gtk_window_set_skip_pager_hint(GTK_WINDOW(gb_window), TRUE);
	gtk_window_set_icon(GTK_WINDOW(gb_window), icons[IMAGE_LOGO]);
	gdk_pixbuf_unref(icons[IMAGE_LOGO]);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(gb_window), vbox1);

	label2 = gtk_label_new("title");
	gtk_widget_show(label2);
	gtk_box_pack_start(GTK_BOX(vbox1), label2, FALSE, FALSE, 5);

	hbox1 = gtk_hbox_new(TRUE, 4);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(hbox1), 4);

	image1 = gtk_image_new_from_stock("gtk-cancel", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(image1);
	gtk_box_pack_start(GTK_BOX(hbox1), image1, TRUE, FALSE, 0);

	image2 = gtk_image_new_from_stock("gtk-cancel", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show(image2);
	gtk_box_pack_start(GTK_BOX(hbox1), image2, TRUE, FALSE, 0);

	image3 = gtk_image_new_from_stock("gtk-cancel", GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_name(image3, "image3");
	gtk_widget_show(image3);
	gtk_box_pack_start(GTK_BOX(hbox1), image3, TRUE, FALSE, 0);

	button1 = gtk_button_new();
	gtk_widget_show(button1);
	gtk_box_pack_start(GTK_BOX(hbox1), button1, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(button1), 4);
	gtk_button_set_relief(GTK_BUTTON(button1), GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click(GTK_BUTTON(button1), FALSE);

	image4 = gtk_image_new_from_pixbuf(icons[IMAGE_BUTTON_UP]);
	gtk_widget_show(image4);
	gtk_container_add(GTK_CONTAINER(button1), image4);

	label3 = gtk_label_new("label3");
	gtk_widget_show(label3);
	gtk_box_pack_start(GTK_BOX(vbox1), label3, FALSE, FALSE, 0);

	label1 = gtk_label_new("points");
	gtk_widget_show(label1);
	gtk_box_pack_start(GTK_BOX(vbox1), label1, FALSE, FALSE, 5);

	hbox2 = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hbox2);
	gtk_box_set_homogeneous(GTK_BOX(hbox2), TRUE);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox2, TRUE, FALSE, 0);

	button4 = gtk_button_new_from_stock("gtk-help");
	gtk_widget_show(button4);
	gtk_box_pack_start(GTK_BOX(hbox2), button4, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(button4), 5);

	button5 = gtk_button_new_from_stock("gtk-close");
	gtk_widget_show(button5);
	gtk_box_pack_start(GTK_BOX(hbox2), button5, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(button5), 5);

	g_signal_connect((gpointer) button1, "clicked", G_CALLBACK(on_button1_clicked), NULL);
	g_signal_connect((gpointer) button4, "clicked", G_CALLBACK(on_button4_clicked), NULL);
	g_signal_connect((gpointer) button5, "clicked", G_CALLBACK(on_button5_clicked), NULL);

	gtk_widget_grab_focus(button4);
}

static GtkWidget *create_help_dialog(void)
{
	GtkWidget *help_dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *scrolledwindow1;
	GtkWidget *dialog_action_area1;

	help_dialog = gtk_dialog_new();
	gtk_container_set_border_width(GTK_CONTAINER(help_dialog), 1);
	gtk_window_set_title(GTK_WINDOW(help_dialog), "Help");
	gtk_window_set_type_hint(GTK_WINDOW(help_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_modal(GTK_WINDOW(help_dialog), TRUE);

	dialog_vbox1 = GTK_DIALOG(help_dialog)->vbox;
	gtk_widget_show(dialog_vbox1);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow1);
	gtk_box_pack_start(GTK_BOX (dialog_vbox1), scrolledwindow1, TRUE, TRUE, 3);
	gtk_container_set_border_width(GTK_CONTAINER(scrolledwindow1), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_NEVER);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolledwindow1), GTK_SHADOW_OUT);

	textview1 = gtk_text_view_new();
	gtk_widget_show(textview1);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), textview1);
	gtk_widget_set_size_request(textview1, 450, -1);
	gtk_container_set_border_width(GTK_CONTAINER(textview1), 1);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(textview1), FALSE);
	gtk_text_view_set_accepts_tab(GTK_TEXT_VIEW(textview1), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview1), GTK_WRAP_WORD);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(textview1), FALSE);
	gtk_text_view_set_pixels_above_lines(GTK_TEXT_VIEW(textview1), 1);
	gtk_text_view_set_pixels_below_lines(GTK_TEXT_VIEW(textview1), 1);
	gtk_text_view_set_pixels_inside_wrap(GTK_TEXT_VIEW(textview1), 1);
	gtk_text_view_set_left_margin(GTK_TEXT_VIEW(textview1), 1);
	gtk_text_view_set_right_margin(GTK_TEXT_VIEW(textview1), 1);

	dialog_action_area1 = GTK_DIALOG(help_dialog)->action_area;
	gtk_widget_show(dialog_action_area1);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area1), GTK_BUTTONBOX_END);

	okbutton1 = gtk_button_new_from_stock("gtk-ok");
	gtk_widget_show(okbutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(help_dialog), okbutton1, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS(okbutton1, GTK_CAN_DEFAULT);

	return help_dialog;
}


static gint destroydialog(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(GTK_WIDGET(data));
	return (FALSE);
}


static void initialise_random_numbers(void)
{
#if defined(HAVE_FCNTL_H) && (defined(HAVE_DEVURANDOM) || defined(HAVE_DEVRANDOM))
# ifdef HAVE_DEVURANDOM
	random_fd = open("/dev/urandom", O_NONBLOCK | O_RDONLY);
# elif HAVE_DEVRANDOM
	random_fd = open("/dev/random", O_NONBLOCK | O_RDONLY);
# endif
#else
    srand(time(NULL) * getpid());
#endif
}


static gint random_number(gint max)
{
#if defined(HAVE_FCNTL_H) && (defined(HAVE_DEVURANDOM) || defined(HAVE_DEVRANDOM))
    if (max <= 255)
	{
		unsigned char byte;
		while (read(random_fd, &byte, 1) == 1)
		{
	    	if (byte < max)
				return (byte % max);
		}
    }
    return 0;
#else
	return (((unsigned short) rand()) % max);
#endif
}


static void on_button5_clicked(GtkButton *button, gpointer user_data)
{
    gb_destroyapp(GTK_WIDGET(button), user_data);
}


static gint get_points(unsigned short a, unsigned short b, unsigned short c)
{
	if (a == b && b == c)
	{
		return 2;
	}
	else
	{
		if (a == b || b == c || a == c)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
}


static void on_button1_clicked(GtkButton *button, gpointer user_data)
{
    unsigned short erg_a, erg_b, erg_c, i, l, m, n, loops;

	if (is_running) return;	// prevent multiple clicks
	is_running = TRUE;
	// change button-image
	gtk_image_set_from_pixbuf(GTK_IMAGE(image4), icons[IMAGE_BUTTON_DOWN]);

	lap++;
	update_labels(gb_window, FALSE, 3);

	l = random_number(MAX_PICS);
	m = random_number(MAX_PICS);
	n = random_number(MAX_PICS);
	erg_a = random_number(MAX_PICS);
	erg_b = random_number(MAX_PICS);
	erg_c = random_number(MAX_PICS);
	//printf("Ani: %d, %d, %d\tErg: %d, %d, %d\n\n", l, m, n, erg_a, erg_b, erg_c);

	// assign icons
	loops = 30;
	for(i = 0; i < loops; i++)
	{
		if (l > 9) l = 0;
		if (m > 9) m = 0;
		if (n > 9) n = 0;
		// simulate stopping of first and second slot
		if (i < (loops - 10))
			gtk_image_set_from_pixbuf(GTK_IMAGE(image1), icons[l]);
		else
			gtk_image_set_from_pixbuf(GTK_IMAGE(image1), icons[erg_a]);
		if (i < (loops - 5))
			gtk_image_set_from_pixbuf(GTK_IMAGE(image2), icons[m]);
		else
			gtk_image_set_from_pixbuf(GTK_IMAGE(image2), icons[erg_b]);

		gtk_image_set_from_pixbuf(GTK_IMAGE(image3), icons[n]);
		l++;
		m++;
		n++;
		// refresh()-replacement
		while (g_main_context_iteration(NULL, FALSE));
		g_usleep(LOOP_DELAY);
	}
	gtk_image_set_from_pixbuf(GTK_IMAGE(image3), icons[erg_c]);

	i = get_points(erg_a, erg_b, erg_c);
	points += (i * 50);

	update_labels(gb_window, FALSE, i);

	// change button image
	gtk_image_set_from_pixbuf(GTK_IMAGE(image4), icons[IMAGE_BUTTON_UP]);
	is_running = FALSE;

}


static void on_button4_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *dialog = create_help_dialog();
	GtkTextBuffer *buffer;

	g_signal_connect(G_OBJECT(dialog), "delete_event", G_CALLBACK(destroydialog), G_OBJECT(dialog));
	g_signal_connect(G_OBJECT(okbutton1), "clicked", G_CALLBACK(destroydialog), G_OBJECT(dialog));

	buffer = gtk_text_buffer_new(NULL);
	gtk_text_buffer_set_text(buffer, help_text, strlen(help_text));
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(textview1), buffer);

	gtk_widget_show(dialog);
}


static void init_strings(void)
{
	help_text = "GTK-Bandit - the one-armed bandit\n\nYour job in this game is to pull the arm of the bandit and then the figures begins to roll. Now hope that the rolls stop with the same figures and you will get 100 points. If you have anyhow two equal figures, you will get 50 points. Otherwise you won't get anything.\n";

	strcpy(info_texts[0], "Sorry boy, no equal figures in this turn.\n");
	strcpy(info_texts[1], "Ok, anyway two figures are equal.\n");
	strcpy(info_texts[2], "You lucky bastard, all three figures are equal.\n");
	strcpy(info_texts[3], "\n");
}


static void update_labels(GtkWidget *window, gint init, gint won)
{
	gchar pts[50];

	if (init)
	{
		gtk_label_set_text(GTK_LABEL(label2), "GTK-Bandit - The one-armed bandit");
	}
	gtk_label_set_text(GTK_LABEL(label3), info_texts[won]);

	g_snprintf(pts, 50, "Points: %4d\tRound: %2d\n", points, lap);
	gtk_label_set_text(GTK_LABEL(label1), pts);

}


static const GdkPixdata pic10 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 891, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\217\377\377\377\202333\234\377\377\377\203333\3\0\0\0""333\377\377\377"
  "\202333\227\377\377\377\1\20\0\0\205\0\0\0\3\"\"\"\21\21\21DDD\225\377"
  "\377\377\202\21\21\21\204DDD\1\21\21\21\203\0\0\0\1\21\21\21\224\377"
  "\377\377\1\21\21\21\206\314\230f\6DDD\21\21\21\"\"\"DDD\"\"\"\21\21\21"
  "\222\377\377\377\2\21\21\21\314\230f\207\377\313\231\3DDDUUU\314\230"
  "f\202DDD\1\21\21\21\220\377\377\377\2\21\21\21\314\230f\211\377\313\231"
  "\1DDD\203\377\313\231\2\314\230f\21\21\21\217\377\377\377\1\21\21\21"
  "\217\377\313\231\1\21\21\21\216\377\377\377\2\21\21\21\314\230f\217\377"
  "\313\231\2\314\230f\21\21\21\215\377\377\377\1\21\21\21\220\377\313\231"
  "\2\314\230f\21\21\21\214\377\377\377\2\21\21\21\314\230f\220\377\313"
  "\231\2\314\230f\21\21\21\214\377\377\377\2\21\21\21\314\230f\205\377"
  "\313\231\202\21\21\21\211\377\313\231\2\314\230f\21\21\21\215\377\377"
  "\377\202\21\21\21\1\314\230f\203\377\313\231\2UUU\210\210\210\203\377"
  "\313\231\202\21\21\21\204\377\313\231\2\314\230f\21\21\21\217\377\377"
  "\377\202\21\21\21\1\314\230f\206\377\313\231\2UUU\210\210\210\204\377"
  "\313\231\2\314\230f\21\21\21\221\377\377\377\202\21\21\21\202\314\230"
  "f\202\"\"\"\207\377\313\231\2\314\230f\21\21\21\223\377\377\377\202\21"
  "\21\21\2\"\"\"www\202\314\230f\204\377\313\231\202\314\230f\1\21\21\21"
  "\214\377\377\377\205\21\21\21\1\"\"\"\202333\4\"\"\"333\20\0\0\"\"\""
  "\210UUU\1\21\21\21\213\377\377\377\1\21\21\21\202\314\230f\202www\3U"
  "UUDDD333\202\"\"\"\2\21\21\21\20\0\0\202\21\21\21\3\"\"\"333DDD\202U"
  "UU\2\314\230f\21\21\21\214\377\377\377\1\21\21\21\205\377\313\231\202"
  "www\204DDD\202www\204\377\313\231\1\21\21\21\215\377\377\377\2\21\21"
  "\21\314\230f\217\377\313\231\2\314\230f\21\21\21\216\377\377\377\1\21"
  "\21\21\217\377\313\231\1\21\21\21\217\377\377\377\2\21\21\21\314\230"
  "f\215\377\313\231\2\314\230f\21\21\21\216\377\377\377\1www\202\21\21"
  "\21\1\314\230f\213\377\313\231\1\314\230f\203\21\21\21\1www\214\377\377"
  "\377\1\21\21\21\202\377\313\231\2\21\21\21\314\230f\211\377\313\231\1"
  "\314\230f\202\21\21\21\202\377\313\231\1\21\21\21\214\377\377\377\1w"
  "ww\202\21\21\21\1\230\313\313\202\21\21\21\207\314\230f\202\21\21\21"
  "\202\230\313\313\202\21\21\21\1www\216\377\377\377\1\21\21\21\203\230"
  "\313\313\207\21\21\21\204\230\313\313\1\21\21\21\221\377\377\377\202"
  "\21\21\21\204\231\314\377\2DDD3\231e\204\231\314\377\202\21\21\21\223"
  "\377\377\377\1\21\21\21\204\231\314\377\2DDD3\231e\204\231\314\377\1"
  "\21\21\21\224\377\377\377\1\21\21\21\204\231\314\377\2DDD3\231e\204\231"
  "\314\377\1\21\21\21\224\377\377\377\1\21\21\21\204\231\314\377\2DDD3"
  "\231e\204\231\314\377\1\21\21\21\223\377\377\377\1\21\21\21\205\231\314"
  "\377\202\21\21\21\205\231\314\377\1\21\21\21\222\377\377\377\206\21\21"
  "\21\202\377\377\377\206\21\21\21\211\377\377\377"
};


static const GdkPixdata pic1 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1519, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\214\377\377\377\210\21\21\21\226\377\377\377\202\21\21\21\210\314e\0"
  "\202\21\21\21\222\377\377\377\202\21\21\21\202\314e\0\210\375\230\0\202"
  "\314e\0\202\21\21\21\217\377\377\377\1\21\21\21\202\314e\0\215\375\230"
  "\0\2\314e\0\21\21\21\215\377\377\377\2\21\21\21\314e\0\220\375\230\0"
  "\2\314e\0\21\21\21\213\377\377\377\2\21\21\21\314e\0\222\375\230\0\2"
  "\314e\0\21\21\21\211\377\377\377\2\21\21\21\2302\0\207\375\230\0\1\375"
  "e\0\204\2302\0\1\375e\0\207\375\230\0\2\2302\0\21\21\21\210\377\377\377"
  "\1\21\21\21\206\375\230\0\2\314e\0e22\202\"\"\"\202\314\230f\202\"\""
  "\"\2e22\314e\0\205\375\230\0\2\314e\0\21\21\21\207\377\377\377\2\21\21"
  "\21\2302\0\205\375\230\0\204\"\"\"\1\314\230f\202\377\313\231\1\314\230"
  "f\203\"\"\"\1e22\205\375\230\0\2\2302\0\21\21\21\206\377\377\377\2\21"
  "\21\21\314e\0\203\375\230\0\1\375e\0\204\"\"\"\1\210\210\210\204\377"
  "\313\231\2\252\252\252www\203\"\"\"\1\375e\0\203\375\230\0\2\314e\0\21"
  "\21\21\205\377\377\377\2\21\21\21\314e\0\204\375\230\0\203\"\"\"\1\210"
  "\210\210\202\377\377\377\1\210\210\210\202\377\313\231\1\252\252\252"
  "\202\377\377\377\1\273\273\273\203\"\"\"\1\375e\0\203\375\230\0\2\230"
  "2\0\21\21\21\204\377\377\377\2\21\21\21\314e\0\203\375\230\0\1\314e\0"
  "\202\"\"\"\1\210\210\210\204\377\377\377\202\210\210\210\204\377\377"
  "\377\1\210\210\210\202\"\"\"\1\314e\0\203\375\230\0\2\314e\0\21\21\21"
  "\204\377\377\377\2\21\21\21\314e\0\203\375\230\0\203\"\"\"\1\210\210"
  "\210\205\377\377\377\1\210\210\210\204\377\377\377\1\210\210\210\203"
  "\"\"\"\203\375\230\0\2\314e\0\21\21\21\204\377\377\377\2\21\21\21\314"
  "e\0\202\375\230\0\1\375e\0\203\"\"\"\1\210\210\210\203\377\377\377\5"
  "\0\0\0\377\377\377\210\210\210\377\377\377\0\0\0\202\377\377\377\1\210"
  "\210\210\203\"\"\"\1\314e\0\202\375\230\0\2\314e\0\21\21\21\204\377\377"
  "\377\2\21\21\21\314e\0\202\375\230\0\1\314e\0\203\"\"\"\1\210\210\210"
  "\205\377\377\377\1\210\210\210\204\377\377\377\1\210\210\210\203\"\""
  "\"\1\314e\0\202\375\230\0\2\314e\0\21\21\21\204\377\377\377\2\21\21\21"
  "\314e\0\202\375\230\0\1\314e\0\203\"\"\"\1\210\210\210\205\377\377\377"
  "\1\210\210\210\204\377\377\377\1\210\210\210\203\"\"\"\1\314e\0\202\375"
  "\230\0\2\314e\0\21\21\21\204\377\377\377\2\21\21\21\314e\0\202\375\230"
  "\0\2\314e\0e22\202\"\"\"\1fff\204\377\377\377\3\210\210\210\377\313\231"
  "\210\210\210\203\377\377\377\1\210\210\210\202\"\"\"\2e22\314e\0\202"
  "\375\230\0\2\314e\0\21\21\21\204\377\377\377\2\21\21\21\2302\0\202\375"
  "\230\0\2\375e\0\375\230\0\203\"\"\"\1fff\202\377\377\377\1\210\210\210"
  "\203\377\313\231\3\210\210\210\377\377\377\210\210\210\203\"\"\"\2\314"
  "e\0\375e\0\202\375\230\0\2\2302\0\21\21\21\205\377\377\377\2\21\21\21"
  "\314e\0\202\375\230\0\202\314e\0\203\"\"\"\202\210\210\210\205\377\313"
  "\231\1\210\210\210\204\"\"\"\203\375\230\0\2\314e\0\21\21\21\206\377"
  "\377\377\2\21\21\21\314e\0\202\375\230\0\1\375e\0\202\314e\0\203\"\""
  "\"\202\314\230f\202\377\313\231\202\314\230f\204\"\"\"\202\314e\0\202"
  "\375\230\0\2\314e\0\21\21\21\207\377\377\377\2\21\21\21\314e\0\202\375"
  "\230\0\1\314e\0\202\375\230\0\203\"\"\"\1\210\210\210\202\314\230f\1"
  "\210\210\210\203\"\"\"\3e22\375\230\0\314e\0\203\375\230\0\1\21\21\21"
  "\210\377\377\377\2\21\21\21\2302\0\203\375\230\0\1\314e\0\202\375\230"
  "\0\1\314e\0\206\"\"\"\1\314e\0\202\375e\0\1\314e\0\203\375\230\0\2\230"
  "2\0\21\21\21\211\377\377\377\2\21\21\21\314e\0\203\375\230\0\2\375e\0"
  "\314e\0\203\375\230\0\202\314e\0\1\230e\0\202\375\230\0\2\314e\0\375"
  "e\0\203\375\230\0\2\314e\0\21\21\21\213\377\377\377\2\21\21\21\314e\0"
  "\204\375\230\0\203\314e\0\3\3142\0\375e\0\3142\0\202\314e\0\204\375\230"
  "\0\2\314e\0\21\21\21\215\377\377\377\2\21\21\21\314e\0\206\375\230\0"
  "\3\3142\0\375\230\0\3142\0\205\375\230\0\1\314e\0\202\21\21\21\214\377"
  "\377\377\2\21\21\21\314e\0\202\21\21\21\202\314e\0\203\375\230\0\3\314"
  "2\0\375\230\0\3142\0\203\375\230\0\202\314e\0\1\21\21\21\202\314e\0\1"
  "\21\21\21\212\377\377\377\2\21\21\21\314e\0\202\375\230\0\1\314e\0\202"
  "\21\21\21\205\314e\0\1\3142\0\203\314e\0\202\21\21\21\1\314e\0\202\375"
  "\230\0\1\21\21\21\212\377\377\377\2\21\21\21\314e\0\204\375\230\0\1\314"
  "e\0\211\21\21\21\1\314e\0\204\375\230\0\2\314e\0\21\21\21\210\377\377"
  "\377\2\21\21\21\314e\0\202\375\230\0\1\314e\0\207\375\230\0\1\3142\0"
  "\207\375\230\0\4\314e\0\375\230\0\314e\0\21\21\21\210\377\377\377\2\""
  "\"\"\2302\0\202\314e\0\2\3142\0\314e\0\206\375\230\0\1\3142\0\206\375"
  "\230\0\5\314e\0\3142\0\314e\0\2302\0\"\"\"\210\377\377\377\203\"\"\""
  "\3DDD\3142\0\314e\0\206\375\230\0\1\3142\0\206\375\230\0\3\314e\0\314"
  "2\0DDD\202\"\"\"\211\377\377\377\203\"\"\"\2\3142\0\314e\0\206\375\230"
  "\0\1\3142\0\206\375\230\0\2\314e\0\3142\0\202\"\"\"\205\377\377\377"
};


static const GdkPixdata pic2 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1251, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\206\377\377\377\224\0\"\0\213\377\377\377\1\0\"\0\224\0\210\0\1\0\""
  "\0\211\377\377\377\2\0\"\0\0\210\0\224\0\272\0\2\0\210\0\0\"\0\210\377"
  "\377\377\2\0\"\0\0\210\0\224\0\272\0\2\0\210\0\0\"\0\210\377\377\377"
  "\2\0\"\0\0\210\0\224\0\272\0\2\0\210\0\0\"\0\210\377\377\377\1\0\"\0"
  "\202\0\210\0\222\0\"\0\202\0\210\0\1\0\"\0\210\377\377\377\3\0\"\0\0"
  "\210\0\0\"\0\222\0T\0\3\0\"\0\0\210\0\0\"\0\210\377\377\377\3\0\"\0\0"
  "\210\0\0\"\0\222\0T\0\3\0\"\0\0\210\0\0\"\0\210\377\377\377\3\0\"\0\0"
  "\210\0\0\"\0\222\0T\0\3\0\"\0\0\210\0\0\"\0\210\377\377\377\203\0\"\0"
  "\203\0T\0\214\0\"\0\203\0T\0\203\0\"\0\210\377\377\377\4\0\"\0\0\210"
  "\0\0\"\0\0T\0\202\0\"\0\214\314\230f\202\0\"\0\4\0T\0\0\"\0\0\210\0\0"
  "\"\0\207\377\377\377\1\0\"\0\202\0\210\0\202\0\"\0\202\314\230f\1\252"
  "\252\252\203\377\377\377\1\314\314\314\202\377\313\231\1\314\314\314"
  "\203\377\377\377\1\252\252\252\202\314\230f\202\0\"\0\202\0\210\0\1\0"
  "\"\0\205\377\377\377\10\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\314\230f"
  "\377\313\231\252\252\252\205\377\377\377\202\314\314\314\205\377\377"
  "\377\10\252\252\252\377\313\231\314\230f\0\"\0\0\210\0\0\272\0\0\210"
  "\0\0\"\0\204\377\377\377\7\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\377\313"
  "\231\252\252\252\206\377\377\377\2\356\356\356\314\314\314\206\377\377"
  "\377\7\252\252\252\377\313\231\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\203"
  "\377\377\377\10\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\314\230f\377\313"
  "\231\252\252\252\204\377\377\377\1\21\21\21\202\377\377\377\3\335\335"
  "\335\377\377\377\21\21\21\204\377\377\377\10\252\252\252\377\313\231"
  "\314\230f\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\202\377\377\377\10\0\""
  "\0\0\210\0\0\272\0\0\210\0\0\"\0\314\230f\377\313\231\252\252\252\206"
  "\377\377\377\2\335\335\335\314\314\314\206\377\377\377\10\252\252\252"
  "\377\313\231\314\230f\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\202\377\377"
  "\377\5\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\202\377\313\231\1\252\252"
  "\252\206\377\377\377\202\252\252\252\206\377\377\377\1\252\252\252\202"
  "\377\313\231\5\0\"\0\0\210\0\0\272\0\0\210\0\0\"\0\202\377\377\377\1"
  "\0\"\0\202\0\210\0\2\0\"\0\314\230f\203\377\313\231\1\252\252\252\204"
  "\377\377\377\1\252\252\252\202\377\313\231\1\252\252\252\204\377\377"
  "\377\1\252\252\252\203\377\313\231\2\314\230f\0\"\0\202\0\210\0\1\0\""
  "\0\202\377\377\377\1\0\"\0\202\0\210\0\2\0\"\0\314\230f\204\377\313\231"
  "\204\252\252\252\204\377\313\231\204\252\252\252\204\377\313\231\2\314"
  "\230f\0\"\0\202\0\210\0\1\0\"\0\202\377\377\377\1\0\"\0\202\0\210\0\2"
  "\0\"\0\314\230f\224\377\313\231\2\314\230f\0\"\0\202\0\210\0\1\0\"\0"
  "\203\377\377\377\202\0\"\0\2\21\21\21\314\230f\224\377\313\231\2\314"
  "\230f\21\21\21\202\0\"\0\207\377\377\377\2\21\21\21\314\230f\222\377"
  "\313\231\2\314\230f\21\21\21\213\377\377\377\2\21\21\21\314\230f\205"
  "\377\313\231\2\314\230ffff\202DDD\2fff\314\230f\205\377\313\231\2\314"
  "\230f\21\21\21\215\377\377\377\2\21\21\21\314\230f\204\377\313\231\1"
  "DDD\204\21\21\21\1DDD\204\377\313\231\2\314\230f\21\21\21\217\377\377"
  "\377\202\21\21\21\1\314\230f\212\377\313\231\1\314\230f\202\21\21\21"
  "\220\377\377\377\2\21\21\21\0\252\0\202\21\21\21\210\314\230f\202\21"
  "\21\21\2\0\252\0\21\21\21\217\377\377\377\3\21\21\21\375e\0\230e\0\202"
  "\0\252\0\210\21\21\21\203\0\252\0\2\230e\0\21\21\21\215\377\377\377\1"
  "\21\21\21\203\375e\0\202\230e\0\211\0\252\0\202\230e\0\202\375e\0\1\21"
  "\21\21\214\377\377\377\1\21\21\21\205\375e\0\211\230e\0\204\375e\0\1"
  "\21\21\21\213\377\377\377\1\21\21\21\202\375e\0\1DDD\216\375e\0\1DDD"
  "\202\375e\0\1\21\21\21\212\377\377\377\1\21\21\21\202\375e\0\2DDD\375"
  "e\0\205DDD\202\375e\0\205DDD\2\375e\0DDD\202\375e\0\1\21\21\21\212\377"
  "\377\377\1\21\21\21\202\375e\0\3DDD\375e\0DDD\203\375e\0\1DDD\202\375"
  "e\0\1DDD\203\375e\0\3DDD\375e\0DDD\202\375e\0\1\21\21\21\205\377\377"
  "\377"
};


static const GdkPixdata pic3 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1017, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\215\377\377\377\206f2\0\231\377\377\377\1f2\0\206\377\3143\1f2\0\226"
  "\377\377\377\203\21\21\21\206\230e\0\204\21\21\21\221\377\377\377\202"
  "\21\21\21\215\0e\230\202\21\21\21\215\377\377\377\202\21\21\21\202\0"
  "e\230\215\0\231\314\202\0e\230\202\21\21\21\212\377\377\377\1\21\21\21"
  "\202\0e\230\221\0\231\314\202\0e\230\1\21\21\21\210\377\377\377\2\21"
  "\21\21\0e\230\225\0\231\314\2\0e\230\21\21\21\206\377\377\377\2\21\21"
  "\21\0e\230\210\0\231\314\212\0\230\230\205\0\231\314\2\0e\230\21\21\21"
  "\204\377\377\377\2\21\21\21\0e\230\204\0\231\314\204\0\230\230\214e\230"
  "\0\203\0\230\230\3\0\231\314\0e\230\21\21\21\204\377\377\377\2\21\21"
  "\21\0e\230\202\0\231\314\1\0\230\230\205e\230\0\214\375\313\0\204e\230"
  "\0\3\0\230\230\0e\230\21\21\21\202\377\377\377\2\21\21\21\0e\230\202"
  "\0\231\314\202e\230\0\205\375\313\0\214\313\230\230\204\375\313\0\202"
  "e\230\0\1\21\21\21\202\377\377\377\2\21\21\21\0e\230\202e\230\0\202\375"
  "\313\0\205\313\230\230\213\377\313\231\1\314\230f\204\313\230\230\202"
  "\375\313\0\1e\230\0\202\21\21\21\202e\230\0\202\375\313\0\202\313\230"
  "\230\203\377\313\231\202\230\230e\1\231e3\210\377\313\231\203\230\230"
  "e\204\377\313\231\202\313\230\230\1\375\313\0\202\21\21\21\202\375\313"
  "\0\202\313\230\230\210\377\313\231\3\230\230e\231e3\230ee\202\377\313"
  "\231\3\314\230fee2\230\230e\211\377\313\231\1\313\230\230\202\21\21\21"
  "\202\313\230\230\214\377\313\231\1\230\230e\202ee2\1\230\230e\213\377"
  "\313\231\1\314\230f\202\21\21\21\1\314\230f\213\377\313\231\202\314\230"
  "f\1\230ee\202\230\230e\1\231e3\202\230\230e\211\377\313\231\1\314\230"
  "f\202\21\21\21\1\314\230f\210\377\313\231\202\230\230e\1\314\230f\202"
  "\230\230e\204\377\313\231\4\313\313\230\230\230eee2\230\230e\207\377"
  "\313\231\1\314\230f\202\21\21\21\1\314\230f\207\377\313\231\203\230\230"
  "e\211\377\313\231\1\313\230\230\202\230ee\206\377\313\231\5\314\230f"
  "\21\21\21\377\377\377\21\21\21\314\230f\232\377\313\231\2\314\230f\21"
  "\21\21\202\377\377\377\2\21\21\21\314\230f\232\377\313\231\2\314\230"
  "f\21\21\21\202\377\377\377\3T\0\0\21\21\21\314\230f\230\377\313\231\5"
  "\314\230f\21\21\21T\0\0\377\377\377T\0\0\202\314\0\0\2\21\21\21\314\230"
  "f\210\377\313\231\3\231e3\21\21\21\0\20\0\202\0\0\0\1ee2\210\377\313"
  "\231\2\314\230f\21\21\21\202\314\0\0\1T\0\0\204\314\0\0\1\21\21\21\202"
  "\314\230f\206\377\313\231\1""333\205\0\0\0\1""21\0\206\377\313\231\2"
  "\314\230f\21\21\21\211\314\0\0\202\21\21\21\202\314\230f\205\377\313"
  "\231\6""21\0\"\"\"\314\230fe22\0\0\0\231e3\204\377\313\231\202\314\230"
  "f\1\21\21\21\205\314\0\0\1T\0\0\206\314\0\0\202\21\21\21\202\314\230"
  "f\213\377\313\231\202\314\230f\202\21\21\21\205\314\0\0\3T\0\0\375\230"
  "\0T\0\0\207\314\0\0\202\21\21\21\213\314\230f\202\21\21\21\206\314\0"
  "\0\5T\0\0\375\230\0\375\313\0\375\230\0T\0\0\210\314\0\0\213\21\21\21"
  "\207\314\0\0\2T\0\0\375\230\0\203\375\313\0\2\375\230\0T\0\0\230\314"
  "\0\0\2T\0\0\375\230\0\204\375\313\0\2\375\230\0T\0\0\214\314\0\0\1\21"
  "\21\21\213\314\0\0\2T\0\0\375\230\0\205\375\313\0\2\375\230\0T\0\0\226"
  "\314\0\0\2T\0\0\375\230\0\205\375\313\0\202\375\230\0\1T\0\0\213\314"
  "\0\0\1\21\21\21\212\314\0\0\1T\0\0\202\375\230\0\203\375\313\0\1\375"
  "\230\0\202T\0\0\230\314\0\0\202T\0\0\202\375\230\0"
};


static const GdkPixdata pic4 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1034, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\215\377\377\377\205D\0\0\232\377\377\377\1D\0\0\205\314\0\0\1D\0\0\227"
  "\377\377\377\2\0\0\0D\0\0\207\314\0\0\1D\0\0\202\0\0\0\222\377\377\377"
  "\202\0\0\0\2\0""3fD\0\0\207\314\0\0\1D\0\0\202\0""3f\202\0\0\0\217\377"
  "\377\377\1\0\0\0\203\0""3f\1D\0\0\207\314\0\0\1D\0\0\204\0""3f\1\0\0"
  "\0\215\377\377\377\1\0\0\0\205\0""3f\1D\0\0\205\314\0\0\1D\0\0\206\0"
  "3f\1\0\0\0\213\377\377\377\1\0\0\0\207\0""3f\205D\0\0\210\0""3f\1\0\0"
  "\0\211\377\377\377\1\0\0\0\226\0""3f\1\0\0\0\210\377\377\377\1\0\0\0"
  "\226\0""3f\1\0\0\0\207\377\377\377\1\0\0\0\230\0""3f\1\0\0\0\206\377"
  "\377\377\1\0\0\0\204\0""3f\217\21\21\21\205\0""3f\1\0\0\0\205\377\377"
  "\377\1\0\0\0\202\0""3f\203\21\21\21\217\314\0\0\204\21\21\21\202\0""3"
  "f\1\0\0\0\204\377\377\377\1\0\0\0\202\21\21\21\226\314\0\0\202\21\21"
  "\21\1\0\0\0\204\377\377\377\1D\0\0\207\314\0\0\214\31322\207\314\0\0"
  "\1D\0\0\204\377\377\377\1D\0\0\203\314\0\0\1\31322\203\314\230f\1\252"
  "\252\252\203\377\377\377\1\252\252\252\202\314\230f\1\252\252\252\203"
  "\377\377\377\1\252\252\252\203\314\230f\1\31322\203\314\0\0\1D\0\0\204"
  "\377\377\377\2D\0\0\314\0\0\202\314\230f\203\377\313\231\1\252\252\252"
  "\205\377\377\377\202\252\252\252\205\377\377\377\1\252\252\252\203\377"
  "\313\231\202\314\230f\2\314\0\0D\0\0\204\377\377\377\2\21\21\21\314\230"
  "f\204\377\313\231\1\252\252\252\206\377\377\377\202\335\335\335\206\377"
  "\377\377\1\252\252\252\204\377\313\231\2\314\230f\21\21\21\204\377\377"
  "\377\2\21\21\21\314\230f\204\377\313\231\1\252\252\252\204\377\377\377"
  "\2\0\0\0\377\377\377\202\335\335\335\2\377\377\377\0\0\0\204\377\377"
  "\377\1\252\252\252\204\377\313\231\2\314\230f\21\21\21\204\377\377\377"
  "\2\21\21\21\314\230f\204\377\313\231\1\252\252\252\206\377\377\377\202"
  "\335\335\335\206\377\377\377\1\252\252\252\204\377\313\231\2\314\230"
  "f\21\21\21\204\377\377\377\2\21\21\21\314\230f\204\377\313\231\1\252"
  "\252\252\206\377\377\377\202\252\252\252\206\377\377\377\1\252\252\252"
  "\204\377\313\231\2\314\230f\21\21\21\205\377\377\377\1\21\21\21\205\377"
  "\313\231\1\252\252\252\204\377\377\377\1\252\252\252\202\377\313\231"
  "\1\252\252\252\204\377\377\377\1\252\252\252\205\377\313\231\1\21\21"
  "\21\206\377\377\377\2\21\21\21\314\230f\205\377\313\231\204\252\252\252"
  "\204\377\313\231\204\252\252\252\205\377\313\231\2\314\230f\21\21\21"
  "\207\377\377\377\1\21\21\21\226\377\313\231\1\21\21\21\210\377\377\377"
  "\2\21\21\21\314\230f\224\377\313\231\2\314\230f\21\21\21\211\377\377"
  "\377\2\21\21\21\314\230f\207\377\313\231\1\314\230f\202UUU\1\314\230"
  "f\207\377\313\231\2\314\230f\21\21\21\213\377\377\377\2\21\21\21\314"
  "\230f\206\377\313\231\1UUU\202\0\0\0\1UUU\206\377\313\231\2\314\230f"
  "\21\21\21\215\377\377\377\2\21\21\21\314\230f\205\377\313\231\1UUU\202"
  "\0\0\0\1UUU\205\377\313\231\2\314\230f\21\21\21\217\377\377\377\202\21"
  "\21\21\1\314\230f\203\377\313\231\1\314\230f\202UUU\1\314\230f\203\377"
  "\313\231\1\314\230f\202\21\21\21\220\377\377\377\2\21\21\21\314\0\0\202"
  "\21\21\21\210\314\230f\202\21\21\21\2\314\0\0\21\21\21\217\377\377\377"
  "\1\21\21\21\202f2\0\202\314\0\0\210\21\21\21\202\314\0\0\202f2\0\1\21"
  "\21\21\215\377\377\377\1\21\21\21\204f2\0\205\314\0\0\1\0\0\0\204\314"
  "\0\0\204f2\0\1\21\21\21\214\377\377\377\1\21\21\21\211f2\0\1\0\0\0\210"
  "f2\0\1\21\21\21\206\377\377\377"
};


static const GdkPixdata pic5 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1451, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\211\377\377\377\205\21\21\21\202\377\377\377\207\21\21\21\214\377\377"
  "\377\206\21\21\21\205\252\252\252\202\21\21\21\207\252\252\252\205\21"
  "\21\21\206\377\377\377\1\21\21\21\207\252\252\252\203\377\377\377\204"
  "\252\252\252\205\377\377\377\206\252\252\252\1\21\21\21\204\377\377\377"
  "\1\21\21\21\202\252\252\252\226\377\377\377\203\252\252\252\1\21\21\21"
  "\203\377\377\377\2\21\21\21\252\252\252\225\377\377\377\205\252\252\252"
  "\1\21\21\21\203\377\377\377\2\21\21\21\252\252\252\202\377\377\377\203"
  "\252\252\252\203\377\377\377\203\252\252\252\203\377\377\377\203\252"
  "\252\252\204\377\377\377\2\252\252\252\21\21\21\203\252\252\252\1\21"
  "\21\21\203\377\377\377\3\21\21\21\252\252\252\377\377\377\202\252\252"
  "\252\2\21\21\21\252\252\252\203\377\377\377\3\252\252\252\21\21\21\252"
  "\252\252\203\377\377\377\3\252\252\252\21\21\21\252\252\252\204\377\377"
  "\377\1\252\252\252\204\21\21\21\204\377\377\377\1\21\21\21\203\252\252"
  "\252\202\21\21\21\202\252\252\252\2\377\377\377\252\252\252\202\21\21"
  "\21\202\252\252\252\202\377\377\377\1\252\252\252\202\21\21\21\204\252"
  "\252\252\3\21\21\21\252\252\252\21\21\21\207\377\377\377\203\21\21\21"
  "\202\252\252\252\2\21\21\21\252\252\252\202\21\21\21\202\252\252\252"
  "\1\21\21\21\203\252\252\252\1\21\21\21\202\252\252\252\204\21\21\21\202"
  "\252\252\252\1\21\21\21\210\377\377\377\2\21\21\21\252\252\252\202\377"
  "\377\377\2\252\252\252\21\21\21\202\252\252\252\202\377\377\377\5\252"
  "\252\252\21\21\21\252\252\252\21\21\21\252\252\252\202\377\377\377\203"
  "\252\252\252\1\21\21\21\202\252\252\252\1\21\21\21\210\377\377\377\2"
  "\21\21\21\252\252\252\202\377\377\377\3\252\252\252\21\21\21\252\252"
  "\252\204\377\377\377\3\252\252\252\21\21\21\252\252\252\205\377\377\377"
  "\2\252\252\252\21\21\21\202\252\252\252\1\21\21\21\210\377\377\377\2"
  "\21\21\21\252\252\252\202\377\377\377\3\252\252\252\21\21\21\252\252"
  "\252\204\377\377\377\3\252\252\252\21\21\21\252\252\252\205\377\377\377"
  "\2\252\252\252\21\21\21\202\252\252\252\1\21\21\21\210\377\377\377\2"
  "\21\21\21\252\252\252\203\377\377\377\1\252\252\252\206\377\377\377\1"
  "\252\252\252\206\377\377\377\2\252\252\252\21\21\21\202\252\252\252\1"
  "\21\21\21\210\377\377\377\2\21\21\21\252\252\252\204\377\377\377\213"
  "\252\252\252\203\377\377\377\4\252\252\252\377\377\377\252\252\252\21"
  "\21\21\210\377\377\377\2\21\21\21\252\252\252\203\377\377\377\202\252"
  "\252\252\212\21\21\21\202\252\252\252\203\377\377\377\2\252\252\252\21"
  "\21\21\210\377\377\377\1\21\21\21\203\252\252\252\203\21\21\21\1f2\0"
  "\203www\203f2\0\203\252\252\252\202\21\21\21\202\252\252\252\3\377\377"
  "\377\252\252\252\21\21\21\210\377\377\377\2\21\21\21\252\252\252\202"
  "\21\21\21\203f2\0\2www\335\335\335\202\377\377\377\3wwwf2\0\252\252\252"
  "\202\377\377\377\3\335\335\335\252\252\252f2\0\202\21\21\21\202\252\252"
  "\252\1\21\21\21\210\377\377\377\202\21\21\21\204f2\0\1www\205\377\377"
  "\377\1\252\252\252\205\377\377\377\1\252\252\252\202f2\0\203\21\21\21"
  "\210\377\377\377\202\"\"\"\203f2\0\1www\204\377\377\377\5\"\"\"\377\377"
  "\377\273\273\273\377\377\377\"\"\"\204\377\377\377\1\252\252\252\202"
  "f2\0\2DDD\"\"\"\210\377\377\377\202\"\"\"\203f2\0\1www\204\377\377\377"
  "\5\252\252\252\377\377\377\252\252\252\377\377\377\252\252\252\204\377"
  "\377\377\1\252\252\252\202f2\0\2""333\"\"\"\210\377\377\377\2\"\"\"\0"
  "\0\0\203f2\0\1www\205\377\377\377\3wwwf2\0\252\252\252\205\377\377\377"
  "\1\252\252\252\202f2\0\2\0\0\0\"\"\"\210\377\377\377\3\"\"\"\0\0\0\""
  "\"\"\203f2\0\1www\203\377\377\377\1\252\252\252\203f2\0\1\252\252\252"
  "\203\377\377\377\1\252\252\252\202f2\0\3\"\"\"\0\0\0\"\"\"\210\377\377"
  "\377\3\"\"\"\0\0\0\"\"\"\204f2\0\203www\205f2\0\203\252\252\252\203f"
  "2\0\3\"\"\"\0\0\0\"\"\"\210\377\377\377\3\"\"\"\0\0\0\"\"\"\206f2\0\2"
  "\0\0\0\"\"\"\203f2\0\2\"\"\"\0\0\0\205f2\0\3\"\"\"\0\0\0\"\"\"\210\377"
  "\377\377\3\"\"\"\0\0\0\"\"\"\206f2\0\1\"\"\"\205\0\0\0\1\"\"\"\204f2"
  "\0\1\"\"\"\202\0\0\0\1\"\"\"\210\377\377\377\1\"\"\"\202\0\0\0\1\"\""
  "\"\203f2\0\1\"\"\"\202\0\0\0\3\21\21\21\"\"\"\0\0\0\202\"\"\"\2\0\0\0"
  "\21\21\21\203f2\0\1\"\"\"\202\0\0\0\1\"\"\"\210\377\377\377\1\"\"\"\202"
  "\0\0\0\6\21\21\21\"\"\"f2\0\"\"\"\0\0\0\"\"\"\206f2\0\5\"\"\"\0\0\0\""
  "\"\"f2\0\"\"\"\203\0\0\0\1""333\211\377\377\377\1\"\"\"\203\0\0\0\3\""
  "\"\"\0\0\0\"\"\"\202f2\0\205\0\0\0\4f2\0\"\"\"\0\0\0\"\"\"\203\0\0\0"
  "\1""333\212\377\377\377\1\"\"\"\205\0\0\0\204f2\0\3\"\"\"\0\0\0\"\"\""
  "\203f2\0\205\0\0\0\1""333\213\377\377\377\1\"\"\"\205\0\0\0\203\"\"\""
  "\203\0\0\0\202\"\"\"\205\0\0\0\1""333\215\377\377\377\1\"\"\"\220\0\0"
  "\0\1""333\217\377\377\377\216\"\"\"\202333\211\377\377\377"
};


static const GdkPixdata pic6 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1305, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\204\377\377\377\230DDD\210\377\377\377\1DDD\226\356\356\356\1DDD\210"
  "\377\377\377\1DDD\226\356\356\356\1DDD\210\377\377\377\1DDD\226\356\356"
  "\356\1DDD\210\377\377\377\1DDD\226\356\356\356\1DDD\210\377\377\377\1"
  "\210\0\0\226\314\0\0\1\210\0\0\210\377\377\377\1\210\0\0\226\314\0\0"
  "\1\210\0\0\204\377\377\377\203DDD\2www\273\273\273\226\356\356\356\2"
  "\273\273\273www\203DDD\204\377\377\377\3\21\21\21\0\0\0www\222\314\230"
  "f\3www\0\0\0\21\21\21\210\377\377\377\3\21\21\21""21\0\314\230f\222\377"
  "\313\231\3\314\230f21\0\21\21\21\210\377\377\377\3\21\21\21f2\0\314\230"
  "f\222\377\313\231\3\314\230ff2\0\21\21\21\210\377\377\377\3\21\21\21"
  "f2\0\314\230f\223\377\313\231\3\314\230ff2\0\21\21\21\206\377\377\377"
  "\3\21\21\21""21\0\231e3\203\377\313\231\205\314\230f\205\377\313\231"
  "\204\314\230f\204\377\313\231\3f2\0\314\230f\21\21\21\204\377\377\377"
  "\2\21\21\21\314\230f\203UUU\2\314\230f\20\0\0\204\21\21\21\2\0\0\0ww"
  "w\202\377\313\231\2www\"\0\0\204\21\21\21\1\20\0\0\202\314\230f\202U"
  "UU\2\314\230f\21\21\21\204\377\377\377\5\21\21\21\314\230ff2\0\377\313"
  "\231\210\210\210\202\21\21\21\205\"\"\"\5\0\0\0\210\210\210\252\252\252"
  "\"\"\"\0\0\0\204\"\"\"\202\21\21\21\5UUU\377\313\231f2\0\314\230f\21"
  "\21\21\204\377\377\377\3\21\21\21\314\230ff2\0\202\377\313\231\1\"\0"
  "\0\206\"\"\"\5\0\0\20\210\210\210\377\313\231\0\0\"\21\21\21\205\"\""
  "\"\6\0\0\0\210\210\210\377\313\231f2\0\314\230f\21\21\21\205\377\377"
  "\377\2\21\21\21\314\230f\202\377\313\231\1\314\230f\205\21\21\21\2\0"
  "\0\0fff\202\377\313\231\2UUU\0\0\0\205\21\21\21\1""333\203\377\313\231"
  "\2\314\230f\21\21\21\205\377\377\377\2\21\21\21\314\230f\203\377\313"
  "\231\1fff\204DDD\1fff\204\377\313\231\1fff\204DDD\1fff\203\377\313\231"
  "\2\314\230f\21\21\21\206\377\377\377\1\21\21\21\202\314\230f\225\377"
  "\313\231\2\314\230f\21\21\21\207\377\377\377\2\21\21\21\314\230f\213"
  "\377\313\231\1\314\230f\211\377\313\231\2\314\230f\21\21\21\210\377\377"
  "\377\2\21\21\21\314\230f\210\377\313\231\202\314\230f\211\377\313\231"
  "\2\314\230f\21\21\21\211\377\377\377\1\21\21\21\202\314\230f\206\377"
  "\313\231\202\314\230f\2\377\313\231\314\230f\210\377\313\231\2\314\230"
  "f\21\21\21\212\377\377\377\3\21\21\21\377\313\231\314\230f\204\377\313"
  "\231\202\314\230f\202\377\313\231\203\314\230f\205\377\313\231\2\314"
  "\230f\21\21\21\213\377\377\377\1\21\21\21\203\314\230f\202\377\313\231"
  "\202\314\230f\202\377\313\231\1www\202\377\313\231\202\314\230f\203\377"
  "\313\231\202\314\230f\1\21\21\21\214\377\377\377\2\21\21\21\377\313\231"
  "\204\314\230f\202\377\313\231\4\"\"\"\0\0\0\314\230f\377\313\231\202"
  "\314\230f\202\377\313\231\202\314\230f\1\21\21\21\215\377\377\377\3\21"
  "\21\21\314\230f\377\313\231\202\314\230f\203\377\313\231\202\0\0\0\1"
  "\314\230f\202\377\313\231\203\314\230f\2\377\313\231\21\21\21\215\377"
  "\377\377\5\21\21\21\314ff\210\0\0\231e3\377\313\231\202\314\230f\202"
  "\377\313\231\2\210\210\210www\203\377\313\231\202\314\230f\2\377\313"
  "\231\21\21\21\215\377\377\377\1\21\21\21\202\375\0""2\4\3132e\210\0\0"
  "\31322\377\313\231\203\314\230f\203\377\313\231\203\314\230f\4\377\313"
  "\231\231e3\230e\0\21\21\21\213\377\377\377\13\21\21\21\3142\0\375\0""2"
  "\314\0""2\3773e\334\0\0\210\0\0\3132e\231e3\314\230f\377\313\231\204"
  "\314\230f\7\377\313\231\314\230fv\0\0\272\0\0\3773\230\272\0\0\21\21"
  "\21\212\377\377\377\1\21\21\21\202\375\0""2\5\314\0""2\3132e\334\0\0"
  "\377\231\231\31322\202\210\0\0\15\23133\210\0\0\230ee\23133\210\0\0\252"
  "\0\0v\0\0\356\0\0\375\0""2\377\231\231\375\0""2\272\0\0\21\21\21\210"
  "\377\377\377\3\21\21\21\31322\3132e\202\314\0""2\15\377\231\231\334\0"
  "\0\377\231\231\37733\356\0\0\377\231\231\3773e\356\0\0\377\231\231\375"
  "\0""2\356\0\0\375\0""2\377\231\231\202\375\0""2\1\377\231\231\203\375"
  "\0""2\1\21\21\21\206\377\377\377\17\21\21\21\2302\0\31322\377\231\231"
  "\314\0\0\37733\377\231\231\334\0\0\377\231\231\37733\356\0\0\377\231"
  "\231\31322\356\0\0\377\231\231\202\375\0""2\7\375\0e\377\231\231\356"
  "\0\0\375\0""2\377\231\231\356\0\0\377\231\231\202\375\0""2\202\21\21"
  "\21\202\377\377\377"
};


static const GdkPixdata pic7 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1274, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\377\377\377\377\220\377\377\377\1\"\"\"\2042\0\0\1\"\"\"\202\377\377"
  "\377\1\230e\0\222\377\377\377\4\230e\0f2\0\377\377\377\"\"\"\2022\0\0"
  "\204f2\0\2022\0\0\3\"\"\"\377\376ef2\0\203\377\377\377\203\"\"\"\204"
  "\377\377\377\203\"\"\"\204\377\377\377\2f2\0\377\376e\2022\0\0\207f2"
  "\0\6""2\0\0T\0\0\377\376ef2\0\377\377\377\"\"\"\2052\0\0\2\377\377\377"
  "\"\"\"\2052\0\0\1\"\"\"\202\377\377\377\3f2\0\377\376eT\0\0\2032\0\0"
  "\203f2\0\2032\0\0\2\21\21\21f2\0\2032\0\0\203f2\0\1""2\0\0\202\"\"\""
  "\1""2\0\0\206f2\0\2052\0\0\3fff\273\273\273\231\231\231\2032\0\0\3\231"
  "\231\231\252\252\252DDD\2022\0\0\205f2\0\2""2\0\0\"\"\"\202\377\377\377"
  "\2\"\"\"2\0\0\210f2\0\2""2\0\0\273\273\273\203\377\377\377\3\314\314"
  "\3142\0\0\356\356\356\203\377\377\377\2\231\231\2312\0\0\204f2\0\2""2"
  "\0\0\"\"\"\205\377\377\377\2022\0\0\205f2\0\2""2\0\0\273\273\273\205"
  "\377\377\377\1\210\210\210\205\377\377\377\3UUU2\0\0f2\0\2022\0\0\211"
  "\377\377\377\2052\0\0\1\21\21\21\206\377\377\377\1\314\314\314\206\377"
  "\377\377\2032\0\0\213\377\377\377\1""2\0\0\202\"\"\"\2""2\0\0UUU\206"
  "\377\377\377\1\210\210\210\206\377\377\377\4UUU2\0\0\"\"\"2\0\0\211\377"
  "\377\377\1""2\0\0\202\"\"\"\5f2\0""2\0\0UUU\377\377\377\21\21\21\204"
  "\377\377\377\3\0\0\"\377\377\377\21\21\21\204\377\377\377\4UUU2\0\0\""
  "\"\"2\0\0\211\377\377\377\2""2\0\0\"\"\"\202f2\0\2""2\0\0\21\21\21\205"
  "\377\377\377\3www2\0\0\252\252\252\205\377\377\377\2""2\0\0f2\0\202\""
  "\"\"\1""2\0\0\207\377\377\377\1""2\0\0\202\"\"\"\203f2\0\2""2\0\0\210"
  "\210\210\203\377\377\377\5\210\210\2102\0\0f2\0""2\0\0\210\210\210\203"
  "\377\377\377\2www2\0\0\202f2\0\2\"\"\"2\0\0\207\377\377\377\2""2\0\0"
  "\"\"\"\205f2\0\3""2\0\0""333DDD\2022\0\0\203f2\0\2022\0\0\3DDD3332\0"
  "\0\203f2\0\202\"\"\"\1""2\0\0\206\377\377\377\2""2\0\0\"\"\"\206f2\0"
  "\2022\0\0\1\20\0\0\206f2\0\2022\0\0\205f2\0\2\"\"\"2\0\0\206\377\377"
  "\377\2""2\0\0\"\"\"\207f2\0\1""2\0\0\210f2\0\1""2\0\0\205f2\0\2\"\"\""
  "2\0\0\206\377\377\377\2""2\0\0\"\"\"\207f2\0\1""2\0\0\210f2\0\1""2\0"
  "\0\205f2\0\2\"\"\"2\0\0\205\377\377\377\1""2\0\0\202\"\"\"\206f2\0\1"
  "2\0\0\212f2\0\1""2\0\0\204f2\0\202\"\"\"\1""2\0\0\204\377\377\377\2""2"
  "\0\0\"\"\"\207f2\0\1""2\0\0\212f2\0\1""2\0\0\205f2\0\2\"\"\"2\0\0\204"
  "\377\377\377\2""2\0\0\"\"\"\206f2\0\3\"\"\"2\0\0f2\0\2102\0\0\3f2\0""2"
  "\0\0\"\"\"\204f2\0\2\"\"\"2\0\0\204\377\377\377\2""2\0\0\"\"\"\206f2"
  "\0\1\"\"\"\2022\0\0\1\210\210\210\202\313\230\313\2022\0""1\202\313\230"
  "\313\1www\2022\0\0\1\"\"\"\204f2\0\2\"\"\"2\0\0\204\377\377\377\2""2"
  "\0\0\"\"\"\207f2\0\5""2\0\0\2313e\313\230\313\20\0\0""2\0""1\202\314"
  "f\230\5e222\0\0\313\230\313\314f\2302\0\0\205f2\0\2\"\"\"2\0\0\204\377"
  "\377\377\2""2\0\0\"\"\"\207f2\0\14""2\0\0e22\230e\2302\0""1D\0\0\377"
  "\231\313\377\231\3762\0""1\20\0\0\230e\230e22\"\0\0\205f2\0\2\"\"\"2"
  "\0\0\204\377\377\377\2""2\0\0\"\"\"\210f2\0\3""2\0\0\230ee\377\231\313"
  "\203\377e\313\4\377e\376\377\231\313\230e\2302\0""1\206f2\0\2\"\"\"2"
  "\0\0\204\377\377\377\2""2\0\0\"\"\"\211f2\0\2""2\0\0\377e\376\2042\0"
  "\0\2\377e\3762\0\0\207f2\0\2\"\"\"2\0\0\204\377\377\377\2""2\0\0\"\""
  "\"\230f2\0\2\"\"\"2\0\0\204\377\377\377\2""2\0\0\"\"\"\230f2\0\2\"\""
  "\"2\0\0\204\377\377\377\2""2\0\0\"\"\"\230f2\0\2\"\"\"2\0\0\204\377\377"
  "\377\2""2\0\0\"\"\"\230f2\0\3\"\"\"2\0\0\377\377\377"
};


static const GdkPixdata pic8 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1552, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\214\377\377\377\207\21\21\21\226\377\377\377\203\21\21\21\207\314\230"
  "f\204\21\21\21\220\377\377\377\202\21\21\21\1\314\230f\203\377\313\231"
  "\1\314\230f\206\377\313\231\203fff\1\21\21\21\216\377\377\377\2\21\21"
  "\21\314\230f\203\377\313\231\202\314\230f\202\377\313\231\202\314\230"
  "f\204\377\313\231\203fff\1\21\21\21\214\377\377\377\2\21\21\21\314\230"
  "f\206\377\313\231\202\314\230f\203\377\313\231\1\314\230f\203\377\313"
  "\231\202fff\1\21\21\21\213\377\377\377\2\21\21\21\314\230f\205\377\313"
  "\231\202\314\230f\203\377\313\231\202\314\230f\205\377\313\231\202ff"
  "f\1\21\21\21\212\377\377\377\2\21\21\21\314\230f\210\377\313\231\202"
  "\314\230f\207\377\313\231\4\230eewww\314\230f\21\21\21\210\377\377\377"
  "\2\21\21\21fff\206\377\313\231\203\314\230f\206\377\313\231\1\314\230"
  "f\202UUU\4\314\230f\377\313\231\231\2303\21\21\21\207\377\377\377\1\21"
  "\21\21\202fff\204\377\313\231\202\314\230f\206\377\313\231\1\314\230"
  "f\203UUU\6\230\230e\314\230fUUU\377\313\231\231e3\21\21\21\207\377\377"
  "\377\1\21\21\21\202fff\212\377\313\231\1\231e3\202UUU\202\314\230f\202"
  "\377\313\231\2\314\230fUUU\202\314\230f\1\21\21\21\207\377\377\377\1"
  "\21\21\21\202fff\205\377\313\231\1\314\230f\202\"\"\"\3ee2\314\230f\231"
  "e3\202\314\230f\202\230\230e\202UUU\5\314\230f\230\230eUUU\314\230f\21"
  "\21\21\207\377\377\377\1\21\21\21\202fff\202\377\313\231\202\314\230"
  "f\2\231e3\20\0\0\202\210\210\210\5\0\0\20www\230\230e\230ee\314\230f"
  "\202www\203\377\313\231\4\314\230fUUU\314\230f\21\21\21\207\377\377\377"
  "\1\21\21\21\202fff\1\314\230f\202\230ee\11fff\0\0\0\356\356\356\335\335"
  "\335\273\273\273\377\377\377\0\0\20UUU\230\230e\204\377\313\231\1\314"
  "\230f\202UUU\202\314\230f\1\21\21\21\210\377\377\377\10\21\21\21fff\231"
  "\231\231fff\377\313\231\314\230f\"\"\"\377\377\377\202\0\0\0\6\356\356"
  "\356DDD\230\230e\314\230f\377\313\231\314\230f\203UUU\1\314\230f\202"
  "\377\313\231\2\314\230f\21\21\21\210\377\377\377\16\21\21\21\314\230"
  "f\377\313\231UUU\314\230fUUU\0\0\0\356\356\356\273\273\273\210\210\210"
  "\377\377\377\21\21\21www\314\230f\202UUU\1\314\230f\205\377\313\231\2"
  "\314\230f\21\21\21\210\377\377\377\12\21\21\21\231\2303\377\313\231\314"
  "\230fUUU\377\313\231\230ee\"\"\"\314\314\314\273\273\273\202333\1\210"
  "\210\210\211\377\313\231\2\314\230f\21\21\21\211\377\377\377\4\21\21"
  "\21\314\230f\377\313\231UUU\202\377\313\231\4""333\0\0\20\0\0\"333\213"
  "\377\313\231\1\21\21\21\213\377\377\377\3\21\21\21\377\313\231\231e3"
  "\202e22\1\21\21\21\202DDD\1\21\21\21\202e22\2\377\313\231\314\230f\206"
  "\377\313\231\2\314\230f\21\21\21\213\377\377\377\2\21\21\21\314\230f"
  "\203\21\21\21\1DDD\202333\1DDD\202\21\21\21\1\314\230f\207\377\313\231"
  "\1\21\21\21\215\377\377\377\2\21\21\21e22\202333\1\"\"\"\204333\1\21"
  "\21\21\207\377\313\231\2\314\230f\21\21\21\215\377\377\377\6\21\21\21"
  "\"\"\"DDD\"\"\"\21\21\21DDD\202333\3DDD333\21\21\21\202\377\313\231\202"
  "\314\230f\3\377\313\231\314\230f\21\21\21\215\377\377\377\2\21\21\21"
  "\"\"\"\202DDD\2\"\"\"\21\21\21\203333\202DDD\3""333\21\21\21\314\230"
  "f\202\377\313\231\2\314\230f\21\21\21\216\377\377\377\4\21\21\21DDD3"
  "33\"\"\"\205333\203DDD\2\21\21\21ee2\202\314\230f\2\"\"\"\0v\0\202\0"
  "\"\0\214\377\377\377\1\21\21\21\202\"\"\"\1DDD\202333\10DDD333\"\"\""
  "333DDD333\"\"\"\21\21\21\202\"\"\"\4\0v\0\0\230\0\0D\0\0v\0\202\0\"\0"
  "\212\377\377\377\4\21\21\21\"\"\"DDD\0\0\0\203\21\21\21\3DDD333\"\"\""
  "\203333\1\21\21\21\202\0v\0\202\0\230\0\2\0D\0\0\230\0\202\0v\0\202\0"
  "\"\0\210\377\377\377\5\21\21\21""333\"\"\"\21\21\21\"\"\"\203\21\21\21"
  "\6""333\"\"\"333DDD333\21\21\21\205\0D\0\203\0\230\0\202\0v\0\1\0\"\0"
  "\207\377\377\377\2\21\21\21DDD\202\21\21\21\203\"\"\"\1\21\21\21\204"
  "333\2\21\21\21\0v\0\212\0\230\0\2\0v\0\0\"\0\205\377\377\377\4\0\"\0"
  "\0\230\0\21\21\21\0\0\0\203\21\21\21\2\"\"\"\21\21\21\202333\202\21\21"
  "\21\214\0\230\0\2\0v\0\0\"\0\204\377\377\377\5\0\"\0\0\230\0\377\313"
  "\231\21\21\21\"\"\"\204\21\21\21\1\"\"\"\202\21\21\21\2\0v\0\0D\0\215"
  "\0\230\0\2\0v\0\0\"\0\203\377\377\377\2\0\"\0\0\230\0\202\377\313\231"
  "\2\21\21\21\0\0\0\203\"\"\"\5\21\21\21fff\314\230f\0v\0\0D\0\215\0\230"
  "\0\2\0v\0\0\"\0\202\377\377\377\4\0\"\0\0v\0\0\230\0\314\230f\202\377"
  "\313\231\1www\203\21\21\21\5www\377\313\231\314\230f\0v\0\0D\0\215\0"
  "\230\0\2\0v\0\0\"\0\202\377\377\377\2\0\"\0\0v\0\202\0\230\0\1\314\230"
  "f\206\377\313\231\1\314\230f\202\0v\0\1\0D\0\215\0\230\0\2\0v\0\0\"\0"
};


static const GdkPixdata pic9 = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1124, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\207\377\377\377\207\0\0v\231\377\377\377\1\0\0v\20622\313\206\0\0v\224"
  "\377\377\377\1\0\0v\20622\313\5ff\314\313\231\377\230f\314e3\23122\313"
  "\207\0\0v\215\377\377\377\1\0\0v\20522\313\2""22e\314\230f\202\375\230"
  "\0\2\3142\0e2e\20622\313\1\0\0v\216\377\377\377\1\0\0v\20422\313\6""2"
  "2e\230\227\0\375\313\0\375\230\0\3142\0e22\20522\313\1\0\0v\217\377\377"
  "\377\4\0\0D\0\0\210\0\0\2522\0\230\20233\231\4\"\"\"DDDe22e2e\20522\313"
  "\1\0\0v\220\377\377\377\202\"\0\0\1\20\0\0\203\0\0\0\1\0\0\"\202\0\0"
  "T\203\0\0v\202\0\0\210\2\0""2\230\0\0T\217\377\377\377\4\21\21\21\314"
  "2\0\2302\0\3142\0\202\2302\0\202e22\2f2\0T\0\0\203D\0\0\4""2\0\0\"\0"
  "\0\"\"\"\0\0\0\216\377\377\377\1\21\21\21\205\2302\0\1\3142\0\211\230"
  "2\0\3\3142\0\2302\0\21\21\21\215\377\377\377\2\21\21\21\2302\0\205\314"
  "2\0\1\2302\0\206\3142\0\204\2302\0\1\21\21\21\214\377\377\377\2\21\21"
  "\21\231e3\202\314\230f\202\231e3\202\314\230f\4\377\313\231\314\230f"
  "\313e2\3142\0\202\314\230f\205\3142\0\1\21\21\21\214\377\377\377\1\21"
  "\21\21\217\377\313\231\4\314e\0\231e3\3142\0\21\21\21\213\377\377\377"
  "\5\21\21\21\230e\0\377\313\231\314\230f\377\313\231\204\314\230f\1\377"
  "\313\231\203\314\230f\206\377\313\231\2\231e3\21\21\21\213\377\377\377"
  "\4\21\21\21\314\230f\377\313\231\314\230f\212\377\313\231\1\314\230f"
  "\205\377\313\231\2\2302\0\21\21\21\211\377\377\377\2\21\21\21\"\0\0\203"
  "\377\313\231\205\314\230f\206\377\313\231\202\314\230f\203\377\313\231"
  "\2\2302\0\21\21\21\210\377\377\377\2\21\21\21\377\313\231\202\"\"\"\1"
  "\314\230f\221\377\313\231\2\2302\0\21\21\21\210\377\377\377\1\21\21\21"
  "\202\377\313\231\1\314\230f\203\"\"\"\2f2\0e22\202\231e3\1\230ee\203"
  "\314\230f\207\377\313\231\2\2302\0\21\21\21\210\377\377\377\3\21\21\21"
  "\377\313\231\314\230f\202\377\313\231\217\0\0\0\202\"\"\"\3\314\230f"
  "\377\313\231\21\21\21\207\377\377\377\3\21\21\21\377\313\231\314\230"
  "f\202\377\313\231\207\0\0\0\1\377\313\231\207\0\0\0\204\377\313\231\1"
  "\21\21\21\207\377\377\377\3\21\21\21\377\313\231\314\230f\202\377\313"
  "\231\207\0\0\0\1\377\313\231\207\0\0\0\5\377\313\231\314\230f\377\313"
  "\231\314\230f\21\21\21\207\377\377\377\3\21\21\21\377\313\231\314\230"
  "f\202\377\313\231\207\0\0\0\1\377\313\231\207\0\0\0\5\377\313\231\314"
  "\230f\377\313\231\314\230f\21\21\21\210\377\377\377\1\21\21\21\203\377"
  "\313\231\2\231e3e22\204\0\0\0\2\231e3\377\313\231\206\0\0\0\5e22\377"
  "\313\231\314\230f\377\313\231\21\21\21\211\377\377\377\1\21\21\21\213"
  "\377\313\231\1\314\230f\202\231e3\202e22\6\"\"\"\314\230f\377\313\231"
  "\314\230f\377\313\231\21\21\21\211\377\377\377\1\21\21\21\224\377\313"
  "\231\1\21\21\21\212\377\377\377\1\21\21\21\224\377\313\231\1\21\21\21"
  "\212\377\377\377\1\21\21\21\202\377\313\231\1\314\230f\204\377\313\231"
  "\1\314\230f\203\231e3\1\314\230f\207\377\313\231\2\314\230f\21\21\21"
  "\212\377\377\377\1\21\21\21\202\377\313\231\202\314\230f\206\377\313"
  "\231\2\314\230f\231e3\207\377\313\231\2\314\230f\21\21\21\213\377\377"
  "\377\1\21\21\21\203\377\313\231\204\314\230f\210\377\313\231\202\314"
  "\230f\3\377\313\231\314\230f\21\21\21\213\377\377\377\3\0\20\0\231e3"
  "\314\230f\205\377\313\231\210\314\230f\203\377\313\231\2\231e3\21\21"
  "\21\212\377\377\377\2\0\0v22\313\204\"\"\"\202\231e3\1\314\230f\211\377"
  "\313\231\1\314\230f\202\"\"\"\1\0\0v\211\377\377\377\1\0\0v\20622\313"
  "\215\"\"\"\20322\313\1\0\0\210\207\377\377\377\1\0\0v\21422\313\1\0\0"
  "v\21322\313\1\0\0v\204\377\377\377"
};


static const GdkPixdata logo = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 2058, /* header length + pixel_data length */
  0x2010001, /* pixdata_type */
  96, /* rowstride */
  32, /* width */
  32, /* height */
  /* pixel_data: */
  (guint8*)
  "\217\377\377\377\203\0\0\0\203\377\377\377\213\0\0\0\216\377\377\377"
  "\11\0\0\0\252\252\252UUUff3\0\0\0\377\377\377\0\0\0\231\231\231\314\377"
  "\314\202\314\314\314\3\335\335\335\314\314\314\335\335\335\202\314\314"
  "\314\2\335\335\335\0\0\0\216\377\377\377\1\0\0\0\202UUU\6\231\231\231"
  "\0\0\0\377\377\377\0\0\0\335\335\335\231\231f\203\0\0\0\1\0\21\0\205"
  "\0\0\0\215\377\377\377\11\0\0\0DDDwwwfffwww\0\0\0\377\377\377\0\0\0\335"
  "\335\335\202\0\0\0\5wwwfffwww\210\210\210\21\21\21\202www\1\0\0\0\214"
  "\377\377\377\7\0\0\0UUUwwwDDDfffUUU\21\21\21\202\0\0\0\1\314\314\314"
  "\202\0\0\0\10""333UUUDDD333\21\21\21""333UUU\0\0\0\213\377\377\377\3"
  "\0\0\0DDDwww\202\"\"\"\3UUU\252\252\252\"\"\"\202\0\0\0\1\335\335\335"
  "\202\0\0\0\1UUU\203333\202\21\21\21\2fff\0\0\0\212\377\377\377\11\0\0"
  "\0UUUwww\"\"\"\21\21\21\0\0\0UUU\252\252\252\"\"\"\202\0\0\0\1\314\314"
  "\314\202\0\0\0\5\21\0\0""333\21\21\21\0\21\0\21\21\21\203\0\0\0\211\377"
  "\377\377\5\0\0\0UUU\210\210\210\"\"\"\21\21\21\202\0\0\0\3UUU\273\273"
  "\273\"\"\"\202\0\0\0\1\314\377\314\202\0\0\0\2\210\210\210UUU\202\21"
  "\21\21\2www\210\210\210\202\0\0\0\210\377\377\377\6\0\0\0UUU\231\231"
  "\231\"\"\"\21\21\21\0\0\0\202\377\377\377\3UUU\252\252\252333\202\0\0"
  "\0\1\314\314\314\202\0\0\0\1\"\"\"\202333\1\21\21\21\202\"\"\"\202\0"
  "\0\0\207\377\377\377\6\0\0\0\252\252\252\231\231\231UUU\21\21\21\0\0"
  "\0\202\377\377\377\4\0\0\0DDD\273\273\273\"\"\"\202\0\0\0\1\335\335\335"
  "\202\0\0\0\4www\"\"\"DDD\21\21\21\204\0\0\0\205\377\377\377\202\0\0\0"
  "\5\252\252\252UUUwwwDDD\0\0\0\203\377\377\377\3\0\0\0\252\252\252\231"
  "\231\231\203\0\0\0\1\314\314\231\202\0\0\0\3\0\21\0\"\"\"\0\0\21\205"
  "\0\0\0\204\377\377\377\3\0\0\0UUU\252\252\252\202\0\0\0\3www\"\"\"\0"
  "\0\0\202\377\377\377\4\0\0\0UUU\314\314\314UUU\203\0\0\0\6\273\273\273"
  "\231\231\231\0\0\0\21\21\21\"\"\"\21\0\0\205\0\0\0\204\377\377\377\2"
  "\0\0\0\252\252\252\202\0\0\0\3\252\252\252UUU\0\0\0\203\377\377\377\4"
  "\0\0\0UUU\314\314\314UUU\203\0\0\0\13\231\231\231\314\314\231\273\273"
  "\273\314\314\231\231\314\314\314\314\231\273\273\273\314\314\231\273"
  "\273\273\314\314\231\0\0\0\204\377\377\377\3\0\0\0UUU\0\0\0\202UUU\1"
  "\0\0\0\204\377\377\377\5UUU\314\314\314\273\273\273\314\314\314UUU\204"
  "\0\0\0\1\210\210\210\210\0\0\0\205\377\377\377\2\0\0\0\377\377\377\202"
  "\0\0\0\204\377\377\377\6\0\0\0\231\231\231\231\231f\231\231\231DDDUU"
  "U\203\0\0\0\4\231\231fwww\231\231f\210\210\210\202www\4\210\210\210f"
  "\231fwww\0\0\0\213\377\377\377\202\0\0\0\7\314\314\314\314\314\231\314"
  "\314\314\273\273\273\314\314\231\231\314\314\314\314\231\202\0\0\0\1"
  "\210\210\210\206\0\0\0\1\21\0\0\202\0\0\0\212\377\377\377\4\0\0\0UUU"
  "\0\0\0\314\314\314\202\210\210\210\4\231\231f\231\231\231\231\231f\231"
  "\231\314\202\0\0\0\6f\231f\0\0\0wwwf\231f\231fff\231f\203www\2\0\0\0"
  "\377\377\377\211\0\0\0\202UUU\12\0\21\0\273\273\273\210\210\210\314\314"
  "\231\252\252\252\210\210\210f\231f\314\314\231www\0\0\0\202\252\252\252"
  "\7\231\314\231\314\231\231\210\210\210\252\252\252\231\231\231\231\231"
  "f\252\252\252\202\0\0\0\3\252\252\252UUUff3\205UUU\1ff3\202\252\252\252"
  "\12\0\0\0\314\314\231\210\210\210\231\314\231\231\231\231\231\231f\210"
  "\210\210\252\252\252f\231f\0\0\0\202www\1fff\202f\231f\4fffwwwfffff3"
  "\202\0\0\0\3UUUfff3f3\202\252\252\252\202\210\210\210\1fff\203UUU\21"
  "\0\0\0\273\273\273\210\210\210\231\231f\231\231\231f\231\231\231\231"
  "f\252\252\252www\0\0\0\252\252\252\231\231f\231\231\231\210\210\210\231"
  "ff\231\231\231\231\231f\202\231\231\231\202\0\0\0\3UUUff3\0\0\21\202"
  "\0\0\0\13\21\21\21\"\"\"333\0\21\0\0\0\0UUU\0\0\0\273\273\273\231\231"
  "ff\231\231\231\231f\202\210\210\210\6\252\252\252wwwfffff3f\231ffff\202"
  "f\231f\202fff\7ff3UUU\0\21\0\0\0\0UUU\252\252\252\0\0\0\202\377\377\377"
  "\207\0\0\0\3\314\314\231\231\314\314\314\231\231\204\252\252\252\2\231"
  "\231f\231\314\231\202\231\231\231\7\231\231f\231ffwww\231\231f\210\210"
  "\210\231\231f\231\231\231\202\0\0\0\3UUU\231\231\231\0\0\0\210\377\377"
  "\377\202\0\0\0\2\231\231ff\231f\202www\6ff3f\231ffffUUUwwwff3\203fff"
  "\4UUUff33ffff3\202\0\0\0\3UUUwww\"\"\"\210\377\377\377\23\0\0\0\252\252"
  "\252\231\231\231\252\252\252\231\231\231\231\231f\231\231\231\210\210"
  "\210\231\231f\231\231\231\231\231fwww\210\210\210f\231fffff\231fwww\210"
  "\210\210www\202\0\0\0\4UUUfff\"\"\"\0\0\0\210\377\377\377\4\0\0\0""3"
  "3\0UUUfff\204UUU\1""3f3\203DDD\2""333DDD\204333\202\0\0\0\2\231\231\231"
  "UUU\202\0\0\0\211\377\377\377\1\0\0\21\202\0\0\0\16\0\21\0ff3wwwfffU"
  "UUfffUUUff3UUUff3DDD3f3ff33f3\202\0\0\0\4UUU\231\231\231\252\252\252"
  "\0\0\0\213\377\377\377\7\0\0\0\21\21\21UUUf\231f\231\231f\210\210\210"
  "\231\231f\202www\6f\231ffff\231ffwwwfffwww\202\0\0\0\4DDDwwwUUU\252\252"
  "\252\202\0\0\0\212\377\377\377\2\0\21\0UUU\202fff\12ff3DDDUUU3f3DDDf"
  "333f333333\0DDD\202\0\0\0\2\"\"\"www\202\0\0\0\3\252\252\252UUU\0\0\0"
  "\210\377\377\377\24\0\0\0\21\0\0UUU\231\231f\210\210\210f\231\231\231"
  "\231fwww\210\210\210wwwf\231ffffwwwfffff3\0\0\0\377\377\377\0\0\0UUU"
  "\252\252\252\202\0\0\0\2\252\252\252\0\0\0\210\377\377\377\1\0\0\0\203"
  "fff\11UUUff3UUU3f3f333f3333DDD33\0\202333\1\0\0\0\202\377\377\377\1\0"
  "\0\0\202UUU\3\0\0\0UUU\0\0\0\210\377\377\377\7\0\0\0ffff\231f\231\231"
  "\231\231\231f\210\210\210UUU\206\0\0\0\1\0\21\0\202\0\0\0\203\377\377"
  "\377\202\0\0\0\2\377\377\377\0\0\0\211\377\377\377\220\0\0\0"
};


static const GdkPixdata bup = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1194, /* header length + pixel_data length */
  0x2010002, /* pixdata_type */
  180, /* rowstride */
  45, /* width */
  80, /* height */
  /* pixel_data: */
  (guint8*)
  "\1\377\377\377\2\243\0\0\0\0\10\377\377\377\7\377\377\377\12\377\377"
  "\377\3\377\377\377\11\377\377\377\15\377\377\377'\377\377\377\33\377"
  "\377\377\11\244\0\0\0\0\202\377\377\377\10\1\377\377\377\35\202\0\0\0"
  "\377\4\377\377\377(\377\377\377\11\377\377\377\30\377\377\377\20\243"
  "\0\0\0\0\4\377\377\377\20\377\377\377\2\377\377\377\33\0\0\0\352\203"
  "\0\0\0\377\3\377\377\377\40\377\377\377\17\377\377\377\10\242\0\0\0\0"
  "\4\377\377\377\6\377\377\377!\377\377\377\5\377\377\377\17\204\0\0\0"
  "\377\3\377\377\377#\377\377\377\24\377\377\377\1\242\0\0\0\0\5\377\377"
  "\377\7\377\377\377\1\377\377\377\3\377\377\3770\377\377\377\15\202\0"
  "\0\0\377\3\377\377\377.\377\377\377\23\377\377\377\15\243\0\0\0\0\7\377"
  "\377\377\3\377\377\377\2\377\377\377\33\0\0\0\333\377\377\377\10\377"
  "\377\377\21\377\377\377\16\202\377\377\377\3\1\377\377\377\12\243\0\0"
  "\0\0\6\377\377\377\1\377\377\377\25\0\0\0\377\377\377\377\16\377\377"
  "\377\1\377\377\377\3\202\377\377\377\1\1\377\377\377\17\243\0\0\0\0\7"
  "\377\377\377\2\377\377\377+\0\0\0\377\377\377\377\17\377\377\377\3\377"
  "\377\377\13\377\377\377\3\202\377\377\377\7\1\377\377\377\2\242\0\0\0"
  "\0\4\377\377\377\4\377\377\377D\0\0\0\377\377\377\377,\203\377\377\377"
  "\1\3\377\377\377\4\377\377\377\14\377\377\377\5\242\0\0\0\0\4\377\377"
  "\377\4\377\377\377\22\0\0\0\377\377\377\377)\204\0\0\0\0\3\377\377\377"
  "\2\377\377\377\4\377\377\377\2\242\0\0\0\0\3\377\377\377!\0\0\0\352\377"
  "\377\377\22\205\0\0\0\0\1\377\377\377\2\243\0\0\0\0\3\377\377\377!\0"
  "\0\0\377\377\377\377\14\251\0\0\0\0\3\377\377\377\24\0\0\0\377\377\377"
  "\377>\251\0\0\0\0\3\377\377\3775\0\0\0\377\377\377\377.\251\0\0\0\0\4"
  "\377\377\377\30\0\0\0\352\377\377\377.\377\377\377\1\247\0\0\0\0\4\377"
  "\377\377\1\377\377\377.\0\0\0\377\377\377\377!\204\0\0\0\0\1\377\377"
  "\377\1\244\0\0\0\0\3\377\377\377\30\0\0\0\311\377\377\377/\204\0\0\0"
  "\0\1\377\377\377\6\244\0\0\0\0\3\377\377\377\10\0\0\0\377\377\377\377"
  "\25\204\0\0\0\0\1\377\377\377\2\244\0\0\0\0\3\377\377\377\1\0\0\0\377"
  "\377\377\377\30\204\0\0\0\0\1\377\377\377\1\244\0\0\0\0\3\377\377\377"
  "\16\0\0\0\377\377\377\377-\251\0\0\0\0\3\377\377\377\3\0\0\0\377\377"
  "\377\377\33\251\0\0\0\0\4\377\377\377\6\0\0\0\377\377\377\3773\377\377"
  "\377\1\250\0\0\0\0\3\377\377\377\24\0\0\0\360\377\377\377)\251\0\0\0"
  "\0\3\377\377\377\17\0\0\0\377\377\377\377!\251\0\0\0\0\4\377\377\377"
  "\7\0\0\0\332\377\377\377%\377\377\377\1\250\0\0\0\0\3\377\377\377\13"
  "\0\0\0\377\377\377\377\17\251\0\0\0\0\4\377\377\377\6\0\0\0\377\377\377"
  "\377\31\377\377\377\1\250\0\0\0\0\3\377\377\377\15\0\0\0\254\377\377"
  "\377\16\251\0\0\0\0\3\377\377\377\5\0\0\0\377\377\377\377\7\251\0\0\0"
  "\0\3\377\377\377\2\0\0\0\215\377\377\377\10\251\0\0\0\0\3\377\377\377"
  "\14\0\0\0\345\377\377\377\37\251\0\0\0\0\3\377\377\377\11\0\0\0\377\377"
  "\377\377\35\251\0\0\0\0\3\377\377\377\2\0\0\0\310\377\377\377\32\251"
  "\0\0\0\0\3\377\377\377\5\0\0\0\377\377\377\377)\251\0\0\0\0\3\377\377"
  "\377\24\0\0\0\377\377\377\377\24\244\0\0\0\0\1\377\377\377\1\204\0\0"
  "\0\0\3\377\377\377\27\0\0\0\377\377\377\377\"\251\0\0\0\0\3\377\377\377"
  "*\0\0\0\377\377\377\377\40\251\0\0\0\0\3\377\377\377-\0\0\0\377\377\377"
  "\377!\224\0\0\0\0\1\377\377\377\2\224\0\0\0\0\3\377\377\377\36\0\0\0"
  "\377\377\377\377\10\251\0\0\0\0\3\377\377\377\13\0\0\0\377\377\377\377"
  "\11\251\0\0\0\0\3\377\377\377\23\0\0\0\332\377\377\377\32\252\0\0\0\0"
  "\2\377\377\377\6\377\377\377\1\252\0\0\0\0\1\377\377\377\1\254\0\0\0"
  "\0\1\377\377\377\3\255\0\0\0\0\1\377\377\377\4\254\0\0\0\0\1\377\377"
  "\377\6\254\0\0\0\0\1\377\377\377\5\254\0\0\0\0\1\377\377\377\7\377\0"
  "\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377"
  "\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\327\0\0\0\0"
};


static const GdkPixdata bdown = {
  0x47646b50, /* Pixbuf magic: 'GdkP' */
  24 + 1189, /* header length + pixel_data length */
  0x2010002, /* pixdata_type */
  180, /* rowstride */
  45, /* width */
  80, /* height */
  /* pixel_data: */
  (guint8*)
  "\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0"
  "\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\253"
  "\0\0\0\0\1\377\377\377\7\254\0\0\0\0\1\377\377\377\5\254\0\0\0\0\1\377"
  "\377\377\6\254\0\0\0\0\1\377\377\377\4\377\0\0\0\0\206\0\0\0\0\3\377"
  "\377\377\3\377\377\377\6\377\377\377\1\252\0\0\0\0\4\377\377\377\1\377"
  "\377\377\23\0\0\0\332\377\377\377\32\253\0\0\0\0\3\377\377\377\13\0\0"
  "\0\377\377\377\377\11\253\0\0\0\0\3\377\377\377\36\0\0\0\377\377\377"
  "\377\10\253\0\0\0\0\3\377\377\377-\0\0\0\377\377\377\377!\224\0\0\0\0"
  "\1\377\377\377\2\226\0\0\0\0\3\377\377\377*\0\0\0\377\377\377\377\40"
  "\246\0\0\0\0\1\377\377\377\1\204\0\0\0\0\3\377\377\377\27\0\0\0\377\377"
  "\377\377\"\253\0\0\0\0\3\377\377\377\24\0\0\0\377\377\377\377\24\253"
  "\0\0\0\0\3\377\377\377\5\0\0\0\377\377\377\377)\253\0\0\0\0\3\377\377"
  "\377\2\0\0\0\310\377\377\377\32\253\0\0\0\0\3\377\377\377\11\0\0\0\377"
  "\377\377\377\35\253\0\0\0\0\3\377\377\377\14\0\0\0\345\377\377\377\37"
  "\253\0\0\0\0\3\377\377\377\2\0\0\0\215\377\377\377\10\253\0\0\0\0\3\377"
  "\377\377\5\0\0\0\377\377\377\377\7\253\0\0\0\0\3\377\377\377\15\0\0\0"
  "\254\377\377\377\16\253\0\0\0\0\4\377\377\377\6\0\0\0\377\377\377\377"
  "\31\377\377\377\1\252\0\0\0\0\3\377\377\377\13\0\0\0\377\377\377\377"
  "\17\253\0\0\0\0\4\377\377\377\7\0\0\0\332\377\377\377%\377\377\377\1"
  "\252\0\0\0\0\3\377\377\377\17\0\0\0\377\377\377\377!\253\0\0\0\0\3\377"
  "\377\377\24\0\0\0\360\377\377\377)\253\0\0\0\0\4\377\377\377\6\0\0\0"
  "\377\377\377\3773\377\377\377\1\252\0\0\0\0\3\377\377\377\3\0\0\0\377"
  "\377\377\377\33\253\0\0\0\0\3\377\377\377\16\0\0\0\377\377\377\377-\253"
  "\0\0\0\0\3\377\377\377\1\0\0\0\377\377\377\377\30\204\0\0\0\0\1\377\377"
  "\377\1\246\0\0\0\0\3\377\377\377\10\0\0\0\377\377\377\377\25\204\0\0"
  "\0\0\1\377\377\377\2\246\0\0\0\0\3\377\377\377\30\0\0\0\311\377\377\377"
  "/\204\0\0\0\0\1\377\377\377\6\245\0\0\0\0\4\377\377\377\1\377\377\377"
  ".\0\0\0\377\377\377\377!\204\0\0\0\0\1\377\377\377\1\246\0\0\0\0\4\377"
  "\377\377\30\0\0\0\352\377\377\377.\377\377\377\1\252\0\0\0\0\3\377\377"
  "\3775\0\0\0\377\377\377\377.\253\0\0\0\0\3\377\377\377\24\0\0\0\377\377"
  "\377\377>\253\0\0\0\0\3\377\377\377!\0\0\0\377\377\377\377\14\253\0\0"
  "\0\0\3\377\377\377!\0\0\0\352\377\377\377\22\205\0\0\0\0\1\377\377\377"
  "\2\244\0\0\0\0\4\377\377\377\4\377\377\377\22\0\0\0\377\377\377\377)"
  "\204\0\0\0\0\3\377\377\377\2\377\377\377\4\377\377\377\2\243\0\0\0\0"
  "\4\377\377\377\4\377\377\377D\0\0\0\377\377\377\377,\203\377\377\377"
  "\1\3\377\377\377\4\377\377\377\14\377\377\377\5\244\0\0\0\0\7\377\377"
  "\377\2\377\377\377+\0\0\0\377\377\377\377\17\377\377\377\3\377\377\377"
  "\13\377\377\377\3\202\377\377\377\7\1\377\377\377\2\244\0\0\0\0\6\377"
  "\377\377\1\377\377\377\25\0\0\0\377\377\377\377\16\377\377\377\1\377"
  "\377\377\3\202\377\377\377\1\1\377\377\377\17\244\0\0\0\0\7\377\377\377"
  "\3\377\377\377\2\377\377\377\33\0\0\0\333\377\377\377\10\377\377\377"
  "\21\377\377\377\16\202\377\377\377\3\1\377\377\377\12\243\0\0\0\0\5\377"
  "\377\377\7\377\377\377\1\377\377\377\3\377\377\3770\377\377\377\15\202"
  "\0\0\0\377\3\377\377\377.\377\377\377\23\377\377\377\15\243\0\0\0\0\4"
  "\377\377\377\6\377\377\377!\377\377\377\5\377\377\377\17\204\0\0\0\377"
  "\3\377\377\377#\377\377\377\24\377\377\377\1\243\0\0\0\0\4\377\377\377"
  "\20\377\377\377\2\377\377\377\33\0\0\0\352\203\0\0\0\377\3\377\377\377"
  "\40\377\377\377\17\377\377\377\10\244\0\0\0\0\202\377\377\377\10\1\377"
  "\377\377\35\202\0\0\0\377\6\377\377\377(\377\377\377\11\377\377\377\30"
  "\377\377\377\20\0\0\0\0\377\377\377\2\243\0\0\0\0\11\377\377\377\7\377"
  "\377\377\12\377\377\377\3\377\377\377\11\377\377\377\15\377\377\377'"
  "\377\377\377\33\377\377\377\11\0\0\0\0"
};


static void load_images(void)
{
	icons = g_new(GdkPixbuf*, 13);
	icons[0] = gdk_pixbuf_from_pixdata(&pic1, FALSE, NULL);
	icons[1] = gdk_pixbuf_from_pixdata(&pic2, FALSE, NULL);
	icons[2] = gdk_pixbuf_from_pixdata(&pic3, FALSE, NULL);
	icons[3] = gdk_pixbuf_from_pixdata(&pic4, FALSE, NULL);
	icons[4] = gdk_pixbuf_from_pixdata(&pic5, FALSE, NULL);
	icons[5] = gdk_pixbuf_from_pixdata(&pic6, FALSE, NULL);
	icons[6] = gdk_pixbuf_from_pixdata(&pic7, FALSE, NULL);
	icons[7] = gdk_pixbuf_from_pixdata(&pic8, FALSE, NULL);
	icons[8] = gdk_pixbuf_from_pixdata(&pic9, FALSE, NULL);
	icons[9] = gdk_pixbuf_from_pixdata(&pic10, FALSE, NULL);
	icons[10] = gdk_pixbuf_from_pixdata(&logo, FALSE, NULL);
	icons[11] = gdk_pixbuf_from_pixdata(&bup, FALSE, NULL);
	icons[12] = gdk_pixbuf_from_pixdata(&bdown, FALSE, NULL);
}


static void init_images(void)
{
	gint i;

	initialise_random_numbers();

	// define start images
	i = random_number(MAX_PICS) + 1;
	gtk_image_set_from_pixbuf(GTK_IMAGE(image1), icons[i]);
	i = random_number(MAX_PICS) + 1;
	gtk_image_set_from_pixbuf(GTK_IMAGE(image2), icons[i]);
	i = random_number(MAX_PICS) + 1;
	gtk_image_set_from_pixbuf(GTK_IMAGE(image3), icons[i]);
}


// main exit function
gint gb_destroyapp(GtkWidget *widget, gpointer gdata)
{
	if (is_running) return TRUE;
	if (GTK_IS_WINDOW(gb_window)) gtk_widget_destroy(gb_window);
	if (random_fd != -1) close(random_fd);
	gb_window = NULL;
	return FALSE;
}


void gb_start_easteregg(void)
{
	random_fd = -1;
	load_images();
	create_window();
	g_signal_connect(G_OBJECT(gb_window), "delete_event", G_CALLBACK(gb_destroyapp), NULL);

	points = 0;
	lap = 0;
	init_images();
	init_strings();
	update_labels(gb_window, TRUE, 3);

	gtk_widget_show(gb_window);
}


static gboolean gb_on_key_pressed(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	static gchar text[] = "00000";

	switch (event->keyval)
	{
		case 'g':
		{
			text[0] = 'g';
			text[1] = '\0';
			return TRUE;
			break;
		}
		case 'e':
		{
			text[1] = 'e';
			text[2] = '\0';
			return TRUE;
			break;
		}
		case 'a':
		{
			text[2] = 'a';
			text[3] = '\0';
			return TRUE;
			break;
		}
		case 'n':
		{
			text[3] = 'n';
			text[4] = '\0';
			return TRUE;
			break;
		}
		case 'y':
		{
			text[4] = 'y';
			text[5] = '\0';
			if (utils_str_equal(text, "geany")) gb_start_easteregg();
			return TRUE;
			break;
		}
		default:
		{
			text[0] = '\0';
			return FALSE;
		}
	}
}


