/* -*- mode: C++; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/*
 *  Main authors:
 *     Christian Schulte <schulte@gecode.org>
 *
 *  Copyright:
 *     Christian Schulte, 2002
 *
 *  Last modified:
 *     $Date: 2009-02-05 11:48:53 +0100 (Thu, 05 Feb 2009) $ by $Author: schulte $
 *     $Revision: 8155 $
 *
 *  This file is part of Gecode, the generic constraint
 *  development environment:
 *     http://www.gecode.org
 *
 *  Permission is hereby granted, free of charge, to any person obtaining
 *  a copy of this software and associated documentation files (the
 *  "Software"), to deal in the Software without restriction, including
 *  without limitation the rights to use, copy, modify, merge, publish,
 *  distribute, sublicense, and/or sell copies of the Software, and to
 *  permit persons to whom the Software is furnished to do so, subject to
 *  the following conditions:
 *
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 *  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

namespace Gecode {

  forceinline void
  IntVar::_init(Space& home, int min, int max) {
    varimp = new (home) Int::IntVarImp(home,min,max);
  }

  forceinline void
  IntVar::_init(Space& home, const IntSet& ds) {
    varimp = new (home) Int::IntVarImp(home,ds);
  }

  forceinline
  IntVar::IntVar(void) {}
  forceinline
  IntVar::IntVar(const IntVar& x)
    : VarBase<Int::IntVarImp>(x.varimp) {}
  forceinline
  IntVar::IntVar(const Int::IntView& x)
    : VarBase<Int::IntVarImp>(x.var()) {}

  forceinline int
  IntVar::val(void) const {
    if (!varimp->assigned())
      throw Int::ValOfUnassignedVar("IntVar::val");
    return varimp->val();
  }
  forceinline int
  IntVar::min(void) const {
    return varimp->min();
  }
  forceinline int
  IntVar::med(void) const {
    return varimp->med();
  }
  forceinline int
  IntVar::max(void) const {
    return varimp->max();
  }


  forceinline unsigned int
  IntVar::width(void) const {
    return varimp->width();
  }
  forceinline unsigned int
  IntVar::size(void) const {
    return varimp->size();
  }



  forceinline bool
  IntVar::assigned(void) const {
    return varimp->assigned();
  }
  forceinline bool
  IntVar::range(void) const {
    return varimp->range();
  }
  forceinline bool
  IntVar::in(int n) const {
    return varimp->in(n);
  }


  forceinline void
  IntVar::update(Space& home, bool share, IntVar& x) {
    varimp = x.varimp->copy(home,share);
  }

  /*
   * Range iterator
   *
   */
  forceinline
  IntVarRanges::IntVarRanges(void) {}

  forceinline
  IntVarRanges::IntVarRanges(const IntVar& x)
    : Int::IntVarImpFwd(x.var()) {}

  forceinline void
  IntVarRanges::init(const IntVar& x) {
    Int::IntVarImpFwd::init(x.var());
  }


  /*
   * Value iterator
   *
   */

  forceinline
  IntVarValues::IntVarValues(void) {}

  forceinline
  IntVarValues::IntVarValues(const IntVar& x) {
    IntVarRanges r(x);
    Iter::Ranges::ToValues<IntVarRanges>::init(r);
  }

  forceinline void
  IntVarValues::init(const IntVar& x) {
    IntVarRanges r(x);
    Iter::Ranges::ToValues<IntVarRanges>::init(r);
  }

}

// STATISTICS: int-var

