#!/usr/bin/ruby
#
#  geekast.rb - main
#  Copyright (C) 2004-2008 Frédéric Logier
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#require 'rubygems'
require 'gettext'


# module Controller
require 'geekast/controllers/controller'

# module Model
require 'geekast/models/model'

# module View
require 'geekast/views/view'

# module Signal
#require 'geekast/lib/signal'


module Geekast

  TEXTDOMAIN = 'geekast'
  NAME = 'Geekast'
  extend GetText
  bindtextdomain(Geekast::TEXTDOMAIN, nil, nil, "UTF-8")

  VERSION = '0.1.3'
  COMMENTS = _('a GNOME Peercast GUI.')
  COPYRIGHT = 'Copyright (C) 2004-2008 Frédéric Logier'
  AUTHORS = [ 'Frédéric Logier <fredix@gmail.com>' ]
  DOCUMENTERS = [ 'Frédéric Logier <fredix@gmail.com>' ]
  TRANSLATORS = 'Frédéric Logier <fredix@gmail.com>'
  LIST = 'geekast-dev@gna.org'


  URL = ARGV[0]

  def self.main
    Model.main
    Controller.main
    View.main
  end
end


Geekast.main
